/*@(#)srfctest.h          20.24.17.1     SAP     96/07/10 */

/*====================================================================*/
/*                                                                    */
/*     PROGRAM     :   srfctest.h (running on Windows, Windows_NT,    */
/*                                 Windows_95, OS/2 and R/3-Platforms)*/
/*                                                                    */
/*                                                                    */
/*     DESCRIPTION :   Includes file for RFC-Test                     */
/*                                                                    */
/*                                                                    */
/*     SAP AG Walldorf                                                */
/*     Systeme, Anwendungen und Produkte in der Datenverarbeitung     */
/*                                                                    */
/*     Copyright (C) SAP AG 1994                                      */
/*                                                                    */
/*====================================================================*/


/*--------------------------------------------------------------------*/
/* Defines                                                            */
/*--------------------------------------------------------------------*/

#undef __EXTENSIONS__     /* no Sun extensions */
#define _XOPEN_SOURCE

#define BLANK                  ' '
#define LINE_SIZE              256
#define ITAB0332_ENTRY_SIZE    332
#define ITAB1000_ENTRY_SIZE    1000
#define ETAB0332_ENTRY_SIZE    332
#define ETAB1000_ENTRY_SIZE    1000

/*--------------------------------------------------------------------*/
/* Set up includes                                                    */
/*--------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>

/* SAP flag for OS/2 */
#if defined(OS2)
#define SAPonOS2_2x
#endif

/* SAP flag for Windows NT or 95 */
#ifdef _WIN32
#  define SAPonNT
#endif

/* SAP flag for Windows 3.xx */
#ifdef _WINDOWS
#  ifndef _WIN32
#    define SAPonWINDOWS
#  endif
#endif

#if !defined(SAPonUNIX) && !defined(SAPonNT) && !defined(SAPonWINDOWS) && !defined(SAPonOS2_2x) && !defined(SAPonOS400)
#include "saptype.h"
/*--------------------------------------------------------------------*/
/* The include file saptype.h is only for SAP internal make.          */
/*                                                                    */
/* If you want to make this program on your environment you must      */
/* compile and link with some flags depending on your operating       */
/* system.                                                            */
/*                                                                    */
/* Following flags are possible:                                      */
/*                                                                    */
/* UNIX:  #define SAPonUNIX                                           */
/* OS/2, Windows 3.x, NT or 95: already defined in this file          */
/*                                                                    */
/* If you have some problems with the struct timeval, timezone        */
/* please add the flag SAP_RFC_TIME in your own saptype.h or in your  */
/* compile options                                                    */
/*--------------------------------------------------------------------*/
#endif

#ifdef SAPonOS400
#include "o4port.h"
#else
#ifdef SAPonWINDOWS
#undef __STDC__
#endif
#include <sys/timeb.h>
#endif

#include "saprfc.h"
#include "sapitab.h"
#include "rfcsi.h"

#ifdef DGUX
#include <sys/time.h>
#endif

/*--------------------------------------------------------------------*/
/* Function prototypes                                                */
/*--------------------------------------------------------------------*/

int srfcinfo(void);

int srfcconn(void);

int srfcload(void);

int srfcdiag(void);

void get_parameter_for_conn_test(void);

void get_parameter_for_load_test(void);

void get_parameter_for_diag_test(void);

void get_connect_data_from_file(void);

void get_connect_data_via_dialog(void);

void get_load_test_data_from_file(void);

void get_load_test_data_via_dialog(void);

void get_diag_test_data_from_file(void);

void get_diag_test_data_via_dialog(void);

void save_test_parameter(void);

#ifdef __VMS
  /* der compiler auf VAX/VMS kann maximal 31 chars fuer identifier */
  /* wegen object file format */
  #define get_connection_parameters_from_file  get_connectn_params_from_file
  #define get_connection_parameters_via_dialog get_connectn_params_via_dialog
#endif

void get_connection_parameters_from_file(void);

void get_connection_parameters_via_dialog(void);

int RFC_connect(void);

char *read_record(FILE *fp,
                  char *ibuf);

int PM_search(char *param,
              char *text,
              int  leng);

int fill_table(ITAB_H itab_h,
               long   leng);

int check_table(ITAB_H itab_h,
                char   *itabname,
                long   recvleng,
                char   *checktab,
                char   *text,
                char   *retcode);

int output_table(ITAB_H itab_h,
                 char   *itabname);

void display(char          *arrow,
             RFC_PARAMETER *rfc_param);

void display_rfcsi(RFCSI *rfcsi);

void DLL_CALL_BACK_FUNCTION rfc_error(char *operation);

void rfc_param(RFC_PARAMETER *rfc_param,
               char          *abap_field_name,
               unsigned      data_type,
               void          *data_addr,
               unsigned      data_len );

#if defined(SAPonSUN) || defined(SAPonRS6000) || defined(SAPonALPHA) || defined(SAPonRM600) || defined(SAP_RFC_TIME)
struct timeval
{
  unsigned long   tv_sec;    /* seconds since Jan. 1, 1970 */
  long            tv_usec;   /* and microseconds */
};
struct timezone
{
  int     tz_minuteswest;    /* of UTC */
  int     tz_dsttime;        /* type of DST correction to apply */
};
#endif

#ifdef SAPonUNIX
unsigned long int diffmsec (struct timeval *, struct timeval *);
#else
unsigned long int diffmsec_NON_UNIX(struct timeb *, struct timeb *);
#endif

/*--------------------------------------------------------------------*/
/* Declarations                                                       */
/*--------------------------------------------------------------------*/

int               i,
                  j,
                  rc,
                  znr,
                  syntax_OK;

unsigned	  ulen;

long              lineleng,
                  itableng;

char              work_file[129],
                  std_data_file[13] = "srfctest.txt";

char              requtext[256],
                  echotext[256],
                  resptext[256];

char              *ptr,
                  action,
                  ips[101],
                  wbuf[513],
                  sbuf1[513],
                  sbuf2[513],
                  sbuf[4096+1];

char              rfc_dest[33],
                  client[4],
                  userid[13],
                  password[9],
                  language[2];

char              saprfc_ini[2],
                  sideinfo[2],
                  sapsys[2],
                  register_mode[2],
                  load_balancing[2],
                  mshost[101],
                  group[33],
                  r3name[4],
                  ashost[101],
                  sysnr[3],
                  gwhost[101],
                  gwserv[8],
                  use_sapgui[2],
                  abap_debug[2],
                  rfc_trace[2];

char              std_rfc_dest_r3[4] = "BIN",
                  std_rfc_dest_r2[4] = "K50",
		  std_gwhost[7]      = "iw1009",
		  std_gwserv[8]      = "sapgw00",
		  std_r3name[4]      = "BIN",
		  std_mshost[7]      = "hs0311",
		  std_group[7]       = "PUBLIC",
		  std_ashost[7]      = "hs0311",
		  std_sysnr[3]       = "53",
		  std_tcode[31]      = "SE38",
		  std_fname[31]      = "STFC_SAPGUI";

long              nrcall,
                  nrcount,
                  lgit0332,
                  lgit1000,
                  lget0332,
                  lget1000;

char              retcode[2],
                  exitcode[2],
                  checktab[2],
                  printtab[2],
                  nrcall_field[6],
                  lgit0332_field[6],
                  lgit1000_field[6],
                  lget0332_field[6],
                  lget1000_field[6],
		  transaction_test[2],
		  tcode[31],
		  fname[31];

char              text0332[73],
                  text1000[73],
                  texi0332[73],
                  texi1000[73];

char              abort_text[80],
                  last_error_text[150];

FILE              *work_fp;

char              *exception = NULL,
                  *function  = NULL;

struct         tm *time_ptr;

time_t            actutime;

#ifdef SAPonUNIX
struct timeval  sopenmsec,
                eopenmsec,
                scallmsec,
                ecallmsec,
                sfillmsec,
                efillmsec,
                schekmsec,
                echekmsec;

struct timezone tzp;
#else
struct timeb    sopenmsec,
                eopenmsec,
                scallmsec,
                ecallmsec,
                sfillmsec,
                efillmsec,                  
                schekmsec,
                echekmsec;
#endif

unsigned long int msectime,
                  msecopen,
                  mseccall,
                  msecfill,
                  msecchek,
                  totalsnd,
                  totalrcv,
                  totaldat;

RFC_RC                 rfc_rc;
RFC_ENV                new_env;
RFC_HANDLE             rfc_handle;
RFC_FUNCTIONNAME       function_name;
RFC_ERROR_INFO         error_info;
RFC_ATTRIBUTES         rfc_attributes;

RFC_PARAMETER          exporting[6],
                       importing[4],
                       parameters[6];

RFC_TABLE              tables[5];

RFC_OPTIONS            rfc_opt;
RFC_CONNOPT_CPIC       rfc_connopt_cpic;
RFC_CONNOPT_R3ONLY     rfc_connopt_r3only;
RFC_CONNOPT_VERSION_3  rfc_connopt_version_3;

RFCSI                  rfcsi;

char                   name_systeminfo_test[31]  = "RFC_SYSTEM_INFO",
                       name_connection_test[31]  = "STFC_CONNECTION",
                       name_performance_test[31] = "STFC_PERFORMANCE";
                       
