/* static char sccsid[] = "@(#)srfctest       20.28.14.1     SAP     96/06/26 "; */

/*====================================================================*/
/*                                                                    */
/*     PROGRAM     :   srfctest.c (running on Windows, Windows_NT,    */
/*                                 Windows_95, OS/2 and R/3-Platforms)*/
/*                                                                    */
/*                                                                    */
/*     DESCRIPTION :   Test program for Remote Function Calls         */
/*                                                                    */
/*                     - GET SYSTEM INFO:                             */
/*                        Get system info of a RFC server             */
/*                                                                    */
/*                     - CONNECTION TEST:                             */
/*                        Send a request and wait for echo and info   */
/*                                                                    */
/*                     - PERFORMANCE TEST:                            */
/*                        Send and receive internal tables            */
/*                        Number of entries of internal tables will   */
/*                        be required via dialog.                     */
/*                                                                    */
/*                     - RFC WITH SAPGUI:                             */
/*                        + Execute any transaction in R/3.           */
/*                        + Execute any function module in R/3.       */
/*                          Restriction: No import/export parameters  */
/*                                       are supported.               */
/*                                                                    */
/*                     The RFC-Server-System can be R/2 or R/3 for    */
/*                     CONNECTION TEST or PERFORMANCE TEST.           */
/*                                                                    */
/*                     RFC WITH SAPGUI is only for R/3 >= 3.0 and not */
/*                     available with 16-bit RFC Library              */
/*                                                                    */
/*                                                                    */
/*     SAP AG Walldorf                                                */
/*     Systeme, Anwendungen und Produkte in der Datenverarbeitung     */
/*                                                                    */
/*     Copyright (C) SAP AG 1994                                      */
/*                                                                    */
/*====================================================================*/


/*--------------------------------------------------------------------*/
/* Setup includes                                                     */
/*--------------------------------------------------------------------*/

#include "srfctest.h"


/*--------------------------------------------------------------------*/
/* main                                                               */
/*--------------------------------------------------------------------*/

main(int argc, char **argv)
{
  setbuf(stderr, NULL);

  strcpy(work_file, std_data_file);

  if (argc == 1)
    syntax_OK = 1;
  else
    syntax_OK = 0;
 
  for (i = 1; i < argc; i++)
  {
    if (memcmp(argv[i], "file=", 5) == 0)
    {
      syntax_OK = 1;
      znr = strlen(argv[i]) - 5;
      if (znr)
      {
	if (znr > 128)
	  argv[i][5+128] = '\0';
	strcpy(work_file, &argv[i][5]);
      }
    }
  }

  if (syntax_OK == 0)
  {
    printf("\nSyntax:   srfctest [options]\n");
    printf("\n          options:  file=<test data file>\n\n");
    exit(1);
  }

  for (;;)
  {
    printf("\n\n");
    printf("               **********************************************\n");
    printf("               *                                            *\n");
    printf("               *              SAP RFC-API TEST              *\n");
    printf("               *                                            *\n");
    printf("               *                    OS/2,                   *\n");
    printf("               *       Windows, Windows_NT, Windows_95      *\n");
    printf("               *                R/3-Platforms               *\n");
    printf("               *                                            *\n");
    printf("               *                                            *\n");
    printf("               **********************************************\n\n\n");

    /*----------------------------------------------------------------*/
    /*  Keyboard Input:  - ACTION                                     */
    /*----------------------------------------------------------------*/

    printf("\n                            Possible RFC-Tests\n");
    printf("\n                            1. RFC_SYSTEM_INFO");
    printf("\n                            2. CONNECTION");
    printf("\n                            3. PERFORMANCE");
    printf("\n                            4. RFC with SAPGUI");
    printf("\n                            E. Exit\n\n");

    do
    {
      printf("                            Your Choice.......: ");
      gets(ips);
      ips[0] = (char) toupper(ips[0]);
      
      if (ips[0] == 'E')
	break;
    } while ((ips[0] < '1') || (ips[0] > '4'));

#ifdef SAPonWINDOWS
    if (ips[0] == '4')
    {
      printf("\n\nRFC with SAPGUI not available with 16-bit-RFC library!!!!!\n\n");
      exit(1);
    }
#endif
 
    if (ips[0] == 'E')
      break;

    action = ips[0];

    switch(action)
    {
      case '1':
	printf("\n\n\n");
	printf("               **********************************************\n");
	printf("               *                                            *\n");
	printf("               *          RFC-API:  RFC SYSTEM INFO         *\n");
	printf("               *                                            *\n");
	printf("               *       GET SYSTEM INFO OF A RFC SERVER      *\n");
	printf("               *                                            *\n");
	printf("               **********************************************\n");
	srfcinfo();
	break;

      case '2':
	printf("\n\n\n");
	printf("               **********************************************\n");
	printf("               *                                            *\n");
	printf("               *          RFC-API:  CONNECTION TEST         *\n");
	printf("               *                                            *\n");
	printf("               *     SEND MESSAGE AND WAIT FOR ECHO/INFO    *\n");
	printf("               *                                            *\n");
	printf("               **********************************************\n");
	srfcconn();
	break;

      case '3':
	printf("\n\n\n");
	printf("               **********************************************\n");
	printf("               *                                            *\n");
	printf("               *         RFC-API:  PERFORMANCE TEST         *\n");
	printf("               *                                            *\n");
	printf("               *        SEND/RECEIVE INTERNAL TABLES        *\n");
	printf("               *                                            *\n");
	printf("               **********************************************\n");
	srfcload();
	break;

      case '4':
        printf("\n\n\n");
        printf("               **********************************************\n");
        printf("               *                                            *\n");
        printf("               *         RFC-API:  RFC with SAPGUI          *\n");
        printf("               *                                            *\n");
        printf("               *    Start transaction or function module    *\n");
        printf("               *                                            *\n");
        printf("               **********************************************\n");
        srfcdiag();
        break;
    }


  printf("\n<==  RfcGetAttributes         rc = ");
  rc = RfcGetAttributes(rfc_handle, &rfc_attributes);
  printf("%d\n", rc);
  if (rc)
    rfc_error("RfcGetAttributes");

  printf("\nAttributes of this RFC connection");
  printf("\n---------------------------------");
  printf("\nDestination :   %s", rfc_attributes.dest);
  printf("\nOwn Host    :   %s", rfc_attributes.own_host);
  printf("\nPartner Host:   %s", rfc_attributes.partner_host);
  printf("\nSystem No.  :   %s", rfc_attributes.systnr);
  printf("\nSystem Name :   %s", rfc_attributes.sysid);
  printf("\nClient      :   %s", rfc_attributes.client);
  printf("\nUser        :   %s", rfc_attributes.user);
  printf("\nLanguage    :   %s\n", rfc_attributes.language);

    /*----------------------------------------------------------------*/
    /* Close RFC connection                                           */
    /*----------------------------------------------------------------*/
    printf("\n<==  RfcClose\n");
    RfcClose(rfc_handle);

    printf("\n\n");

    do
    {
      printf("                    Continue (y/n)..................:  ");
      gets(ips);
      ips[0] = (char) toupper(ips[0]);
    } while ((ips[0] != 'Y') && (ips[0] != 'N'));

    if (ips[0] == 'N')
      break;
  }

  printf("\n");
  return 0;
}


/*====================================================================*/
/*                                                                    */
/* Call Function RFC_SYSTEM_INFO                                      */
/*                                                                    */
/* Get system info of a RFC server                                    */
/*                                                                    */
/*====================================================================*/
int srfcinfo()
{
  get_parameter_for_conn_test();

  RFC_connect();

#ifdef SAPonUNIX
    gettimeofday(&scallmsec, &tzp);
#else
    ftime(&scallmsec);
#endif

  for (nrcount=0; nrcount<nrcall; nrcount++)
  {
    /*----------------------------------------------------------------*/
    /* call RFC_SYSTEM_INFO                                           */
    /*----------------------------------------------------------------*/

    function = name_systeminfo_test;

    memset(&exporting[0], 0, sizeof(exporting));
    memset(&importing[0], 0, sizeof(importing));

    rfc_param(&importing[0], "RFCSI_EXPORT", TYPC, &rfcsi, sizeof(rfcsi));

    /* no table ---> terminate array */
    tables[0].name = NULL;

    printf("\n<==  RfcCallReceive (%s)     rfc_rc = ", function);
    rfc_rc = RfcCallReceive(rfc_handle,
	  		    function,
			    exporting,
			    importing,
			    tables,
			    &exception);
    printf("%d\n", rfc_rc);

    /* check return code */
    switch(rfc_rc)
    {
      case RFC_OK:
        break;
      case RFC_EXCEPTION:
      case RFC_SYS_EXCEPTION:
        rfc_error(exception);
        break;
      default:
        rfc_error("RfcCallReceive");
        break;
    }

#ifdef SAPonUNIX
    gettimeofday(&ecallmsec, &tzp);
#else
    ftime(&ecallmsec);
#endif

    /* Compute required times */
#ifdef SAPonUNIX
    msecopen = diffmsec(&eopenmsec, &sopenmsec);
    mseccall = diffmsec(&ecallmsec, &scallmsec);
#else
    msecopen = diffmsec_NON_UNIX(&eopenmsec, &sopenmsec);
    mseccall = diffmsec_NON_UNIX(&ecallmsec, &scallmsec);
#endif

    printf("\n\n");
    printf("*******************************************************************************\n");
    printf("*                                                                             *\n");
    printf("*  Connect to SAP required                                   %10d msec  *\n", msecopen);
    printf("*                                                                             *\n");
    printf("*  Total required time for RFC                               %10d msec  *\n", mseccall);
    printf("*                                                                             *\n");
    printf("*******************************************************************************\n");       
    display_rfcsi(&rfcsi);

    if (nrcount < nrcall-1)
    {
      printf("\n\nHit return key for next RFC call\n");
      getchar();

      /* RFC server is NON-SAP and use register mode:        */
      /*    ===> Close and Open the RFC connection necessary */
      if ((sapsys[0] == 'E') && (register_mode[0] == 'Y'))
      {
        printf("\n<==  RfcClose\n");
	RfcClose(rfc_handle);
        RFC_connect();
      }

#ifdef SAPonUNIX
      gettimeofday(&scallmsec, &tzp);
#else
      ftime(&scallmsec);
#endif
    }
  }
  return 0;
}


/*====================================================================*/
/*                                                                    */
/* Call Function STFC_CONNECTION                                      */
/*                                                                    */
/* Send message and wait for echo and info                            */
/*                                                                    */
/*====================================================================*/
int srfcconn()
{
  get_parameter_for_conn_test();

  RFC_connect();

#ifdef SAPonUNIX
    gettimeofday(&scallmsec, &tzp);
#else
    ftime(&scallmsec);
#endif

  for (nrcount=0; nrcount<nrcall; nrcount++)
  {
    /*----------------------------------------------------------------*/
    /* call Connection Test                                           */
    /*----------------------------------------------------------------*/

    function = name_connection_test;

    memset(&exporting[0], 0, sizeof(exporting));
    memset(&importing[0], 0, sizeof(importing));

    memset(requtext, ' ', 255);
    strcpy(requtext, "abcdefghijklmnopqrstuvwxyz ABCDEFGHIJKLMNOPQRSTUVWXYZ 1234567890");
    strcpy(requtext+strlen(requtext), "   !$%&/()=?{[]}+*~#-_.:,;");
    requtext[strlen(requtext)] = ' ';
  
    rfc_param(&exporting[0], "REQUTEXT", TYPC, requtext, 255);
    rfc_param(&importing[0], "ECHOTEXT", TYPC, echotext, 255);
    rfc_param(&importing[1], "RESPTEXT", TYPC, resptext, 255);

    /* no table ---> terminate array */
    tables[0].name = NULL;

    printf("\n<==  RfcCallReceive (%s)     rfc_rc = ", function);
    rfc_rc = RfcCallReceive(rfc_handle,
	  		    function,
			    exporting,
			    importing,
			    tables,
			    &exception);
    printf("%d\n", rfc_rc);

    /* check return code */
    switch(rfc_rc)
    {
      case RFC_OK:
        break;
      case RFC_EXCEPTION:
      case RFC_SYS_EXCEPTION:
        rfc_error(exception);
        break;
      default:
        rfc_error("RfcCallReceive");
        break;
    }

#ifdef SAPonUNIX
    gettimeofday(&ecallmsec, &tzp);
#else
    ftime(&ecallmsec);
#endif

    display("Export Parameter", exporting);

    display("Import Parameter", importing);

    /* Compute required times */
#ifdef SAPonUNIX
    msecopen = diffmsec(&eopenmsec, &sopenmsec);
    mseccall = diffmsec(&ecallmsec, &scallmsec);
#else
    msecopen = diffmsec_NON_UNIX(&eopenmsec, &sopenmsec);
    mseccall = diffmsec_NON_UNIX(&ecallmsec, &scallmsec);
#endif

    printf("\n\n");
    printf("*******************************************************************************\n");
    printf("*                                                                             *\n");
    printf("*  Connect to SAP required                                   %10d msec  *\n", msecopen);
    printf("*                                                                             *\n");
    printf("*  Total required time for RFC                               %10d msec  *\n", mseccall);
    printf("*                                                                             *\n");
    printf("*******************************************************************************\n");       
    if (nrcount < nrcall-1)
    {
      printf("\n\nHit return key for next RFC call\n");
      getchar();

      /* RFC server is NON-SAP and use register mode:        */
      /*    ===> Close and Open the RFC connection necessary */
      if ((sapsys[0] == 'E') && (register_mode[0] == 'Y'))
      {
        printf("\n<==  RfcClose\n");
	RfcClose(rfc_handle);
        RFC_connect();
      }

#ifdef SAPonUNIX
      gettimeofday(&scallmsec, &tzp);
#else
      ftime(&scallmsec);
#endif
    }
  }
  return 0;
}


/*====================================================================*/
/*                                                                    */
/* Call Function STFC_PERFORMANCE                                     */
/*                                                                    */
/* Send/receive internal tables                                       */
/* Number of entries will be required via dialog                      */
/*                                                                    */
/*====================================================================*/
int srfcload()
{
  get_parameter_for_load_test();

  RFC_connect();

#ifdef SAPonUNIX
    gettimeofday(&scallmsec, &tzp);
#else
    ftime(&scallmsec);
#endif

  /* Prepare internal table ITAB0332 */
  tables[0].name     = "ITAB0332";
  tables[0].nlen     = 8;
  tables[0].type     = TYPC;
  tables[0].leng     = ITAB0332_ENTRY_SIZE;
  tables[0].itmode   = RFC_ITMODE_BYREFERENCE;

  printf("\n<==  ItCreate (ITAB0332)      it_handle = ");
  tables[0].ithandle = ItCreate("ITAB0332",
				ITAB0332_ENTRY_SIZE,
				0,
				0);
  printf("%d\n", tables[0].ithandle);

  if (tables[0].ithandle == NULL )
    rfc_error("ItCreate ITAB0332");

  /* Prepare internal table ITAB1000 */
  tables[1].name     = "ITAB1000";
  tables[1].nlen     = 8;
  tables[1].type     = TYPC;
  tables[1].leng     = ITAB1000_ENTRY_SIZE;
  tables[1].itmode   = RFC_ITMODE_BYREFERENCE;

  printf("\n<==  ItCreate (ITAB1000)      it_handle = ");
  tables[1].ithandle = ItCreate("ITAB1000",
				ITAB1000_ENTRY_SIZE,
				0,
				0);
  printf("%d\n", tables[1].ithandle);

  if (tables[1].ithandle == NULL )
    rfc_error("ItCreate ITAB1000");

  /* Prepare internal table ETAB0332 */
  tables[2].name     = "ETAB0332";
  tables[2].nlen     = 8;
  tables[2].type     = TYPC;
  tables[2].leng     = ETAB0332_ENTRY_SIZE;
  tables[2].itmode   = RFC_ITMODE_BYREFERENCE;

  printf("\n<==  ItCreate (ETAB0332)      it_handle = ");
  tables[2].ithandle = ItCreate("ETAB0332",
				ETAB0332_ENTRY_SIZE,
				0,
				0);
  printf("%d\n", tables[2].ithandle);

  if (tables[2].ithandle == NULL )
    rfc_error("ItCreate ETAB0332");

  /* Prepare internal table ETAB1000 */
  tables[3].name     = "ETAB1000";
  tables[3].nlen     = 8;
  tables[3].type     = TYPC;
  tables[3].leng     = ETAB1000_ENTRY_SIZE;
  tables[3].itmode   = RFC_ITMODE_BYREFERENCE;

  printf("\n<==  ItCreate (ETAB1000)      it_handle = ");
  tables[3].ithandle = ItCreate("ETAB1000",
				ETAB1000_ENTRY_SIZE,
				0,
				0);
  printf("%d\n", tables[3].ithandle);

  if (tables[3].ithandle == NULL )
    rfc_error("ItCreate ETAB1000");

  for (nrcount=0; nrcount<nrcall; nrcount++)
  {
    /*----------------------------------------------------------------*/
    /* call Performance Test                                          */
    /*----------------------------------------------------------------*/

    function = name_performance_test;

    memset(&exporting[0], 0, sizeof(exporting));
    memset(&importing[0], 0, sizeof(importing));

    for (i=0; i<255; i++)
      sprintf(&requtext[i], "%01d", (i+1) % 10);

    rfc_param(&exporting[0], "CHECKTAB", TYPC, checktab, 1);
    rfc_param(&exporting[1], "LGIT0332", TYPC, lgit0332_field, 5);
    rfc_param(&exporting[2], "LGIT1000", TYPC, lgit1000_field, 5);
    rfc_param(&exporting[3], "LGET0332", TYPC, lget0332_field, 5);
    rfc_param(&exporting[4], "LGET1000", TYPC, lget1000_field, 5);

    rfc_param(&importing[0], "EXITCODE", TYPC, exitcode, 1);
    rfc_param(&importing[1], "TEXT0332", TYPC, text0332, 72);
    rfc_param(&importing[2], "TEXT1000", TYPC, text1000, 72);

    /* terminate array */
    tables[4].name = NULL;

#ifdef SAPonUNIX
    gettimeofday(&sfillmsec, &tzp);
#else
    ftime(&sfillmsec);
#endif

    /* Fill table ITAB0332 as required */
    if (fill_table(tables[0].ithandle, lgit0332))
      printf("\nERROR: Fill table itab0332\n");

    /* Fill table ITAB1000 as required */
    if (fill_table(tables[1].ithandle, lgit1000))
      printf("\nERROR: Fill table itab1000\n");  

#ifdef SAPonUNIX
    gettimeofday(&efillmsec, &tzp);
#else
    ftime(&efillmsec);
#endif

    printf("\n<==  RfcCallReceive (%s)     rfc_rc = ", function);
    rfc_rc = RfcCallReceive(rfc_handle,
			    function,
			    exporting,
			    importing,
			    tables,
			    &exception);
    printf("%d\n", rfc_rc);

    /* check return code */
    switch(rfc_rc)
    {
      case RFC_OK:
        break;
      case RFC_EXCEPTION:
      case RFC_SYS_EXCEPTION:
        rfc_error(exception);
        break;
      default:
        rfc_error("RfcCallReceive");
        break;
    }

    display("Export Parameter", exporting);

    display("Import Parameter", importing);

#ifdef SAPonUNIX
    gettimeofday(&ecallmsec, &tzp);
#else
    ftime(&ecallmsec);
#endif

    /* Compute required times */
#ifdef SAPonUNIX
    msecopen = diffmsec(&eopenmsec, &sopenmsec);
    mseccall = diffmsec(&ecallmsec, &scallmsec);
    msecfill = diffmsec(&efillmsec, &sfillmsec);
#else
    msecopen = diffmsec_NON_UNIX(&eopenmsec, &sopenmsec);
    mseccall = diffmsec_NON_UNIX(&ecallmsec, &scallmsec);
    msecfill = diffmsec_NON_UNIX(&efillmsec, &sfillmsec);
#endif
  
    totalsnd = ((long)lgit0332 * 332) + ((long)lgit1000 * 1000);
    totalrcv = ((long)lget0332 * 332) + ((long)lget1000 * 1000);
    totaldat = totalsnd + totalrcv;

    printf("\n\n%s", text0332);
    printf("\n%s", text1000);
  
    /*----------------------------------------------------------------*/
    /* Check and output result of test                                */
    /*----------------------------------------------------------------*/

    if (exitcode[0] != 'O')
    {
      printf("\n\n ERROR OCCURS !!!!!\n");
      return 0;
    }

    if (checktab[0] == 'Y')
    {
#ifdef SAPonUNIX
      gettimeofday(&schekmsec, &tzp);
#else
      ftime(&schekmsec);
#endif
    }
  
    /* Check receive length, real length and contents of ETAB0332 */
    check_table(tables[2].ithandle,
	        "ETAB0332",
	        lget0332,
	        checktab,
	        texi0332,
	        exitcode);
		
    /* Check receive length and real length of ETAB1000 */
    check_table(tables[3].ithandle,
	        "ETAB1000",
	        lget1000,
	        checktab,
	        texi1000,
	        retcode);

    printf("\n%s", texi0332);
    printf("\n%s", texi1000);

    if (checktab[0] == 'Y')
    {
#ifdef SAPonUNIX
      gettimeofday(&echekmsec, &tzp);
      msecchek = diffmsec(&echekmsec, &schekmsec);
#else
      ftime(&echekmsec);
      msecchek = diffmsec_NON_UNIX(&echekmsec, &schekmsec);
#endif
    }

    /*----------------------------------------------------------------*/
    /* Output result of test if everything OK                         */
    /*----------------------------------------------------------------*/

    if ((exitcode[0] != 'O') || (retcode[0] != 'O'))
    {
      printf("\n\n ERROR OCCURS !!!!!\n");
      return 0;
    }

    printf("\n\n");
    printf("*******************************************************************************\n");
    printf("*                                                                             *\n");
    printf("*  Connect to SAP required                                   %10d msec  *\n", msecopen);
    printf("*                                                                             *\n");
    printf("*  Time for fill export tables before RFC                    %10d msec  *\n", msecfill);
    printf("*                                                                             *\n");  

    if (checktab[0] == 'Y')
    {
      printf("*  Time for RFC (+ remotely check contents of export tables) %10d msec  *\n", mseccall);
      printf("*                                                                             *\n");  
      printf("*  Time for check contents of import tables (locally)        %10d msec  *\n", msecchek);
    }
    else
      printf("*  Time for RFC (No check contents of all tables)            %10d msec  *\n", mseccall);

    printf("*                                                                             *\n");  
    printf("*  Total send data                                           %10ld bytes *\n", totalsnd);
    printf("*                                                                             *\n"); 
    printf("*  Total receive data                                        %10ld bytes *\n", totalrcv);
    printf("*                                                                             *\n"); 
    printf("*  Total transfer data                                       %10ld bytes *\n", totaldat);
    printf("*                                                                             *\n");
    printf("*******************************************************************************\n");

    /*  Output internal tables on screen if required */
    if (printtab[0] == 'Y')
    {
      printf("\n\nHit return key for output internal tables on screen");
      getchar();
      output_table(tables[0].ithandle, "ITAB0332");
      output_table(tables[1].ithandle, "ITAB1000");

      output_table(tables[2].ithandle, "ETAB0332");
      output_table(tables[3].ithandle, "ETAB1000");
    }

    if (nrcount < nrcall-1)
    {
      /* Free all internal tables */
      printf("\n<==  ItFree (ITAB0332)");
      ItFree(tables[0].ithandle);

      printf("\n<==  ItFree (ITAB1000)");
      ItFree(tables[1].ithandle);

      printf("\n<==  ItFree (ETAB0332)");
      ItFree(tables[2].ithandle);

      printf("\n<==  ItFree (ETAB1000)");
      ItFree(tables[3].ithandle);

      printf("\n\nHit return key for next RFC call\n");
      getchar();

      /* RFC server is NON-SAP and use register mode:        */
      /*    ===> Close and Open the RFC connection necessary */
      if ((sapsys[0] == 'E') && (register_mode[0] == 'Y'))
      {
        printf("\n<==  RfcClose\n");
	RfcClose(rfc_handle);
        RFC_connect();
      }

#ifdef SAPonUNIX
      gettimeofday(&scallmsec, &tzp);
#else
      ftime(&scallmsec);
#endif
    }
  }

  /* Delete all internal tables */
  printf("\n<==  ItDelete (ITAB0332)");
  ItDelete(tables[0].ithandle);

  printf("\n<==  ItDelete (ITAB1000)");
  ItDelete(tables[1].ithandle);

  printf("\n<==  ItDelete (ETAB0332)");
  ItDelete(tables[2].ithandle);

  printf("\n<==  ItDelete (ETAB1000)");
  ItDelete(tables[3].ithandle);

  return 0;
}


/*====================================================================*/
/*                                                                    */
/* Call any Function Module in SAP R/3                                */
/*                                                                    */
/* Restriction: NO export or import parameter are supported           */
/*                                                                    */
/*====================================================================*/
int srfcdiag()
{
  get_parameter_for_diag_test();

  RFC_connect();

  for (nrcount=0; nrcount<nrcall; nrcount++)
  {
    /*----------------------------------------------------------------*/
    /* call a function module or a transaction in R/3                 */
    /*----------------------------------------------------------------*/

    if (transaction_test[0] == 'T')
      function = "ABAP4_CALL_TRANSACTION";
    else
      function = fname;

    memset(&exporting[0], 0, sizeof(exporting));
    memset(&importing[0], 0, sizeof(importing));

    if (transaction_test[0] == 'T')
      rfc_param(&exporting[0], "TCODE", TYPC, tcode, 4);

    tables[0].name = NULL;

    printf("\n<==  RfcCallReceive (%s)     rfc_rc = ", function);
    rfc_rc = RfcCallReceive(rfc_handle,
                            function,
                            exporting,
                            importing,
                            tables,
                            &exception);
    printf("%d\n", rfc_rc);

    /* check return code */
    switch(rfc_rc)
    {
      case RFC_OK:
        break;
      case RFC_EXCEPTION:
      case RFC_SYS_EXCEPTION:
        rfc_error(exception);
        break;
      default:
        rfc_error("RfcCallReceive");
        break;
    }

    if (nrcount < nrcall-1)
    {
      printf("\n\nHit return key for next RFC call\n");
      getchar();

      /* RFC server is NON-SAP and use register mode:        */
      /*    ===> Close and Open the RFC connection necessary */
      if ((sapsys[0] == 'E') && (register_mode[0] == 'Y'))
      {
        printf("\n<==  RfcClose\n");
	RfcClose(rfc_handle);
        RFC_connect();
      }
    }
  }

  /* Compute required times */
#ifdef SAPonUNIX
  msecopen = diffmsec(&eopenmsec, &sopenmsec);
#else
  msecopen = diffmsec_NON_UNIX(&eopenmsec, &sopenmsec);
#endif

  printf("\n\n");
  printf("*******************************************************************************\n");
  printf("*                                                                             *\n");
  printf("*  Connect to SAP required                                   %10d msec  *\n", msecopen);
  printf("*                                                                             *\n");
  printf("*******************************************************************************\n");

  return 0;
}


/*--------------------------------------------------------------------*/
/* Prepare and Open a RFC-Connection                                  */
/*--------------------------------------------------------------------*/
int RFC_connect()
{
  printf("\n");

  /* install error handler */
  new_env.allocate     = NULL;
  new_env.errorhandler = rfc_error;
  printf("\n<==  RfcEnvironment (Install Error Handling function)\n");
  RfcEnvironment(&new_env);

#ifdef SAPonUNIX
    gettimeofday(&sopenmsec, &tzp);
#else
    ftime(&sopenmsec);
#endif

#ifdef SAP_RFCOPENEXTV3
  {
    int      sapgui,
	     balanced,
	     trace,
    char    *destination;
    RFC_MODE mode;

    if ((sideinfo[0] == 'Y') || (saprfc_ini[0] == 'Y')
      destination = rfc_dest;
    else
      destination = NULL;

    if ((sapsys[0] == '2') || (sapsys[0] == 'E'))
      mode = RFC_MODE_CPIC;
    else
      mode = RFC_MODE_VERSION_3;

    if (use_sapgui[0] == 'Y')
      sapgui = 1;
    else
      sapgui = 0;

    if (load_balancing[0] == 'Y')
      balanced = 1;
    else
      balanced = 0;

    if (abap_debug[0] == 'Y')
      trace = 2;
    else
      trace = 0;

    if (rfc_trace[0] == 'Y')
      trace = trace + 1;

    printf("\n<==  RfcOpenExtV3             rfc_handle = ");

    rfc_handle = RfcOpenExtV3(destination,
			      mode,
			      ashost,
			      atoi(sysnr),
			      gwhost,
			      gwserv,
			      client,
			      userid,
			      password,
			      language,
			      trace,
			      balanced,
			      mshost,
			      r3name,
			      group,
			      sapgui);

    printf("%d\n", rfc_handle);

    if(rfc_handle == RFC_HANDLE_NULL)
      rfc_error("RfcOpenExtV3");
  }
#else
  if (saprfc_ini[0] == 'Y')
  {
    /*****************************/
    /* Working with 'saprfc.ini' */
    /*****************************/
    rfc_opt.destination = rfc_dest;
    rfc_opt.mode        = RFC_MODE_PARAMETER;
    rfc_opt.connopt     = NULL;
    rfc_opt.client      = client;
    rfc_opt.user        = userid;
    rfc_opt.password    = password;
    rfc_opt.language    = language;
    rfc_opt.trace       = 0;
  }
  else
  {
    /*****************************/
    /* Without 'saprfc.ini'      */
    /*****************************/
    if ((sapsys[0] == '2') || (sapsys[0] == 'E'))
    {
      /*=================================================*/
      /* RFC server is an R/2 system or external program */
      /*=================================================*/
      memset(&rfc_connopt_cpic, 0, sizeof(rfc_connopt_cpic));
      rfc_opt.destination = rfc_dest;
      rfc_opt.mode        = RFC_MODE_CPIC;
      rfc_opt.connopt     = &rfc_connopt_cpic;
      rfc_opt.client      = client;
      rfc_opt.user        = userid;
      rfc_opt.password    = password;
      rfc_opt.language    = language;
      if (rfc_trace[0] == 'Y')
        rfc_opt.trace = 1;
      else
        rfc_opt.trace = 0;

      if (sideinfo[0] == 'N')
      {
	/* No local sideinfo */
	rfc_connopt_cpic.gateway_host    = gwhost;
	rfc_connopt_cpic.gateway_service = gwserv;
      }
    }
    else
    {
      /*=============================*/
      /* RFC server is an R/3 system */
      /*=============================*/
      memset(&rfc_connopt_version_3, 0, sizeof(rfc_connopt_version_3));
      rfc_opt.mode        = RFC_MODE_VERSION_3;
      rfc_opt.connopt     = &rfc_connopt_version_3;
      rfc_opt.client      = client;
      rfc_opt.user        = userid;
      rfc_opt.password    = password;
      rfc_opt.language    = language;
      if (rfc_trace[0] == 'Y')
        rfc_opt.trace = 1;
      else
        rfc_opt.trace = 0;

      /* 'D': Working with ABAP debugger  */
      /* 'E': ABAP debugger and RFC trace */
      if (abap_debug[0] == 'Y')
        rfc_opt.trace = rfc_opt.trace + 'D';
      else
      {
        if (use_sapgui[0] == 'Y')
	  rfc_connopt_version_3.use_sapgui = 1;
        else
	  rfc_connopt_version_3.use_sapgui = 0;
      }

      if (sideinfo[0] == 'Y')
      {
        /*+++++++++++++++++++++++++*/
        /* Working with 'sideinfo' */
        /*+++++++++++++++++++++++++*/
        rfc_opt.destination = rfc_dest;
      }
      else
      {
        /*+++++++++++++++++++++++++*/
        /* Without 'sideinfo'      */
        /*+++++++++++++++++++++++++*/
	if (load_balancing[0] == 'Y')
	{
	  /*-----------------------------------------*/
	  /* Using Load Balancing for connect to R/3 */
	  /*-----------------------------------------*/
	  rfc_connopt_version_3.use_load_balancing = 1;
	  rfc_connopt_version_3.lb_host            = mshost;
	  rfc_connopt_version_3.lb_system_name     = r3name;
	  rfc_connopt_version_3.lb_group           = group;
        }
	else
	{
	  /*------------------------------------------*/
	  /* Connect to a specific application server */
	  /*------------------------------------------*/
	  rfc_connopt_version_3.hostname = ashost;
	  rfc_connopt_version_3.sysnr    = atoi(sysnr);
	}
      }
    }
  }

  printf("\n<==  RfcOpen                  rfc_handle = ");
  rfc_handle = RfcOpen(&rfc_opt);
  printf("%d\n", rfc_handle);

  if(rfc_handle == RFC_HANDLE_NULL)
    rfc_error("RfcOpen");
#endif

#ifdef SAPonUNIX
    gettimeofday(&eopenmsec, &tzp);
#else
    ftime(&eopenmsec);
#endif

  return 0;
}


/*--------------------------------------------------------------------*/
/* set up RFC parameters                                              */
/*--------------------------------------------------------------------*/
void rfc_param(RFC_PARAMETER *rfc_param,
	       char          *abap_field_name,
	       unsigned      data_type,
	       void          *data_addr,
	       unsigned      data_len)
{
  RFC_PARAMETER *p = rfc_param;

  p->name = (void *)abap_field_name;
  p->nlen = abap_field_name == NULL ? 0 : strlen(abap_field_name);
  p->type = data_type;
  p->addr = data_addr;
  p->leng = data_len;

  /* init next parameter for no more parameter */

  p++;
  p->name = NULL;
  p->nlen = 0;
  p->type = 0;
  p->addr = NULL;
  p->leng = 0;

  return;
}


/*--------------------------------------------------------------------*/
/* Error Cleanup because of a RFC-Error                               */
/* Because of Windows DLL function must not be defined as static      */
/*--------------------------------------------------------------------*/
void DLL_CALL_BACK_FUNCTION rfc_error(char *operation)
{
  memset(&error_info, 0, sizeof(error_info));

  printf("\n<==  RfcLastError\n");

  RfcLastError(&error_info);

  if (function != NULL)
    fprintf(stderr, "\nFUNCTION: %s", function);

  if (exception != NULL)
    fprintf(stderr, "\nEXCEPTION: %s", exception);

  fprintf(stderr, "\nRFC operation/code %s\n", operation);

  fprintf(stderr, "ERROR/EXCEPTION\n");
  fprintf(stderr, "key     : %s\n", error_info.key);
  fprintf(stderr, "status  : %s\n", error_info.status);
  fprintf(stderr, "message : %s\n", error_info.message);
  fprintf(stderr, "internal: %s\n", error_info.intstat);

  printf("\n<==  RfcClose\n");
  RfcClose(RFC_HANDLE_NULL);

  exit(1);
}


/*--------------------------------------------------------------------*/
/* Display RFC-Parameter                                              */
/*--------------------------------------------------------------------*/
void display(char          *arrow,
	     RFC_PARAMETER *rfc_param)
{
  char  s[256];
  RFC_PARAMETER *p = rfc_param;

  i = 1;
  while (p->name != NULL)
  {
    printf("\n%s %d:", arrow, i);
    printf(" %-08s", p->name);
    printf("    length = %-5u", p->leng);
    if (p->addr != NULL && p->leng > 0)
    {
      switch(p->type)
      {
	case TYPC:
	  printf("  type = TYPC");
	  memset(s, 0, sizeof(s));
	  memcpy(s, p->addr, p->leng);
	  printf("\n      value = ");
	  printf("'%s'\n",s);
	  break;

	case TYPINT:
	  printf("  type = TYPINT");
	  memcpy(&j, p->addr, sizeof(int));
	  printf("\n      value = ");
	  printf("%d\n", j );
	  break;

	default:
	  break;
      }
    }
    p++; i++;
  }
  return;
}


void display_rfcsi( RFCSI * rfcsi )
{
#define OUT( text, value ) \
    printf( "%-22s %-.*s\n", text, sizeof(rfcsi->value), rfcsi->value );
#define OUTX( text, value, add ) \
    printf( "%-22s %-.*s %s\n", text, sizeof(rfcsi->value), \
            rfcsi->value, (add) );
#define NLINE printf( "\n" )
#define HEADER( text ) \
   printf( "%s\n-----------------------------------------------\n\n", \
           (text) );

    NLINE;
    NLINE;
    HEADER( "SAP System Information" );
    NLINE;
    OUT( "Destination", rfcdest );
    NLINE;
    OUT( "Host", rfchost );
    OUT( "System ID", rfcsysid );
    OUT( "Database", rfcdatabs );
    OUT( "DB host", rfcdbhost );
    OUT( "DB system", rfcdbsys );
    NLINE;
    OUT( "SAP release", rfcsaprl );
    NLINE;
    OUT( "RFC Protokoll", rfcproto );
    OUT( "Characters", rfcchartyp );
    OUT( "Integers ", rfcinttyp );
    OUT( "Floating P.", rfcflotyp );
    OUT( "SAP machine id", rfcmach );
    NLINE;
    OUTX( "Timezone", rfctzone,
          rfcsi->rfcdayst[0] != ' ' ? "(Daylight saving time)" : "" );

    NLINE;
    NLINE;
} /* display_rfcsi */


/*--------------------------------------------------------------------*/
/* Search for certain parameter                                       */
/*--------------------------------------------------------------------*/
int PM_search(char *param,
	      char *text,
	      int  leng)
{
  char  *pa,
	*pe;

  memset(param, '\0', leng);
  pa = strstr(sbuf, text);
  if (pa == NULL)
    return 99;

  pa = pa + strlen(text);

  pe = (char *) memchr(pa, ' ', leng);
  if (pe == NULL)
    znr = &sbuf[strlen(sbuf)] - pa;
  else
    znr = pe - pa;

  if (znr == 0)
    return 99;

  if (znr > leng)
    znr = leng;

  memcpy(param, pa, znr);

  return 0;
}


/*--------------------------------------------------------------------*/
/* Get parameters for CONNECTION test                                 */
/*--------------------------------------------------------------------*/
void get_parameter_for_conn_test()
{

  /* Open the work file */
  work_fp = fopen(work_file, "r");
  if (work_fp == NULL)
  {
    get_connect_data_via_dialog();
    wbuf[strlen(wbuf)] = '\n';
    strcpy(wbuf+strlen(wbuf), sbuf2);
    save_test_parameter();
  }
  else
  {
    get_connect_data_from_file();
    if (work_fp != NULL)
    {
      fclose(work_fp);
      work_fp = NULL;
    }
  }
  return;
}


/*--------------------------------------------------------------------*/
/* Get parameters for PERFORMANCE test                                */
/*--------------------------------------------------------------------*/
void get_parameter_for_load_test()
{
  memset(lgit0332_field, 0, 5);
  memset(lgit1000_field, 0, 5);
  memset(lget0332_field, 0, 5);
  memset(lget1000_field, 0, 5);

  /* Open the work file */
  work_fp = fopen(work_file, "r");
  if (work_fp == NULL)
  {
    get_connect_data_via_dialog();
    get_load_test_data_via_dialog();
    save_test_parameter();
  }
  else
  {
    get_connect_data_from_file();
    get_load_test_data_from_file();
    if (work_fp != NULL)
    {
      fclose(work_fp);
      work_fp = NULL;
    }
  }

  return;
}


/*--------------------------------------------------------------------*/
/* Get parameters for SAPGUI test                                     */
/*--------------------------------------------------------------------*/
void get_parameter_for_diag_test()
{

  /* Open the work file */
  work_fp = fopen(work_file, "r");
  if (work_fp == NULL)
  {
    get_connect_data_via_dialog();
    get_diag_test_data_via_dialog();
    save_test_parameter();
  }
  else
  {
    get_connect_data_from_file();
    get_diag_test_data_from_file();
    if (work_fp != NULL)
    {
      fclose(work_fp);
      work_fp = NULL;
    }
  }

  return;
}


/*--------------------------------------------------------------------*/
/* Get connect data from file                                         */
/*--------------------------------------------------------------------*/
void get_connect_data_from_file()
{
  if (read_record(work_fp, sbuf1) == NULL)
  {
    printf("\nCannot read data file\n");
    exit(1);
  }
  strcpy(sbuf, sbuf1);
  read_record(work_fp, sbuf2);

  get_connection_parameters_from_file();

  if ((sapsys[0] == '2') || (sapsys[0] == '3'))
  {
    printf("\n\n               SAP LOGON DATA:");

    /* Client */
    memset(client, '\0', 3);
    rc = PM_search(client, "CLIENT=", 3);
    if (rc)
    {
      printf("\n\nInfo about Client (CLIENT=) not found or not correct");
      exit(1);
    }
    printf("\n                 Client..................................: %s", client);

    /* User Id */
    memset(userid, '\0', 12);
    rc = PM_search(userid, "USERID=", 12);
    if (rc)
    {
      printf("\n\nInfo about User Id (USERID=) not found or not correct");
      exit(1);
    }
    printf("\n                 UserID..................................: %s", userid);

    /* Password */
    memset(password, '\0', 8);
    rc = PM_search(password, "PASSWORD=", 8);
    if (rc)
    {
      printf("\n\nInfo about Password (PASSWORD=) not found or not correct");
      exit(1);
    }
    printf("\n                 Password................................: XXXXXXXX");
    znr = strlen(password);
    for (i = 0; i < znr; i++)
      password[i] = (char) (password[i] + 30 + i);

    /* Language */
    memset(language, '\0', 1);
    rc = PM_search(language, "LANGUAGE=", 1);
    language[0] = (char) toupper(language[0]);
    if (rc)
      language[0] = 'E';
    printf("\n                 Language................................: %c", language[0]);
  }

  /* Number of Calls of this RFC-function */
  memset(nrcall_field, '\0', 5);
  rc = PM_search(nrcall_field, "NRCALL=", 5);
  if (rc)
    strcpy(nrcall_field, "00001");

  nrcall = atol(nrcall_field);
  sprintf(nrcall_field, "%05d", nrcall);
  printf("\n\n               #Calls of this RFC-function...............: %s", nrcall_field);

  /* Last confirm for test */
  if ((action == '1') || (action == '2'))
  {
    printf("\n\n");
    do
    {
      printf("            Do You Want To Test With These Parameters (Y/N)..: ");
      gets(ips);
      ips[0] = (char) toupper(ips[0]);
    } while ((ips[0] != 'Y') && (ips[0] != 'N'));

    if ((abap_debug[0] == 'Y') && (strcmp(userid, "SAPCPIC") == 0))
    {
      printf("\n\nNo access for ABAP debugging as SAPCPIC (It's a CPIC-User)!!!");
      printf("\n\nHit return key to continue\n");
      getchar();
      ips[0] = 'N';
    }

    if (ips[0] == 'N')
    {
      if (work_fp != NULL)
      {
        fclose(work_fp);
        work_fp = NULL;
      }
      get_connect_data_via_dialog();
      save_test_parameter();
    }
  }

  return;
}


/*--------------------------------------------------------------------*/
/* Get connect data via dialog                                        */
/*--------------------------------------------------------------------*/
void get_connect_data_via_dialog()
{
  do
  {
    memset(wbuf, '\0', 512);

    get_connection_parameters_via_dialog();

    if ((sapsys[0] == '2') || (sapsys[0] == '3'))
    {
      printf("\n               SAP LOGON DATA:\n");

      /* Client */
      if (strlen(client) == 0)
        strcpy(client, "000");
      printf("                 Client..................................: (%s): ", client);
      gets(ips);
      if (strlen(ips) == 0)
        strcpy(ips, client);
      znr = strlen(ips);
      if (znr > 3)
        znr = 3;
      memcpy(&client[3-znr], ips, znr);
      sprintf(wbuf+strlen(wbuf), "CLIENT=%s ", client);

      /* User Id */
      if (strlen(userid) == 0)
        strcpy(userid, "SAPCPIC");
      printf("                 UserID..................................: (%s): ", userid);
      gets(ips);
      if (strlen(ips) == 0)
        strcpy(ips, userid);
      ips[12] = 0;
      strcpy(userid, ips);
      for (i = 0; i < (int) strlen(ips); i++)
        userid[i] = (char) toupper(userid[i]);
      sprintf(wbuf+strlen(wbuf), "USERID=%s ", userid);
  
      /* Password */
      if (strlen(password) == 0)
        strcpy(password, "admin");
      printf("                 Password................................: (XXXXXXXX):");
      gets(ips);
      if (strlen(ips) == 0)
        strcpy(ips, password);
      ips[8] = 0;
      strcpy(password, ips);
      for (i = 0; i < (int) strlen(password); i++)
        password[i] = (char) (toupper(password[i]) - 30 - i);
      sprintf(wbuf+strlen(wbuf), "PASSWORD=%s ", password);
      for (i = 0; i < (int) strlen(password); i++)
        password[i] = (char) (password[i] + 30 + i);

      /* Language */
      if (strlen(language) == 0)
        language[0] = 'E';
      printf("                 Language (E)............................: (%c): ", language[0]);
      gets(ips);
      if (strlen(ips) == 0)
        ips[0] = language[0];
      language[0] = (char) toupper(ips[0]);
      sprintf(wbuf+strlen(wbuf), "LANGUAGE=%c ", language[0]);
    }

    /* Number of Calls of this RFC-function */
    printf("\n");
    if (strlen(nrcall_field) == 0)
      strcpy(nrcall_field, "00001");
    printf("               #Calls of this RFC-function...............: (%s): ", nrcall_field);
    gets(ips);
    if (strlen(ips) == 0)
      strcpy(ips, nrcall_field);
    ips[5] = 0;
    strcpy(nrcall_field, ips);
    nrcall = atol(nrcall_field);
    sprintf(nrcall_field, "%05d", nrcall);
    sprintf(wbuf+strlen(wbuf), "NRCALL=%s \n", nrcall_field);

    /* Last confirm for test */
    if ((action != '1') && (action != '2'))
      ips[0] = 'Y';
    else
    {
      printf("\n");
      do
      {
	printf("            Do You Want To Test With These Parameters (Y/N)..: ");
	gets(ips);
	ips[0] = (char) toupper(ips[0]);
      } while ((ips[0] != 'Y') && (ips[0] != 'N'));
    }

    if ((abap_debug[0] == 'Y') && (strcmp(userid, "SAPCPIC") == 0))
    {
      printf("\n\nNo access for ABAP debugging as SAPCPIC (It's a CPIC-User)!!!");
      printf("\n\nHit return key to continue\n");
      getchar();
      ips[0] = 'N';
    }
  } while (ips[0] != 'Y');

  return;
}


/*--------------------------------------------------------------------*/
/* Get connection parameters from file                                */
/*--------------------------------------------------------------------*/
void get_connection_parameters_from_file()
{
  printf("\n\n               CONNECTION PARAMETERS:");

  /* Working with 'saprfc.ini' */
  memset(saprfc_ini, ' ', 1);
  rc = PM_search(saprfc_ini, "RFCINI=", 1);
  if (rc)
    saprfc_ini[0] = 'Y';
  printf("\n                 Working with 'saprfc.ini' (Y/N)Y........: %c", saprfc_ini[0]);

  if (saprfc_ini[0] == 'Y')
  {
    /* Destination in 'saprfc.ini' */
    memset(rfc_dest, '\0', 32);
    rc = PM_search(rfc_dest, "DEST=", 32);
    if (rc)
    {
      printf("\n\nInfo about destination (DEST=) not found or not correct");
      exit(1);
    }
    printf("\n                 Destination in 'saprfc.ini'.............: %s", rfc_dest);

    /* RFC server is SAP R/2 or R/3 or External */
    memset(sapsys, '\0', 1);
    rc = PM_search(sapsys, "SAPSYS=", 1);
    if (rc)
      sapsys[0] = '3';
    printf("\n                 Server is R/2, R/3 or External (2/3/E)3.: %c", sapsys[0]);

    /* If External, Using register mode ? */
    if (sapsys[0] == 'E')
    {
      memset(register_mode, '\0', 1);
      rc = PM_search(register_mode, "REGMOD=", 1);
      if (rc)
        register_mode[0] = 'Y';
      printf("\n                 Using registering feature (Y/N)Y........: %c", register_mode[0]);
    }
  }
  else
  {
    /* RFC server is SAP R/2 or R/3 or External */
    memset(sapsys, '\0', 1);
    rc = PM_search(sapsys, "SAPSYS=", 1);
    if (rc)
      sapsys[0] = '3';
    printf("\n                 Server is R/2, R/3 or External (2/3/E)3.: %c", sapsys[0]);

    /* If External, Using register mode ? */
    if (sapsys[0] == 'E')
    {
      memset(register_mode, '\0', 1);
      rc = PM_search(register_mode, "REGMOD=", 1);
      if (rc)
        register_mode[0] = 'Y';
      printf("\n                 Using registering feature (Y/N)Y........: %c", register_mode[0]);
    }

    /* Working with local sideinfo */
    memset(sideinfo, ' ', 1);
    rc = PM_search(sideinfo, "SIDEINFO=", 1);
    if (rc)
      sideinfo[0] = 'Y';
    printf("\n                 Working with local sideinfo (Y/)Y.......: %c", sideinfo[0]);

    if ((sapsys[0] == '2') || (sapsys[0] == 'E'))
    {
      /* Destination in sideinfo */
      memset(rfc_dest, '\0', 32);
      rc = PM_search(rfc_dest, "DEST=", 32);
      if (rc)
      {
        printf("\n\nInfo about destination (DEST=) not found or not correct");
        exit(1);
      }
      if (sideinfo[0] == 'Y')
        printf("\n                 DEST in 'sideinfo' (local and gateway)..: %s", rfc_dest);
      else
        printf("\n                 DEST in 'sideinfo' for the SAP gateway..: %s", rfc_dest);

      if (sideinfo[0] == 'N')
      {
        memset(gwhost, '\0', 100);
        rc = PM_search(gwhost, "GWHOST=", 100);
        if (rc)
        {
          printf("\n\nInfo about gateway host name (GWHOST=) not found or not correct");
          exit(1);
        }
        printf("\n                 Host name of the SAP gateway to R/2.....: %s", gwhost);

        memset(gwserv, '\0', 7);
        rc = PM_search(gwserv, "GWSERV=", 7);
        if (rc)
        {
          printf("\n\nInfo about gateway service (GWSERV=) not found or not correct");
          exit(1);
        }
        printf("\n                 Service of the specified SAP gateway....: %s", gwserv);
      }
      printf("\n\n               RFC-SPECIFIC PARAMETERS:");
    }
    else
    {
      if (sideinfo[0] == 'Y')
      {
        /* Destination in sideinfo */
        memset(rfc_dest, '\0', 32);
        rc = PM_search(rfc_dest, "DEST=", 32);
        if (rc)
        {
          printf("\n\nInfo about destination (DEST=) not found or not correct");
          exit(1);
        }
        printf("\n                 DEST in locale 'sideinfo'...............: %s", rfc_dest);
      }
      else
      {
        /* Use load balancing for connect to R/3 */	
        memset(load_balancing, ' ', 1);
        rc = PM_search(load_balancing, "BALANCE=", 1);
        if (rc)
	  load_balancing[0] = 'Y';
        printf("\n                 Use load balancing (Y/N)Y...............: %c", load_balancing[0]);
  
        if (load_balancing[0] == 'Y')
        {
          /* R/3 name */
          memset(r3name, '\0', 3);
          rc = PM_search(r3name, "R3NAME=", 3);
          if (rc)
          {
            printf("\n\nInfo about R/3 name (R3NAME=) not found or not correct");
            exit(1);
          }
          printf("\n                 R/3 system name.........................: %s", r3name);

          /* R/3 message server */
          memset(mshost, '\0', 100);
          rc = PM_search(mshost, "MSHOST=", 100);
          if (rc)
          {
            printf("\n\nInfo about message server (MSHOST=) not found or not correct");
            exit(1);
          }
          printf("\n                 Host name of the message server.........: %s", mshost);

          /* R/3 selected group */
          memset(group, '\0', 32);
          rc = PM_search(group, "GROUP=", 32);
          if (rc)
          {
            printf("\n\nInfo about selected group (GROUP=) not found or not correct");
            exit(1);
          }
          printf("\n                 Selected group..........................: %s", group);
        }
        else
        {
          /* R/3 Application server */
          memset(ashost, '\0', 100);
          rc = PM_search(ashost, "ASHOST=", 100);
          if (rc)
          {
            printf("\n\nInfo about application server (ASHOST=) not found or not correct");
            exit(1);
          }
          printf("\n                 Host name of an application server......: %s", ashost);
  
          /* R/3 System number */
          memset(sysnr, '\0', 2);
          rc = PM_search(sysnr, "SYSNR=", 2);
          if (rc)
          {
            printf("\n\nInfo about system number (SYSNR=) not found or not correct");
            exit(1);
          }
          printf("\n                 System number...........................: %s", sysnr);
        }
      }

      printf("\n\n               RFC-SPECIFIC PARAMETERS:");
      /* Using ABAP debugger */
      memset(abap_debug, ' ', 1);
      rc = PM_search(abap_debug, "DEBUG=", 1);
      if (rc)
        abap_debug[0] = 'N';
      printf("\n                 Working with ABAP debugger (Y/N)N.......: %c", abap_debug[0]);
  
      /* Using SAPGUI */
      if (abap_debug[0] == 'Y')
      {
	use_sapgui[0] = 'Y';
        printf("\n                 Use SAPGUI (Y/N)N.......................: %c", use_sapgui[0]);
      }
      else
      {
        if (action == '4')
        {
	  use_sapgui[0] = 'Y';
          printf("\n                 Use SAPGUI (Y/N)N.......................: %c", use_sapgui[0]);
        }
	else
	{
          memset(use_sapgui, ' ', 1);
          rc = PM_search(use_sapgui, "SAPGUI=", 1);
          if (rc)
            use_sapgui[0] = 'N';
          printf("\n                 Use SAPGUI (Y/N)N.......................: %c", use_sapgui[0]);
        }
      }
    }

    /* RFC-Trace */
    memset(rfc_trace, ' ', 1);
    rc = PM_search(rfc_trace, "TRACE=", 1);
    if (rc)
      rfc_trace[0] = 'N';
    printf("\n                 RFC-Trace (Y/N)N........................: %c", rfc_trace[0]);
  }
  return;
}


/*--------------------------------------------------------------------*/
/* Get connection parameters via dialog                               */
/*--------------------------------------------------------------------*/
void get_connection_parameters_via_dialog()
{
  printf("\n\n               CONNECTION PARAMETERS:\n");

  /* Working with saprfc.ini */
  if (strlen(saprfc_ini) == 0)
    saprfc_ini[0] = 'Y';
  do
  {
    printf("                 Working with 'saprfc.ini' (Y/N)Y........: (%c): ", saprfc_ini[0]);
    gets(ips);
    if (strlen(ips) == 0)
      ips[0] = saprfc_ini[0];
    ips[0] = (char) toupper(ips[0]);
  } while ((ips[0] != 'Y') && (ips[0] != 'N'));
  saprfc_ini[0] = ips[0];
  sprintf(wbuf+strlen(wbuf), "RFCINI=%c ", saprfc_ini[0]);

  if (saprfc_ini[0] == 'Y')
  {
    /* Destination in saprfc.ini */
    if (strlen(rfc_dest) == 0)
      strcpy(rfc_dest, std_rfc_dest_r3);
    printf("                 Destination in 'saprfc.ini'.............: (%s): ", rfc_dest);
    gets(ips);
    if (strlen(ips) == 0)
      strcpy(ips, rfc_dest);
    ips[32] = 0;
    strcpy(rfc_dest, ips);
    for (i = 0; i < (int) strlen(rfc_dest); i++)
      rfc_dest[i] = (char) toupper(rfc_dest[i]);
    sprintf(wbuf+strlen(wbuf), "DEST=%s ", rfc_dest);

    /* RFC server is SAP R/2 or R/3 or External */
    if (strlen(sapsys) == 0)
      sapsys[0] = '3';
    do
    {
      printf("                 Server is R/2, R/3 or External (2/3/E)3.: (%c): ", sapsys[0]);
      gets(ips);
      if (strlen(ips) == 0)
        ips[0] = sapsys[0];
      ips[0] = (char) toupper(ips[0]);
    } while ((ips[0] != '2') && (ips[0] != '3') && (ips[0] != 'E'));
    sapsys[0] = ips[0];
    sprintf(wbuf+strlen(wbuf), "SAPSYS=%c ", sapsys[0]);

    /* If External, Using register mode ? */
    if (sapsys[0] == 'E')
    {
      if (strlen(register_mode) == 0)
        register_mode[0] = 'Y';
      do
      {
        printf("                 Using registering feature (Y/N)Y........: (%c): ", register_mode[0]);
        gets(ips);
        if (strlen(ips) == 0)
          ips[0] = register_mode[0];
        ips[0] = (char) toupper(ips[0]);
      } while ((ips[0] != 'Y') && (ips[0] != 'N'));
      register_mode[0] = ips[0];
      sprintf(wbuf+strlen(wbuf), "REGMOD=%c ", register_mode[0]);
    }
  }
  else
  {
    /* RFC server is SAP R/2 or R/3 or External */
    if (strlen(sapsys) == 0)
      sapsys[0] = '3';
    do
    {
      printf("                 Server is R/2, R/3 or External (2/3/E)3.: (%c): ", sapsys[0]);
      gets(ips);
      if (strlen(ips) == 0)
        ips[0] = sapsys[0];
      ips[0] = (char) toupper(ips[0]);
    } while ((ips[0] != '2') && (ips[0] != '3') && (ips[0] != 'E'));
    sapsys[0] = ips[0];
    sprintf(wbuf+strlen(wbuf), "SAPSYS=%c ", sapsys[0]);

    /* If External, Using register mode ? */
    if (sapsys[0] == 'E')
    {
      if (strlen(register_mode) == 0)
        register_mode[0] = 'Y';
      do
      {
        printf("                 Using registering feature (Y/N)Y........: (%c): ", register_mode[0]);
        gets(ips);
        if (strlen(ips) == 0)
          ips[0] = register_mode[0];
        ips[0] = (char) toupper(ips[0]);
      } while ((ips[0] != 'Y') && (ips[0] != 'N'));
      register_mode[0] = ips[0];
      sprintf(wbuf+strlen(wbuf), "REGMOD=%c ", register_mode[0]);
    }

    /* Working with local sideinfo */
    if (sapsys[0] == 'E')
    {
      sideinfo[0] = 'Y';
      printf("                 Working with local sideinfo (Y/N)Y......: %c\n", sideinfo[0]);
    }
    else
    {
      if (strlen(sideinfo) == 0)
        sideinfo[0] = 'Y';
      do
      {
        printf("                 Working with local sideinfo (Y/N)Y......: (%c): ", sideinfo[0]);
        gets(ips);
        if (strlen(ips) == 0)
          ips[0] = sideinfo[0];
        ips[0] = (char) toupper(ips[0]);
      } while ((ips[0] != 'Y') && (ips[0] != 'N'));
      sideinfo[0] = ips[0];
    }
    sprintf(wbuf+strlen(wbuf), "SIDEINFO=%c ", sideinfo[0]);

    if ((sapsys[0] == '2') || (sapsys[0] == 'E'))
    {
      /* Destination in sideinfo */
      if (strlen(rfc_dest) == 0)
        strcpy(rfc_dest, std_rfc_dest_r2);
      if (sideinfo[0] == 'Y')
        printf("                 DEST in 'sideinfo' (local and gateway)..: (%s): ", rfc_dest);
      else
        printf("                 DEST in 'sideinfo' for gateway to R/2...: (%s): ", rfc_dest);
      gets(ips);
      if (strlen(ips) == 0)
        strcpy(ips, rfc_dest);
      ips[32] = 0;
      strcpy(rfc_dest, ips);
      for (i = 0; i < (int) strlen(rfc_dest); i++)
        rfc_dest[i] = (char) toupper(rfc_dest[i]);
      sprintf(wbuf+strlen(wbuf), "DEST=%s ", rfc_dest);

      if (sideinfo[0] == 'N')
      {
        /* Host name of a SAP gateway */
        if (strlen(gwhost) == 0)
          strcpy(gwhost, std_gwhost);
        printf("                 Host name of the SAP gateway to R/2.....: (%s): ", gwhost);
        gets(ips);
        if (strlen(ips) == 0)
          strcpy(ips, gwhost);
        ips[100] = 0;
        strcpy(gwhost, ips);
        sprintf(wbuf+strlen(wbuf), "GWHOST=%s ", gwhost);

        /* Service of the specified SAP gateway */
        if (strlen(gwserv) == 0)
          strcpy(gwserv, std_gwserv);
        printf("                 Service of the specified gateway........: (%s): ", gwserv);
        gets(ips);
        if (strlen(ips) == 0)
          strcpy(ips, gwserv);
        ips[7] = 0;
        strcpy(gwserv, ips);
        sprintf(wbuf+strlen(wbuf), "GWSERV=%s ", gwserv);
      }
      printf("\n               RFC-SPECIFIC PARAMETERS:\n");
    }
    else
    {
      if (sideinfo[0] == 'Y')
      {
        /* Destination in sideinfo */
        if (strlen(rfc_dest) == 0)
          strcpy(rfc_dest, std_rfc_dest_r3);
        printf("                 DEST in local 'sideinfo'................: (%s): ", rfc_dest);
        gets(ips);
        if (strlen(ips) == 0)
          strcpy(ips, rfc_dest);
        ips[32] = 0;
        strcpy(rfc_dest, ips);
        for (i = 0; i < (int) strlen(rfc_dest); i++)
          rfc_dest[i] = (char) toupper(rfc_dest[i]);
        sprintf(wbuf+strlen(wbuf), "DEST=%s ", rfc_dest);
      }
      else
      {
        /* Working with load balancing */
        if (strlen(load_balancing) == 0)
          load_balancing[0] = 'Y';
        do
	{
	  printf("                 Use load balancing (Y/N)Y...............: (%c): ", load_balancing[0]);
          gets(ips);
          if (strlen(ips) == 0)
            ips[0] = load_balancing[0];
          ips[0] = (char) toupper(ips[0]);
        } while ((ips[0] != 'Y') && (ips[0] != 'N'));
        load_balancing[0] = ips[0];
        sprintf(wbuf+strlen(wbuf), "BALANCE=%c ", load_balancing[0]);

        if (load_balancing[0] == 'Y')
        {
          /* R/3 System name */
          if (strlen(r3name) == 0)
            strcpy(r3name, std_r3name);
          printf("                 R/3 system name.........................: (%s): ", r3name);
          gets(ips);
          if (strlen(ips) == 0)
            strcpy(ips, r3name);
          ips[3] = 0;
          strcpy(r3name, ips);
          for (i = 0; i < (int) strlen(r3name); i++)
            r3name[i] = (char) toupper(r3name[i]);
          sprintf(wbuf+strlen(wbuf), "R3NAME=%s ", r3name);

          /* R/3 message server */
          if (strlen(mshost) == 0)
            strcpy(mshost, std_mshost);
          printf("                 Host name of the message server.........: (%s): ", mshost);
          gets(ips);
          if (strlen(ips) == 0)
            strcpy(ips, mshost);
          ips[100] = 0;
          strcpy(mshost, ips);
          sprintf(wbuf+strlen(wbuf), "MSHOST=%s ", mshost);

          /* R/3 Selected group */
          if (strlen(group) == 0)
            strcpy(group, std_group);
          printf("                 Selected group (PUBLIC).................: (%s): ", group);
          gets(ips);
          if (strlen(ips) == 0)
            strcpy(ips, group);
          ips[32] = 0;
          strcpy(group, ips);
          sprintf(wbuf+strlen(wbuf), "GROUP=%s ", group);
        }
        else
        {
          /* R/3 application server */
          if (strlen(ashost) == 0)
            strcpy(ashost, std_ashost);
          printf("                 Host name of an application server......: (%s): ", ashost);
          gets(ips);
          if (strlen(ips) == 0)
            strcpy(ips, ashost);
          ips[100] = 0;
          strcpy(ashost, ips);
          sprintf(wbuf+strlen(wbuf), "ASHOST=%s ", ashost);

          /* R/3 System number */
          if (strlen(sysnr) == 0)
            strcpy(sysnr, std_sysnr);
          printf("                 System number...........................: (%s): ", sysnr);
          gets(ips);
          if (strlen(ips) == 0)
            strcpy(ips, sysnr);
          ips[2] = 0;
          strcpy(sysnr, ips);
          sprintf(wbuf+strlen(wbuf), "SYSNR=%s ", sysnr);
        }
      }

      printf("\n               RFC-SPECIFIC PARAMETERS:\n");
      /* Using ABAP debugger */
      if (strlen(abap_debug) == 0)
        abap_debug[0] = 'N';
      do
      {
        printf("                 Working with ABAP debugger (Y/N)N.......: (%c): ", abap_debug[0]);
        gets(ips);
        if (strlen(ips) == 0)
          ips[0] = abap_debug[0];
        ips[0] = (char) toupper(ips[0]);
      } while ((ips[0] != 'Y') && (ips[0] != 'N'));
      abap_debug[0] = ips[0];
      sprintf(wbuf+strlen(wbuf), "DEBUG=%c ", abap_debug[0]);

      /* Using SAPGUI */
      if (abap_debug[0] == 'Y')
      {
        use_sapgui[0] = 'Y';
        printf("                 Use SAPGUI (Y/N)N.......................: (%c): \n", use_sapgui[0]);
      }
      else
      {
	if (action == '4')
	{
          use_sapgui[0] = 'Y';
          printf("                 Use SAPGUI (Y/N)N.......................: (%c): \n", use_sapgui[0]);
	}
	else
	{
          if (strlen(use_sapgui) == 0)
            use_sapgui[0] = 'N';
          do
          {
            printf("                 Use SAPGUI (Y/N)N.......................: (%c): ", use_sapgui[0]);
            gets(ips);
            if (strlen(ips) == 0)
              ips[0] = use_sapgui[0];
            ips[0] = (char) toupper(ips[0]);
          } while ((ips[0] != 'Y') && (ips[0] != 'N'));
          use_sapgui[0] = ips[0];
        }
      }
      sprintf(wbuf+strlen(wbuf), "SAPGUI=%c ", use_sapgui[0]);
    }

    /* RFC-Trace */
    if (strlen(rfc_trace) == 0)
      rfc_trace[0] = 'N';
    do
    {
      printf("                 RFC trace (Y/N)N........................: (%c): ", rfc_trace[0]);
      gets(ips);
      if (strlen(ips) == 0)
        ips[0] = rfc_trace[0];
      ips[0] = (char) toupper(ips[0]);
    } while ((ips[0] != 'Y') && (ips[0] != 'N'));
    rfc_trace[0] = ips[0];
    sprintf(wbuf+strlen(wbuf), "RFCTRACE=%c ", rfc_trace[0]);
  }
  return;
}


/*--------------------------------------------------------------------*/
/* Save parameters for next tests                                     */
/*--------------------------------------------------------------------*/
void save_test_parameter()
{

  /* Open the work file */
  work_fp = fopen(work_file, "w");
  if (work_fp == NULL)
  {
    printf("\n\nCan not save RFC-parameters for next tests");
    printf("\n\nHit return key to continue\n");
    getchar();
  }
  else
  {
    fputs(wbuf, work_fp);
    fclose(work_fp);
    work_fp = NULL;
  }
  return;
}


/*--------------------------------------------------------------------*/
/* Get load test data from file                                       */
/*--------------------------------------------------------------------*/
void get_load_test_data_from_file(void)
{
  strcpy(sbuf, sbuf2);

  printf("\n\n               PERFORMANCE TEST DATA:");

  /* No of lines for ITAB0332 */
  memset(lgit0332_field, '\0', 5);
  rc = PM_search(lgit0332_field, "LGIT0332=", 5);
  if (rc)
    memset(lgit0332_field, '0', 5);

  lgit0332 = atol(lgit0332_field);
  sprintf(lgit0332_field, "%05d", lgit0332);
  printf("\n                 #Lines in export table (length 0332)....: %s", lgit0332_field);

  /* No of lines for ITAB1000 */
  memset(lgit1000_field, 0, 5);
  rc = PM_search(lgit1000_field, "LGIT1000=", 5);
  if (rc)
    memset(lgit1000_field, '0', 5);

  lgit1000 = atol(lgit1000_field);
  sprintf(lgit1000_field, "%05d", lgit1000);
  printf("\n                 #Lines in export table (length 1000)....: %s", lgit1000_field);

  /* No of lines for ETAB0332 */
  memset(lget0332_field, 0, 5);
  rc = PM_search(lget0332_field, "LGET0332=", 5);
  if (rc)
    memset(lget0332_field, '0', 5);

  lget0332 = atol(lget0332_field);
  sprintf(lget0332_field, "%05d", lget0332);
  printf("\n                 #Lines in import table (length 0332)....: %s", lget0332_field);

  /* No of lines for ETAB1000 */
  memset(lget1000_field, 0, 5);
  rc = PM_search(lget1000_field, "LGET1000=", 5);
  if (rc)
    memset(lget1000_field, '0', 5);

  lget1000 = atol(lget1000_field);
  sprintf(lget1000_field, "%05d", lget1000);
  printf("\n                 #Lines in import table (length 1000)....: %s", lget1000_field);

  /* Check contents of tables */
  rc = PM_search(checktab, "CHECKTAB=", 1);
  if (rc)
    checktab[0] = 'N';

  printf("\n                 Check contents of tables (Y/N)N.........: %c", checktab[0]);

  /* Output tables on sreen */
  rc = PM_search(printtab, "PRINTTAB=", 1);
  if (rc)
    printtab[0] = 'N';

  printf("\n                 Output tables on screen (Y/N)N..........: %c", printtab[0]);

  /* Last confirm for test */
  printf("\n\n");
  do
  {
    printf("            Do You Want To Test With These Parameters (Y/N)..: ");
    gets(ips);
    ips[0] = (char) toupper(ips[0]);
  } while ((ips[0] != 'Y') && (ips[0] != 'N'));

  if ((abap_debug[0] == 'Y') && (strcmp(userid, "SAPCPIC") == 0))
  {
    printf("\n\nNo access for ABAP debugging as SAPCPIC (It's a CPIC-User)!!!");
    printf("\n\nHit return key to continue\n");
    getchar();
    ips[0] = 'N';
  }

  if (ips[0] == 'N')
  {
    if (work_fp != NULL)
    {
      fclose(work_fp);
      work_fp = NULL;
    }
    get_connect_data_via_dialog();
    get_load_test_data_via_dialog();
    save_test_parameter();
  }

  return;
}


/*--------------------------------------------------------------------*/
/* Get load test data via dialog                                      */
/*--------------------------------------------------------------------*/
void get_load_test_data_via_dialog(void)
{
  printf("\n               PERFORMANCE TEST DATA:\n");

  /* No of lines for ITAB0332 */
  if (strlen(lgit0332_field) == 0)
    strcpy(lgit0332_field, "00000");
  printf("                 #Lines in export table (length 0332)....: (%s): ", lgit0332_field);
  gets(ips);
  if (strlen(ips) == 0)
    strcpy(ips, lgit0332_field);
  ips[5] = 0;
  strcpy(lgit0332_field, ips);
  lgit0332 = atol(lgit0332_field);
  sprintf(lgit0332_field, "%05d", lgit0332);
  sprintf(wbuf+strlen(wbuf), "LGIT0332=%s ", lgit0332_field);

  /* No of lines for ITAB1000 */
  if (strlen(lgit1000_field) == 0)
    strcpy(lgit1000_field, "00000");
  printf("                 #Lines in export table (length 1000)....: (%s): ", lgit1000_field);
  gets(ips);
  if (strlen(ips) == 0)
    strcpy(ips, lgit1000_field);
  ips[5] = 0;
  strcpy(lgit1000_field, ips);
  lgit1000 = atol(lgit1000_field);
  sprintf(lgit1000_field, "%05d", lgit1000);
  sprintf(wbuf+strlen(wbuf), "LGIT1000=%s ", lgit1000_field);

  /* No of lines for ETAB0332 */
  if (strlen(lget0332_field) == 0)
    strcpy(lget0332_field, "00000");
  printf("                 #Lines in import table (length 0332)....: (%s): ", lget0332_field);
  gets(ips);
  if (strlen(ips) == 0)
    strcpy(ips, lget0332_field);
  ips[5] = 0;
  strcpy(lget0332_field, ips);
  lget0332 = atol(lget0332_field);
  sprintf(lget0332_field, "%05d", lget0332);
  sprintf(wbuf+strlen(wbuf), "LGET0332=%s ", lget0332_field);

  /* No of lines for ETAB1000 */
  if (strlen(lget1000_field) == 0)
    strcpy(lget1000_field, "00000");
  printf("                 #Lines in import table (length 1000)....: (%s): ", lget1000_field);
  gets(ips);
  if (strlen(ips) == 0)
    strcpy(ips, lget1000_field);
  ips[5] = 0;
  strcpy(lget1000_field, ips);
  lget1000 = atol(lget1000_field);
  sprintf(lget1000_field, "%05d", lget1000);
  sprintf(wbuf+strlen(wbuf), "LGET1000=%s ", lget1000_field);

  /* Check contents of tables */
  if (strlen(checktab) == 0)
    checktab[0] = 'N';
  do
  {
    printf("                 Check contents of tables (Y/N)N.........: (%c): ", checktab[0]);
    gets(ips);
    if (strlen(ips) == 0)
      ips[0] = checktab[0];
    ips[0] = (char) toupper(ips[0]);
  } while ((ips[0] != 'Y') && (ips[0] != 'N'));
  checktab[0] = ips[0];
  sprintf(wbuf+strlen(wbuf), "CHECKTAB=%c ", checktab[0]);

  /* Output tables on screen */
  if (strlen(printtab) == 0)
    printtab[0] = 'N';
  do
  {
    printf("                 Output tables on screen (Y/N)N..........: (%c): ", printtab[0]);
    gets(ips);
    if (strlen(ips) == 0)
      ips[0] = printtab[0];
    ips[0] = (char) toupper(ips[0]);
  } while ((ips[0] != 'Y') && (ips[0] != 'N'));
  printtab[0] = ips[0];
  sprintf(wbuf+strlen(wbuf), "PRINTTAB=%c \n", printtab[0]);

  /* Last confirm for test */
  printf("\n");
  do
  {
    printf("            Do You Want To Test With These Parameters (Y/N)..: ");
    gets(ips);
    ips[0] = (char) toupper(ips[0]);
  } while ((ips[0] != 'Y') && (ips[0] != 'N'));

  if ((abap_debug[0] == 'Y') && (strcmp(userid, "SAPCPIC") == 0))
  {
    printf("\n\nNo access for ABAP debugging as SAPCPIC (It's a CPIC-User)!!!");
    printf("\n\nHit return key to continue\n");
    getchar();
    ips[0] = 'N';
  }

  if (ips[0] == 'N')
  {
    if (work_fp != NULL)
    {
      fclose(work_fp);
      work_fp = NULL;
    }
    get_connect_data_via_dialog();
    get_load_test_data_via_dialog();
    save_test_parameter();
  }
  return;
}


/*--------------------------------------------------------------------*/
/* Get diag test data from file                                       */
/*--------------------------------------------------------------------*/
void get_diag_test_data_from_file(void)
{
  strcpy(sbuf, sbuf2);

  printf("\n\n               RFC WITH SAPGUI TEST DATA:");

  /* Start a transaction or a function module in R/3 */
  rc = PM_search(transaction_test, "GUITEST=", 1);
  if (rc)
    transaction_test[0] = 'F';
  printf("\n                 Start transaction or function (T/F)F....: %c", transaction_test[0]);

  /* Name of a transaction or a function module in R/3 */
  if (transaction_test[0] == 'T')
  {
    memset(tcode, '\0', 30);
    rc = PM_search(tcode, "TCODE=", 30);
    if (rc)
      strcpy(tcode, std_tcode);
    printf("\n                 Name of transaction in R/3..............: %s", tcode);
  }
  else
  {
    memset(fname, '\0', 30);
    rc = PM_search(fname, "FNAME=", 30);
    if (rc)
      strcpy(fname, std_fname);
    printf("\n                 Name of function module in R/3..........: %s", fname);
  }

  /* Last confirm for test */
  printf("\n\n");
  do
  { 
    printf("            Do You Want To Test With These Parameters (Y/N)..: ");
    gets(ips);
    ips[0] = (char) toupper(ips[0]);
  } while ((ips[0] != 'Y') && (ips[0] != 'N'));

  if ((abap_debug[0] == 'Y') && (strcmp(userid, "SAPCPIC") == 0))
  {
    printf("\n\nNo access for ABAP debugging as SAPCPIC (It's a CPIC-User)!!!");
    printf("\n\nHit return key to continue\n");
    getchar();
    ips[0] = 'N';
  }

  if (ips[0] == 'N')
  {
    if (work_fp != NULL)
    {
      fclose(work_fp);
      work_fp = NULL;
    }
    get_connect_data_via_dialog();
    get_diag_test_data_via_dialog();
    save_test_parameter();
  }

  return;
}


/*--------------------------------------------------------------------*/
/* Get diag test data via dialog                                      */
/*--------------------------------------------------------------------*/
void get_diag_test_data_via_dialog(void)
{
  printf("\n               RFC WITH SAPGUI TEST DATA:\n");

  /* Start a transaction or a function module in R/3 */
  if (strlen(transaction_test) == 0)
    transaction_test[0] = 'F';
  do
  {
    printf("                 Start transaction or function (T/F)F....: (%c): ", transaction_test[0]);
    gets(ips);
    if (strlen(ips) == 0)
      ips[0] = transaction_test[0];
    ips[0] = (char) toupper(ips[0]);
  } while ((ips[0] != 'T') && (ips[0] != 'F'));
  transaction_test[0] = ips[0];
  sprintf(wbuf+strlen(wbuf), "GUITEST=%c ", transaction_test[0]);

  /* Name of a transaction or a function module in R/3 */
  if (transaction_test[0] == 'T')
  {
    if (strlen(tcode) == 0)
      strcpy(tcode, std_tcode);
    printf("                 Name of transaction (SE38)..............: (%s): ", tcode);
    gets(ips);
    if (strlen(ips) == 0)
      strcpy(ips, tcode);
    else
      ips[4] = 0;
    znr = strlen(ips);
    for (i = 0; i < znr; i++)
      ips[i] = (char) toupper(ips[i]);
    strcpy(tcode, ips);
    sprintf(wbuf+strlen(wbuf), "TCODE=%s ", tcode);
  }
  else
  {
    if (strlen(fname) == 0)
      strcpy(fname, std_fname);
    printf("                 Name of function module (STFC_SAPGUI)...: (%s): ", fname);
    gets(ips);
    if (strlen(ips) == 0)
      strcpy(ips, fname);
    else
      ips[30] = 0;
    znr = strlen(ips);
    for (i = 0; i < znr; i++)
      ips[i] = (char) toupper(ips[i]);
    strcpy(fname, ips);
    sprintf(wbuf+strlen(wbuf), "FNAME=%s ", fname);
  }

  /* Last confirm for test */
  printf("\n");
  do
  {
    printf("            Do You Want To Test With These Parameters (Y/N)..: ");
    gets(ips);
    ips[0] = (char) toupper(ips[0]);
  } while ((ips[0] != 'Y') && (ips[0] != 'N'));

  if ((abap_debug[0] == 'Y') && (strcmp(userid, "SAPCPIC") == 0))
  {
    printf("\n\nNo access for ABAP debugging as SAPCPIC (It's a CPIC-User)!!!");
    printf("\n\nHit return key to continue\n");
    getchar();
    ips[0] = 'N';
  }

  if (ips[0] == 'N')
  {
    if (work_fp != NULL)
    {
      fclose(work_fp);
      work_fp = NULL;
    }
    get_connect_data_via_dialog();
    get_diag_test_data_via_dialog();
    save_test_parameter();
  }
  return;
}


/*--------------------------------------------------------------------*/
/* read record from file with single or multi line                    */
/*--------------------------------------------------------------------*/
char *read_record(FILE *fp,
		  char *ibuf)
{
  int   offset = 0;
  char  line[LINE_SIZE+1];

  ibuf[0] = '\0';

  for (;;)
  {
    if ((ptr = fgets(line, LINE_SIZE, fp)) == NULL)
      return (NULL);

    if (line[strlen(line)-1] == '\n')
      line[strlen(line)-1] = '\0';

    ptr = line;
    switch (*ptr)
    {
      case '\0': continue;
      case '*' : continue;
      case ' ' : continue;
      default  : ;
    }

    strcpy(ibuf+offset, ptr);

    if (ibuf[strlen(ibuf)-1] == '&')
    {
      ibuf[strlen(ibuf)-1] = '\0';
      offset = strlen(ibuf);
      continue;
    }
    break;
  }
  return (ibuf);
}


/*--------------------------------------------------------------------*/
/* Fill internal table as required                                    */
/*--------------------------------------------------------------------*/
int fill_table(ITAB_H itab_h,
	       long   leng)
{
  long		position,
		linenr;
  char		etext[1001];

  if (leng == 0)
    return 0;

  lineleng = ulen = ItLeng(itab_h);

  memset(etext, BLANK, 1000);

  for (position=40; position<lineleng; position++)
    sprintf(etext+position, "%01d", position % 10);

  sprintf(etext, "Line Length: %04d   Line No.: ", lineleng);

  for (linenr=1; linenr<=leng; linenr++)
  {
    sprintf(etext+30, "%05d", linenr);
    etext[35] = ' ';

    ptr = (char *) ItAppLine(itab_h);
    if (ptr == NULL) break;
    memcpy(ptr, etext, ulen);
  }

  if (linenr <= leng)
    return 1;
  else
    return 0;
}


/*--------------------------------------------------------------------*/
/* Check ETABnnnn                                                     */
/*--------------------------------------------------------------------*/
int check_table(ITAB_H itab_h,
		char   *itabname,
		long   recvleng,
		char   *checktab,
		char   *rtext,
		char   *retcode)
{
  long	position;
  char	value[2],
	tbuff[1001],
	etext[73]= " ",
	errline[40]="ERROR:  #Lines = nnnnn  Expected: nnnnn",
	errcont[40]="ERROR at line nnnnn position nnnn:  n/n",
	mtext[73]  ="Import table (length nnnn):  #Lines = nnnnn: OK,  Contents: OK";

  memset(etext, ' ', 72);

  itableng = ItFill(itab_h);
  lineleng = ulen = ItLeng(itab_h);

  strcpy(etext, mtext);
  etext[strlen(etext)] = ' ';

  if (itabname[0] == 'I')
    memcpy(etext, "Ex", 2);

  memcpy(etext+21, itabname+4, 4);

  if (itableng != recvleng)
  {
    memcpy(etext+28, errline, 39);
    sprintf(etext+45, "%05d", itableng);
    etext[50] = ' ';
    sprintf(etext+62, "%05d", recvleng);
    etext[67] = ' ';
    retcode[0] = 'E';
  }
  else
  {
    sprintf(etext+38, "%05d", itableng);
    etext[43] = ':';
    retcode[0] = 'O';

    if (checktab[0] != 'Y')
      memcpy(etext+60, "NO CHECK", 8);
    else
    {
      for (j = 1; ; j++)
      {
	ptr = (char *) ItGetLine(itab_h, j);
	if (ptr == NULL) break;

	memcpy(tbuff, ptr, ulen);
	tbuff[lineleng] = '\0';

	for (position=40; position<lineleng; position++)
	{
	  sprintf(value, "%01d", position % 10);
	  if (value[0] != tbuff[position])
	  {
	    retcode[0] = 'E';
	    break;
	  }
	  position = position + 1;
	}
	if (retcode[0] == 'E')
	{
	  memcpy(etext+28, errcont, 39);
	  sprintf(etext+42, "%05d", j);
	  etext[47] = ' ';
	  sprintf(etext+57, "%05d", position);
	  etext[62] = ' ';
	  etext[64] = tbuff[position];
	  etext[66] = value[0];
	  break;
	}
      }
    }
  }
  strcpy(rtext, etext);
  return 0;
}


/*--------------------------------------------------------------------*/
/* Output itab on screen                                              */
/*--------------------------------------------------------------------*/
int output_table(ITAB_H itab_h,
		 char   *itabname)
{
  char tbuff[1001];

  lineleng = ulen = ItLeng(itab_h);

  printf("\n%s:\n", itabname);

  for (j = 1; ; j++)
  {
    ptr = (char *) ItGetLine(itab_h, j);
    if (ptr == NULL) break;

    memcpy(tbuff, ptr, ulen);
    tbuff[lineleng] = '\0';
    printf("'%s'\n", tbuff);
  }
  return 0;
}


/*--------------------------------------------------------------------*/
/* Compute time in millisec.                                          */
/*--------------------------------------------------------------------*/
#ifdef SAPonUNIX
unsigned long int diffmsec (struct timeval *tmend,
			    struct timeval *tmstart)
{
  if (tmstart->tv_usec > tmend->tv_usec)
  {
    tmend->tv_usec += 1000000;
    tmend->tv_sec--;
  }
  msectime = (tmend->tv_usec - tmstart->tv_usec)/1000 +
	     (tmend->tv_sec - tmstart->tv_sec)*1000;

  return msectime;
}
#else
unsigned long int diffmsec_NON_UNIX (struct timeb *tmend,
				     struct timeb *tmstart)
{

  if (tmstart->millitm > tmend->millitm)
  {
      tmend->millitm = tmend->millitm + 1000;
      tmend->time = tmend->time - 1;
  }
  msectime = ((long)tmend->millitm - (long)tmstart->millitm) +
	     (tmend->time - tmstart->time)*1000;

  return msectime;
}
#endif

