#!/bin/sh

BASEDIR=/MySQL
SOCKET_PATH=${BASEDIR}/var/mysql.sock
PID_PATH=${BASEDIR}/var/mysql.pid
DATADIR=${BASEDIR}/var
TEMP=/tmp
USER=mysql
DEFS_FILE=${BASEDIR}/etc/my.cnf

if [ `uname` = "SunOS" ]; then
	PATH="/usr/ucb:/usr/xpg4/bin:$PATH"
fi

running() {
	if [ -r ${PID_PATH} ]; then
		if kill -0 `cat ${PID_PATH}` 2> /dev/null; then
			return 0
		fi
		rm -f ${PID_PATH}
	fi
	return 1
}

start() {
	if running; then
		echo "MySQL is already running"
		return 0
	fi

	echo -n "Starting MySQL ... "

	$BASEDIR/bin/mysqld --defaults-file=${DEFS_FILE} --basedir=${BASEDIR} --datadir=${DATADIR} \
		--user=${USER} --skip-networking --socket=${SOCKET_PATH} \
		--pid-file=${PID_PATH} --tmpdir=${TEMP} 2> /dev/null 1> /dev/null &

	if [ $? -eq 0 ]; then
		sleep 3
		chmod go-rw ${SOCKET_PATH}
		echo "[OK]"
		return 0
	else
		echo "[FAILED]"
	fi
	return 1
}

stop() {
	if running; then
		:
	else
		echo "MySQL is not running"
		return 0
	fi

	echo -n "Stopping MySQL ...  "

	if kill -TERM `cat ${PID_PATH}` 2> /dev/null; then
		sleep 3
		echo "[OK]"
		return 0
	else
		echo "[FAILED"
	fi
	return 1
}

restart() {
	stop
	sleep 3
	start
}

status() {
	if running; then
		echo "MySQL is running"
		return 0
	else
		echo "MySQL is not running"
		return 1
	fi
}

case "$1" in
	start)
		start
		;;
	stop)
		stop
		;;
	restart)
		restart
		;;
	status)
		status
		;;
	*)
		echo $"Usage: $0 {start|stop|status|restart}"
		exit 1
esac

exit $?
