#!/bin/sh

NAME="Session Clustering daemon"
PREFIX=/usr/local/Zend
RUNAS=65534
ZEND_INI=${PREFIX}/etc/zend.ini
BINARY=ZendSessionManager
DISABLE=

if [ ! -z "${DISABLE}" ]; then
	echo "${NAME} is disabled! To enable run: ${PREFIX}/bin/sc_enable.sh"
	exit 0
fi

PS_CMD="/bin/ps ax"
ID_CMD="id -u"
if [ `uname` = "SunOS" ]; then
	PATH="/usr/ucb:$PATH"
	PS_CMD="/bin/ps -ef"
	ID_CMD="/usr/xpg4/bin/id -u"
fi

# Check whether we are not running the user we need:
if [ "`${ID_CMD}`" != "${RUNAS}" ]; then
	${PREFIX}/bin/runas ${RUNAS} "$0 $*"
	ret=$?
	exit $ret
fi	

ZEND_TEMP=`grep zend_temp_dir ${ZEND_INI} 2> /dev/null | sed 's/zend_temp_dir *= *//'`
if [ -z "${ZEND_TEMP}" ]; then
	echo "Missing 'zend_temp_dir' directive in ${ZEND_INI}!"
	exit 1
fi

PID_FILE=${ZEND_TEMP}/${BINARY}_starter.lock
SCD_PID_FILE=${ZEND_TEMP}/${BINARY}.lock

lookup_process()
{
	if ${PS_CMD} | grep $1 | grep $2 2> /dev/null 1> /dev/null; then
		return 0
	fi
	return 1
}

start_scd()
{
	while : ; do
		EVENT_NODEVPOLL=yes EVENT_NOKQUEUE=yes ${PREFIX}/bin/${BINARY} -p ${ZEND_INI} -x -i
		if [ $? -ne 0 ]; then
			return 1
		fi
	done
	return 0
}

stop_scd()
{
	ret=0
	if [ -r ${SCD_PID_FILE} ]; then
		pid=`cat ${SCD_PID_FILE}`
		if lookup_process $pid ${BINARY} ; then
			kill -TERM $pid
			ret=$?
		else
			rm -f ${SCD_PID_FILE}
		fi
	fi
	return $ret
}

running() {
	if [ -r ${SCD_PID_FILE} ]; then
		if lookup_process `cat ${SCD_PID_FILE}` ${BINARY} ; then
			return 0
		fi
		rm -f ${SCD_PID_FILE}
	fi
	return 1
}

start() {
	if running; then
		echo "${NAME} is already running"
		return 0
	fi

	echo -n "Starting ${NAME} ... "

	$0 start_scd&
	pid=$!
	sleep 1
	if lookup_process $pid "start_scd" ; then
		echo $pid > ${PID_FILE}
		echo "[OK]"
		return 0
	else
		echo "[FAILED]"
	fi
	return 1
}

stop() {
	if running; then
		:
	else
		echo "${NAME} is not running"
		return 0
	fi

	echo -n "Stopping ${NAME} ...  "

	if kill -TERM `cat ${PID_FILE}` 2> /dev/null; then
		echo "[OK]"
		return 0
	else
		echo "[FAILED"
	fi
	return 1
}

restart() {
	stop
	stop_scd
	sleep 2
	start
}

status() {
	pid=`cat ${SCD_PID_FILE} 2>/dev/null`
	if running; then
		echo "${NAME} is running (PID: ${pid})"
		return 0
	else
		echo "${NAME} is not running"
		return 1
	fi
}

case "$1" in
	start)
		stop_scd
		start
		;;
	stop)
		stop
		stop_scd
		;;
	graceful_stop)
		stop
		pid=`cat ${SCD_PID_FILE}`
		kill -USR2 ${pid}	
		;;
	restart)
		restart
		;;
	status)
		status
		;;
	start_scd) # For internal use only
		start_scd
		;;
	*)
		echo $"Usage: $0 {start|stop|graceful_stop|status|restart}"
		exit 1
esac

exit $?
