<?

define('OK',          1<<1);
define('CANCEL',      1<<2);
define('SUBMIT',      1<<3);
define('NEXT',        1<<4);
define('BACK',        1<<5);
define('YES',         1<<6);
define('NO',          1<<7);


class Dbuilder
{
  var $dbuilder;
	var $dbuilder_fp;
  var $dbuilder_out;
  var $dbuilder_in;
	var $dbuilder_in_fp;
	var $scenario_file;
  var $cols;
  var $rows;

  function Dbuilder()
  {
    $this->dbuilder = "./dbuilder";
		
    if(!@file_exists($this->dbuilder) || !@is_executable($this->dbuilder)){
      die("./dbuilder: doesn't exist or not executable\n");
    }
    
		$this->dbuilder_out = "/tmp/dbuilder.output.".getmypid();
    $this->dbuilder_in = "/tmp/dbuilder.input.".getmypid();
		$this->scenario_file = "/tmp/dbuilder.scenario.".getmypid();
		
		@unlink($this->scenario_file);
  }

	// ADD_COMP_ARRAY
	function add_comp_array($args)
	{
		if(is_array($args)) {
			foreach ($args as $arg) {
				$this->add_comp_array($arg);
			}
		}
		else {
			$args = str_replace("\n", "\n\n", $args);
			if(strlen($args) == 0) {
				$args = "_"; // special symbol for empty string ('')
			}
			$fp = fopen ($this->scenario_file, "a");
			fwrite ($fp, "$args\n");
			fwrite ($fp, ".\n");
			fclose ($fp);
		}
	}
	
	// ADD_COMP
  function add_comp()
  {
		$args = func_get_args();
		$this->add_comp_array ($args);
  }

	// DIALOG_EXEC
  function dialog_exec()
  {
    $exec_cmd = "$this->dbuilder --input $this->dbuilder_in --output $this->dbuilder_out --scenario $this->scenario_file";

		posix_mkfifo ($this->dbuilder_in, 0600);
		$this->dbuilder_fp = popen($exec_cmd, "w");
		$this->dbuilder_in_fp = fopen($this->dbuilder_in, "w");
  }

	// SEND_MSG
	function send_msg($msg)
	{
		@fwrite($this->dbuilder_in_fp, $msg);
		@fflush($this->dbuilder_in_fp);
	}

	// UPDATE_VIEW
	function update_view($id, $value)
	{
		$this->send_msg("UPDATE $id\n$value\n.\n");
	}

	// DESTROY_DIALOG
	function destroy_dialog()
	{
		$this->send_msg("DESTROY\n");
		while(@file_exists($this->dbuilder_in));
	}

	// GET_SIMPLE_OUTPUT
  function get_simple_output()
  {
		@pclose($this->dbuilder_fp);
		@fclose($this->dbuilder_in_fp);

		@unlink($this->scenario_file);
		
    $file = @file($this->dbuilder_out);
		@unlink($this->dbuilder_out);

    return $file;
  }

	// GET_PARSED_OUTPUT
  function get_parsed_output()
  {
    $file = $this->get_simple_output();
		$output = array();

		if($file) {
			foreach($file as $line){
				$line = chop($line);
				if(preg_match("/^(.*)=(.*)$/", $line, $match)){
					$output[$match[1]] = $match[2];
				}
				else{
					die("Error output: $line");
				}
			}
		}
		return $output;
  }
	
	// CALC_WIN_SIZE
  function calc_win_size()
  {
    system("$this->dbuilder --output $this->dbuilder_out --printsize 1>/dev/null 2>/dev/null", $status);
    if($status==0 && preg_match("/(\d+)\s+(\d+)/", join("", $this->get_simple_output()), $match)){
      $this->cols = $match[1];
      $this->rows = $match[2];
    }
    else{
      die("Cannot get screen size\n");
    }
  }

	// GET_TEXT_SIZE
  function get_text_size($text)
  {
    $width = 40;
    $height = 1;

    foreach(preg_split("/\r?\n/", $text) as $line){
			$len = strlen($line);
      if($width < $len){
        $width = $len;
      }
      $height++;
    }

    return array($width, $height);
  }

	// SET_TITLE
  function set_title($text)
  {
    $this->add_comp("title", $text);
  }

	// SET_BACKTITLE
  function set_backtitle($text)
  {
    $this->add_comp("backtitle", $text);
  }

	// SET_SIZE
  function set_size($width, $height)
  {
    $this->add_comp("windowsize", $width, $height);
    $this->cols = $width;
    $this->rows = $height;
  }

  //=================================
  // Buttons functions
  //=================================
  
	// BUTTON
  function button($type)
  {
    $btns = array();
    if($type & YES){
      array_push($btns, array("YES", "Yes"));
    }
    if($type & NO){
      array_push($btns, array("NO", "No"));
    }
    if($type & BACK){
      array_push($btns, array("BACK", "Back"));
    }
    if($type & OK){
      array_push($btns, array("OK", "Ok"));
    }
    if($type & SUBMIT){
      array_push($btns, array("SUBMIT", "Submit"));
    }
    if($type & NEXT){
      array_push($btns, array("NEXT", "Next"));
    }
    if($type & CANCEL){
      array_push($btns, array("CANCEL", "Cancel"));
    }
    $this->btns_panel($btns);
  }

	// BTNS_PANEL
  function btns_panel($btns)
  {
    $d = 2;
    $s = $this->cols/2 - $d/2;
    foreach($btns as $button){
      $s -= (strlen($button[1]) + 4 + $d)/2;
    }
    foreach($btns as $button){
      $this->add_comp("button", $button[0], intval($s), intval($this->rows-4), $button[1]);
      $s += $d + strlen($button[1]) + 4;
    }
  }

  //=================================
  // Simple forms functions
  //=================================
  
	// PUT_TEXT
	function put_text($text, $add=0, $textarea_id="TEXT")
  {
    $size = $this->get_text_size($text);

    $width = $size[0]*1.1;
    $height = $size[1]*1.1;
    if($width >= $this->cols){
      $text = wordwrap($text, 70);
      $size = $this->get_text_size($text);
    }
    $this->set_size(intval($size[0]*1.1), intval($size[1]*1.1+6+$add));

    $this->add_comp("textarea", $textarea_id, intval(($this->cols-$size[0])/2), 1, intval($size[0]), intval($size[1]), $text);

    return $size[1];
  }

	// TEXTBOX
	function textbox($file, $title, $button_type=null)
	{
		if(!$button_type){
			$button_type = BACK|NEXT|CANCEL;
		}

    $this->calc_win_size();
    if($this->cols > 84){
      $this->set_size(84, $this->rows-2);
    }
    else{
      $this->set_size($this->cols-2, $this->rows-2);
    }
    $this->set_title($title);

		$this->add_comp("textbox", 1, 1, $this->cols-2, $this->rows-6, $file);
    
    $this->button($button_type);
		
		$this->dialog_exec();
		$output = $this->get_parsed_output();

		if(empty($output["BUTTON"]) || $output["BUTTON"] == "CANCEL"){
			return -1;
		}
		return $output;
	}

	// MSGBOX
  function msgbox($title, $text, $button_type=null)
  {
		if(!$button_type){
			$button_type = OK;
		}

    $this->calc_win_size();
    $this->set_title($title);

    $this->put_text($text);
    
    $this->button($button_type);
		
    $this->dialog_exec();
		$output = $this->get_parsed_output();
		
		if(empty($output["BUTTON"]) || $output["BUTTON"] == "CANCEL"){
			return -1;
		}
    return $output;
  }

	// INFOBOX
  function infobox($title, $text)
  {
    $this->calc_win_size();
    $this->set_title($title);
		$this->add_comp("timeout", 1000);

    $this->put_text($text, -5);
    
		$this->dialog_exec();
		sleep(1);
		$this->destroy_dialog();
		$output = $this->get_parsed_output();
		
		if(empty($output["BUTTON"]) || $output["BUTTON"] == "CANCEL"){
			return -1;
		}
    return $output;
  }

	// INPUTBOX
  function inputbox($title, $text, $init="", $button_type=null)
  {
		if(!$button_type){
			$button_type = BACK|NEXT|CANCEL;
		}

    $this->calc_win_size();
    $this->set_title($title);

    $row_cur = $this->put_text($text, 2) + 1; 
  
    $this->add_comp("editbox", "EDIT", intval($this->cols*.2), intval(++$row_cur), $init, intval($this->cols*.6));
		
    $this->button($button_type);

    $this->dialog_exec();
		$output = $this->get_parsed_output();
    
		if(empty($output["BUTTON"]) || $output["BUTTON"] == "CANCEL"){
			return -1;
		}
    return $output["EDIT"];
  }
	
	// PASSWORDBOX
  function passwordbox($title, $text, $init="", $button_type=null)
  {
		if(!$button_type){
			$button_type = BACK|NEXT|CANCEL;
		}

    $this->calc_win_size();
    $this->set_title($title);

    $row_cur = $this->put_text($text, 2) + 1; 
  
    $this->add_comp("passwordbox", "PASS", intval($this->cols*.2), intval(++$row_cur), $init, intval($this->cols*.6));
		
    $this->button($button_type);

    $this->dialog_exec();
		$output = $this->get_parsed_output();
    
		if(empty($output["BUTTON"]) || $output["BUTTON"] == "CANCEL"){
			return -1;
		}
    return $output["PASS"];
  }

	// YESNOBOX
  function yesnobox($title, $text, $button_type=null)
  {
		if(!$button_type){
			$button_type = YES|NO|CANCEL;
		}

    $output = $this->msgbox($title, $text, $button_type);

		if(empty($output["BUTTON"]) || $output["BUTTON"] == "CANCEL"){
			return -1;
		}
    return $output["BUTTON"] == "YES" ? true : ($output["BUTTON"] == "NO" ? false : -1);
  }

	// PASSWORD_GET
  function password_get($title, $text, $button_type=null)
  {
		if(!$button_type){
			$button_type = BACK|NEXT|CANCEL;
		}

    while(true)
    {
      $this->calc_win_size();
      $this->set_title($title);

      $row_cur = $this->put_text($text, 4) + 1;

      $size = $this->cols*.6;

      $this->add_comp("label", "PASS_L", intval($this->cols*.2), intval(++$row_cur), "Password: ");
      $this->add_comp("passwordbox", "PASS", intval($this->cols*.2 + 10), intval($row_cur), "", intval($size-10));
      $this->add_comp("label", "PASSC_L", intval($this->cols*.2), intval(++$row_cur), "Confirm: ");
      $this->add_comp("passwordbox", "PASSC", intval($this->cols*.2 + 10), intval($row_cur), "", intval($size-10));

      $this->button($button_type);

			$this->dialog_exec();
			$output = $this->get_parsed_output();
      
			if(empty($output["BUTTON"]) || $output["BUTTON"] == "CANCEL"){
				return -1;
			}
      if(($output["PASS"] == $output["PASSC"]) && $output["PASS"] != ""){
				return $output["PASS"];
      }
      $this->msgbox("Error", "Passwords don't match", OK);
    }
  }

	// MENUBOX
  function menubox($title, $text, $menu_arr, $default="", $button_type=null)
  {
		if(!$button_type){
			$button_type = BACK|NEXT|CANCEL;
		}

    $this->calc_win_size();
    $this->set_title($title);

    $row_cur = $this->put_text($text, count($menu_arr)+2);

    $this->add_comp("menubox", "MENU", 2, intval(++$row_cur), count($menu_arr)+2, $this->cols-4, $default, count($menu_arr));

		foreach($menu_arr as $id => $val) {
			$this->add_comp($id, $val);
		}

    $this->button($button_type);

		$this->dialog_exec();
		$output = $this->get_parsed_output();

		if(empty($output["BUTTON"]) || $output["BUTTON"] == "CANCEL"){
			return -1;
		}
    return $output["MENU"];
  }

  //===================================
  // Scale functions
  //===================================

	// SCALE
  function scale($title, $text, $full)
  {
    $this->calc_win_size();
    $this->set_title($title);

    $this->put_text($text, 0, "ST1");

    $this->add_comp("scale", "SP1", 2, $this->rows-3, $this->cols-4, $full);

    $this->dialog_exec();
  }

	// SCALE_UPDATE
  function scale_update($percent, $text=null)
  {
    $this->update_view("SP1", $percent);
		if($text) {
			$this->update_view("ST1", $text);
		}
  }

	// SCALE_CLOSE
	function scale_close()
	{
		$this->destroy_dialog();
		$output = $this->get_parsed_output();
	}
}

?>
