/*
 * Port. Some global variables. The cabletron type tables are kept here.
 *
 * Copyright 1992 by the Massachusetts Institute of Technology.
 *
 * For copying and distribution information, please see the file
 * <mit-copyright.h>
 *
 * Tom Coppeto
 * MIT Network Operations
 * 26 January 1992
 *
 *    $Source: /afs/.net.mit.edu/tools/src/port/RCS/data.c,v $
 *    $Author: nocuser $
 *    $Locker:  $
 *    $Log:	data.c,v $
 * Revision 1.4  94/06/21  15:44:51  nocuser
 * *** empty log message ***
 * 
 * Revision 1.3  93/10/19  17:28:54  tom
 * added new types
 * for asante ports
 * 
 * Revision 1.2  93/10/18  12:57:24  tom
 * asante mods
 * 
 * Revision 1.1  92/02/02  13:02:32  tom
 * Initial revision
 * 
 */

#ifndef lint
static char *rcsid = "$Header: /afs/.net.mit.edu/tools/src/port/RCS/data.c,v 1.4 94/06/21 15:44:51 nocuser Exp $";
#endif

#include "port.h"
#include <mit-copyright.h>

int    the_update     = norm_update;
int    the_retry      = norm_retry;
int    the_timeout    = norm_timeout;
int    the_burst      = norm_burst;
char   *the_community = "public";


struct _category empty[] = 
{
  0x0,     "",
};

struct _category ctron_media_types[] =
{
  0x00,    "3rd Part Vendors",  
  0x01,    "IRM",              
  0x02,    "NB20/25",
  0x03,    "NB35",
  0x10,    "THIN_MIM",
  0x50,    "THIN_MIM",
  0x30,    "TRMIM_12",
  0x31,    "TRMIM_RPT",
  0x32,    "TRMIM_24",
  0x33,    "TRMIM_22",
  0x34,    "TRMIM_34",
  0x35,    "TRMIM_32",
  0x36,    "TRFOT_28",
  0x37,    "TRFOT_26",
  0x38,    "TRFOT_22",
  0x39,    "TRFOT_18",
  0x3a,    "TRFOT_12",
  0x3b,    "TRFOT_16",
  0x41,    "TPMIM_T1",
  0x42,    "TPMIM_T",
  0x43,    "TPMIM_T3",
  0x60,    "TPMIM_24",
  0x61,    "TPMIM_22",
  0x62,    "TPMIM_34",
  0x63,    "TPMIM_32",
  0x70,    "FO_22",
  0x80,    "FO_16",
  0x90,    "FOIRL",
  0x92,    "FOM_18",
  0x93,    "FOM_12",
  0x94,    "FOM_16",
  0x95,    "FOM_28",
  0x96,    "FOM_22",
  0x97,    "FOM_26",
  0xb0,    "IRM2",
  0xb1,    "IRBM",
  0xb4,    "TRMBM",
  0xb5,    "IRM/SNMP",
  0xc0,    "FOT_12",
  0xd0,    "TPT",
  0xe0,    "FOT_6",
  0xff,    "NOMIM",
  0x10010, "Mini MMAC",
  0x10020, "MRXI",
  0x20000, "PIM-X",
  0x20001, "PIM-A",
  0x20002, "PIM-C",
  0x20003, "PIM-T",
  0x20004, "PIM-F2",
  0x20005, "PIM-F1",
  0x20006, "PIM-T1",
  0x20007, "PIM-B",  
  0x30043, "MRXI",
  0x300A0, "MRXI-28",
  0x30042, "MRXI-2",
  0x00000, (char *) NULL,
};

struct _category asante_media_types[] = 
{
  0x1,     "mgmt",
  0x2,     "BNC",
  0x3,     "AUI",
  0x4,     "10bT",
  0x5,     "FOIL",
  0x6,     "3in1",
  0x0,     (char *) NULL,
};

struct _category *media_types[] = 
{
  empty,
  ctron_media_types, 
  asante_media_types,
  asante_media_types,
};

struct _category interface_types[] = 
{
  1,        "other",
  2,        "reg1822",
  3,        "hdh1822",
  4,        "x25",
  5,        "x25",
  6,        "ethernet",
  7,        "csmacd",
  8,        "tokenBus",
  9,        "tokenRing",
  10,       "man",
  11,       "starLan",
  12,       "proteon10",
  13,       "proteon80",
  14,       "hyper",
  15,       "fddi",
  16,       "lapb",
  17,       "sdlc",
  18,       "ds1",
  19,       "e1",
  20,       "basicISDN",
  21,       "primISDN",
  22,       "pps",
  23,       "ppp",
  24,       "loop",
  25,       "eon",
  26,       "eth3",
  26,       "nsip",
  27,       "slip",
  28,       "ultra",
  29,       "ds3",
  30,       "sip",
  31,       "fr",
   0,       (char *) NULL,
};



struct _category asante_board_types[] = 
{
  0x1,      "Mgmt/BB",
  0x2,      "12 Port",
  0x5,      "Empty",
  0x6,      "Mgmt",
  0x9,      "12/Bottom",
  0xa,      "12/Top",
  0x1a,     "12/Top*",
  0x19,     "12/Bottom*",
  0x0,      (char *) NULL,
};

struct _category *board_types[] = 
{
  empty,
  ctron_media_types, 
  asante_board_types,
  asante_board_types,
};

struct _category mpboard_type[] = 
{
  0x20000, "MPIM-X",
  0x20001, "MPIM-A",
  0x20002, "MPIM-C",
  0x20003, "MPIM-T",
  0x20004, "MPIM-F2",
  0x20005, "MPIM-F1",
  0x20006, "MPIM-T1",
  0x20007, "MPIM-B",
  0x00000, (char *) NULL,
};

struct _category spboard_type[] = 
{
  0x20001, "SPIM-A",
  0x20002, "SPIM-C",
  0x20003, "SPIM-T",
  0x20004, "SPIM-F2",
  0x20005, "SPIM-F1",
  0x20006, "SPIM-T1",
  0x20007, "SPIM-B",
  0x00000, (char *) NULL,
};



int DEVICE_RESTART[] = {0, 0, 2, 2};
int ADMIN_ERR[]      = {0, 0, 1, 1, 3};
int ADMIN_OFF[]      = {0, 1, 3, 3, 2};
int ADMIN_ON[]       = {0, 2, 2, 2, 1};
int LINK_INACTIVE[]  = {0, 1, 3, 3};
int LINK_ACTIVE[]    = {0, 2, 2, 2};
int LINK_NOSUPP[]    = {0, 3, 1, 1};
int NETWORK_ACTIVE[] = {0, 1, 3, 3, 1};
int NETWORK_SEG[]    = {0, 2, 3, 3, 2};
