/*
 * This is the main file.
 *
 * Copyright 1990 by the Massachusetts Institute of Technology.
 *
 * For copying and distribution information, please see the file
 * <mit-copyright.h>.
 *
 * Tom Coppeto
 * MIT Network Operations
 * 26 January 1992
 *
 *    $Source: /afs/.net.mit.edu/tools/src/port/RCS/main.c,v $
 *    $Author: tom $
 *    $Locker:  $
 *    $Log:	main.c,v $
 * Revision 1.2  92/02/04  19:05:54  tom
 * *** empty log message ***
 * 
 * Revision 1.1  92/02/02  13:02:34  tom
 * Initial revision
 * 
 * 
 */

#ifndef lint
static char *rcsid = "$Header: /afs/.net.mit.edu/tools/src/port/RCS/main.c,v 1.2 92/02/04 19:05:54 tom Exp $";
#endif

#include "port.h"
#include <ss/ss.h>
#include <signal.h>
#include <mit-copyright.h>

extern ss_request_table PROC_TABLE;
static int sci_idx;

main(argc, argv)
     int  argc;
     char **argv;
{
  int code = 0;

  sci_idx = ss_create_invocation("port", VERSION_STRING,
                               (char *) NULL, &PROC_TABLE, &code);
  if (code)
    {
      (void) fprintf(stderr,"%s: error creating ss invocation.\n");
      exit(1);
    }

  (void) ss_add_info_dir(sci_idx, INFO_DIR, &code);
  if (code)
    ss_perror(sci_idx, code, INFO_DIR);

  printf("Repeater Control Program (%s).\n\n", VERSION_STRING);
  (void) ss_listen(sci_idx);
}
 


