/*
 * Port. Header stuff & things.
 *
 * Copyright 1992 by the Massachusetts Institute of Technology.
 *
 * For copying and distribution information, please see the file
 * <mit-copyright.h>.
 *
 * Tom Coppeto
 * MIT Network Operations
 * 26 January 1992
 *
 *    $Header: /afs/.net/tools/src/port/RCS/port.h,v 1.12 1994/06/12 17:27:01 tom Exp tom $
 *    $Author: tom $
 *    $Locker: tom $
 * 
 */

#include <stdio.h>
#include <ctype.h>
#include <strings.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/socket.h>
#include <arpa/snmp/snmp_hs.h>

#define VERSION_STRING "2 5/7"
#define INFO_DIR "/afs/net/tools/lib/port/help"
#define KEYFILE  "/afs/net/tools/lib/port/agent_lists"
#define DBFILE   "/afs/.net/tools/lib/port/port_db"

#define SUCCESS         0
#define ERROR          -1
#define MAX_BOARDS      10

#define INACTIVE        1
#define READONLY        2
#define READWRITE       3
#define SUPERUSER       4

#define CABLETRON       1
#define ASANTE          2
#define ASANTE2072      3
#define MIB2            4
#define HP              5
#define ALLIED_TELESIS  6
#define DAVID_SYSTEMS   7



caddr_t make_snmp_query();
caddr_t make_snmp_next();
caddr_t *make_lots_o_snmp_queries();
caddr_t *make_lots_o_snmp_nexts();

extern objident vSysDescr;
extern objident vSysUptime;
extern objident vNumBoards;

extern objident vDeviceType[];
extern objident vDeviceName[];
#ifdef notdef
extern objident vDeviceIPAddress;
extern objident vDeviceMACAddress;
extern objident vDeviceMACType;
#endif
extern objident vDeviceSlots[];
extern objident vDeviceOccSlots[];
#ifdef notdef
extern objident vDevicePortsOn;
#endif
extern objident vDevicePorts[];
extern objident vDeviceTotalPkts[];
extern objident vDeviceXmitColls[];
extern objident vDeviceRecColls[];
extern objident vDeviceRestart[];
#ifdef notdef
extern objident vDeviceResetCounter;
extern objident vDeviceRedundantCts;
extern objident vDeviceTimeBase;
#endif

extern objident vBoardName[];
extern objident vBoardType[];
extern objident vBoardTotalPorts[];
extern objident vBoardPortsOn[];
extern objident vBoardTotalPkts[];
extern objident vBoardXmitColls[];
extern objident vBoardRecColls[];

extern objident vPortMediaType[];
extern objident vPortAdminStatus[];
extern objident vPortLinkStatus[];
extern objident vPortNetworkStatus[];
extern objident vPortTotalPkts[];
extern objident vPortXmitColls[];
extern objident vPortRecColls[];

extern objident vIfNumber;
extern objident vIfDescr;
extern objident vIfType;
extern objident vIfSpeed;
extern objident vIfMtu;
extern objident vIfAdminStatus;
extern objident vIfOperStatus;
extern objident vIfInOctets;
extern objident vIfOutOctets;
extern objident vIfInUcastPkts;
extern objident vIfOutUcastPkts;
extern objident vIfInNUcastPkts;
extern objident vIfOutNUcastPkts;
extern objident vIfInErrors;
extern objident vIfOutErrors;
extern objident vIfInDiscards;
extern objident vIfOutDiscards;
extern objident vIfOutQlen;


#ifdef notdef
extern objident vPortRedundantCt;
extern objident vPortRedundantType;
extern objident vPortRedundantStatus;
#endif

extern objident vCommunityName;
extern objident vCommunityType;

extern objident vNSGroupId;
extern objident vNSPortId;
extern objident vNSSrcMACAddr;
extern objident vNSDstMACAddr;
extern objident vNSIPAddr;
extern objident vNSIPTime;

extern int DEVICE_RESTART[];
extern int ADMIN_ERR[];
extern int ADMIN_OFF[];
extern int ADMIN_ON[];
extern int LINK_INACTIVE[];
extern int LINK_ACTIVE[];
extern int LINK_NOSUPP[];
extern int NETWORK_ACTIVE[];
extern int NETWORK_SEG[];


char *copy_string();
char *input_string();
char *reverse();
char *format_uptime();
double calculate_ave_exponent();

extern int    the_update;
extern int    the_retry;
extern int    the_timeout;
extern int    the_burst;
extern char   *the_community;

#define string_equiv(a, b, c) (strncmp((a), (b), (c) < strlen((a)) \
                                        ? strlen((a)) : (c)) == 0)


typedef struct 
{
  char name[64];
  char alias[64];
  char saddr[16];
  struct in_addr addr;
  char *community;
  int vendor;
} Agent;


struct _category
{
  int  id;
  char *name;
};

extern struct _category *device_types[];
extern struct _category *board_types[];
extern struct _category *media_types[];
extern struct _category interface_types[];

/*
 * default normal settings 
 */

#define norm_update      20
#define norm_retry       2
#define norm_timeout     3
#define norm_burst       1

#define dis_update       3600
#define dis_retry        4
#define dis_timeout      5
#define dis_burst        10
