/*
 * Port. This file contains miscellaneous utilities.
 *
 * Copyright 1992 by the Massachusetts Institute of Technology.
 *
 * For copying and distribution information, please see the file
 * <mit-copyright.h>.
 *
 * Tom Coppeto
 * MIT Network Operations
 * 26 January 1992
 *
 *    $Source: /afs/.net.mit.edu/tools/src/port/RCS/utils.c,v $
 *    $Author: nocuser $
 *    $Locker:  $
 * 
 */

#ifndef lint
static char *rcsid = "$Header: /afs/.net.mit.edu/tools/src/port/RCS/utils.c,v 1.12 94/06/21 15:44:54 nocuser Exp $";
#endif

#include "port.h"
#include <stdio.h>
#include <math.h>
#include <mit-copyright.h>


char *
get_category(i, c)
     int i;
     struct _category *c;
{
  struct _category *cp;
  static char *foo = "unknown";

  cp = c;
  while(cp && cp->name)
    if(cp->id == i)
      return(cp->name);
    else
      ++cp;

  return(foo);
}



average(avg, n, exponent)
     register int *avg;
     int  n;
     double exponent;
{
  register double d;

  
  d = (double) (exponent * (double) avg[0] + (double) n * (1.0 - exponent));
  avg[0] = (int) d;
}


double
calculate_ave_exponent(interval, span)
     int interval;
     int span;
{
  double d1, d2;

  d1 = (double) ((double) interval/(double) span);
  d2 = (double) exp(-d1);
  return((double) d2);
}



Agent **
get_agents(key)
     char *key;
{
  FILE *fp;
  char buf[BUFSIZ];
  char *c, *d;
  Agent *a;
  Agent **list;
  struct hostent *hp;
  int n = 0;

  if(!key)
    return((Agent **) NULL);

  if(!(fp = fopen(KEYFILE, "r")))
    {
      fprintf(stderr, "cannot open file \"%s\" to get agent lists.\n", 
	      KEYFILE);
      return((Agent **) NULL);
    }

  if(!(list = (Agent **) malloc(sizeof(Agent *))))
     {
       perror("error allocating agent");
       fclose(fp);
       return;
     }

  while(fgets(buf, sizeof(buf), fp))
    {
      if(!(c = index(buf, '|')))
	continue;
      *c++ = '\0';
      
      if(strcmp(buf, key) && strcmp(key, "all"))
	continue;

      if(!(a = (Agent *) malloc(sizeof(Agent) * 2)))
	{
	  perror("error allocating agent");
	  free_agents(list);
	  fclose(fp);
	  return((Agent **) NULL);
	}
      bzero(a, sizeof(Agent));
      
      d = c;      
      while((*d != '\n') && (*d != '\t') && (*d != ' '))
	++d;
      *d = '\0';
      strcpy(a->alias, c);
      if(!(hp = gethostbyname(a->alias)))
        {
          fprintf(stderr, "warning: cannot resolve name of agent, %s.\n", 
		  a->name);
	  continue;
        }

      strcpy(a->name, hp->h_name);
      upcase(a->name);
      bcopy(hp->h_addr, &(a->addr.s_addr), hp->h_length);
      strcpy(a->saddr, inet_ntoa(a->addr));
      if(!(list = (Agent **) realloc(list, sizeof(Agent *) * (n+2))))
	{
	   perror("error allocating agent");
	   fclose(fp);
	   return((Agent **) NULL);
	 }
      ++n;
      list[n-1] = a;
    }

  fclose(fp);
  list[n] = (Agent *) NULL;
  if(n > 0)
    return(list);
  
  printf("no items match \"%s\".\n", key);
  free(list);
  return((Agent **) NULL);
}




char *
get_db(key)
     char *key;
{
  FILE *fp;
  char buf[BUFSIZ];
  char *c, *d;

  c = (char *) NULL;

  if(!key)
    return((char *) NULL);

  if(!(fp = fopen(DBFILE, "r")))
    {
      fprintf(stderr, "cannot open file \"%s\" to get things.\n", 
	      KEYFILE);
      return((char *) NULL);
    }

  while(fgets(buf, sizeof(buf), fp))
    {
      if(!(c = index(buf, '|')))
	continue;
      *c++ = '\0';
      
      if(strcasecmp(key, buf))
	continue;

      if(d = index(c, '\n'))
	*d = '\0';
      
      fclose(fp);
      return(c);
    }

  fclose(fp);
  return((char *) NULL);
}



      

free_agents(a)
     Agent **a;
{
  Agent **ap;

  if(a)
    {
      ap = a;
      while(*ap)
	{
	  free(*ap);
	  ++ap;
	}
      free(a);
    }
}


power(n)
     int n;
{
  int i = 1;
  
  while(n--)
    i *= 2;
  return(i);
}
