/*
 * This file contains snmp variable definitions.
 *
 * Tom Coppeto
 * MIT Network Operations
 * 26 January 1992
 *
 *    $Source: /afs/.net/tools/src/port/RCS/variable.c,v $
 *    $Author: tom $
 *    $Locker: tom $
 *    $Log: variable.c,v $
 * Revision 1.6  1994/06/12  17:26:52  tom
 * add new objects for 2072
 *
 * Revision 1.5  94/05/28  20:47:19  tom
 * *** empty log message ***
 * 
 * Revision 1.4  93/10/18  12:59:01  tom
 * asante mods
 * 
 * Revision 1.3  93/08/27  14:54:11  tom
 * 
 * Revision 1.2  92/02/04  19:06:33  tom
 * *** empty log message ***
 * 
 * Revision 1.1  92/02/02  13:02:38  tom
 * Initial revision
 * 
 */

#ifndef lint
static char *rcsid = "$Header: /afs/.net/tools/src/port/RCS/variable.c,v 1.6 1994/06/12 17:26:52 tom Exp tom $";
#endif

#include "port.h"

/*
 * genaral variables
 */


objident vSysDescr = {
  9,
  1, 3, 6, 1, 2, 1, 1, 1, 0
};

objident vSysUptime = {
  9,
  1, 3, 6, 1, 2, 1, 1, 3, 0
};


/*
 * device variables
 */


objident vDeviceType[] = {
  { 0, 0 },
  { /* ctron */
    12,
    1, 3, 6, 1, 4, 1, 52, 1, 1, 1, 1, 0,
  },
  { /* asante 1012*/
    12,
    1, 3, 6, 1, 4, 1, 298, 1, 1, 3, 2, 0,
  },
  { /* asante 2072 */
    12,
    1, 3, 6, 1, 4, 1, 298, 1, 1, 3, 2, 0,
  },
  { /* mib-2 */
    9,
    1, 3, 6, 1, 2, 1, 1, 1, 0,
  }
};

#ifdef notdef
objident vDeviceName = {
  12,
  1, 3, 6, 1, 4, 1, 52, 1, 1, 1, 2, 0
};

objident vDeviceIPAddress = {
  12,
  1, 3, 6, 1, 4, 1, 52, 1, 1, 1, 3, 0
};

objident vDeviceMACAddress = {
  12,
  1, 3, 6, 1, 4, 1, 52, 1, 1, 1, 6, 0
};

objident vDeviceMACType = {
  13,
  1, 3, 6, 1, 4, 1, 52, 1, 2, 1, 1, 2, 0
};

objident vDeviceSlots = {
  13,
  1, 3, 6, 1, 4, 1, 52, 1, 2, 1, 1, 3, 0
};
#endif

objident vDeviceOccSlots[] = {
  { 0, 0 },
  {
    13,
    1, 3, 6, 1, 4, 1, 52, 1, 2, 1, 1, 4, 0,
  },
  {
    13,
    1, 3, 6, 1, 4, 1, 298, 1, 3, 1, 1, 7, 0,
  },
  {
    13,
    1, 3, 6, 1, 4, 1, 298, 1, 3, 1, 1, 7, 0,
  }
};

#ifdef notdef

objident vDevicePortsOn = {
  13,
  1, 3, 6, 1, 4, 1, 52, 1, 2, 1, 1, 5, 0
};

objident vDevicePorts = {
  13,
  1, 3, 6, 1, 4, 1, 52, 1, 2, 1, 1, 6, 0
};
#endif

objident vDeviceTotalPkts[] = {
  { 0, 0 },
  {
    13, 
    1, 3, 6, 1, 4, 1, 52, 1, 2, 1, 1, 7, 0,
  },
  {
    14,
    1, 3, 6, 1, 4, 1, 298, 1, 3, 3, 1, 1, 1, 0,
  },
  {
    15,
    1, 3, 6, 1, 4, 1, 298, 1, 3, 3, 1, 7, 1, 2, 1,
  }
};

objident vDeviceXmitColls[] = {
  { 0, 0 },
  {
    13, 
    1, 3, 6, 1, 4, 1, 52, 1, 2, 1, 1, 9, 0,
  },
  {
    14,
    1, 3, 6, 1, 4, 1, 298, 1, 3, 3, 1, 1, 12, 0,
  },
  {
    15,
    1, 3, 6, 1, 4, 1, 298, 1, 3, 3, 1, 7, 1, 13, 1,
  }
};

objident vDeviceRecColls[] = {
  { 0, 0 },
  {
    13, 
    1, 3, 6, 1, 4, 1, 52, 1, 2, 1, 1, 10, 0,
  },
  {
    14,
    1, 3, 6, 1, 4, 1, 298, 1, 3, 3, 1, 1, 12, 0,
  },
  {
    15,
    1, 3, 6, 1, 4, 1, 298, 1, 3, 3, 1, 7, 1, 13, 1,
  }
};

objident vDeviceRestart[] = {
  { 0, 0 },
  {
    13, 
    1, 3, 6, 1, 4, 1, 52, 1, 2, 1, 1, 18, 0,
  },
  { 
    12,
    1, 3, 6, 1, 4, 1, 298, 1, 1, 1, 9, 0,
  },
  { 
    12,
    1, 3, 6, 1, 4, 1, 298, 1, 1, 1, 9, 0,
  }
};

#ifdef notdef
objident vDeviceResetCounter = {
  13, 
  1, 3, 6, 1, 4, 1, 52, 1, 2, 1, 1, 19, 0
};

objident vDeviceRedundantCts = {
  13, 
  1, 3, 6, 1, 4, 1, 52, 1, 2, 1, 1, 20, 0
};

objident vDeviceTimeBase = {
  13, 
  1, 3, 6, 1, 4, 1, 52, 1, 2, 1, 1, 21, 0
};
#endif

/*
 * board variables
 */


objident vBoardName[] = {
  { 0, 0 },
  {
    14, 
    1, 3, 6, 1, 4, 1, 52, 1, 2, 2, 3, 1, 2, 0,
  },
  {
    15,
    1, 3, 6, 1, 4, 1, 298, 1, 3, 1, 1, 8, 1, 4, 0,
  },
  {
    15,
    1, 3, 6, 1, 4, 1, 298, 1, 3, 1, 1, 8, 1, 4, 0,
  }
};

objident vBoardType[] = {
  { 0, 0 },
  {
    14, 
    1, 3, 6, 1, 4, 1, 52, 1, 2, 2, 3, 1, 3, 0,
  },
  {
    15,
    1, 3, 6, 1, 4, 1, 298, 1, 3, 1, 1, 8, 1, 3, 0,
  },
  {
    15,
    1, 3, 6, 1, 4, 1, 298, 1, 3, 1, 1, 8, 1, 3, 0,
  }
};

objident vBoardTotalPorts[] = {
  { 0, 0 },
  {
    14, 
    1, 3, 6, 1, 4, 1, 52, 1, 2, 2, 3, 1, 4, 0,
  },
  {
    15,
    1, 3, 6, 1, 4, 1, 298, 1, 3, 1, 1, 8, 1, 2, 0,
  },
  {
    15,
    1, 3, 6, 1, 4, 1, 298, 1, 3, 1, 1, 8, 1, 2, 0,
  }
};

#ifdef notdef
objident vBoardPortsOn = {
  14, 
  1, 3, 6, 1, 4, 1, 52, 1, 2, 2, 3, 1, 6, 0
};
#endif

objident vBoardTotalPkts[] = {
  { 0, 0 },
  {
    14, 
    1, 3, 6, 1, 4, 1, 52, 1, 2, 2, 3, 2, 1, 0,
  },
  {
    15,
    1, 3, 6, 1, 4, 1, 298, 1, 3, 3, 1, 3, 1, 2, 0,
  },
  {
    15,
    1, 3, 6, 1, 4, 1, 298, 1, 3, 3, 1, 3, 1, 2, 0,
  }
};

objident vBoardXmitColls[] = {
  { 0, 0 },
  {
    14, 
    1, 3, 6, 1, 4, 1, 52, 1, 2, 2, 3, 2, 3, 0,
  },
  {
    15,
    1, 3, 6, 1, 4, 1, 298, 1, 3, 3, 1, 3, 1, 13, 0,
  },
  {
    15,
    1, 3, 6, 1, 4, 1, 298, 1, 3, 3, 1, 3, 1, 13, 0,
  }
};

objident vBoardRecColls[] = {
  { 0, 0 },
  {
    14, 
    1, 3, 6, 1, 4, 1, 52, 1, 2, 2, 3, 2, 4, 0,
  },
  {
    15,
    1, 3, 6, 1, 4, 1, 298, 1, 3, 3, 1, 3, 1, 13, 0,
  },
  {
    15,
    1, 3, 6, 1, 4, 1, 298, 1, 3, 3, 1, 3, 1, 13, 0,
  }
};



/*
 * port statistic variables
 */

objident vPortMediaType[] = {
  { 0, 0 },
  {
    15, 
    1, 3, 6, 1, 4, 1, 52, 1, 2, 2, 4, 1, 2, 0, 0,
  },
  {
    16,
    1, 3, 6, 1, 4, 1, 298, 1, 3, 4, 1, 1, 1, 3, 0, 0,
  },
  {
    16,
    1, 3, 6, 1, 4, 1, 298, 1, 3, 4, 1, 1, 1, 3, 0, 0,
  },
  {
    11,
    1, 3, 6, 1, 2, 1, 2, 2, 1, 3, 0,
  }
};

objident vPortAdminStatus[] = {
  { 0, 0 },
  {
    15, 
    1, 3, 6, 1, 4, 1, 52, 1, 2, 2, 4, 1, 3, 0, 0,
  },
  {
    16,
    1, 3, 6, 1, 4, 1, 298, 1, 3, 4, 1, 1, 1, 9, 0, 0,
  },
  {
    16,
    1, 3, 6, 1, 4, 1, 298, 1, 3, 4, 1, 1, 1, 9, 0, 0,
  },
  {
    11,
    1, 3, 6, 1, 2, 1, 2, 2, 1, 7, 0,
  }
};

objident vPortLinkStatus[] = {
  { 0, 0 },
  {
    15, 
    1, 3, 6, 1, 4, 1, 52, 1, 2, 2, 4, 2, 2, 0, 0,
  },
  {
    16,
    1, 3, 6, 1, 4, 1, 298, 1, 3, 4, 1, 1, 1, 4, 0, 0,
  },
  {
    16,
    1, 3, 6, 1, 4, 1, 298, 1, 3, 4, 1, 1, 1, 4, 0, 0,
  },
  {
    11,
    1, 3, 6, 1, 2, 1, 2, 2, 1, 8, 0,
  }
};

objident vPortNetworkStatus[] = {
  { 0, 0 },
  {
    15, 
    1, 3, 6, 1, 4, 1, 52, 1, 2, 2, 4, 2, 3, 0, 0,
  },
  {
    16,
    1, 3, 6, 1, 4, 1, 298, 1, 3, 4, 1, 1, 1, 6, 0, 0,
  },
  {
    16,
    1, 3, 6, 1, 4, 1, 298, 1, 3, 4, 1, 1, 1, 6, 0, 0,
  },
  {
    11,
    1, 3, 6, 1, 2, 1, 2, 2, 1, 8, 0,
  }  
};

objident vPortTotalPkts[] = {
  { 0, 0 },
  {
    15, 
    1, 3, 6, 1, 4, 1, 52, 1, 2, 2, 4, 2, 4, 0, 0,
  },
  {
    16,
    1, 3, 6, 1, 4, 1, 298, 1, 3, 3, 1, 4, 1, 3, 0, 0,
  },
  {
    16,
    1, 3, 6, 1, 4, 1, 298, 1, 3, 3, 1, 4, 1, 3, 0, 0,
  },
  {
    11,
    1, 3, 6, 1, 2, 1, 2, 2, 1, 10, 0, 0
  }
};

objident vPortXmitColls[] = {
  { 0, 0 },
  {
    15, 
    1, 3, 6, 1, 4, 1, 52, 1, 2, 2, 4, 2, 6, 0, 0,
  },
  {
    16,
    1, 3, 6, 1, 4, 1, 298, 1, 3, 3, 1, 4, 1, 14, 0, 0,
  },
  {
    16,
    1, 3, 6, 1, 4, 1, 298, 1, 3, 3, 1, 4, 1, 14, 0, 0,
  },
  {
    11,
    1, 3, 6, 1, 2, 1, 2, 2, 1, 20, 0
  }
};

objident vPortRecColls[] = {
  { 0, 0 },
  {
    15, 
    1, 3, 6, 1, 4, 1, 52, 1, 2, 2, 4, 2, 7, 0, 0,
  },
  {
    16,
    1, 3, 6, 1, 4, 1, 298, 1, 3, 3, 1, 4, 1, 14, 0, 0,
  },
  {
    16,
    1, 3, 6, 1, 4, 1, 298, 1, 3, 3, 1, 4, 1, 14, 0, 0,
  },
  {
    11,
    1, 3, 6, 1, 2, 1, 2, 2, 1, 12, 0
  }
};

#ifdef notdef
objident vPortRedundantCt = {
  15, 
  1, 3, 6, 1, 4, 1, 52, 1, 2, 2, 4, 2, 15, 0, 0
};

objident vPortRedundantType = {
  15, 
  1, 3, 6, 1, 4, 1, 52, 1, 2, 2, 4, 2, 16, 0, 0
};

objident vPortRedundantStatus = {
  15, 
  1, 3, 6, 1, 4, 1, 52, 1, 2, 2, 4, 2, 17, 0, 0
};
#endif



                                                     
/*                                                   
 * mib-II interfaces group                           
 */                                                  
                                                     
objident vIfNumber = {                               
        9,                                           
        1, 3, 6, 1, 2, 1, 2, 1, 0                    
};                                                   
                                                     
objident vIfIndex = {                                
        11,                                          
        1, 3, 6, 1, 2, 1, 2, 2, 1, 1, 0              
};                                                   
                                                     
objident vIfDescr = {                                
        11,                                          
        1, 3, 6, 1, 2, 1, 2, 2, 1, 2, 0              
};                                                   

objident vIfType = {                                    
        11,                                             
        1, 3, 6, 1, 2, 1, 2, 2, 1, 3, 0                 
};                                                      
                                                        
objident vIfMtu = {                                     
        11,                                             
        1, 3, 6, 1, 2, 1, 2, 2, 1, 4, 0                 
};                                                      
                                                        
objident vIfSpeed = {                                   
        11,                                             
        1, 3, 6, 1, 2, 1, 2, 2, 1, 5, 0                 
};                                                      
                                                        
objident vIfPhysicalAddress = {                         
        11,                                             
        1, 3, 6, 1, 2, 1, 2, 2, 1, 6, 0                 
};                                                      

objident vIfAdminStatus = {                                  
        11,                                                  
        1, 3, 6, 1, 2, 1, 2, 2, 1, 7, 0                      
};                                                           
                                                             
objident vIfOperStatus = {                                   
        11,                                                  
        1, 3, 6, 1, 2, 1, 2, 2, 1, 8, 0                      
};                                                           
                                                             
objident vIfLastChange = {                                   
        11,                                                  
        1, 3, 6, 1, 2, 1, 2, 2, 1, 9, 0                      
};                                                           
                                                                               
objident vIfInOctets = {                                
        11,                                             
        1, 3, 6, 1, 2, 1, 2, 2, 1, 10, 0                
};                                                      
                                                        
objident vIfInUcastPkts = {                             
        11,                                             
        1, 3, 6, 1, 2, 1, 2, 2, 1, 11, 0                
};                                                      
                                                        
objident vIfInNUcastPkts = {                            
        11,                                             
        1, 3, 6, 1, 2, 1, 2, 2, 1, 12, 0                
};                                                      
                                                        
objident vIfInDiscards = {                              
        11,                                             
        1, 3, 6, 1, 2, 1, 2, 2, 1, 13, 0                
};                                                      
                                                                               
objident vIfInErrors = {                            
        11,                                         
        1, 3, 6, 1, 2, 1, 2, 2, 1, 14, 0            
};                                                  
                                                    
objident vIfInUnknownProtos = {                     
        11,                                         
        1, 3, 6, 1, 2, 1, 2, 2, 1, 15, 0            
};                                                  
                                                    
objident vIfOutOctets = {                           
        11,                                         
        1, 3, 6, 1, 2, 1, 2, 2, 1, 16, 0            
};                                                  
                                                    
objident vIfOutUcastPkts = {                        
        11,                                         
        1, 3, 6, 1, 2, 1, 2, 2, 1, 17, 0            
};                                                  
                                                   
objident vIfOutNUcastPkts = {                   
        11,                                     
        1, 3, 6, 1, 2, 1, 2, 2, 1, 18, 0        
};                                              
                                                
objident vIfOutDiscards = {                     
        11,                                     
        1, 3, 6, 1, 2, 1, 2, 2, 1, 19, 0        
};                                              
                                                
objident vIfOutErrors = {                       
        11,                                     
        1, 3, 6, 1, 2, 1, 2, 2, 1, 20, 0        
};                                              
                                                
objident vIfOutQlen = {                         
        11,                                     
        1, 3, 6, 1, 2, 1, 2, 2, 1, 21, 0        
};                                              
                                                



/*
 * Community names
 */

objident vCommunityName = {
  13, 
  1, 3, 6, 1, 4, 1, 52, 1, 52, 2, 1, 2, 0
};

objident vCommunityType = {
  13, 
  1, 3, 6, 1, 4, 1, 52, 1, 52, 2, 1, 6, 0
};

objident vNSGroupId = {
  27,
  1, 3, 6, 1, 4, 1, 298, 1, 3, 5, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

objident vNSPortId = {
  27,
  1, 3, 6, 1, 4, 1, 298, 1, 3, 5, 1, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

objident vNSSrcMACAddr = {
  27,
  1, 3, 6, 1, 4, 1, 298, 1, 3, 5, 1, 1, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

objident vNSDstMACAddr = {
  27,
  1, 3, 6, 1, 4, 1, 298, 1, 3, 5, 1, 1, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

objident vNSIPAddr = {
  27,
  1, 3, 6, 1, 4, 1, 298, 1, 3, 5, 1, 1, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

objident vNSIPTime = {
  27,
  1, 3, 6, 1, 4, 1, 298, 1, 3, 5, 1, 1, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
, 0
};

