/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */
/* $Header: /afs/athena.mit.edu/astaff/project/andrew/a-andy-r4/src/cmu/atk/text/RCS/search.c,v 2.11 91/09/12 16:35:22 bobg Exp $ */
/* $ACIS:search.c 1.2$ */
/* $Source: /afs/athena.mit.edu/astaff/project/andrew/a-andy-r4/src/cmu/atk/text/RCS/search.c,v $ */

#ifndef lint
static char *rcsid = "$Header: /afs/athena.mit.edu/astaff/project/andrew/a-andy-r4/src/cmu/atk/text/RCS/search.c,v 2.11 91/09/12 16:35:22 bobg Exp $";
#endif /* lint */


#include <ctype.h>

#include <class.h>
#include <smpltext.ih>
#include <search.eh>
/* array to fold upper case to lower case 
Now modified to handle the iso 8859 char set  # 1 */

static long TryMatch();

static unsigned char FoldTRT[256] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, ' ', '!', '"', '#', '$', '%',
'&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4',
'5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'a', 'b', 'c',
'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r',
's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '[', '\\', ']', '^', '_', '`', 'a',
'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p',
'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', 127,
128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
208,209,210,211,212,213,214,247,216,217,218,219,220,221,222,255
};

struct SearchPattern {
    short size, used;
    unsigned char *body;
};
int MatchLength;

search__GetMatchLength (classID)
struct classheader *classID;
{
    return MatchLength;
}


char *
search__GetQuotedSearchString(classID, string, resString, resStrLen)
struct classheader *classID;
char *string;
char *resString;
long resStrLen;
{
    long resultMaxLen;
    long resultLen = 0;
    char *result;
    char *res;
    
    if (resString == NULL) {
	resultMaxLen = strlen(string) + 10;
	result = (char *) malloc(resultMaxLen + 1);
    }
    else {
	resultMaxLen = resStrLen;
	result = resString;
    }
    res = result;

    while (*string != '\0') {
	if (resultLen >= resultMaxLen - 2) {
	    if (resString != NULL) {
		*res = '\0';
		return NULL;
	    }
	    resultMaxLen *= 2;
	    result = (char *) realloc(result, resultMaxLen);
	    res = &result[resultLen];
	}

	*res++ = *string;
	resultLen++;
	string++;
    }
    *res = '\0';
    return result;
}

char *
search__CompilePattern (classID, string, result)
struct classheader *classID;
unsigned char *string;
struct SearchPattern  **result; {
    struct SearchPattern  *p;
    long    used = 0;
    int     LastStart = -1;
    int     ParenStack[20];
    int     ParenDepth = 0;
    if ((p = *result) == 0) {
	p = (struct SearchPattern  *) malloc (sizeof (struct SearchPattern));
	p -> body = (unsigned char *) malloc (p -> size = 100);
	*result = p;
    }
    p -> used = 0;
    while (*string) {
	int     ThisStart = used;
	if (used + 20 >= p -> size)
	    p -> body = (unsigned char *) realloc (p -> body, p -> size += 50);
	p -> body[used++] = FoldTRT[*string];
	string++;
	LastStart = ThisStart;
    }  /* end of while loop */
    p -> body[used] = 0;
    p -> used = used;
    return 0;
}

search__MatchPattern (classID, d, pos, p)
struct classheader *classID;
struct simpletext *d;
long pos;
struct SearchPattern *p; {
    unsigned char *s;
    unsigned char optchar;
    int dl;
    long bufLen;
    unsigned char *buf = NULL;

    MatchLength = 0;
    if (p == 0 || p -> used <= 0) return -1;
    optchar = p->body[0];
    dl = simpletext_GetLength(d);
    bufLen = 0;
    for (; pos < dl; ++pos) {
	int n;
        if (bufLen == 0)
            buf = (unsigned char *) simpletext_GetBuf(d, pos, 1024, &bufLen);
	s = p -> body;
	n = TryMatch (d, pos, &s, 1);
	if (n>=0) {
	    MatchLength = n - pos;
	    return pos;
	}
    }
    return -1;
}

search__MatchPatternReverse (classID, d, pos, p)
struct classheader *classID;
struct simpletext *d;
long pos;
struct SearchPattern *p; {
    unsigned char *s;
    int canopt;
    unsigned char optchar;
    long bufLen;
    unsigned char *buf = NULL;

    MatchLength = 0;
    if (p == 0 || p -> used <= 0) return -1;
    optchar = p->body[0];
    canopt = !isop(optchar);
    bufLen = 0;
    for (; pos >= 0; --pos) {
	int n;
        if (bufLen == 0)
            buf = (unsigned char *)simpletext_GetBufEnd(d, pos + 1, 1024, &bufLen);
	if (canopt)
            if (optchar != FoldTRT[bufLen--, *--buf])
                continue;
	s = p -> body;
	n = TryMatch (d, pos, &s, 1);
	if (n>=0) {
	    MatchLength = n - pos;
	    return pos;
	}
    }
    return -1;
}

static long TryMatch (d, pos, s, loop)
struct simpletext *d;
long pos;
unsigned char **s; {
    unsigned char  c,
                            dc;
    unsigned char *buf = NULL;
    long bufLen = 0;
    long length = simpletext_GetLength(d);

    do {
	if (c = *(*s)++) {
	    switch (c) {
		case BPAR:
		    if ((pos = TryMatch (d, pos, s, 1)) < 0)
			return pos;
		    break;
		case EPAR:
		    return pos;
		case ANY1:
                    if (bufLen == 0)
                        buf = (unsigned char *)simpletext_GetBuf(d, pos, 1024, &bufLen);
		    dc = *buf++, bufLen--;
		    if (pos >= length || dc == '\n')
			return -1;
		    pos++;
		    break;
		case SET:
                    if (bufLen == 0)
                        buf = (unsigned char *)simpletext_GetBuf(d, pos, 1024, &bufLen);
		    dc = *buf++, bufLen--;
		    if (((*s)[dc >> 3] & (1 << (dc & 7))) == 0)
			return -1;
		    *s += 16;
		    pos++;
		    break;
		case STAR:
		    {
			unsigned char  *st = *s;
			int     npos, code;
			/* first check if we've got another in a row */
			if ((npos = TryMatch (d, pos, &st, 0)) >= 0) {
			    (*s)--;
			    /* try to continue wildcard matching */
			    code = TryMatch (d, npos, s, 1);
			    /* if that fails, see if the rest of the pattern matches here */
			    if (code < 0) return TryMatch(d, pos, &st, 1);
			    else return code;
			}
			else
			    *s = SkipOp (*s);
		    }
		    break;
		default:
		    if (pos >= length) return -1;
                    if (bufLen == 0)
                        buf = (unsigned char *)simpletext_GetBuf(d, pos, 1024, &bufLen);
		    dc = *buf++, bufLen--;
		    if (c != FoldTRT[dc])
			return - 1;
		    pos++;
		    break;
	    }
	}
	else
	    break;
    } while (loop);
    return pos;
}
