@make(report)
@style(topmargin 1.45in)
@style(spread .8)
@style(spacing 1.4)
@style(leftmargin 1.25in)
@style(rightmargin 1.25in)
@style(indent 0in)
@style(fontfamily TimesRoman)
@device(postscript)

@modify(appendix, numbered [Appendix @A.]) 

@modify(tc2, below 0.1inch)
@modify(tc1, below 0.1inch)
@modify(hd1, pagebreak off)
@modify(hdg, fixed 1in)
@modify(enumerate, spacing 1.4, longlines wrap)
@modify(center, spacing 1.4, longlines wrap)
@modify(itemize, spacing 1.4, longlines wrap, 
	indent -3, numbered <@#@#@@B{*} @,@@B{-}>)
@modify(flushleft, spacing 1.4, longlines wrap)
@modify(verbatim, spacing 1.4, longlines wrap)
@pageheading(left "Course VI Undergraduate Thesis", center @value[page], right "Policies and Procedures")
@begin(majorheading)

THE THESIS GUIDE: 

Course VI Undergraduate Thesis Policies and Procedures
September 1992 Edition
@end(majorheading)
@begin(center)
@b[MASSACHUSETTS INSTITUTE OF TECHNOLOGY   
The Course VI Undergraduate Office, Room 38-476, (617) 253-7329]
@end(center)

@begin<format>
@bar()
@b(THESIS DEADLINES)
[@i<Discussion of Deadlines and Extensions on page @pageref(deadlines)>]
@bar()			   
@TabSet(.3in, 2.1in, 3.8in)
@\Term@\Degree Date@\Deadline 
@bar()
@\Fall Term 1992@\February 1993@\January 29, 1993
@bar()
@\SPRING TERM 1993@\JUNE 1992@\@B(FINAL DEADLINE: MAY 17, 1992)
@\@\@\[Prize Nominations: May 7, 1992]
@bar() 
@\Summer Session 1993@\September 1993@\August 27, 1993
@bar()
@end(format)
@\@b(THESIS AGREEMENT FORMS) (previously @i<Thesis Proposal Forms>) are
due on @b(November 9, 1992), for the Fall Term 1992, and @b(April 19, 1993) for the Spring Term 1993. (see page @pageref(agreem
ent))
Students submit them @b(only) once unless their thesis project totally changes.
@bar()
@newpage

@chapter(Outreach Program by The Barker Engineering Library)

Barker is eager to help undergraduate thesis students at every stage
of the thesis project. The library can help students to approach topics,
to perform on-line searches, and with indexes, abstracts, and citations.  For
information and assistance, contact Ms. Schildhauer, x3-6051.
@Chapter(Getting Started:  The Thesis Project)

The thesis requirement gives undergraduates an opportunity to develop
and demonstrate their ability to perform and document a reasonably
comprehensive project requiring considerable initiative, creative
thought, and a good deal of individual responsibility.  The thesis may
be a design project, an analytical paper, or other sorts of papers or
projects.  It should involve engineering or scientific techniques
(broadly defined).

Course VI S.B. Theses normally involve one or more of the following:
@blankspace(1)
@begin(enumerate)
Design of a system (usually electronic), construction, test, and evaluation;

Formulation of an analytical or computational model of a system or
process, simulation of the model, and comparison with actual data;

Development of a computer program that might:
@begin(enumerate)
simulate a real system (e.g. Artificial Intelligence);

aid in a diagnostic procedure;

provide sophisticated, real-time analysis of measured data;

@end(enumerate)

Development and analysis of a theory or theorem which is an abstraction or
idealization of an actual process or system;

Application of some of the standard methods (of communication theory
or control theory, for example) to aid in understanding of a process
or system.
@end(enumerate)

The foregoing may sound formidable, but we expect no more than can be
accomplished in one term in a time allotment equivalent to one regular
subject.  Ordinarily the thesis is an individual effort; however,
group projects may be possible if the work of the individuals can be
evaluated separately.

The thesis is normally completed over the course of the senior year.
It may be started (and completed) earlier.  Unless you are in the VI-A
Program, you must do your research at M.I.T., not at a summer or
part-time job with a company for which you received pay.  Students may
use a thesis topic which suggested itself during their summer jobs,
but they must have an M.I.T@. supervisor.

The thesis write-up is considered a major part of the thesis project.
The report should include a clear statement of the problem and why it
is of interest or importance, a description of the history and
literature on the subject, a statement of the author's work and
observations, a discussion of the author's findings in relation to
those of predecessors, the author's conclusions and suggestions for
further work.  Extensive data, code, or mathematical derivations
should be in appendices rather than the body of the report.  Specific
bibliographic citations should be included whenever reference is made
to documents or other communications.  It must be well written,
clearly organized, and contain no stylistic or grammatical errors.
Supervisors are encouraged to require early drafts, to provide
criticism of the writing as well as the technical content, to require
re-writes, and to insist that the final document conform to the
accepted standards of technical writing.  The final grade should be
based in part on the writing quality of the thesis.  The Writing
Center (14N-317, x3-3090) offers free consultation and advice on any
writing problem.


@Chapter(Administration and Registration)

The Course VI Undergraduate Thesis is administered by Anne Hunter, the
Administrator of Course VI Undergraduate Programs.  Questions about
thesis policies and procedures should be addressed to her.  The Course
VI undergraduate thesis requirement calls for a minimum of 12 units of
6ThU.  Students normally register for 4 units of 6ThU in the fall
term, and 8 units in the spring term. Those who are attempting to
complete a thesis in one term should register for 12 units.  Students
with especially ambitious projects may register for and receive credit
for more units.  Up to 18 units of 6ThU may be registered for with the
informal approval of the thesis supervisor and the faculty advisor.
Students wishing to receive credit for more than 18 units of 6ThU
should fill out a Department Petition Form, before completing the
thesis, giving a justification of their request, obtain the supporting
signatures of their supervisor and their academic advisor, and submit
the petition at the Undergraduate Office.  If the petition is
approved, the student may register for extra units.  The maximum
number of 6ThU units is 30.  Students should not normally register for
more than 12 units of 6ThU in one term.  The same petition procedure
should be followed for students who wish to register for more than 12
units of 6ThU in one term.


6ThU is not affected by the ADD or DROP Dates.  You may add it or drop
it up to the last day of classes, without petitioning, with an
Add/Drop Card.  Anne Hunter's signature (as the instructor) is
required, however, not that of your supervisor.

Students must be registered for thesis in the term in which they
complete their thesis in order to receive a final grade.  Students who
fail to complete their theses on time must therefore register for one
additional unit of thesis the subsequent term.


@Section(When to Start)

The best time to start looking for a thesis is spring term junior
year.  That way, you can do background research over the summer, take
helpful subjects in the fall term, and work hard on it over IAP.  Even
if you're here over the summer, it's hard to find a topic then because
most of the faculty are away.  Most students, however, start looking
@begin(u) early @end(u) in the fall of the senior year.  Some very
popular faculty do not like supervising one-term theses, so your
options are more limited if you wait until late fall in the senior
year to start thinking and talking about thesis.  It often takes a
month or longer to find and firm up a topic with a supervisor.  It is
possible to complete a thesis from scratch in one term, but the
probability of finishing on time is less than 50%.

@Section(The First Step: Finding a Topic and Supervisor)

It's not as difficult to find a thesis topic and a supervisor as many
students fear.  For one thing, an undergraduate thesis supervisor need
not be a Course VI faculty member.  Students thinking about continuing
directly into MIT EECS graduate school will find it to their advantage
to establish an early research relationship with EECS labs and
faculty.  However, any faculty member or research staff member at MIT
may supervise an EECS undergraduate thesis.  [Draper Lab is not part
of MIT.]  Fully a third of our students are supervised by
non-Department faculty or staff.  Look in Mathematics, Physics, Civil
Engineering, Aeronautics and Astronautics, Plasma Fusion, and Brain
and Cognitive Sciences.  Some listings are available in the Course VI
Undergraduate Office.  Projects in the UROP booklet can be adapted as
undergraduate theses.  Athena has been a rich source of theses.  There
is no special permission procedure for non-Department supervised
students.

Secondly, it is not necessary to come up with your own topic in
detail.  Having too specific a topic in mind may be a hindrance,
although general ideas can be helpful.  Many undergraduate
theses are small pieces of large faculty research projects.  Lots of
faculty need labs or lecture demonstrations developed.

Thirdly, an EECS undergraduate thesis topic need not be narrowly in EE
or CS at all!  It must involve engineering or scientific techniques,
broadly defined.  A creative writing or history thesis would be
unlikely to qualify, but many areas of, say, economics or cognitive
science would be suitable, because they involve METHODS common to EE
or CS.  Almost any area in the Schools of Engineering or Science is
appropriate.  Students pursuing two or more S.B. degrees can usually
arrange to write one thesis.  Such students should contact the thesis
administrators of each Department well in advance.

Non VI-A students may NOT perform their actual thesis research at a
company or for pay.  Ideas for theses may come from any source,
including jobs, and preliminary work may have been done for pay, but
the thesis work is to be done by the student for the thesis, and is to
be owned by the student, not by a company.

Each student is totally responsible for finding a thesis topic and
supervisor.  While many people will be willing to help
you, the final responsibility is yours alone.

You may have done a UROP project or a project in a laboratory subject
which you wish to extend, or you may have done well in a subject which
needs a lab or lecture demo developed.  If so, talk to the appropriate
faculty or staff members.  If you already have a very specific topic
in mind, you may have to talk to many faculty and staff to find one
interested in supervising you, so start early.  Talk to your faculty
advisor, and any other faculty you know, for leads.  Pick up a
'Research Interest Guide' and a 'Recent Undergraduate Thesis Projects'
listing in the Undergraduate Office and talk to faculty in the area of
your topic.  If you are more flexible, without a limited topic in
mind, narrow your scope to one or two specific research areas, and see
faculty and staff in those areas.  Ask them what projects they need
done, and who else might have suitable research available in the same
area.  Look at EECS undergraduate theses in Barker.  Ask graduate
students to recommend faculty.  If you get stuck, go back to your
advisor and talk things out again, choosing a different field with new
people to contact.  As soon as you have reached a meeting of minds
with a supervisor, fill out a Thesis Agreement Form to get your topic
defined and formalized.  At this point you should be registered for
four units of 6ThU (or three units of 6.929 for VI-A students).

@Section(The Thesis Agreement Form)

@label(agreement)
It is very important that the Thesis Agreement Form (available in the
Course VI Undergraduate Office) be filled out as soon as a supervisor
has agreed to work with you on a thesis.  Do NOT wait until the
Agreement Form Deadline to hand one in.  Once an Agreement Form has been
submitted to the Undergraduate Office, you officially have a thesis
and a supervisor.  The agreement need not be lengthy or very detailed;
a few concise sentences are sufficient.  This form is like a
contract indicating the original scope and limits of the thesis, and
formalizing the agreement.  It tells the department and your academic
advisor that you have found a topic and supervisor.  Until you hand us
an agreement, we have no way of knowing that you have a supervisor, who
it is, or that you have done any thesis work.  You must use the form
form as a cover sheet, but you may attach other sheets to the top
copy.  It is assumed that your thesis project will evolve as it
progresses; it is not necessary to re-submit an agreement or inform the
Undergraduate Office of evolutionary or title changes.  If your
supervisor or project changes completely, however, you should submit a
new agreement.  Once you have submitted an agreement, NO other progress
report need be submitted to the Undergraduate Office at any time.
VI-A students registered for 6.929 must submit agreements accompanied
by company agreement letters.  See Appendix page @pageref(lettersample).


@Section(Thesis Grades:  The Grade of J or Cancellation of Thesis Registration)

When you register for thesis for the first time, the Undergraduate
Office must receive an agreement from you by the Agreement Deadline
for that term (Nov. 9, 1992, for the Fall Term and April 17, 1993 for
the Spring Term 1993).  If we receive an agreement form, and you have
registered for 4 units of 6ThU or 3 units of 6.929, we will give you
the grade of J (satisfactory progress) for 6ThU.  If we do not receive
an agreement by the agreement deadline, your 6ThU or 6.929
registration will be @begin(u)cancelled.@end(u)

If you subsequently hand in an Agreement Form by the last day of
classes, you may be permitted to re-register for thesis. Graduating
seniors must NOT miss the agreement deadline, however, and should hand
in an agreement much earlier than the deadline, since their advisors
will not put them onto the degree list until an agreement has been
filed.  Further, having thesis cancelled automatically will cause
the Registrar to remove your name from the Degree List.
Students doing one-term theses, who will be submitting a
thesis at the thesis deadline, are not exempt: they must hand in an
agreement by the agreement deadline, or have their thesis registration
cancelled.  The grade of U (unsatisfactory progress) can be given if
the thesis supervisor informs the Undergraduate Office that he or she
wishes to give a student that grade.  The final grade in 6ThU is a
letter grade, not Pass/Fail.  No Incompletes (I's) will be given in
thesis.  A grade is solicited from a thesis supervisor by the
Undergraduate Office ONLY at thesis completion.  Unless a supervisor
informs us otherwise, the grade of J will continue to be given until
thesis completion.  For thesis registration, IAP is considered to be
part of the Fall Term: additional IAP units are not normally permitted.  

@Chapter(VI-A Students: 6.929)

Those VI-A students who are admitted to the graduate program use their
final six-month work assignment to do their thesis research.  This is
a graduate, S.M. thesis registered for as 6ThG and subject to all
Graduate Office policies.  VI-A students who do not apply or are not
admitted to the graduate program must write an undergraduate thesis.
Students who write up a second company assignment into a thesis 
register for 6.929, not 6ThU!
Such students should discuss thesis issues with the VI-A Director @i(before)
their second work assignment.  Students registered for 6.929
must follow all thesis procedures, including submitting a
Thesis Agreement.  A company agreement letter like that in the
Appendix on page @pageref(lettersample) must accompany all VI-A 
Agreement Forms.  If difficulties develop in obtaining the Company
Clearance Letteer contact the Director of the VI-A Program for help.  If
the equivalent of an oral presentation occurred at the company,
a second presentation at M.I.T@. is optional.

@Chapter(Funding and Equipment)

If you need special computer accounts or equipment for your thesis,
ask your thesis supervisor.  For thesis wordprocessing or minor
computation, Project Athena accounts should be satisfactory.  If your
work is for a sponsored research project or an academic subject, there
are funds which should pay for these.  The use of Department
laboratory kits is discouraged.  Note that there is a machine shop for
EECS students located in the basement of Building 38.  It is available
to you if your thesis is not part of a funded research project.  See
Mr@. James Byrne in Room 38-017 for assistance.  In the event that
your supervisor certifies that there are no available funds for your
project, the Department has a very small amount of money available for
thesis support.  For computer accounts, see Mr@. Claude Bellot, Room
38-463.  For other support, consult Anne Hunter in 38-476.  

@Chapter(Avoiding Delay)

Many students fail to graduate on time because their theses are not
complete.  Some delays are inevitable, but there are ways to minimize
them.

@begin(enumerate)

@i(Unavailable Parts).  Special parts which have to be ordered
can cause delays of weeks or months.  Try to find alternate sources,
other ways of coping, and do legwork rather than passively waiting for
parts to arrive.  Do other aspects of the thesis if waiting is
unavoidable.  

@i(Waiting for Other People to do Their Part).  Graduate students and
faculty can think on a different time-scale than undergraduates.  Next
term can be almost as good as next week.  Try to anticipate and work
around these problems, avoiding projects that are excessively
interwoven with graduate theses, especially those that can't really be
started until somebody else makes something work.  Think flexibly
about altering your project to avoid this, but NOT by enlarging it to
include other people's projects!  

@i(The Incredible Expanding Thesis).  It is inevitable that your project
will evolve as you progress.  But that should not mean that it gets
bigger and more inclusive.  Negotiate diplomatically.  Unlike graduate
theses, undergraduate theses don't absolutely have to succeed.  If
you've debugged for hundreds of hours and only a brand-new
from-scratch approach will work, consider giving up.  This can
alienate your supervisor and affect your final grade, but should
still be considered.

@i(The Alienated Supervisor).  Students often think a supervisor has lost
patience with the student and the project when it is nothing personal,
just the press of other commitments.  Don't react to this situation by
disappearing.  Keep working and keep your supervisor aware of your
efforts and progress.  They like to know what is going on, and they
@i(hate)
feeling that you've disappeared.  Write
notes or send electronic mail OFTEN.

@i(Writing Delays).  Students can be frustrated when they hand their
supervisors a chapter or two of write-up, which it took them a few
hours to write, and find that it takes the supervisor several days to
read, correct and return it.  Other students find it impossible to
start writing.  Don't wait until you are finished designing,
programming, testing, debugging, etc., to start writing.  Go to the
Barker Engineering Library and read theses similar to yours for good
ideas about presentation, tone, etc.  Develop a detailed outline with
lots of notes, a list of figures, a reasonable format (there's no
single correct format), bibliography.  Draft an introduction and first
chapter.  Listen carefully to your supervisor's suggestions for
revision.  Don't wait until it is 90% written to show it to your
supervisor.  Take the first chapter to the Writing Center for analysis and
assistance.

@i(Lack of Discipline and Time Management Skills).  Working on a thesis
may be different from anything you've done while at MIT: for four
years you may have had nothing but short, specific and discrete tasks
due at short-term intervals.  With the thesis there is a final
deadline, four or nine months away.  This requires a different kind of
self-discipline.  MAKE A SCHEDULE.  Write out a detailed, ordered list
of tasks that have to be done, allowing for the inevitable delays and
your other commitments, and aiming not for the final deadline, but for
a week or so earlier.  Set specific short-term deadlines and be a hard
taskmaster.  If you find your hours, days and weeks melting away to no
effect, take early action.  The UAAO has material and programs
available to help you with time management: see 
Stephanie Bartling, Study Skills Coordinator, 7-103, 3-6772.

@i(If You Just Can't Finish).  If you're going to miss the deadline,
not by hours or days, but by weeks or months, sit down with your
supervisor and agree on what exactly has to be done.  Take your name
off the degree list, arrange for housing for extra time, and @i(keep
going).  It is very difficult to complete a thesis long distance or
while working.  Students who are sure they have only a few weeks of
work left end up graduating several terms later.  A few walk away with
only the thesis remaining, let that thesis get old and cold, and get
their degrees years later, if at all.

@end(enumerate)

@Chapter(The Oral Presentation)

All students should make an oral presentation of their thesis project.
This extremely valuable part of your thesis generally consists of a ten-minute
presentation with a five-minute discussion period with the supervisor
and at least one other faculty or staff member.  Your supervisor will
arrange your presentation.  VI-A students completing S.B. thesis
research at work usually arrange it with their company supervisor, even
if the final document is not completed there.

Supervisors are responsible for arranging oral presentations.  While
this presentation is not a `thesis defense', the supervisor may 
include the quality of the thesis presentation in the
final grade.


@Subsection(Hints for Oral Presentations:)

@begin(enumerate) Practice in front of friends, supervisor, and
mirror.  Practicing gives smoothness and polish.  Do at least one
complete 'dry run' for timing.

Keep it short.  Budget your time.  Put your watch where you can see
it, and stay aware of the time.  Don't rush by talking fast.  If
you're running long, go straight to your conclusions, and omit detail.

Don't read, but use notes or an outline.  Speak clearly and more
slowly than seems reasonable.  Make eye contact.

@begin(multiple)
Be extremely organized and use a logical structure.  Avoid getting bogged
down in excessive detail.  Give the Big Picture quickly, but mostly talk
about your thesis project, not the total research project.  Consult your 
supervisor for advice about which parts to cover in more detail.  Here is 
a possible structure:
@tabclear
@tabset(1.2in, 2.5in, 3.5in)


Time@\Topic
@bar()

1 minute@\Introduction: [Background, Motivation,  Big Picture]

1 minute@\Statement of Objectives, the Problem, the Hypothesis

1 minute@\Overview:  Approach, Methodology

@begin(format)
4 minutes@\Most Important Thing: More Detail Here 
@\[example, substantive accomplishment]
@end(format)

2 minutes@\Results

1 minute@\Conclusion: key lessons, need for future research
@bar()

Note that you spend almost half of your time introducing or concluding.  

@end(multiple)

Use a few (<10) professional-looking transparencies.
Overhead projectors should be reserved in advance from the Instrument
Room, 38-501, 3-4675.  You don't have TIME to use the blackboard.

It's better to be too formal than too casual.  Dressing up and
speaking properly may help cover lack of sleep and nervousness.  This
doesn't mean your speech has to be humorless or lifeless.

Your target audience is neither your supervisor nor a freshman, but
your fellow seniors in Electrical Engineering or Computer Science,
respectively.

@end(enumerate)


@Chapter(Thesis Prizes)

The thesis supervisors nominate theses for thesis awards.  In the
spring term the thesis must be submitted to the Undergraduate Office
by the Institute Deadline (May 7, 1993) to be considered for a prize.
The supervisor nominates by sending an additional copy of the thesis,
with a nominating letter detailing how the thesis is superior, to
Prof. James K. Roberge, for theses in Electrical Engineering, or to
Prof. Rodney A. Brooks, for Computer Science theses.  Nominations must be
received by the spring Institute thesis deadline.  Theses which were
submitted earlier, for the previous May, September and February degree
dates, may be considered for prizes in the following spring.
Questions from supervisors (not students) about prizes should be
referred to the appropriate faculty member.

@Chapter(Finishing Up)

@Section(MIT's "Specifications for Thesis Preparation")

The Institute publishes a booklet (revised 1992), outlining detailed
rules for theses.  Unfortunately, it is oriented toward Masters and
Ph.D. theses, which have different and much stricter requirements.
Wherever those guidelines differ from those described here, the
Institute instructions must be disregarded.  DON'T USE the Institute
pamphlet!  If you use it instead of this document, you will put
yourself through a lot of extra hassle, and have to make a lot of
changes at
the last minute.  @i(Handbook for Scientific and Technical Writing), 
by Rob Adams McKean, is
available in the Undergraduate Office, and recommended.

@Section(Writing an Abstract)

The original thesis which you submit to the Undergraduate Office must
have an abstract immediately after the title page.  (In previous years
two copies of the abstract were required.  This is no longer the
case.)  The abstract should contain your thesis title, your name, your
thesis supervisor, the degree and the date.  See the sample on page
@pageref(abstractsample).  Those students who found it difficult to
get their thesis title short enough should have no difficulty writing
an abstract.  Start by writing out a full title, with all the
adjectives and phrases you cut from the title.  Describe your methods
or procedures in a couple of sentences, and your conclusions or
results in another sentence or two.  It should be no longer than 150
words.  If you wrote up a brief statement on your agreement form, it
may be helpful to modify that into an abstract.

@Section(Wordprocessors, Printers, and Paper)

@begin(itemize)

@b(Wordprocessing.)  Students generally wordprocess their theses
themselves, rather than typing or having someone else type them.  Most
theses go through many draft versions, with minor and major revisions.
Supervisors don't like handwritten material at any stage.    
Please note that the SCRIBE thesis document on
Athena may NOT be correct, especially for the title page. On Athena,
for latex, type @i(attach thesis), then @i(cd /mit/thesis/tex).
For scribe it's the same, except for @i(/scribe) instead of @i(/tex).
Check to be
sure that your title page is exactly like the one on page @pageref(titlesample).
And DO BACKUPS!  

@b(Printers.)  There are lots of printers around MIT that produce
excellent copy; many work with the popular formatters SCRIBE or TEX.
Athena has a thesis printer that uses low-acid paper.  
Very cheap dot-matrix printers should be avoided.  Whatever printer
you plan to use, don't wait until just hours before the deadline, when
you haven't slept in a week, to find an alternative.  Have a
contingency plan ready.  No extensions can be given for computer,
printer, or disk crashes.  Do backups!

@b(Paper.)  The single original copy that you submit should be on
acid-free or 100% cotton or rag paper.  [Acid-free paper is indicated
by an infinity symbol.]  There is a thesis printer on athena that uses
this kind of paper.  Otherwise, obtain water-marked acid-free paper at
University Stationery on Mass.  Ave. (It's much cheaper there than at
the Coop), and put it in the printer for the final few copies.  Your
thesis will only remain readable for a handful of years if it's on
regular paper.  If your thesis is to be submitted to the library it
MUST be on acid-free paper.  Ask your supervisor: even if he or she
says it is not to be submitted you may want to have a copy or two on
this paper so it stays readable for more than just a few years.

@b(Type.)  Any reasonable size and style of font is acceptable.  The
print must be dark black (not grey).

@b(Margins.)  There must be at least one-inch margins on the top and
bottom, with all text, charts, photographs, and code INSIDE the
margins.  On the left side a margin of at least one and one quarter
inches must be strictly maintained.  If you are submitting a two-sided
thesis, the right margin must also be one and one quarter inches; if
one-sided, the right margin must be one inch.  Lack of control over
your formatter (SCRIBE or TEX or LATEX, for example) is NOT an excuse
for failure to adhere to these rules.  Get assistance from on-line
consultants, friends, or SIPB (3-7788)!  For pages of code, remember
that there are good quality photocopiers available that will
@b(reduce) your code so that it fits within the margins.

@b(Format.)  The document should be double-spaced.  No
specific format is required.

@b(Corrections.)  Avoid the use of correction fluid; hand-scribbled
corrections are never permitted.  

@b(Figures.)  Charts, tables, and graphs should be capable
of being photocopied clearly, and should not be hand-labeled.
No material should be taped or glued to pages, instead use a
high quality printer to copy pictures into your text.

@b(Supplementary Media.)  You may submit floppies, video cassettes,
etc., with your thesis, but the written part must make sense by
itself.

@end(itemize)

@Section(Title Page and Copyright)  

Make your title page look EXACTLY like the sample one on page
@pageref(titlesample) of this guide.  Use the name "Leonard A. Gould"
for the third signature, precisely as shown.  Check that his title is
as shown, as some athena templates are incorrect.  Copyright your
thesis by placing a copyright notice on the title page, with your name
and the year, as shown on the sample on page @pageref(titlesample).
The author must, as a condition of the degree, grant permission to the
Institute to reproduce and distribute publicly copies of the thesis.
A statement to this effect must appear on the title page.  See the
sample title page on page @pageref(titlesample).  You must submit a
correct title page.

You automatically have the copyright @b(unless) you received money
from MIT for doing the research or writing it up.  If you wish to register
your copyright (certainly a good idea if you're planning to use your
thesis for commerical purposes), contact the Technology Licensing Office
at E32-300 for assistance.

@Section(Deadlines and Extensions)
@label(deadlines)

The deadlines for 1992-1993 are listed on the front page of this
document.  Note that the Department's final thesis deadlines are about
ten days LATER than the Institute's deadlines.  Going past the
Institute's Deadline to the Department's Deadline is NOT considered an
extension and does NOT require any permission.  Apart from eligibility
for Thesis Prizes, the Institute Deadline means nothing to Course VI
Undergraduates.  Do NOT call us to check the deadline:  Trust us!

@i(Here's Why):  The Department Deadline is later than the Institute
one because the Institute allows ten days after its deadline for
supervisors to read and grade theses.  We know from experience that by
the time they are ready to sign theses, supervisors know the grades.
Therefore our deadline for theses is also the deadline for final
grades to be submitted to the Undergraduate Office (supervisors, note
well!).  Students must bring the completed grade sheet (available
from the Course VI Undergraduate Office) with the final copy of the
thesis.

The Department's thesis deadline means that students who hand in
theses after that date are not @i(guaranteed) that their final thesis
grade will be posted in time for them to graduate that term.  Students
who hand in a thesis late may be able to graduate at Commencement but
not have their names in the Commencement Booklet.  Students who fail
to graduate because they missed the thesis deadline by more time will
have to register for one unit of thesis for the following term, get on
that term's degree list, and graduate at the end of it.  No extensions
of that guarantee beyond the final Department Deadline, as listed on
the front of this guide, are possible.  No thesis supervisor is
empowered to extend the deadline.  Since there are no extensions,
there are no forms to be filled out to get an extension.  Students
should NOT give up at the deadline, but should hand in their theses as
fast as possible.  You may hand in your thesis on any weekday during
business hours, at any time of the year.  Students who miss the
deadline but are very close to finishing should call (x3-7329) the
Undergraduate Office on the morning AFTER the Final Thesis Deadline,
so we can reassure you and encourage you to keep working, knowing
we're pulling for you.  @b(Please) eliminate other calls to the
Undergraduate Office to inquire about extensions, especially ON or
BEFORE the deadline.  We save all of our strength and sympathy for
those who actually miss the deadline, so that we just don't want
to deal with people futilely trying to get extensions.  These three
paragraphs say everything we have to say about deadlines and
extensions.  

@Section(Supervisor's Signature and Final Grade)

Try not to wait until the afternoon of the deadline to submit your
thesis.  Make sure that your supervisor will be here when you need his
or her signature; no thesis can be accepted without a supervisor's
original signature on the title page.  The Department signature (L. A.
Gould's) will be furnished automatically later.  Be sure to pick up a
receipt/grade sheet from the Undergraduate Office before you hand in
your thesis.  Have your supervisor fill out the grade sheet part at
the same time that he or she signs your thesis.  Remember that your
final thesis grade must be handed in with your thesis.  In emergencies
we will accept phoned-in or emailed grades from supervisors as long as
the white grade sheet is sent promptly.


@Section(Copies, Binders, Labels and Clips)

Submit only one (1) copy of your thesis.  It should be the original,
unless for some reason a photocopy is better suited for copying.  The
title page (see sample on page @pageref(titlesample)) must bear your
and your thesis supervisor's original signatures.  The Departmental
signature will be provided later.  The Institute pamphlet specifies
more copies because many departments maintain their own undergraduate
thesis library.  Since this Department does not own a spare airplane
hangar, we do not.  The copy that you submit will either be sent on to
Archives, if your supervisor so indicates, or be returned to your
supervisor, shortly after you graduate.  It is nevertheless customary
to give your thesis supervisor a copy when you finish.


@label(binder) The thesis must be submitted in a temporary binder
consisting of two pieces of cardboard and binder clips.  These are
available free in Archives (14N-118).  Do not hole-punch or bind your
thesis in any other way.  On the front cover of the binder, place a
label containing your name, thesis title, supervisor, degree and date.

@label(gradesheet)
@Section(The Thesis Receipt/Grade Sheet and the Degree List)

Before you come to the Course VI Undergraduate Office to submit your
thesis, use the checklist on page @pageref(checklist) to be sure
you're ready.  You must bring the grade sheet/receipt form with you
when you hand in your thesis.  Do not trust anyone else to hand carry
the white, grade sheet copy, or let it be sent in the Institute mail.

At that time your name will be checked against the Degree List.  [If
you intend to graduate in that term and you're not on that list (which
is maintained by the Registrar) you will be sent to Ms. Josephine
Eisner (E19-335, x3-4781), to remedy the situation.]  If you've
followed these instructions successfully, your thesis will be
accepted, and each copy of your thesis receipt/grade sheet will be
stamped with an official Department stamp.  Keep your receipt; it is
your evidence that you did turn in a thesis.  Take the stamped pink
copy to your academic advisor, and check your degree requirements one
last time.

@blankspace(2)
Revised 7/92: Anne M. Hunter
@newpage 

@Appendix(Sample VI-A/EIP Company Agreement Letter)

@label(lettersample)
@blankspace(2)
@begin(format, spacing 1.3)
Professor Leonard A. Gould
Department of Electrical Engineering and Computer Science
Room 38-476, M.I.T.
Cambridge, MA   02139
@end(format)

@ux(Subject: Bachelor of Science Thesis of [Student])

Dear Professor Gould:

The attached Thesis Agreement Form entitled [Thesis Title] describes a
research study that [Student] carried out as an MIT VI-A{or EIP}
student using, at least in part, the facilities of [Company].
[Student] intends to prepare a thesis based on this VI-A assignment to
be submitted as one of the requirements for the Bachelor of Science
degeree.  We understand that, if such a report is to be acceptable to
MIT, faculty regulations require that:
@begin(enumerate, spacing 1.2)
@blankspace(1)
The written presentation of the work must be approved by a member of
the MIT staff who can have access to the pertinent background, methods
of investigation and results.

The work is not subject to restriction for reasons of
either proprietary interest or national security.

The actual thesis document becomes the permanent property of MIT, and
may be placed in the MIT Library within one month of the date of
submission.

For the thesis to be accepted, [Student), as copyright owner must give
MIT the right to reproduce and to distribute publicly the thesis.  If
the student has assigned the copyright to [Company], [Company] agrees
that MIT shall have the nonexclusive right to reproduce, publish and
distribute the thesis.

@end(enumerate)
@blankspace(2)
@begin(verbatim, spacing 1.2)

__________________________               __________________________
Direct Company                           Student
Supervisor       
@end(verbatim)
@newpage
@Appendix(Sample Abstract)
@blankspace(2)

@begin(center)
@label(abstractsample)
A Stratigraphic Model Editor
by 
Stephen P. Gildea
@blankspace(1)

Submitted to the 
Department of Electrical Engineering and Computer Science
@blankspace(1)
May 16, 1992
@blankspace(1)
In Partial Fulfillment of the Requirements for the Degree of
Bachelor of Science in Computer [Electrical] Science and Engineering
@end(center)

@blankspace( 2)

@majorheading(ABSTRACT)
@blankspace(1)

The stratigraphic model editor provides a convenient and efficient
tool for geophysicists manipulating the complex models used in ray
tracing and other forward modeling techniques.  The editor allows the
user to build a model of the earth on a Symbolics Lisp Machine screen
using the mouse.  The earth models manipulated by the program
represent a two-dimensional slice of the earth, typically extending
three or four miles down and having 10 to 50 layers.  The layers need
not be flat, but can contain features such as reefs and salt domes.
These models are important in exploration geophysics.  The editor
generates data files representing this model that can be used as input
to a ray-tracing program.  The description of the file format is
written in a high-level declarative language, so that the editor can
be easily modified to support other formats.

@blankspace(2 lines)

@begin(flushleft)
Thesis Supervisor:  Roger Turpening
Title: Associate Director, MIT Earth Resources Laboratory
@end(flushleft)


@newpage

@label(titlesample)
@Appendix(Sample Title Page)
@begin(center)
@blankspace(1)
@b(The Electrical and Optical Characterization

of the InGaAs/InP Alloy System)

by

John M. Doe

@blankspace(1)
Submitted to the Department of Electrical Engineering and Computer Science

in Partial Fulfillment of the Requirements for the Degree of

Bachelor of Science in Electrical [Computer] Science and Engineering

at the Massachusetts Institute of Technology

May 1992

Copyright John M. Doe 1992.  All rights reserved.
@blankspace(1)

The author hereby grants to M.I.T. permission to reproduce 
and to distribute copies of this thesis document in whole or in part,
and to grant others the right to do so.
@end(center)
@blankspace(2)
@begin<flushleft>
Author@&_
@tabclear
@tabset(5.15in, 2.55in)
@\Department of Electrical Engineering and Computer Science
@\@\May 17, 1992
@tabclear
Certified by@&_
@tabset(4.75in, 4.9in)
@\[Supervisor's Name]
@\@\Thesis Supervisor
@tabclear
Accepted by@&_
@tabclear
@tabset(2.55in,4.95in)
@\@\Leonard A. Gould
@\Chairman, Department Committee on Undergraduate Theses
@tabclear
@end(leftflush)

@newpage

@label<checklist>
@Appendix(Checklist for Handing in a Thesis)


Read over this checklist before you hand your thesis in at the Undergraduate Office.
@blankspace(1)
@begin(itemize)

Are your margins at least one inch on all sides and one and one
quarter inches on the left (or both sides if two-sided)?

Does your title page look exactly like the sample on page
@pageref(titlesample)?  Check the copyright and the sentence right
after it that starts "The author hereby...".

Do you have an abstract located immediately after
the title page?  Does it look a lot like the one on page
@pageref(abstractsample)?

If your thesis is to be submitted to the library, make sure you have
printed your final copy onto watermarked acid-free paper.  There
is a `thesis'  athena printer that provides this paper automatically.

Have you made all the copies you need (for your mother, supervisor,
friends)?    Once your single original copy is submitted, you can't
borrow it back.

Is your submission copy properly covered in cardboard, held together
only with clips, with the front cover clearly labeled?  [See page
@pageref(binder)]

Have you and your supervisor signed the title page of the submission
copy?  The third signature (Prof. Gould's) will be provided later.  [See
page @pageref(titlesample)]

Have you and your supervisor filled out your thesis grade
sheet/receipt form?  (Available in the Course VI Undergraduate Office)
[See page]
@pageref(gradesheet)]

@end(itemize)
@blankspace(2)
@appendix(Changes since the previous edition of this Guide:)

@begin(itemize)

Minor wording changes on the title page.  See page @pageref(titlesample).

The thesis may be two-sided.

Only one copy of the abstract is now required.  

Correction fluid is not permitted.

No photographs or other material may be glued, taped or otherwise
affixed to the pages of the thesis.   

Theses that come in after the Spring thesis prize deadline may be
considered for the following year's competition.
@end(itemize)


@pageheading(left "", center @value[page], right "")

