/*************************************************************************/
/* (c) Copyright Tai Jin, 1988.  All Rights Reserved.                    */
/*     Hewlett-Packard Laboratories.                                     */
/*                                                                       */
/* Permission is hereby granted for unlimited modification, use, and     */
/* distribution.  This software is made available with no warranty of    */
/* any kind, express or implied.  This copyright notice must remain      */
/* intact in all versions of this software.                              */
/*                                                                       */
/* The author would appreciate it if any bug fixes and enhancements were */
/* to be sent back to him for incorporation into future versions of this */
/* software.  Please send changes to tai@iag.hp.com or ken@sdd.hp.com.   */
/*************************************************************************/

#ifndef lint
static char RCSid[] = "@(#)$Header: adjtime.c,v 1.7 90/02/07 15:34:04 src Exp $";
#endif
/*$Log:	adjtime.c,v $
 * Revision 1.7  90/02/07  15:34:04  15:34:04  src (Source Hacker)
 * CHANGED KEY !!!
 * 
 * Revision 1.6  89/02/09  12:26:24  12:26:24  tai (Tai Jin (Guest))
 * *** empty log message ***
 * 
 * Revision 1.6  89/02/09  12:26:24  12:26:24  tai (Tai Jin)
 * added comment
 * 
 * Revision 1.5  88/08/30  01:08:21  01:08:21  tai (Tai Jin)
 * fix copyright notice again
 * 
 * Revision 1.4  88/08/30  00:51:46  00:51:46  tai (Tai Jin)
 * fix copyright notice
 * 
 * Revision 1.3  88/04/03  17:50:30  17:50:30  tai (Tai Jin)
 * added some comments, used registers
 * 
 * Revision 1.2  88/04/02  15:00:23  15:00:23  tai (Tai Jin)
 * removed OLD_TICK ifdef
 * 
 * Revision 1.1  88/04/02  14:56:45  14:56:45  tai (Tai Jin)
 * Initial revision
 * */

/*
 * Adjust time routine (emulates BSD adjtime()).
 * Uses SYSV messages to communicate with the adjtimed daemon.
 */

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <time.h>
#include <signal.h>
#include "adjtime.h"

#if defined(SDD)
#include <stdio.h>
#define abs(x)  ((x) < 0 ? -(x) : (x))
int _adjtime_debug = 0;
static long adjthresh = 400L;
static long saveup;

clear_Xadjtime()
{
    saveup = 0L;
    if (_adjtime_debug)
	(void) fprintf(stderr, "ADJTIME (%ld): saveup reset !!\n", 
		       time((long *)0));
}


Xadjtime(delta, olddelta)
     register struct timeval *delta;
     register struct timeval *olddelta;
{
    struct timeval newdelta;

    if (_adjtime_debug)
	(void) fprintf(stderr, "ADJTIME (%ld): %ld/%ld ", 
		       time((long *)0), delta->tv_sec, delta->tv_usec);

    /* If they are giving us seconds, ignore up to current threshold saved */
    if (delta->tv_sec) {
	saveup = 0L;
	if (_adjtime_debug)
	    (void) fprintf(stderr, "Big leap, saveup reset\n");
	return(adjtime(delta, olddelta));
    }

    /* add in, needs check for overflow ? */
    saveup += delta->tv_usec;
    if (_adjtime_debug)
	(void) fprintf(stderr, "[%ld/%ld] ", saveup, adjthresh);

    /* Broke the threshold, call adjtime() */
    if (abs(saveup) > adjthresh) {
	newdelta.tv_sec = 0L;
	newdelta.tv_usec = saveup;
	saveup = 0L;
	if (_adjtime_debug)
	    (void) fprintf(stderr, "adjtime called, saveup reset\n");
	return(adjtime(&newdelta, olddelta));
    }

    if (_adjtime_debug)
	(void) fprintf(stderr, "just added\n");
    olddelta->tv_sec = olddelta->tv_usec = 0L;
    return(0);
}
#endif


adjtime(delta, olddelta)
     register struct timeval *delta;
     register struct timeval *olddelta;
{
    register int mqid;
    MsgBuf msg;
    register MsgBuf *msgp = &msg;

    /*
     * get the key to the adjtime message queue
     * (note that we must get it every time because the queue might have been
     *  removed and recreated)
     */
    if ((mqid = msgget(KEY, 0)) == -1) {
	return (-1);
    }

    msgp->msgb.mtype = CLIENT;
    msgp->msgb.tv = *delta;

    if (olddelta)
	msgp->msgb.code = DELTA2;
    else
	msgp->msgb.code = DELTA1;

    if (msgsnd(mqid, &msgp->msgp, MSGSIZE, 0) == -1)
	return (-1);

    if (olddelta) {
	if (msgrcv(mqid, &msgp->msgp, MSGSIZE, SERVER, 0) == -1)
	    return (-1);

	*olddelta = msgp->msgb.tv;
#if defined(SDD)
	if (_adjtime_debug)
	    (void) fprintf(stderr, "ADJTIME (%ld): *REAL* leftover %ld/%ld\n", 
			   time((long *)0), 
			   olddelta->tv_sec, olddelta->tv_usec);
#endif
    }

    return (0);
} /* adjtime */
