/*
 * $Header: /src/NTP/v3/xntp/kernel/RCS/dcf77sync.h,v 2.3 1992/07/08 11:43:23 kardel XNTP-DCF-1 $
 *
 * $Id: dcf77sync.h,v 2.3 1992/07/08 11:43:23 kardel XNTP-DCF-1 $
 *
 * Copyright (c) 1989,1990,1991,1992
 * Frank Kardel Friedrich-Alexander Universitaet Erlangen-Nuernberg
 *                                   
 * This code can be modified and used freely provided that the
 * credits remain intact.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * $Log: dcf77sync.h,v $
 * Revision 2.3  1992/07/08  11:43:23  kardel
 * struct clockformat added
 *
 * Revision 2.2  1992/07/06  13:58:40  kardel
 * support for returning format code in DCFIOC_TIMECODE
 *
 * Revision 2.1  1992/07/05  21:31:40  kardel
 * initial extendable multi protocol version
 *
 * Revision 1.2  1992/03/13  16:51:24  kardel
 * legal terms changed
 *
 * Revision 1.1  1992/03/13  16:50:10  kardel
 * Initial revision
 */

#ifndef lint
  static char dcf77hrcsid[]="$Id: dcf77sync.h,v 2.3 1992/07/08 11:43:23 kardel XNTP-DCF-1 $ FAU";
#endif

#define DCF_DELTA        20

struct dcf			/* dcf module local data */
{
  queue_t       *dcf_queue;	/* read stream for this channel */
  int            dcf_flags;	/* operation and current status flags */
  
  int		 dcf_syncflags;	/* possible sync events (START/END/character) */
  char           dcf_startsym[64]; /* possible start packet values */
  char           dcf_endsym[64];   /* possible end packet values */
  char		 dcf_syncsym[64]; /* sync characters */

  struct timeval dcf_stime;	/* packet sample time */
  int            dcf_index;	/* current buffer index */
  char          *dcf_data;      /* data buffer */
  unsigned short dcf_dsize;	/* size of data buffer */
  unsigned short dcf_lformat;	/* last format used */
  unsigned long  dcf_lstate;	/* last state code */
  char          *dcf_ldata;	/* last data buffer */
  unsigned short dcf_ldsize;	/* last data buffer length */
  unsigned long  dcf_badformat;	/* number of unparsable pakets */
  
  long           dcf_delta[DCF_DELTA]; /* delta buffer */
  int            dcf_dindex;
  long           dcf_usecerror;	/* last error at adjust time */
  long           dcf_usecdisp;	/* last calculated dispersion */
};

typedef struct dcf dcf_t;

struct clocktime		/* clock time broken up from time code */
{
  long day;
  long month;
  long year;
  long hour;
  long minute;
  long second;
  long usecond;
  long utcoffset;	/* in minutes */
  long flags;		/* current clock status */
};

typedef struct clocktime clocktime_t;

/*
 * clock formats specify routines to be called to
 * convert the buffer into a struct clock.
 * functions are called
 *   fn(buffer, data, clock) -> CVT_NONE, CVT_FAIL, CVT_OK
 *
 * the private data pointer can be used to
 * distingush between different formats of a common
 * base type
 */
#define F_START		0x00000001 /* start packet delimiter */
#define F_END		0x00000002 /* end packet delimiter */
#define SYNC_START	0x00000004 /* packet start is sync event */
#define SYNC_END	0x00000008 /* packet end is sync event */
#define SYNC_CHAR	0x00000010 /* special character is sync event */

struct clockformat
{
  int (*convert)();		/* conversion routine */
  void (*syncevt)();		/* routine for handling sync events (time stamps) */
  void *data;			/* local parameters */
  char *name;			/* clock format name */
  unsigned short length;	/* maximum length of data packet */
  unsigned long flags;		/* valid start symbols etc. */
  char startsym;		/* start symbol */
  char endsym;			/* end symbol */
  char syncsym;			/* sync charcter */
};

typedef struct clockformat clockformat_t;

/*--------------- debugging support ---------------------------------*/

#ifdef DEBUG_DCF

#define DD_OPEN    0x00000001
#define DD_CLOSE   0x00000002
#define DD_RPUT    0x00000004
#define DD_WPUT    0x00000008
#define DD_RSVC    0x00000010

#define dcfprintf(flags, arg) (((flags) & dcfdebug) ? printf arg : 0)

#else
#define dcfprintf(flags, arg)
#endif

