/*
 * authdecrypt - routine to decrypt a packet to see if this guy knows our key.
 */
#include <sys/types.h>

/*
 * For our purposes an NTP packet looks like:
 *
 *	a variable amount of unencrypted data, multiple of 8 bytes, followed by:
 *	NOCRYPT_OCTETS worth of unencrypted data, followed by:
 *	BLOCK_OCTETS worth of ciphered checksum.
 */ 
#define	NOCRYPT_OCTETS	4
#define	BLOCK_OCTETS	8

#define	NOCRYPT_LONGS	((NOCRYPT_OCTETS)/sizeof(u_long))
#define	BLOCK_LONGS	((BLOCK_OCTETS)/sizeof(u_long))

/*
 * Imported from the key data base module
 */
extern u_long cache_keyid;	/* cached key ID */
extern u_char DEScache_dkeys[];	/* cached decryption keys */
extern u_char DESzerodkeys[];	/* zero key decryption keys */

extern int authhavekey();

/*
 * Stat counters, imported from data base module
 */
extern u_long authdecryptions;
extern u_long authkeyuncached;
extern u_long authdecryptok;

int
DESauthdecrypt(keyno, pkt, length)
	u_long keyno;
	u_long *pkt;
	int length;	/* length of variable data in octets */
{
	register u_long *pd;
	register int i;
	register u_char *keys;
	register int longlen;
	u_long work[2];

	authdecryptions++;
	
	if (keyno == 0)
		keys = DESzerodkeys;
	else {
		if (keyno != cache_keyid) {
			authkeyuncached++;
			if (!authhavekey(keyno))
				return 0;
		}
		keys = DEScache_dkeys;
	}

	/*
	 * Get encryption block data in host byte order and decrypt it.
	 */
	longlen = length / sizeof(u_long);
	pd = pkt + longlen;		/* points at NOCRYPT area */
	work[0] = *(pd + NOCRYPT_LONGS);
	work[1] = *(pd + NOCRYPT_LONGS + 1);

	if (longlen & 0x1) {
		DESauth_des(work, keys);
		work[0] ^= *(--pd);
	}

	for (i = longlen/2; i > 0; i--) {
		DESauth_des(work, keys);
		work[1] ^= *(--pd);
		work[0] ^= *(--pd);
	}

	/*
	 * Success if the encryption data is zero
	 */
	if ((work[0] == 0) && (work[1] == 0)) {
		authdecryptok++;
		return 1;
	}
	return 0;
}
