/*
 * gizmo_util.c - stuff I didn't have any other place for
 */
#include <stdio.h>
#include <errno.h>
#include <strings.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in.h>

#include "ntp_syslog.h"
#include "ntp_fp.h"
#include "ntp.h"
#include "gizmo.h"


/*
 * This contains odds and ends.  For the Unix daemon these odds and ends
 * fortunately contained a lot of Unix dependent stuff.  These are
 * replaced wholesale.
 *
 * We retain support for the hourly call.  We also include entries
 * to decode and set individual authentication keys and a dummy entry
 * for rereading the authentication keys (which we can't do).
 */

#ifdef DEBUG
extern int debug;
#endif

/*
 * init_util - initialize the utilities
 */
void
init_util()
{
	/*
	 * Nothing to do here
	 */
}


/*
 * hourly_stats - print some interesting stats
 */
void
hourly_stats()
{
	extern l_fp drift_comp;
	extern long compliance;
	extern char *lfptoa();
	extern char *mfptoa();

	syslog(LOG_INFO, "hourly check: drift %s compliance %s",
		lfptoa(&drift_comp, 8),
		mfptoa((compliance<0)?(-1):0, compliance, 8));
}



/*
 * setauthkey - decode and use an authentication key
 */
void
setauthkey(keyno, rawkeys)
	u_long keyno;
	u_long *rawkeys;
{
	u_long keys[2];
	u_long masterkey[2];
	u_char ekeys[128];
	u_char dkeys[128];
	extern void auth_subkeys();
	extern void auth_des();
	extern void auth_setkey();
	extern int auth_parity();

	keys[0] = rawkeys[0];
	keys[1] = rawkeys[1];

	masterkey[0] = (GIZMO_KEY_L ^ keyno) ^ (keyno << 1);
	masterkey[1] = (GIZMO_KEY_R ^ keyno) ^ (keyno << 1);
	auth_subkeys(masterkey, ekeys, dkeys);
	auth_des(keys, dkeys);
	if (!auth_parity(keys)) {
		syslog(LOG_ERR, "parity error on key number %d, not used",
		    keyno);
	} else {
		auth_setkey(keyno, keys);
	}
}


/*
 * rereadkeys - read the authentication key file over again.
 */
void
rereadkeys()
{
}


/*
 * clock_parms - return the gizmo's clock parameters
 */
void
clock_parms(tickadj, tick)
	u_long *tickadj;
	u_long *tick;
{
	/*
	 * These values are hardwired, in gizmo.h
	 */
	*tickadj = (u_long)GIZMO_TICKADJ;
	*tick = (u_long)GIZMO_TICK;
}
