/*
 *  $Header: /src/NTP/v3/xntp/include/RCS/dcf77.h,v 2.3 1992/07/08 11:37:51 kardel XNTP-DCF-1 $
 *
 *  $Id: dcf77.h,v 2.3 1992/07/08 11:37:51 kardel XNTP-DCF-1 $
 *
 *  Copyright (c) 1989,1990,1991,1992
 *  Frank Kardel Friedrich-Alexander Universitaet Erlangen-Nuernberg
 *                                    
 *  This code can be modified and used freely provided that the
 *  credits remain intact.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * $Log: dcf77.h,v $
 * Revision 2.3  1992/07/08  11:37:51  kardel
 * pass back number failed format conversions since last TIMECODE call
 *
 * Revision 2.2  1992/07/06  14:00:33  kardel
 * support for returning format code in DCFIOC_TIMECODE
 *
 * Revision 2.1  1992/07/05  21:30:55  kardel
 * initial multi protocal version
 *
 * Revision 1.2  1992/03/13  16:49:24  kardel
 * legal terms changed
 *
 * Revision 1.1  1991/12/16  10:59:51  kardel
 * Initial revision
 *
 */

#ifndef lint
  static char dcfhrcsid[]="$Id: dcf77.h,v 2.3 1992/07/08 11:37:51 kardel XNTP-DCF-1 $ FAU";
#endif

/*
 * state flags
 */
#define DCFB_ANNOUNCE           0x0001 /* switch time zone warning (DST switch) */
#define DCFB_POWERUP            0x0002 /* no synchronisation */
#define DCFB_NOSYNC             0x0004 /* timecode currently not confirmed */
#define DCFB_DST                0x0008 /* DST in effect */
#define DCFB_UTC		0x0010 /* UTC time */
#define DCFB_LEAP		0x0020 /* LEAP warning (1 hour prior to occurence) */
#define DCFB_ALTERNATE		0x0040 /* alternate antenna used */
#define DCFB_S_LEAP		0x0100 /* supports LEAP */
#define DCFB_S_LOCATION		0x0200 /* supports LOCATION information */

#define DCF_POWERUP(x)          ((x) & DCFB_POWERUP)
#define DCF_NOSYNC(x)           (((x) & (DCFB_POWERUP|DCFB_NOSYNC)) == DCFB_NOSYNC)
#define DCF_SYNC(x)             (((x) & (DCFB_POWERUP|DCFB_NOSYNC)) == 0)
#define DCF_ANNOUNCE(x)         ((x) & DCFB_ANNOUNCE)
#define DCF_DST(x)              ((x) & DCFB_DST)
#define DCF_UTC(x)		((x) & DCFB_UTC)
#define DCF_LEAP(x)		(DCF_SYNC(x) && ((x) & DCFB_LEAP))
#define DCF_ALTERNATE(x)	((x) & DCFB_ALTERNATE)
#define DCF_S_LEAP(x)		((x) & DCFB_S_LEAP)
#define DCF_S_LOCATION(x)	((x) & DCFB_S_LOCATION)

/*
 * ioctls
 */
#define DCFIOC_SETSTAT	(('D'<<8) + 'S')
#define DCFIOC_GETSTAT	(('D'<<8) + 'G')
#define DCFIOC_TIMECODE	(('D'<<8) + 'T')
#define DCFIOC_GETFMT	(('D'<<8) + 'F')

/*
 * sizes
 */
#define DCF_TCMAX	64

/*
 * operation flags
 */
#define DCF_STAT_FILTER 0x00000001

/*
 * ioctl structure
 */
union dcfctl 
{
  struct dcfstatus
    {
      unsigned long flags;	/* new/old flags */
    } dcfstatus;

  struct dcfgettc
    {
      unsigned long  dcf_state;	/* last state */
      unsigned long  dcf_badformat; /* number of bad packets since last query */
      unsigned short dcf_format;/* last decoded format */
      unsigned short dcf_count;	/* count of valid time code bytes */
      char           dcf_buffer[DCF_TCMAX+1]; /* timecode buffer */
    } dcfgettc;

  struct dcfgetformat
    {
      unsigned short dcf_format;/* number of examined format */
      unsigned short dcf_count;	/* count of valid string bytes */
      char           dcf_buffer[DCF_TCMAX+1]; /* format code string */
    } dcfgetformat;
};
  
typedef union dcfctl dcfctl_t;

/*
 * standart time stamp structure
 */
struct dcftime
{
  struct timeval dcf_time;	/* DCF timestamp */
  struct timeval dcf_stime;	/* received timestamp */
  long           dcf_usecerror;	/* sampled/filtered usec error */
  long           dcf_usecdisp;	/* sample usecdispersion */
  unsigned long  dcf_flags;	/* current operation flags */
  unsigned long	 dcf_state;	/* current receiver state */
  unsigned short dcf_format;	/* format code */
};

typedef struct dcftime dcftime_t;
