#ifdef hpux
#include <string.h>
#include <memory.h>
#include <unistd.h>
#include <stdio.h>


#if !defined(hpux80)
char 
*index(s, c)
register char *s;
register int c;
{
    return strchr (s, c);
}


char 
*rindex(s, c)
register char *s;
register int c;
{
    return strrchr (s, c);
}


int 
bcmp(a, b, count)
register char *a, *b;
register int count;
{
    return memcmp (a, b, count);
}


void 
bcopy(from, to, count)
register char *from;
register char *to;
register int count;
{
   if ((to == from) || (count <= 0))
       return;

   if ((to > from) && (to <= (from + count))) {
       to += count;
       from += count;

       do {
	   *--to = *--from;
       }   while (--count);
   }
   else {
       do {
	   *to++ = *from++;
       }   while (--count);
   }
}


void 
bzero(area, count)
register char *area;
register int count;
{
    memset(area, 0, count);
}
#endif


getdtablesize()
{
    return(sysconf(_SC_OPEN_MAX));
}


int 
setlinebuf(a_stream)
    FILE *a_stream;
{
    return setvbuf(a_stream, (char *) NULL, _IOLBF, 0);
}
#endif
