/* WIDE AREA INFORMATION SERVER SOFTWARE:
   No guarantees or restrictions.  See the readme file for the full standard
   disclaimer.

   Brewster@think.com
*/

/* Change log:
 * $Log:	macbuild.c,v $
 * Revision 1.2  92/02/12  13:35:04  jonathan
 * Added "$Log: $" so RCS will put the log message in the header
 * 
*/

/* This is a clumsy index building program for the Mac.
 * For some reason all this Class garbage is needed to
 * set up something to call the file routines.
 * Sorry about the novice mac code.
 *
 * -brewster 7/90
 */

#include "irfiles.h"
#include "irhash.h"
#include "irtfiles.h"
#include "panic.h"
#include "cutil.h"
#include "irext.h"

#include <profile.h>
#include <EventMgr.h>
#include <FileMgr.h>

/*----------------------------------------------------------------------*/
/* Class definitions */

#include <CApplication.h>
#include <CFile.h>
#include <CView.h>
#include <CWindow.h>
#include <CDesktop.h>
#include <CDirector.h>
#include "CDynamicError.h"

extern	CApplication	*gApplication;

struct CBuildApp : CApplication 
{
  void	IBuildApp(void);
};

void CBuildApp::IBuildApp(void)
{
  CApplication::IApplication(4, 20480L, 2048L);
  gError->Dispose(); /* get rid if the CError that IApplication defined */
  gError = new(CDynamicError); /* make our own error handler */
}

/*----------------------------------------------------------------------*/
/* Gets a full filename from the mac file objects.
 * getwd was taken from utils.c from the 
 * document retrieval system.
 */

#include <HFS.H>
#include <string.h>
/* for file manipulation routines */
typedef enum file_style {MAC_FILE_STYLE, UNIX_FILE_STYLE} file_style;

static char 
*getwd(file_style style)
/* This function returns the unix style path name which is set by any of the SF
   routines (using the global vars).  The code is from the net, I have no idea
   who the author might be.  He/She does include the following note:
   
  		Note that it is perfectly legal for a Macintosh owner to create a
		directory hierarchy where the length of full path names of the deepest
		files exceeds 255 bytes; since the file system never manipulates full
		pathnames internally (it only ever sees them when passed as parameters),
		it doesn't and needn't check.  However, this poses an ethical problem if
		you are constructing full pathnames: my code simply bombs if it would
		construct a pathname >255 bytes, and if I increased the buffer size, the
		resulting pathnames are useless except for documentation purposes (since
		the file system can't have string parameters >255 bytes).
 */
{
	CInfoPBRec d;
	static char ret[255];
	char nm[50], tmp[255];
	long cur_dir = CurDirStore; /* mac global var */
	long cur_vol = 0 - SFSaveDisk; /* mac global var */
	
	ret[0] = '\0';
	d.dirInfo.ioDrDirID = cur_dir;
	for(;;) {
		d.dirInfo.ioCompletion = 0;
		d.dirInfo.ioNamePtr = (StringPtr) nm;
		d.dirInfo.ioVRefNum = cur_vol;
		d.dirInfo.ioFDirIndex = -1;

		PBGetCatInfo(&d,0);
/*		if(d.ioResult != noErr) return(0); this is not defined in lightspeed's headers */
		PtoCstr((char *) nm);
		strcpy(tmp,ret);
		if (style == UNIX_FILE_STYLE)
		  strcpy(ret,"/");
		else 
		  strcpy(ret,":");
		strcat(ret,nm);
		strcat(ret,tmp);
		if(d.dirInfo.ioDrDirID == 2) break;	/* home directory */
		d.dirInfo.ioDrDirID = d.dirInfo.ioDrParID;
	} 
	/* if its MAC style, remove the leading colon */
	if (style == MAC_FILE_STYLE)
	  return(ret+1);
	else
	  return(ret);
}

/*----------------------------------------------------------------------*/
/* Gets a filename from the user (one that exists already) */
 
static boolean 
get_filename(char* prompt, char *filename)
{
   SFReply	macSFReply;
   Point pos;
   pos.h = pos.v = 100;
   SFGetFile(pos, (StringPtr)"\pFile to Index:", 
			 NULL, -1, NULL, NULL, &macSFReply);
   if(macSFReply.good)
    { /* then we have a gotten a good file.
	   * put together the full filename
       */
		 
      strcpy(filename, getwd(MAC_FILE_STYLE));
      strcat(filename, ":");
	  PtoCstr((char *)macSFReply.fName);
	  strcat(filename, (char *)macSFReply.fName);
	  CtoPstr((char *)macSFReply.fName);
	  return(true);
	 }
	else
	  return(false);
}

/*----------------------------------------------------------------------*/
/* Gets a filename from the user (one that does not exist already) */
 
static int get_new_filename(char *filename)
{
	SFReply	macSFReply;
	Point pos;
	pos.h = pos.v = 100;
	
	SFPutFile(pos, (StringPtr)"\pLocation of Index:", 
				   (StringPtr)"\pindex", 
			  NULL, &macSFReply);
	if(macSFReply.good){
		/* then we have a gotten a good file.
		 * put together the full filename
		 */
		 
		 strcpy(filename, getwd(MAC_FILE_STYLE));
		 strcat(filename, ":");
		 PtoCstr((char *)macSFReply.fName);
		 strcat(filename, (char *)macSFReply.fName);
		 CtoPstr((char *)macSFReply.fName);
		 return(true);
	}
	else{
	return(false);
	}
}

/*----------------------------------------------------------------------*/
/* Main routine for building an index */

FILE *logfile = NULL;
 
void main()
{	
  char filename[MAX_FILE_NAME_LEN + 1]; 
  char index_filename[MAX_FILE_NAME_LEN + 1];
  database* db;
  long count;
  SFReply macSFReply;
  Point pos;
	dataopsrec  dataops;
	
  InitProfile(3000,200);

/* dgg -- must duplicate mods to irbuild.c */
  dataops.separator_function= NULL;
  dataops.header_function= NULL;
  dataops.date_function= NULL;
  dataops.finish_header_function= NULL;
  dataops.type= "TEXT";
  dataops.wordDelimiter= wordbreak_notalnum;
  dataops.addseparatorwords= false;
  dataops.extraheaderweight= true;
  dataops.repeat_weight= 1;
  dataops.minwordlen= 2;
  stop_list_file("\0");
  gDelimiters[0]= '\0';  
  wordDelimiter= wordbreak_notalnum;   
/* dgg -- end new inits */
	
_profile = false;
_trace = false;
freopen("stdout","w",stdout);
	
  pos.h = pos.v = 100;

  gApplication = new(CBuildApp);
  ((CBuildApp *)gApplication)->IBuildApp();
  
  if(true == get_new_filename(index_filename))
	printf("The full index filename is: %s\n", index_filename);
  else 
    return;
    
  printf("Initializing Database.\n");
  db = openDatabase(index_filename, true,false);
  if (db == NULL)
	panic("unable to open the database\n");
  db->the_word_memory_hashtable =
    init_word_memory_hashtable(65536L, 500000L, db->the_word_memory_hashtable);

  	SFGetFile(pos, (StringPtr)"\pFiles to Index:", 
			  NULL, -1, NULL, NULL, &macSFReply);
	if(macSFReply.good)
	{
		/* then we have a file.  In this version we index all the
		 * files in the volume of the selected file 
		 */
		 OSErr Error;
		 CInfoPBRec PBRec;
		 CInfoPBPtr PBPtr = &PBRec;
		 
		 char nm[50];
		 char dirname[500];

_profile = true;

		 strcpy(dirname, getwd(MAC_FILE_STYLE));
		 
		 /* set up the PBRec */
		 PBPtr->hFileInfo.ioVRefNum  = 0 - SFSaveDisk;
		 PBPtr->hFileInfo.ioDirID = CurDirStore;
		 PBPtr->hFileInfo.ioNamePtr = macSFReply.fName;
		 PBPtr->hFileInfo.ioCompletion = NULL;
		 PBPtr->hFileInfo.ioFDirIndex = 0; 
		 Error = PBGetCatInfo(PBPtr, FALSE); 
		 
		 PBPtr->hFileInfo.ioVRefNum  = 0 - SFSaveDisk;
		 PBPtr->hFileInfo.ioDirID = CurDirStore;
		 PBPtr->hFileInfo.ioFDirIndex = 1; 
		 PBPtr->hFileInfo.ioNamePtr = (StringPtr) nm;
		 while((Error = PBGetCatInfo(PBPtr, FALSE)) != fnfErr)
		 {
		 	/* loop until we are done with the volume */
		 	PBPtr->hFileInfo.ioVRefNum  = 0 - SFSaveDisk;
		 	PBPtr->hFileInfo.ioDirID = CurDirStore;
		 	PBPtr->hFileInfo.ioNamePtr = (StringPtr) nm;
		 	PBPtr->hFileInfo.ioCompletion = NULL;
			PBPtr->hFileInfo.ioFDirIndex++;
			/* to determine if a record is a directory do
			 * PBPtr->hFileInfo.ioFlAttrib & 0x10
			 */
			
			strcpy(filename, dirname);
			strcat(filename, ":");
			PtoCstr(nm);
			strcat(filename, nm);
			CtoPstr(nm);
			if(!(PBPtr->hFileInfo.ioFlAttrib & 0x10))
			{
				printf("Indexing File: %s...\n", filename);
				index_text_file(filename, &dataops, db,true, false);
			}
			else
				printf("Directory %s is not indexed\n", filename);
		 }
		 
_profile = false;

	}

	printf("Finished entering Files to be indexed.\n");
	printf("Now updating disk files\n");
 	finished_add_word(db);
  	closeDatabase(db);
	
	printf("Finished with the indexing. Exiting.\n");
	for(count = 0; count < 100000; count++)
	  ;  /* delay to show message */
	  
	gApplication->Exit();
}

/*----------------------------------------------------------------------*/
