/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class PSQLException
extends SQLException {
    private String message;
    static ResourceBundle bundle;

    public PSQLException(String string) {
        this.translate(string, null);
    }

    public PSQLException(String string, Exception exception) {
        Object[] objectArray = new Object[1];
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
            printWriter.println("Exception: " + exception.toString() + "\nStack Trace:\n");
            exception.printStackTrace(printWriter);
            printWriter.println("End of Stack Trace");
            printWriter.flush();
            objectArray[0] = byteArrayOutputStream.toString();
            printWriter.close();
            byteArrayOutputStream.close();
        }
        catch (Exception exception2) {
            objectArray[0] = String.valueOf(exception.toString()) + "\nIO Error on stack trace generation! " + exception2.toString();
        }
        this.translate(string, objectArray);
    }

    public PSQLException(String string, Object object) {
        Object[] objectArray = new Object[]{object};
        this.translate(string, objectArray);
    }

    public PSQLException(String string, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        this.translate(string, objectArray);
    }

    public PSQLException(String string, Object[] objectArray) {
        this.translate(string, objectArray);
    }

    public String getLocalizedMessage() {
        return this.message;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return this.message;
    }

    private void translate(String string, Object[] objectArray) {
        if (bundle == null) {
            try {
                bundle = ResourceBundle.getBundle("org.postgresql.errors");
            }
            catch (MissingResourceException missingResourceException) {
                this.message = string;
            }
        }
        if (bundle != null) {
            this.message = null;
            try {
                this.message = bundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                this.message = string;
            }
        }
        if (objectArray != null && this.message != null) {
            this.message = MessageFormat.format(this.message, objectArray);
        }
    }
}

