#############################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#  Jabber
#  Copyright (C) 1998-1999 The Jabber Team http://jabber.org/
#
##############################################################################

package CLI::Roster;

use strict;
use vars qw($VERSION);

use base qw(Jarl::Roster);


$VERSION = "0.1";

sub new {
  my $proto = shift;
  my $self = { };

  $self->{ROSTER} = {};

  bless($self, $proto);

  my (%args) = @_;

  $self->{varsOnlineOnly} = 0;

  $self->{varsUpdateMode} =
    $self->ParseArg(\%args,"-updatemode","roster");

  $self->DrawMode(1);

  return $self;
}


##############################################################################
#
# ParseArg - Helper function to extract the specified argument from the
#            function call.
#
##############################################################################
sub ParseArg {
  my $self = shift;
  my ($args,$arg,$default) = @_;
  return (exists($args->{$arg}) ? delete($args->{$arg}) : $default);
}


sub Draw {
  my $self = shift;

  return unless ($self->DrawMode() == 1);

  $main::TabBar->Print("="x($main::GUI{maxX}-1),"\n");
  $main::TabBar->Print("Roster:\n");

  foreach my $group ($self->GetGroups()) {
    next if ($group eq '__roster__:none');
    $self->DrawItem($self->CreateTag($group),"group",$group,0)
      unless (($self->{varsOnlineOnly} == 1) &&
              ($self->ActiveGroup($group) == 0));

    if ($self->{groups}->{$group}->{'__roster__:status'} == 1) {
      foreach my $jid (sort {uc($self->{jids}->{$a}->{name}) cmp uc($self->{jids}->{$b}->{name})} keys(%{$self->{groups}->{$group}})) {
	next if ($jid eq '__roster__:status');
	next if (($self->{varsOnlineOnly} == 1) && !defined($self->Resource($jid)));
	$self->DrawItem($self->CreateTag($group,$jid),"jid",$self->{jids}->{$jid}->{name},1);
	if ($self->{groups}->{$group}->{$jid} == 1) {
	  foreach my $resource (sort {$self->{resources}->{$jid}->{$b}->{priority} <=> $self->{resources}->{$jid}->{$a}->{priority}} keys(%{$self->{resources}->{$jid}})) {
	    $self->DrawItem($self->CreateTag($group,$jid,$resource),"resource",$resource,2);
	  }
	}
      }
    }
  }

  foreach my $jid (sort {uc($self->{jids}->{$a}->{name}) cmp uc($self->{jids}->{$b}->{name})} keys(%{$self->{groups}->{'__roster__:none'}})) {
    next if ($jid eq '__roster__:status');
    next if (($self->{varsOnlineOnly} == 1) && !defined($self->Resource($jid)));
    $self->DrawItem($self->CreateTag('__roster__:none',$jid),"jid",$self->{jids}->{$jid}->{name},0);
    if ($self->{jids}->{$jid}->{status} == 1) {
      foreach my $resource (sort {$self->{resources}->{$jid}->{$b}->{priority} <=> $self->{resources}->{$jid}->{$a}->{priority}} keys(%{$self->{resources}->{$jid}})) {
	$self->DrawItem($self->CreateTag('__roster__:none',$jid,$resource),"resource",$resource,1);
      }
    }
  }

  if (!defined($self->{varsSelectedTag})) {
    $self->{varsSelectedJID} = undef;
    $self->{varsSelectedTag} = undef;
  }

  $main::TabBar->Print("="x($main::GUI{maxX}-1),"\n");
}


sub DrawItem {
  my $self = shift;
  my ($tag,$type,$text,$indentLevel) = @_;

  my ($group) = ($tag =~ /group-([^(:::)]+)/);
  $group =~ s/\&bar;/\|/g;
  my ($jid) = ($tag =~ /jid-([^(:::)]+)/);
  $jid =~ s/\&bar;/\|/g;
  my ($resource) = ($tag =~ /res-([^(:::)]+)/);
  $resource =~ s/\&bar;/\|/g;

  my $icon;

  if ($type eq "group") {
    $icon = ($self->{groups}->{$group}->{'__roster__:status'} == 1) ? "-" : "+";
  }

  if ($type eq "resource") {
    $icon = "%Res";
  }

  if ($type eq "jid") {

    my $resource = $self->Resource($jid);

    if (defined($resource)) {
      my $presence =
        (($self->{resources}->{$jid}->{$resource}->{show} ne "") ?
	 $self->{resources}->{$jid}->{$resource}->{show} :
	 $self->{resources}->{$jid}->{$resource}->{type}
	);

      $icon = &main::jarlRosterIF_PresenceIcon($self,$presence,$jid);
    } else {
      $icon = &main::jarlRosterIF_PresenceIcon($self,"unavailable",$jid);
    }
  }

  my $balloon = "";
  $balloon = " - ".${$self->{balloons}->{$tag}}
    if exists($self->{balloons}->{$tag});
  $main::TabBar->Print(sprintf("  %s %s\n",$icon,$text)) if ($type eq "group");
  $main::TabBar->Print(sprintf("  %s%-6s %s\n","       "x$indentLevel,$icon,$text.$balloon)) if ($type ne "group");
}


##############################################################################
#
# RegisterGroup - stub for children to have code for when a group is added.
#
##############################################################################
sub RegisterGroup {
  my $self = shift;
  my ($group) = @_;
}


##############################################################################
#
# RegisterJID - stub for children to have code for when a JID is added.
#
##############################################################################
sub RegisterJID {
  my $self = shift;
  my ($group,$jid,$resource) = @_;

  my $tag = $self->CreateTag($group,$jid,$resource);

  $self->RegisterBalloon($tag,\$self->{jids}->{$jid}->{balloon});
}


1;
