##############################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#  Jabber
#  Copyright (C) 1998-1999 The Jabber Team http://jabber.org/
#
##############################################################################

package Jarl::Profile::FavGroup;

use strict;
use vars qw($VERSION);

$VERSION = "0.1";

sub new {
  my $proto = shift;
  my $self = { };

  bless($self, $proto);

  $self->{FAVGROUP} = {};

  return $self;
}


sub Name {
  my $self = shift;
  my ($name) = @_;
  $self->{FAVGROUP}->{name} = $name if defined($name);
  return $self->{FAVGROUP}->{name};
}

sub Channel {
  my $self = shift;
  my ($channel) = @_;
  $self->{FAVGROUP}->{channel} = $channel if defined($channel);
  return $self->{FAVGROUP}->{channel};
}

sub Server {
  my $self = shift;
  my ($server) = @_;
  $self->{FAVGROUP}->{server} = $server if defined($server);
  return $self->{FAVGROUP}->{server};
}

sub Nick1 {
  my $self = shift;
  my ($nick1) = @_;
  $self->{FAVGROUP}->{nick1} = $nick1 if defined($nick1);
  return $self->{FAVGROUP}->{nick1};
}

sub Nick2 {
  my $self = shift;
  my ($nick2) = @_;
  $self->{FAVGROUP}->{nick2} = $nick2 if defined($nick2);
  return $self->{FAVGROUP}->{nick2};
}


sub XML {
  my $self = shift;
  my $string;
  $string .= "<favgroup";
  $string .= " name='".&XML::Stream::EscapeXML($self->{FAVGROUP}->{name})."'";
  $string .= " channel='".&XML::Stream::EscapeXML($self->{FAVGROUP}->{channel})."'";
  $string .= " server='".&XML::Stream::EscapeXML($self->{FAVGROUP}->{server})."'";
  $string .= " nick1='".&XML::Stream::EscapeXML($self->{FAVGROUP}->{nick1})."'";
  $string .= " nick2='".&XML::Stream::EscapeXML($self->{FAVGROUP}->{nick2})."'";
  $string .= "/>";
  return $string;
}

1;
