##############################################################################
#
# Jarl - Auto-Update Tk Interface Code
#
#   Perl code to handle showing the Jarl Update GUI and interfacing with the
# available updates.
#
##############################################################################

##############################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#  Jabber
#  Copyright (C) 1998-1999 The Jabber Team http://jabber.org/
#
##############################################################################


##############################################################################
#
# jarlAutoUpdateIF_GUI - creates the Update GUI.
#
##############################################################################
sub jarlAutoUpdateIF_GUI {
  my ($query) = @_;

  $jabber{gotupdate} = 0;

  my %releases;
  my $mandatory = 0;

  foreach $release ($query->GetReleases()) {
    $mandatory = 1
      if (($release->GetTag() eq "release")  &&
	  ($release->GetPriority() eq "mandatory"));

  }

  my $instructions = "";

  $GUI{UpdateAvailable}->{window} = $GUI{top}->Toplevel();
  $GUI{UpdateAvailable}->{window}->title("Update Available...");
  $GUI{UpdateAvailable}->{window}->resizable(0,0);

  $GUI{UpdateAvailable}->{top} = 
    $GUI{UpdateAvailable}->{window}->
      Frame(-background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	   )->pack(-side=>"top",
		   -fill=>"y",
		   -padx=>$GUI{width}->{jarl}->{rosteritem}->{pad},
		   -pady=>$GUI{height}->{jarl}->{rosteritem}->{pad},
		   -expand=>1);

  if ($mandatory == 1) {
    $instructions = "There is a newer version of Jarl available.  ".
                    "This is a mandatory update.  We apologize for ".
	            "this requirement, but the newer version either ".
	            "fixes a bug, or matches a change in the protocol.\n\n".
	            "To FTP the file please choose a release from ".
	            "the list below and the appropriate file type ".
		    "that you wish to get:";
  } else {
    $instructions = "There is a newer version of Jarl available.  ".
	            "This is an optional update.  You can either ".
                    "FTP it now or later.\n\nTo get it later choose ".
                    "the \"Get New Version\" menu item from the ".
                    "Jarl menu.\n\nTo get the file now please choose ".
	            "the release that you want to from the list ".
                    "below and the appropriate file type ".
                    "from the list of files:";
  }

  $GUI{UpdateAvailable}->{Text}->{top} =
    $GUI{UpdateAvailable}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	   )->pack(-side=>"top",
		   -fill=>"both",
		   -expand=>1);
  $GUI{UpdateAvailable}->{Text}->{Label} =
    $GUI{UpdateAvailable}->{Text}->{top}->
      Label(-text=>$instructions,
	    -anchor=>"w",
	    -justify=>"left",
	    -wraplength=>250,
	    -font=>$GUI{fonts}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	    -background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal}
	   )->pack(-side=>"left",
		   -fill=>"y",
		   -anchor=>"w");

  $GUI{UpdateAvailable}->{Releases}->{top} =
    $GUI{UpdateAvailable}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	   )->pack(-side=>"top",
		   -fill=>"both",
		   -expand=>1);

  my $header = 1;
  foreach $releaseType ("release","beta","dev") {
    foreach my $release ($query->GetReleases()) {
      next if ($release->GetTag() ne $releaseType);

      if ($header == 1) {
	$header = 0;

	my $frame =
	  $GUI{UpdateAvailable}->{Releases}->{top}->
	    Frame(-background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
		  -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
		 )->pack(-side=>"top",
			 -fill=>"both",
			 -expand=>1);
	$frame->
	  Label(-text=>ucfirst($releaseType),
		-anchor=>"w",
		-font=>$GUI{fonts}->{header},
		-foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
		-background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal}
	   )->pack(-side=>"left",
		   -fill=>"y",
		   -anchor=>"w");
      }

      my $subFrame =
	$GUI{UpdateAvailable}->{Releases}->{top}->
	  Frame(-background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
		-foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	       )->pack(-side=>"top",
		       -fill=>"both",
		       -expand=>1);


      my $disk =
	$subFrame->
	  Label(-image=>$GUI{Icons}->{Disk},
		-cursor=>"hand2",
	       )->pack(-side=>"left",
		       -pady=>2,
		       -padx=>2);
      &jarlMainIF_RegisterIcon($disk,"Disk");

      my $file = $release->GetURL();
      $file =~ s/^.*\/([^\/]+)$/$1/;
      my $link =
	$subFrame->
	  Label(-text=>$file,
		-cursor=>"hand2",
		-anchor=>"w",
		-font=>$GUI{fonts}->{link},
		-background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
		-foreground=>$GUI{color}->{jarl}->{main}->{fg}->{link}
	       )->pack(-side=>"left",
		       -pady=>2,
		       -padx=>2);

      $disk->
	bind("<Button-1>",
	     sub {
	       &jarlFetchURL($release->GetURL());
	       &jarlAutoUpdateIF_CloseCB();
	       $jabber{gotupdate} = 1;
	     }
	    );
      $link->
	bind("<Button-3>",
	     sub {
	       &jarlFetchURL($release->GetURL());
	       &jarlAutoUpdateIF_CloseCB();
	       $jabber{gotupdate} = 1;
	     }
	    );
      $jabber{releaseURL} = $release->GetURL();
    }
  }

  if ($mandatory == 0) {
    $GUI{UpdateAvailable}->{Buttons}->{top} = 
      $GUI{UpdateAvailable}->{top}->
	Frame(-background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
	      -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	     )->pack(-side=>"top",
		     -fill=>"both",
		     -expand=>1);
    $GUI{UpdateAvailable}->{Buttons}->{No} =
      $GUI{UpdateAvailable}->{Buttons}->{top}->
	Button(-text=>"Later",
	       -width=>$GUI{width}->{jarl}->{rosteritem}->{button},
	       -background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
	       -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	       -disabledforeground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{light},
	       -font=>$GUI{fonts}->{normal},
	       -command=>sub{
		 $GUI{fileMenu}->{menu}->menu->
		   insert($GUI{fileMenu}->{menu}->menu->index("end"),
			  "command",
			  -label=>"Get New Version",
			  -font=>$GUI{fonts}->{normal},
			  -background=>$GUI{color}->{jarl}->{menu}->{background},
			  -foreground=>$GUI{color}->{jarl}->{menu}->{text},
			  -command=>sub{
			    &jarlFetchURL($jabber{releaseURL});
			    delete($jabber{releaseURL});
			    $GUI{fileMenu}->{menu}->menu->
			      delete($GUI{fileMenu}->{menu}->menu->index("end")-2,$GUI{fileMenu}->{menu}->menu->index("end")-1);
			  });
		 
		 $GUI{fileMenu}->{menu}->menu->
		   insert($GUI{fileMenu}->{menu}->menu->index("end"),
			  "separator",
			  -background=>$GUI{color}->{jarl}->{menu}->{background});
		 
		 &jarlAutoUpdateIF_CloseCB();
	       }
	      )->pack(-side=>"right",
		      -pady=>$GUI{height}->{jarl}->{rosteritem}->{pad},
		      -padx=>$GUI{width}->{jarl}->{rosteritem}->{pad});
  }
}


##############################################################################
#
# jarlAutoUpdateIF_CloseCB - close the Update GUI.
#
##############################################################################
sub jarlAutoUpdateIF_CloseCB {
  $GUI{UpdateAvailable}->{window}->destroy;
  delete($GUI{UpdateAvailable});
}


1;
