##############################################################################
#
# Jarl - Config Tk Interface Code
#
#   Perl code to handle showing the Jarl Config GUI and interfacing with the
# preferences.
#
##############################################################################

##############################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#  Jabber
#  Copyright (C) 1998-1999 The Jabber Team http://jabber.org/
#
##############################################################################


##############################################################################
#
# jarlConfigIF_GUI - creates the Config GUI.
#
##############################################################################
sub jarlConfigIF_GUI {
  $Debug->Log0("Start the Config");

  if (Exists($GUI{Config}->{window}) && $GUI{Config}->{window}->ismapped()) {
    $GUI{Config}->{window}->raise();
    return;
  }

  $GUI{Config}->{window} = $GUI{top}->Toplevel();
  $GUI{Config}->{window}->withdraw();
  $GUI{Config}->{window}->title("Config");
  $GUI{Config}->{window}->geometry("700x400");
  $GUI{Config}->{window}->resizable(0,0);

  $GUI{Config}->{top} =
    $GUI{Config}->{window}->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"top",
		   -fill=>"both",
		   -expand=>1);

  $GUI{Config}->{TabBar} =
    $GUI{Config}->{top}->
      TabBar(-background=>$GUI{color}->{jarl}->{config}->{bg}->{dark},
	     -tabthickness=>$GUI{width}->{jarl}->{config}->{tabs}->{thickness},
	     -tabfill=>$GUI{color}->{jarl}->{config}->{bg}->{light},
	     -tabbackground=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	     -tabforeground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	     -tabfont=>$GUI{fonts}->{normal},
	     -tabpadx=>$GUI{width}->{jarl}->{config}->{pad}*2,
	     -tabpady=>$GUI{height}->{jarl}->{config}->{pad}*2,
	    )->pack(-side=>'top',
		    -fill=>'x');

  $GUI{Config}->{System}->{top} = 
    $GUI{Config}->{TabBar}->AddTab(-tag=>"system",
                                   -text=>"System");

  $GUI{Config}->{Roster}->{top} = 
    $GUI{Config}->{TabBar}->AddTab(-tag=>"roster",
                                   -text=>"Roster");

#  $GUI{Config}->{Groupchat}->{top} = 
#    $GUI{Config}->{TabBar}->AddTab(-tag=>"groupchat",
#                                   -text=>"Groupchat");

#  $GUI{Config}->{Chat}->{top} = 
#    $GUI{Config}->{TabBar}->AddTab(-tag=>"chat",
#                                   -text=>"Chat");

  $GUI{Config}->{FavGroups}->{top} = 
    $GUI{Config}->{TabBar}->AddTab(-tag=>"favgroups",
                                   -text=>"Favorite Groups");

#  $GUI{Config}->{Syntax}->{top} = 
#    $GUI{Config}->{TabBar}->AddTab(-tag=>"syntax",
#                                   -text=>"Syntax Highlights");

  $GUI{Config}->{Fonts}->{top} = 
    $GUI{Config}->{TabBar}->AddTab(-tag=>"fonts",
				   -text=>"Fonts");

  $GUI{Config}->{WebBrowser}->{top} = 
    $GUI{Config}->{TabBar}->AddTab(-tag=>"webbrowser",
				   -text=>"Web Browser");

  $GUI{Config}->{GPG}->{top} = 
    $GUI{Config}->{TabBar}->AddTab(-tag=>"gpg",
                                   -text=>"GPG");


  #------------------------------------------------------------------------
  #
  # System Prefs
  #
  #------------------------------------------------------------------------
  $GUI{Config}->{System}->{Options}->{top} =
    $GUI{Config}->{System}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"left",
		   -fill=>"both",
		   -expand=>1);

  $GUI{Config}->{System}->{UnifiedPresence}->{top} =
    $GUI{Config}->{System}->{Options}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"top",
		   -fill=>"x",
		   -padx=>5);
  $GUI{Config}->{System}->{UnifiedPresence}->{Check} =
    $GUI{Config}->{System}->{UnifiedPresence}->{top}->
      Checkbutton(-background=>$GUI{color}->{bg}->{normal},
		  -activebackground=>$GUI{color}->{bg}->{normal},
		  -foreground=>$GUI{color}->{fg}->{dark},
		  -selectcolor=>$GUI{color}->{bg}->{normal},
		  -indicatoron=>0,
		  -borderwidth=>0,
		  -image=>$GUI{Icons}->{Unchecked},
		  -selectimage=>$GUI{Icons}->{Checked},
		  -variable=>\$config{unifiedpresence},
		  -state=>"disabled",
		 )->pack(-side=>'left',
			 -anchor=>'e',
			 -padx=>0,
			 -pady=>0);
  &jarlMainIF_RegisterIcon($GUI{Config}->{System}->{UnifiedPresence}->{Check},
			 ($config{unifiedpresence} ? "Checked" : "Unchecked"));
  $GUI{Config}->{System}->{UnifiedPresence}->{Label} = 
    $GUI{Config}->{System}->{UnifiedPresence}->{top}->
      Label(-text=>"Unified Presence",
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	   )->pack(-side=>'left',
		   -anchor=>'w');
  $GUI{Config}->{System}->{UnifiedPresence}->{Label}->
    bind("<Button-1>",sub{ $GUI{Config}->{System}->{UnifiedPresence}->{Check}->invoke(); });


  #------------------------------------------------------------------------
  #
  # Roster Prefs
  #
  #------------------------------------------------------------------------
  $GUI{Config}->{Roster}->{Left}->{top} =
    $GUI{Config}->{Roster}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"left",
		   -fill=>"y");
  $GUI{Config}->{Roster}->{Right}->{top} =
    $GUI{Config}->{Roster}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"left",
		   -fill=>"y");

  $GUI{Config}->{Roster}->{DoubleClick}->{top} =
    $GUI{Config}->{Roster}->{Left}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	    -relief=>"groove",
	    -borderwidth=>2
	   )->pack(-side=>"top",
		   -fill=>"x",
		   -padx=>2,
		   -pady=>2);
  $GUI{Config}->{Roster}->{DoubleClick}->{Label} =
    $GUI{Config}->{Roster}->{DoubleClick}->{top}->
      Label(-text=>"Roster Dbl-Click Behavior:",
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -anchor=>"w",
	    -justify=>"left",
	   )->pack(-side=>'top',
		   -fill=>"x",
		   -anchor=>'w');

  $GUI{Config}->{Roster}->{DoubleClickNormal}->{top} =
    $GUI{Config}->{Roster}->{DoubleClick}->{top}->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	   )->pack(-side=>'left',
		   -fill=>'x',
		   -expand=>1,
		   -padx=>5);
  $GUI{Config}->{Roster}->{DoubleClickNormal}->{Radio} =
    $GUI{Config}->{Roster}->{DoubleClickNormal}->{top}->
      Radiobutton(-value=>"normal",
		  -variable=>\$config{rosterdoubleclick},
		  -activebackground=>$GUI{color}->{bg}->{normal},
		  -background=>$GUI{color}->{bg}->{normal},
		  -foreground=>$GUI{color}->{fg}->{dark},
		  -font=>$GUI{fonts}->{normal},
		  -selectimage=>$GUI{Icons}->{RadioOn},
		  -image=>$GUI{Icons}->{RadioOff},
		  -indicatoron=>0,
		  -borderwidth=>0,
		  -selectcolor=>$GUI{color}->{bg}->{normal},
		 )->pack(-side=>'left',
			 -anchor=>'w');
  &jarlMainIF_RegisterIcon($GUI{Config}->{Roster}->{DoubleClickNormal}->{Radio},"RadioOff");
  $GUI{Config}->{Roster}->{DoubleClickNormal}->{Label} =
    $GUI{Config}->{Roster}->{DoubleClickNormal}->{top}->
      Label(-text=>"Normal",
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	   )->pack(-side=>'left',
		   -fill=>"x",
		   -anchor=>'w');
  $GUI{Config}->{Roster}->{DoubleClickNormal}->{Label}->
    bind("<Button-1>",sub{ $GUI{Config}->{Roster}->{DoubleClickNormal}->{Radio}->invoke(); });

  $GUI{Config}->{Roster}->{DoubleClickChat}->{top} =
    $GUI{Config}->{Roster}->{DoubleClick}->{top}->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	   )->pack(-side=>'right',
		   -fill=>'x',
		   -expand=>1,
		   -padx=>5);
  $GUI{Config}->{Roster}->{DoubleClickChat}->{Radio} =
    $GUI{Config}->{Roster}->{DoubleClickChat}->{top}->
      Radiobutton(-value=>"chat",
		  -variable=>\$config{rosterdoubleclick},
		  -activebackground=>$GUI{color}->{bg}->{normal},
		  -background=>$GUI{color}->{bg}->{normal},
		  -foreground=>$GUI{color}->{fg}->{dark},
		  -font=>$GUI{fonts}->{normal},
		  -selectimage=>$GUI{Icons}->{RadioOn},
		  -image=>$GUI{Icons}->{RadioOff},
		  -indicatoron=>0,
		  -borderwidth=>0,
		  -selectcolor=>$GUI{color}->{bg}->{normal},
		 )->pack(-side=>'left',
			 -anchor=>'w');
  &jarlMainIF_RegisterIcon($GUI{Config}->{Roster}->{DoubleClickChat}->{Radio},"RadioOff");
  $GUI{Config}->{Roster}->{DoubleClickChat}->{Label} =
    $GUI{Config}->{Roster}->{DoubleClickChat}->{top}->
      Label(-text=>"Chat",
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	   )->pack(-side=>'left',
		   -fill=>"x",
		   -anchor=>'w');
  $GUI{Config}->{Roster}->{DoubleClickChat}->{Label}->
    bind("<Button-1>",sub{ $GUI{Config}->{Roster}->{DoubleClickChat}->{Radio}->invoke(); });


  $GUI{Config}->{Roster}->{Subscriptions}->{top} =
    $GUI{Config}->{Roster}->{Left}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	    -relief=>"groove",
	    -borderwidth=>2
	   )->pack(-side=>"top",
		   -fill=>"x",
		   -pady=>2,
		   -padx=>2);

  $GUI{Config}->{Roster}->{SubscriptionPrompt}->{top} =
    $GUI{Config}->{Roster}->{Subscriptions}->{top}->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'x',
		   -padx=>5);
  $GUI{Config}->{Roster}->{SubscriptionPrompt}->{Radio} =
    $GUI{Config}->{Roster}->{SubscriptionPrompt}->{top}->
      Radiobutton(-value=>"prompt",
		  -variable=>\$config{subscriptions},
		  -activebackground=>$GUI{color}->{bg}->{normal},
		  -background=>$GUI{color}->{bg}->{normal},
		  -foreground=>$GUI{color}->{fg}->{dark},
		  -font=>$GUI{fonts}->{normal},
		  -selectimage=>$GUI{Icons}->{RadioOn},
		  -image=>$GUI{Icons}->{RadioOff},
		  -indicatoron=>0,
		  -borderwidth=>0,
		  -selectcolor=>$GUI{color}->{bg}->{normal},
		 )->pack(-side=>'left',
			 -anchor=>'w');
  &jarlMainIF_RegisterIcon($GUI{Config}->{Roster}->{SubscriptionPrompt}->{Radio},"RadioOff");
  $GUI{Config}->{Roster}->{SubscriptionPrompt}->{Label} =
    $GUI{Config}->{Roster}->{SubscriptionPrompt}->{top}->
      Label(-text=>"Prompt me for all Subscription requests",
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	   )->pack(-side=>'left',
		   -anchor=>'w');
  $GUI{Config}->{Roster}->{SubscriptionPrompt}->{Label}->
    bind("<Button-1>",sub{ $GUI{Config}->{Roster}->{SubscriptionPrompt}->{Radio}->invoke(); });

  $GUI{Config}->{Roster}->{SubscriptionRoster}->{top} =
    $GUI{Config}->{Roster}->{Subscriptions}->{top}->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'x',
		   -padx=>5);
  $GUI{Config}->{Roster}->{SubscriptionRoster}->{Radio} =
    $GUI{Config}->{Roster}->{SubscriptionRoster}->{top}->
      Radiobutton(-value=>"roster",
		  -variable=>\$config{subscriptions},
		  -activebackground=>$GUI{color}->{bg}->{normal},
		  -background=>$GUI{color}->{bg}->{normal},
		  -foreground=>$GUI{color}->{fg}->{dark},
		  -font=>$GUI{fonts}->{normal},
		  -selectimage=>$GUI{Icons}->{RadioOn},
		  -image=>$GUI{Icons}->{RadioOff},
		  -indicatoron=>0,
		  -borderwidth=>0,
		  -selectcolor=>$GUI{color}->{bg}->{normal},
		 )->pack(-side=>'left',
			 -anchor=>'w');
  &jarlMainIF_RegisterIcon($GUI{Config}->{Roster}->{SubscriptionRoster}->{Radio},"RadioOff");
  $GUI{Config}->{Roster}->{SubscriptionRoster}->{Label} =
    $GUI{Config}->{Roster}->{SubscriptionRoster}->{top}->
      Label(-text=>"Accept Requests from people in my Roster",
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	   )->pack(-side=>'left',
		   -anchor=>'w');
  $GUI{Config}->{Roster}->{SubscriptionRoster}->{Label}->
    bind("<Button-1>",sub{ $GUI{Config}->{Roster}->{SubscriptionRoster}->{Radio}->invoke(); });

  $GUI{Config}->{Roster}->{SubscriptionAll}->{top} =
    $GUI{Config}->{Roster}->{Subscriptions}->{top}->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'x',
		   -padx=>5);
  $GUI{Config}->{Roster}->{SubscriptionAll}->{Radio} =
    $GUI{Config}->{Roster}->{SubscriptionAll}->{top}->
      Radiobutton(-value=>"all",
		  -variable=>\$config{subscriptions},
		  -activebackground=>$GUI{color}->{bg}->{normal},
		  -background=>$GUI{color}->{bg}->{normal},
		  -foreground=>$GUI{color}->{fg}->{dark},
		  -font=>$GUI{fonts}->{normal},
		  -selectimage=>$GUI{Icons}->{RadioOn},
		  -image=>$GUI{Icons}->{RadioOff},
		  -indicatoron=>0,
		  -borderwidth=>0,
		  -selectcolor=>$GUI{color}->{bg}->{normal},
		 )->pack(-side=>'left',
			 -anchor=>'w');
  &jarlMainIF_RegisterIcon($GUI{Config}->{Roster}->{SubscriptionAll}->{Radio},"RadioOff");
  $GUI{Config}->{Roster}->{SubscriptionAll}->{Label} =
    $GUI{Config}->{Roster}->{SubscriptionAll}->{top}->
      Label(-text=>"Accept All Requests",
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	   )->pack(-side=>'left',
		   -anchor=>'w');
  $GUI{Config}->{Roster}->{SubscriptionAll}->{Label}->
    bind("<Button-1>",sub{ $GUI{Config}->{Roster}->{SubscriptionAll}->{Radio}->invoke(); });

  $GUI{Config}->{Roster}->{SubscriptionDenyNotRoster}->{top} =
    $GUI{Config}->{Roster}->{Left}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"top",
		   -fill=>"x",
		   -padx=>5);
  $GUI{Config}->{Roster}->{SubscriptionDenyNotRoster}->{Check} =
    $GUI{Config}->{Roster}->{SubscriptionDenyNotRoster}->{top}->
      Checkbutton(-background=>$GUI{color}->{bg}->{normal},
		  -activebackground=>$GUI{color}->{bg}->{normal},
		  -foreground=>$GUI{color}->{fg}->{dark},
		  -selectcolor=>$GUI{color}->{bg}->{normal},
		  -indicatoron=>0,
		  -borderwidth=>0,
		  -image=>$GUI{Icons}->{Unchecked},
		  -selectimage=>$GUI{Icons}->{Checked},
		  -variable=>\$config{subscriptiondeny},
		  -command=>sub{
		    if ($config{subscriptiondeny} == 1) {
		      $GUI{Config}->{Roster}->{SubscriptionDenyMessage}->{Entry}->
			configure(-state=>"normal",
				  -background=>$GUI{color}->{jarl}->{config}->{bg}->{light},
				 );
		    } else {
		      $GUI{Config}->{Roster}->{SubscriptionDenyMessage}->{Entry}->
			configure(-state=>"disabled",
				  -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
				 );
		    }
		  }
		 )->pack(-side=>'left',
			 -anchor=>'e',
			 -padx=>0,
			 -pady=>0);
  &jarlMainIF_RegisterIcon($GUI{Config}->{Roster}->{SubscriptionDenyNotRoster}->{Check},
			 ($config{subscriptiondeny} ? "Checked" : "Unchecked"));
  $GUI{Config}->{Roster}->{SubscriptionDenyNotRoster}->{Label} = 
    $GUI{Config}->{Roster}->{SubscriptionDenyNotRoster}->{top}->
      Label(-text=>"Deny Subscription requests for people not in my Roster",
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	   )->pack(-side=>'left',
		   -anchor=>'w');
  $GUI{Config}->{Roster}->{SubscriptionDenyNotRoster}->{Label}->
    bind("<Button-1>",sub{ $GUI{Config}->{Roster}->{SubscriptionDenyNotRoster}->{Check}->invoke(); });

  $GUI{Config}->{Roster}->{SubscriptionDenyMessage}->{top} =
    $GUI{Config}->{Roster}->{Left}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"top",
		   -fill=>"x",
		   -padx=>5);
  $GUI{Config}->{Roster}->{SubscriptionDenyMessage}->{Label} = 
    $GUI{Config}->{Roster}->{SubscriptionDenyMessage}->{top}->
      Label(-text=>"Deny Message:",
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	   )->pack(-side=>'left',
		   -anchor=>'w');
  $GUI{Config}->{Roster}->{SubscriptionDenyMessage}->{Entry} = 
    $GUI{Config}->{Roster}->{SubscriptionDenyMessage}->{top}->
      Entry(-textvariable=>\$config{subscriptiondenymessage},
	    -width=>$GUI{width}->{jarl}->{config}->{entry},
	    -background=>(($config{subscriptiondeny} == 1) ? $GUI{color}->{jarl}->{config}->{bg}->{light} : $GUI{color}->{jarl}->{config}->{bg}->{normal}),
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -state=>(($config{subscriptiondeny} == 1) ? "normal" : "disabled"),
	   )->pack(-side=>'left',
		   -anchor=>'w');
  
  $GUI{Config}->{Roster}->{SubscribeAuto}->{top} =
    $GUI{Config}->{Roster}->{Left}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"top",
		   -fill=>"x",
		   -padx=>5);
  $GUI{Config}->{Roster}->{SubscribeAuto}->{Check} =
    $GUI{Config}->{Roster}->{SubscribeAuto}->{top}->
      Checkbutton(-background=>$GUI{color}->{bg}->{normal},
		  -activebackground=>$GUI{color}->{bg}->{normal},
		  -foreground=>$GUI{color}->{fg}->{dark},
		  -selectcolor=>$GUI{color}->{bg}->{normal},
		  -indicatoron=>0,
		  -borderwidth=>0,
		  -image=>$GUI{Icons}->{Unchecked},
		  -selectimage=>$GUI{Icons}->{Checked},
		  -variable=>\$config{subscribe},
		 )->pack(-side=>'left',
			 -anchor=>'e',
			 -padx=>0,
			 -pady=>0);
  &jarlMainIF_RegisterIcon($GUI{Config}->{Roster}->{SubscribeAuto}->{Check},
			 ($config{subscribe} ? "Checked" : "Unchecked"));
  $GUI{Config}->{Roster}->{SubscribeAuto}->{Label} = 
    $GUI{Config}->{Roster}->{SubscribeAuto}->{top}->
      Label(-text=>"Automatically Subscribe to Subscribers to me",
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	   )->pack(-side=>'left',
		   -anchor=>'w');
  $GUI{Config}->{Roster}->{SubscribeAuto}->{Label}->
    bind("<Button-1>",sub{ $GUI{Config}->{Roster}->{SubscribeAuto}->{Check}->invoke(); });




  #------------------------------------------------------------------------
  #
  # Favorite Gorups
  #
  #------------------------------------------------------------------------
  $GUI{Config}->{FavGroups}->{List}->{top} =
    $GUI{Config}->{FavGroups}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"left",
		   -fill=>"both",
		   -expand=>1);
  $GUI{Config}->{FavGroups}->{List}->{MulColListbox} =
    $GUI{Config}->{FavGroups}->{List}->{top}->
      MulColListbox(-headerbackground=>$GUI{color}->{bg}->{normal},
		    -headerforeground=>$GUI{color}->{fg}->{dark},
		    -headerborderwidth=>1,
		    -background=>$GUI{color}->{bg}->{light},
		    -foreground=>$GUI{color}->{fg}->{dark},
		    -relief=>"sunken",
		    -borderwidth=>2,
		    -height=>0,
		    -width=>0,
		    -sortby=>"name",
		    -font=>$GUI{fonts}->{normal},
		    -selectbackground=>$GUI{color}->{bg}->{list},
		    -selectforeground=>$GUI{color}->{fg}->{list},
		    -scrollbarborderwidth=>1,
		    -scrollbarrelief=>"flat",
		   )->pack(-side=>"top",
			   -fill=>"both",
			   -expand=>1,
			   -padx=>5,
			   -pady=>5);

  $GUI{Config}->{FavGroups}->{List}->{MulColListbox}->
    AddColumn(-header=>"Name",
	      -key=>"name");
  $GUI{Config}->{FavGroups}->{List}->{MulColListbox}->
    AddColumn(-header=>"Channel",
	      -key=>"channel");
  $GUI{Config}->{FavGroups}->{List}->{MulColListbox}->
    AddColumn(-header=>"Server",
	      -key=>"server");
  $GUI{Config}->{FavGroups}->{List}->{MulColListbox}->
    AddColumn(-header=>"Nick1",
	      -key=>"nick1");
#  $GUI{Config}->{FavGroups}->{List}->{MulColListbox}->
#    AddColumn(-header=>"Nick2",
#	      -key=>"nick2");

  &jarlConfigIF_PopulateFavGroupList();

  $GUI{Config}->{FavGroups}->{Buttons}->{top} =
    $GUI{Config}->{FavGroups}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"right",
		   -fill=>"y");
  $GUI{Config}->{FavGroups}->{Buttons}->{Add} =
    $GUI{Config}->{FavGroups}->{Buttons}->{top}->
      Button(-text=>"Add",
	     -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	     -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{jarl}->{config}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -width=>6,
	     -command=>sub{
	       &jarlConfigIF_EditFavGroupGUI("");
	     }
	    )->pack(-side=>"top",
		    -padx=>$GUI{width}->{jarl}->{config}->{pad});
  $GUI{Config}->{FavGroups}->{Buttons}->{Edit} =
    $GUI{Config}->{FavGroups}->{Buttons}->{top}->
      Button(-text=>"Edit",
	     -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	     -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{jarl}->{config}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -width=>6,
	     -command=>sub{
	       return if ($GUI{Config}->{FavGroups}->{List}->{MulColListbox}->curselection eq "");
	       &jarlConfigIF_EditFavGroupGUI($GUI{Config}->{FavGroups}->{List}->{MulColListbox}->get("name",$GUI{Config}->{FavGroups}->{List}->{MulColListbox}->curselection()));
	     }
	    )->pack(-side=>"top",
		    -padx=>$GUI{width}->{jarl}->{config}->{pad});
  $GUI{Config}->{FavGroups}->{Buttons}->{Delete} =
    $GUI{Config}->{FavGroups}->{Buttons}->{top}->
      Button(-text=>"Delete",
	     -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	     -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{jarl}->{config}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -width=>6,
	     -command=>sub{
	       return if ($GUI{Jabber}->{MessageList}->{MulColListbox}->curselection eq "");
	       $GUI{Config}->{FavGroups}->{List}->{MulColListbox}->
		 delete($GUI{Config}->{FavGroups}->{List}->{MulColListbox}->curselection);
	     }
	    )->pack(-side=>"top",
		    -padx=>$GUI{width}->{jarl}->{config}->{pad});



  

  #------------------------------------------------------------------------
  #
  # Web Browser
  #
  #------------------------------------------------------------------------
  $GUI{Config}->{WebBrowser}->{Description}->{top} =
    $GUI{Config}->{WebBrowser}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"top",
		   -fill=>"both",
		   -expand=>1,
		   -padx=>5);
  $GUI{Config}->{WebBrowser}->{Description}->{Label} =
    $GUI{Config}->{WebBrowser}->{Description}->{top}->
      Label(-text=>"Enter the shell command string to launch your web ".
	    "browser of choice.  When you get the part where you enter ".
	    "the URL, put %URL% in the string so that Jarl knows where ".
	    "to plug the URL in.\n\nFor example: \"netscape %URL%\".",
	    -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -wraplength=>400,
	    -justify=>"left",
	   )->pack(-side=>'left',
		   -anchor=>'e');
	    
  $GUI{Config}->{WebBrowser}->{Command}->{top} =
    $GUI{Config}->{WebBrowser}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"top",
		   -fill=>"both",
		   -padx=>5,
		   -pady=>5,
		   -expand=>1);
  $GUI{Config}->{WebBrowser}->{Command}->{Label} =
    $GUI{Config}->{WebBrowser}->{Command}->{top}->
      Label(-text=>"Command:",
	    -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -width=>$GUI{width}->{jarl}->{config}->{label},
	    -anchor=>"e"
	   )->pack(-side=>'left',
		   -anchor=>'e');
  $GUI{Config}->{WebBrowser}->{Command}->{Entry} =
    $GUI{Config}->{WebBrowser}->{Command}->{top}->
      Entry(-textvariable=>\$config{webbrowser}->{command},
	    -width=>$GUI{width}->{jarl}->{config}->{entry},
	    -background=>$GUI{color}->{jarl}->{config}->{bg}->{light},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	   )->pack(-side=>'left',
		   -anchor=>'w');

  #------------------------------------------------------------------------
  #
  # Fonts
  #
  #------------------------------------------------------------------------
  $GUI{Config}->{Fonts}->{vars}->{family} = $config{font}->{family};
  $GUI{Config}->{Fonts}->{vars}->{size} = $config{font}->{size};

  $GUI{Config}->{Fonts}->{Controls}->{top} =
    $GUI{Config}->{Fonts}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"left",
		   -fill=>"y",
		   -padx=>5,
		   -pady=>2);

  $GUI{Config}->{Fonts}->{Families}->{top} =
    $GUI{Config}->{Fonts}->{Controls}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"top",
		   -fill=>"x",
		   -padx=>5,
		   -pady=>5);
  $GUI{Config}->{Fonts}->{Families}->{Label} =
    $GUI{Config}->{Fonts}->{Families}->{top}->
      Label(-text=>"Font:",
	    -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -width=>5,
	    -anchor=>"e"
	   )->pack(-side=>'left',
		   -anchor=>'e');
  $GUI{Config}->{Fonts}->{Families}->{Option} =
    $GUI{Config}->{Fonts}->{Families}->{top}->
      Optionmenu(-options=>[
			    "arial",
			    "courier",
			    "helvetica",
			    "lucida",
			    "times"
			   ],
		 -textvariable=>\$GUI{Config}->{Fonts}->{vars}->{family},
		 -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
		 -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
		 -font=>$GUI{fonts}->{normal},
		 -command=>sub{
		   $GUI{fonts}->{testnormal}->
		     configure(-family=>$GUI{Config}->{Fonts}->{vars}->{family});
		   $GUI{fonts}->{testheader}->
		     configure(-family=>$GUI{Config}->{Fonts}->{vars}->{family});
		   $GUI{fonts}->{testlink}->
		     configure(-family=>$GUI{Config}->{Fonts}->{vars}->{family});
		 }
		)->pack(-side=>'left',
			-anchor=>'w');

  $GUI{Config}->{Fonts}->{Size}->{top} =
    $GUI{Config}->{Fonts}->{Controls}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"top",
		   -fill=>"x",
		   -padx=>5,
		   -pady=>5);
  $GUI{Config}->{Fonts}->{Size}->{Label} =
    $GUI{Config}->{Fonts}->{Size}->{top}->
      Label(-text=>"Size:",
	    -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -width=>5,
	    -anchor=>"e"
	   )->pack(-side=>'left',
		   -anchor=>'e');
  $GUI{Config}->{Fonts}->{Size}->{Option} =
    $GUI{Config}->{Fonts}->{Size}->{top}->
      Optionmenu(-options=>[
			    8,
			    10,
			    12,
			    14,
			    16,
			    18,
			    20
			   ],
		 -textvariable=>\$GUI{Config}->{Fonts}->{vars}->{size},
		 -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
		 -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
		 -font=>$GUI{fonts}->{normal},
		 -command=>sub{
		   $GUI{fonts}->{testnormal}->
		     configure(-size=>$GUI{Config}->{Fonts}->{vars}->{size});
		   $GUI{fonts}->{testheader}->
		     configure(-size=>$GUI{Config}->{Fonts}->{vars}->{size});
		   $GUI{fonts}->{testlink}->
		     configure(-size=>$GUI{Config}->{Fonts}->{vars}->{size});
		 }
		)->pack(-side=>'left',
			-anchor=>'w');

  $GUI{Config}->{Fonts}->{Apply}->{top} =
    $GUI{Config}->{Fonts}->{Controls}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"top",
		   -fill=>"x",
		   -pady=>$GUI{height}->{jarl}->{config}->{pad});
  $GUI{Config}->{Fonts}->{Apply}->{Label} =
    $GUI{Config}->{Fonts}->{Apply}->{top}->
      Label(-text=>"",
	    -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -width=>5,
	    -anchor=>"e"
	   )->pack(-side=>'left',
		   -anchor=>'e');
  $GUI{Config}->{Fonts}->{Apply}->{Button} =
    $GUI{Config}->{Fonts}->{Apply}->{top}->
      Button(-text=>"Apply Font",
	     -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	     -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{jarl}->{config}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{
	       $GUI{fonts}->{normal}->
		 configure(-family=>$GUI{Config}->{Fonts}->{vars}->{family},
			   -size=>$GUI{Config}->{Fonts}->{vars}->{size});
	       $GUI{fonts}->{header}->
		 configure(-family=>$GUI{Config}->{Fonts}->{vars}->{family},
			   -size=>$GUI{Config}->{Fonts}->{vars}->{size});
	       $GUI{fonts}->{link}->
		 configure(-family=>$GUI{Config}->{Fonts}->{vars}->{family},
			   -size=>$GUI{Config}->{Fonts}->{vars}->{size});

	       $config{font}->{family} =
		 $GUI{Config}->{Fonts}->{vars}->{family};
	       $config{font}->{size} =
		 $GUI{Config}->{Fonts}->{vars}->{size};
	       
	       &jarlMainIF_UpdateFontChange();
	     }
	    )->pack(-side=>"left",
		    -padx=>$GUI{width}->{jarl}->{config}->{pad});
  

  $GUI{Config}->{Fonts}->{Examples}->{top} =
    $GUI{Config}->{Fonts}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	    -borderwidth=>2,
	    -relief=>"groove",
	   )->pack(-side=>"left",
		   -padx=>5,
		   -pady=>2);

  $GUI{Config}->{Fonts}->{Example}->{Normal}->{top} =
    $GUI{Config}->{Fonts}->{Examples}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"top",
		   -fill=>"both",
		   -padx=>5,
		   -pady=>2);
  $GUI{Config}->{Fonts}->{Example}->{Normal}->{Label} =
    $GUI{Config}->{Fonts}->{Example}->{Normal}->{top}->
      Label(-text=>"Normal:",
	    -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -width=>8,
	    -anchor=>"e"
	   )->pack(-side=>'left',
		   -anchor=>'e');
  $GUI{Config}->{Fonts}->{Example}->{Normal}->{Label2} =
    $GUI{Config}->{Fonts}->{Example}->{Normal}->{top}->
      Label(-text=>"Jabber rocks!",
	    -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	    -font=>$GUI{fonts}->{testnormal},
	   )->pack(-side=>'left',
		   -anchor=>'e');
  
  $GUI{Config}->{Fonts}->{Example}->{Header}->{top} =
    $GUI{Config}->{Fonts}->{Examples}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"top",
		   -fill=>"both",
		   -padx=>5,
		   -pady=>2);
  $GUI{Config}->{Fonts}->{Example}->{Header}->{Label} =
    $GUI{Config}->{Fonts}->{Example}->{Header}->{top}->
      Label(-text=>"Header:",
	    -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -width=>8,
	    -anchor=>"e"
	   )->pack(-side=>'left',
		   -anchor=>'e');
  $GUI{Config}->{Fonts}->{Example}->{Header}->{Label2} =
    $GUI{Config}->{Fonts}->{Example}->{Header}->{top}->
      Label(-text=>"Message List",
	    -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	    -font=>$GUI{fonts}->{testheader},
	   )->pack(-side=>'left',
		   -anchor=>'e');
  
  $GUI{Config}->{Fonts}->{Example}->{Link}->{top} =
    $GUI{Config}->{Fonts}->{Examples}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"top",
		   -fill=>"both",
		   -padx=>5,
		   -pady=>2);
  $GUI{Config}->{Fonts}->{Example}->{Link}->{Label} =
    $GUI{Config}->{Fonts}->{Example}->{Link}->{top}->
      Label(-text=>"Link:",
	    -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -width=>8,
	    -anchor=>"e"
	   )->pack(-side=>'left',
		   -anchor=>'e');
  $GUI{Config}->{Fonts}->{Example}->{Link}->{Label2} =
    $GUI{Config}->{Fonts}->{Example}->{Link}->{top}->
      Label(-text=>"http://www.foo.bar",
	    -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{link},
	    -font=>$GUI{fonts}->{testlink},
	   )->pack(-side=>'left',
		   -anchor=>'e');
  

  #------------------------------------------------------------------------
  #
  # GPG Prefs
  #
  #------------------------------------------------------------------------
  $GUI{Config}->{GPG}->{Left}->{top} =
    $GUI{Config}->{GPG}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"left",
		   -fill=>"y");
  $GUI{Config}->{GPG}->{Right}->{top} =
    $GUI{Config}->{GPG}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"left",
		   -fill=>"y");

  $GUI{Config}->{GPG}->{UseGPG}->{top} =
    $GUI{Config}->{GPG}->{Left}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"top",
		   -fill=>"x",
		   -padx=>5);

  $GUI{Config}->{GPG}->{UseGPG}->{Check} =
    $GUI{Config}->{GPG}->{UseGPG}->{top}->
      Checkbutton(-background=>$GUI{color}->{bg}->{normal},
		  -activebackground=>$GUI{color}->{bg}->{normal},
		  -foreground=>$GUI{color}->{fg}->{dark},
		  -selectcolor=>$GUI{color}->{bg}->{normal},
		  -indicatoron=>0,
		  -state=>(($options{gpg} == 1) ? "normal" : "disabled"),
		  -borderwidth=>0,
		  -image=>$GUI{Icons}->{Unchecked},
		  -selectimage=>$GUI{Icons}->{Checked},
		  -variable=>\$config{gpg}->{active},
		  -command=>sub{
		    $jabber{presence}->PresenceSend();
		    if ($config{gpg}->{active} == 1) {
		      $GUI{Config}->{GPG}->{GPGChat}->{Check}->
			configure(-state=>"normal");
		      $GUI{Config}->{GPG}->{GPGNormal}->{Check}->
			configure(-state=>"normal");
		      $GUI{Config}->{GPG}->{AutoFetchTrust}->{Check}->
			configure(-state=>"normal");
		      if ($config{gpg}->{autofetchtrust} == 1) {
			$GUI{Config}->{GPG}->{TrustMarginal}->{Radio}->
			  configure(-state=>"normal");
			$GUI{Config}->{GPG}->{TrustFully}->{Radio}->
			  configure(-state=>"normal");
			$GUI{Config}->{GPG}->{KeyServer}->{Entry}->
			  configure(-state=>"normal",
				    -background=>$GUI{color}->{jarl}->{config}->{bg}->{light},
				   );
		      }

#		      foreach my $jid (keys(%normal)) {
#			&jarlNormal_SecureMessage($jid);
#		      }
		      foreach my $jid (keys(%{$chat{jids}})) {
			&jarlChat_SecureChat($jid);
		      }
		    } else {
		      $GUI{Config}->{GPG}->{GPGChat}->{Check}->
			configure(-state=>"disabled");
		      $GUI{Config}->{GPG}->{GPGNormal}->{Check}->
			configure(-state=>"disabled");
		      $GUI{Config}->{GPG}->{AutoFetchTrust}->{Check}->
			configure(-state=>"disabled");
		      $GUI{Config}->{GPG}->{TrustMarginal}->{Radio}->
			configure(-state=>"disabled");
		      $GUI{Config}->{GPG}->{TrustFully}->{Radio}->
			configure(-state=>"disabled");
		      $GUI{Config}->{GPG}->{KeyServer}->{Entry}->
			configure(-state=>"disabled",
				  -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
				 );
#		      foreach my $jid (keys(%normal)) {
#			&jarlNormal_UnsecureMessage($jid);
#		      }
		      foreach my $jid (keys(%chat)) {
			&jarlChat_UnsecureChat($jid);
		      }
		    }
		  }
		 )->pack(-side=>'left',
			 -anchor=>'e',
			 -padx=>0,
			 -pady=>0);
  &jarlMainIF_RegisterIcon($GUI{Config}->{GPG}->{UseGPG}->{Check},
			 ($config{gpg}->{active} ? "Checked" : "Unchecked"));
  $GUI{Config}->{GPG}->{UseGPG}->{Label} = 
    $GUI{Config}->{GPG}->{UseGPG}->{top}->
      Label(-text=>"Enable GPG Support",
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	   )->pack(-side=>'left',
		   -anchor=>'w');
  $GUI{Config}->{GPG}->{UseGPG}->{Label}->
    bind("<Button-1>",sub{ $GUI{Config}->{GPG}->{UseGPG}->{Check}->invoke(); });

  $GUI{Config}->{GPG}->{GPGEncryptWhen}->{top} =
    $GUI{Config}->{GPG}->{Left}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"top",
		   -fill=>"x",
		   -padx=>5);
  $GUI{Config}->{GPG}->{GPGEncryptWhen}->{Label} = 
    $GUI{Config}->{GPG}->{GPGEncryptWhen}->{top}->
      Label(-text=>"Encrypt by Default:",
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	   )->pack(-side=>'left',
		   -anchor=>'w');

  $GUI{Config}->{GPG}->{GPGChat}->{top} =
    $GUI{Config}->{GPG}->{Left}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"top",
		   -fill=>"x",
		   -padx=>5);
  $GUI{Config}->{GPG}->{GPGChat}->{Label} = 
    $GUI{Config}->{GPG}->{GPGChat}->{top}->
      Label(-text=>"",
	    -width=>2,
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	   )->pack(-side=>'left',
		   -anchor=>'w');
  $GUI{Config}->{GPG}->{GPGChat}->{Check} =
    $GUI{Config}->{GPG}->{GPGChat}->{top}->
      Checkbutton(-background=>$GUI{color}->{bg}->{normal},
		  -activebackground=>$GUI{color}->{bg}->{normal},
		  -foreground=>$GUI{color}->{fg}->{dark},
		  -selectcolor=>$GUI{color}->{bg}->{normal},
		  -indicatoron=>0,
		  -borderwidth=>0,
		  -image=>$GUI{Icons}->{Unchecked},
		  -selectimage=>$GUI{Icons}->{Checked},
		  -variable=>\$config{gpg}->{chat},
		  -state=>(($config{gpg}->{active} == 1) ? "normal" : "disabled"),
		 )->pack(-side=>'left',
			 -anchor=>'e',
			 -padx=>0,
			 -pady=>0);
  &jarlMainIF_RegisterIcon($GUI{Config}->{GPG}->{GPGChat}->{Check},
			 ($config{gpg}->{chat} ? "Checked" : "Unchecked"));
  $GUI{Config}->{GPG}->{GPGChat}->{Label} = 
    $GUI{Config}->{GPG}->{GPGChat}->{top}->
      Label(-text=>"Chat Messages",
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	   )->pack(-side=>'left',
		   -anchor=>'w');
  $GUI{Config}->{GPG}->{GPGChat}->{Label}->
    bind("<Button-1>",sub{ $GUI{Config}->{GPG}->{GPGChat}->{Check}->invoke(); });


  $GUI{Config}->{GPG}->{GPGNormal}->{top} =
    $GUI{Config}->{GPG}->{Left}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"top",
		   -fill=>"x",
		   -padx=>5);
  $GUI{Config}->{GPG}->{GPGNormal}->{Label} = 
    $GUI{Config}->{GPG}->{GPGNormal}->{top}->
      Label(-text=>"",
	    -width=>2,
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	   )->pack(-side=>'left',
		   -anchor=>'w');
  $GUI{Config}->{GPG}->{GPGNormal}->{Check} =
    $GUI{Config}->{GPG}->{GPGNormal}->{top}->
      Checkbutton(-background=>$GUI{color}->{bg}->{normal},
		  -activebackground=>$GUI{color}->{bg}->{normal},
		  -foreground=>$GUI{color}->{fg}->{dark},
		  -selectcolor=>$GUI{color}->{bg}->{normal},
		  -indicatoron=>0,
		  -borderwidth=>0,
		  -image=>$GUI{Icons}->{Unchecked},
		  -selectimage=>$GUI{Icons}->{Checked},
		  -variable=>\$config{gpg}->{normal},
		  -state=>(($config{gpg}->{active} == 1) ? "normal" : "disabled"),
		 )->pack(-side=>'left',
			 -anchor=>'e',
			 -padx=>0,
			 -pady=>0);
  &jarlMainIF_RegisterIcon($GUI{Config}->{GPG}->{GPGNormal}->{Check},
			 ($config{gpg}->{normal} ? "Checked" : "Unchecked"));
  $GUI{Config}->{GPG}->{GPGNormal}->{Label} = 
    $GUI{Config}->{GPG}->{GPGNormal}->{top}->
      Label(-text=>"Normal Messages",
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	   )->pack(-side=>'left',
		   -anchor=>'w');
  $GUI{Config}->{GPG}->{GPGNormal}->{Label}->
    bind("<Button-1>",sub{ $GUI{Config}->{GPG}->{GPGNormal}->{Check}->invoke(); });


  $GUI{Config}->{GPG}->{Trust}->{top} =
    $GUI{Config}->{GPG}->{Right}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	    -relief=>"groove",
	    -borderwidth=>2
	   )->pack(-side=>"top",
		   -fill=>"x",
		   -padx=>2,
		   -pady=>2);

  $GUI{Config}->{GPG}->{AutoFetchTrust}->{top} =
    $GUI{Config}->{GPG}->{Trust}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"top",
		   -fill=>"x",
		   -padx=>5);
  $GUI{Config}->{GPG}->{AutoFetchTrust}->{Check} =
    $GUI{Config}->{GPG}->{AutoFetchTrust}->{top}->
      Checkbutton(-background=>$GUI{color}->{bg}->{normal},
		  -activebackground=>$GUI{color}->{bg}->{normal},
		  -foreground=>$GUI{color}->{fg}->{dark},
		  -selectcolor=>$GUI{color}->{bg}->{normal},
		  -indicatoron=>0,
		  -borderwidth=>0,
		  -image=>$GUI{Icons}->{Unchecked},
		  -selectimage=>$GUI{Icons}->{Checked},
		  -variable=>\$config{gpg}->{autofetchtrust},
		  -state=>(($config{gpg}->{active} == 1) ? "normal" : "disabled"),
		  -command=>sub{
		    if ($config{gpg}->{autofetchtrust} == 1) {
		      $GUI{Config}->{GPG}->{TrustMarginal}->{Radio}->
			configure(-state=>"normal");
		      $GUI{Config}->{GPG}->{TrustFully}->{Radio}->
			configure(-state=>"normal");
		      $GUI{Config}->{GPG}->{KeyServer}->{Entry}->
			configure(-state=>"normal",
				  -background=>$GUI{color}->{jarl}->{config}->{bg}->{light},
				 );
		    } else {
		      $GUI{Config}->{GPG}->{TrustMarginal}->{Radio}->
			configure(-state=>"disabled");
		      $GUI{Config}->{GPG}->{TrustFully}->{Radio}->
			configure(-state=>"disabled");
		      $GUI{Config}->{GPG}->{KeyServer}->{Entry}->
			configure(-state=>"disabled",
				  -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
				 );
		    }
		  }
		 )->pack(-side=>'left',
			 -anchor=>'e',
			 -padx=>0,
			 -pady=>0);
  &jarlMainIF_RegisterIcon($GUI{Config}->{GPG}->{AutoTrustFetch}->{Check},
			 ($config{gpg}->{autofetchtrust} ? "Checked" : "Unchecked"));
  $GUI{Config}->{GPG}->{AutoFetchTrust}->{Label} = 
    $GUI{Config}->{GPG}->{AutoFetchTrust}->{top}->
      Label(-text=>"Auto Fetch/Trust Keys for Public Ring",
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	   )->pack(-side=>'left',
		   -anchor=>'w');
  $GUI{Config}->{GPG}->{AutoFetchTrust}->{Label}->
    bind("<Button-1>",sub{ $GUI{Config}->{GPG}->{AutoFetchTrust}->{Check}->invoke(); });

  $GUI{Config}->{GPG}->{Trust}->{Label} =
    $GUI{Config}->{GPG}->{Trust}->{top}->
      Label(-text=>"Trust Level:",
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -anchor=>"w",
	    -justify=>"left",
	   )->pack(-side=>'top',
		   -fill=>"x",
		   -anchor=>'w');

  $GUI{Config}->{GPG}->{TrustMarginal}->{top} =
    $GUI{Config}->{GPG}->{Trust}->{top}->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'x',
		   -expand=>1,
		   -padx=>5);
  $GUI{Config}->{GPG}->{TrustMarginal}->{Indent} = 
    $GUI{Config}->{GPG}->{TrustMarginal}->{top}->
      Label(-text=>"",
	    -width=>2,
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	   )->pack(-side=>'left',
		   -anchor=>'w');
  $GUI{Config}->{GPG}->{TrustMarginal}->{Radio} =
    $GUI{Config}->{GPG}->{TrustMarginal}->{top}->
      Radiobutton(-value=>3,
		  -variable=>\$config{gpg}->{trust},
		  -activebackground=>$GUI{color}->{bg}->{normal},
		  -background=>$GUI{color}->{bg}->{normal},
		  -foreground=>$GUI{color}->{fg}->{dark},
		  -font=>$GUI{fonts}->{normal},
		  -selectimage=>$GUI{Icons}->{RadioOn},
		  -image=>$GUI{Icons}->{RadioOff},
		  -indicatoron=>0,
		  -borderwidth=>0,
		  -selectcolor=>$GUI{color}->{bg}->{normal},
		  -state=>((($config{gpg}->{active} == 1) && ($config{gpg}->{autofetchtrust} == 1)) ? "normal" : "disabled"),
		 )->pack(-side=>'left',
			 -anchor=>'w');
  &jarlMainIF_RegisterIcon($GUI{Config}->{GPG}->{TrustMarginal}->{Radio},"RadioOff");
  $GUI{Config}->{GPG}->{TrustMarginal}->{Label} =
    $GUI{Config}->{GPG}->{TrustMarginal}->{top}->
      Label(-text=>"Marginal",
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	   )->pack(-side=>'left',
		   -fill=>"x",
		   -anchor=>'w');
  $GUI{Config}->{GPG}->{TrustMarginal}->{Label}->
    bind("<Button-1>",sub{ $GUI{Config}->{GPG}->{TrustMarginal}->{Radio}->invoke(); });

  $GUI{Config}->{GPG}->{TrustFully}->{top} =
    $GUI{Config}->{GPG}->{Trust}->{top}->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'x',
		   -expand=>1,
		   -padx=>5);
  $GUI{Config}->{GPG}->{TrustFully}->{Indent} = 
    $GUI{Config}->{GPG}->{TrustFully}->{top}->
      Label(-text=>"",
	    -width=>2,
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	   )->pack(-side=>'left',
		   -anchor=>'w');
  $GUI{Config}->{GPG}->{TrustFully}->{Radio} =
    $GUI{Config}->{GPG}->{TrustFully}->{top}->
      Radiobutton(-value=>4,
		  -variable=>\$config{gpg}->{trust},
		  -activebackground=>$GUI{color}->{bg}->{normal},
		  -background=>$GUI{color}->{bg}->{normal},
		  -foreground=>$GUI{color}->{fg}->{dark},
		  -font=>$GUI{fonts}->{normal},
		  -selectimage=>$GUI{Icons}->{RadioOn},
		  -image=>$GUI{Icons}->{RadioOff},
		  -indicatoron=>0,
		  -borderwidth=>0,
		  -selectcolor=>$GUI{color}->{bg}->{normal},
		  -state=>((($config{gpg}->{active} == 1) && ($config{gpg}->{autofetchtrust} == 1)) ? "normal" : "disabled"),
		 )->pack(-side=>'left',
			 -anchor=>'w');
  &jarlMainIF_RegisterIcon($GUI{Config}->{GPG}->{TrustFully}->{Radio},"RadioOff");
  $GUI{Config}->{GPG}->{TrustFully}->{Label} =
    $GUI{Config}->{GPG}->{TrustFully}->{top}->
      Label(-text=>"Full",
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	   )->pack(-side=>'left',
		   -fill=>"x",
		   -anchor=>'w');
  $GUI{Config}->{GPG}->{TrustFully}->{Label}->
    bind("<Button-1>",sub{ $GUI{Config}->{GPG}->{TrustFully}->{Radio}->invoke(); });


  $GUI{Config}->{GPG}->{KeyServer}->{top} =
    $GUI{Config}->{GPG}->{Trust}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"top",
		   -fill=>"x",
		   -padx=>5);
  $GUI{Config}->{GPG}->{KeyServer}->{Label} = 
    $GUI{Config}->{GPG}->{KeyServer}->{top}->
      Label(-text=>"KeyServer:",
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	   )->pack(-side=>'left',
		   -anchor=>'w');
  $GUI{Config}->{GPG}->{KeyServer}->{Entry} = 
    $GUI{Config}->{GPG}->{KeyServer}->{top}->
      Entry(-textvariable=>\$config{gpg}->{keyserver},
	    -width=>$GUI{width}->{jarl}->{config}->{entry},
	    -background=>((($config{gpg}->{active} == 1) && ($config{gpg}->{autofetchtrust} == 1)) ? $GUI{color}->{jarl}->{config}->{bg}->{light} : $GUI{color}->{jarl}->{config}->{bg}->{normal}),
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -state=>((($config{gpg}->{active} == 1) && ($config{gpg}->{autofetchtrust} == 1)) ? "normal" : "disabled"),
	   )->pack(-side=>'left',
		   -anchor=>'w',
		   -pady=>5);
  
  #------------------------------------------------------------------------
  #
  # CloseButton
  #
  #------------------------------------------------------------------------
  $GUI{Config}->{Buttons}->{top} =
    $GUI{Config}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"bottom",
		   -fill=>"x",
		   -pady=>$GUI{height}->{jarl}->{config}->{pad});
  $GUI{Config}->{Buttons}->{Close} =
    $GUI{Config}->{Buttons}->{top}->
      Button(-text=>"Close",
	     -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	     -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{jarl}->{config}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{
	       &jarlConfigIF_CloseCB();
	     }
	    )->pack(-side=>"right",
		    -padx=>$GUI{width}->{jarl}->{config}->{pad});

  $GUI{Config}->{TabBar}->RaiseTab("system");

  $GUI{Config}->{window}->deiconify();
}


##############################################################################
#
# jarlConfigIF_CloseCB - close the Config GUI
#
##############################################################################
sub jarlConfigIF_CloseCB {
  $GUI{Config}->{window}->destroy;
  delete($GUI{Config});
}


##############################################################################
#
# jarlConfigIF_EditFavGroupGUI - Open the Favorite Group Editor GUI
#
##############################################################################
sub jarlConfigIF_EditFavGroupGUI {
  my ($name) = @_;

  if (Exists($GUI{EditFavGroup}->{window}) && $GUI{EditFavGroup}->{window}->ismapped()) {
    $GUI{EditFavGroup}->{window}->raise();
    return;
  }

  if ($name ne "") {
    $GUI{EditFavGroup}->{vars}->{oldname} = $name;
    $GUI{EditFavGroup}->{vars}->{name} = $name;
    $GUI{EditFavGroup}->{vars}->{channel} = $config{favgroups}->{$name}->{channel};
    $GUI{EditFavGroup}->{vars}->{server} = $config{favgroups}->{$name}->{server};
    $GUI{EditFavGroup}->{vars}->{nick1} = $config{favgroups}->{$name}->{nick1};
#    $GUI{EditFavGroup}->{vars}->{nick2} = $config{favgroups}->{$name}->{nick2};
  } else {
    $GUI{EditFavGroup}->{vars}->{oldname} = "";
    $GUI{EditFavGroup}->{vars}->{name} = "";
    $GUI{EditFavGroup}->{vars}->{channel} = "";
    $GUI{EditFavGroup}->{vars}->{server} = "";
    $GUI{EditFavGroup}->{vars}->{nick1} = "";
#    $GUI{EditFavGroup}->{vars}->{nick2} = "";
  }

  $GUI{EditFavGroup}->{window} = $GUI{top}->Toplevel();
  $GUI{EditFavGroup}->{window}->title("Favorite Group Editor");
  $GUI{EditFavGroup}->{window}->resizable(0,0);

  $GUI{EditFavGroup}->{top} =
    $GUI{EditFavGroup}->{window}->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark}
	   )->pack(-side=>"top",
		   -fill=>"both",
		   -expand=>1);

  $GUI{EditFavGroup}->{Name}->{top} =
    $GUI{EditFavGroup}->{top}->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'both',
		   -expand=>1);
  $GUI{EditFavGroup}->{Name}->{Label} =
    $GUI{EditFavGroup}->{Name}->{top}->
      Label(-text=>"Name:",
	    -width=>$GUI{width}->{jarl}->{profileeditor}->{label},
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -anchor=>'e'
	   )->pack(-side=>'left',
		   -anchor=>'e');
  $GUI{EditFavGroup}->{Name}->{Entry} =
    $GUI{EditFavGroup}->{Name}->{top}->
      Entry(-textvariable=>\$GUI{EditFavGroup}->{vars}->{name},
	    -width=>$GUI{width}->{jarl}->{profileeditor}->{entry},
	    -background=>$GUI{color}->{bg}->{light},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -state=>"normal"
	   )->pack(-side=>'left',
		   -fill=>"x",
		   -expand=>1,
		   -anchor=>'w');

  $GUI{EditFavGroup}->{Channel}->{top} =
    $GUI{EditFavGroup}->{top}->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'both',
		   -expand=>1);
  $GUI{EditFavGroup}->{Channel}->{Label} =
    $GUI{EditFavGroup}->{Channel}->{top}->
      Label(-text=>"Channel:",
	    -width=>$GUI{width}->{jarl}->{profileeditor}->{label},
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -anchor=>'e'
	   )->pack(-side=>'left',
		   -anchor=>'e');
  $GUI{EditFavGroup}->{Channel}->{Entry} =
    $GUI{EditFavGroup}->{Channel}->{top}->
      Entry(-textvariable=>\$GUI{EditFavGroup}->{vars}->{channel},
	    -width=>$GUI{width}->{jarl}->{profileeditor}->{entry},
	    -background=>$GUI{color}->{bg}->{light},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -state=>"normal"
	   )->pack(-side=>'left',
		   -fill=>"x",
		   -expand=>1,
		   -anchor=>'w');

  $GUI{EditFavGroup}->{JIDPullDown}->{top} =
    $GUI{EditFavGroup}->{top}->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark}
	   )->pack(-side=>"top",
		   -fill=>"both",
		   -expand=>1);
  $GUI{EditFavGroup}->{JIDPullDown}->{Label} =
    $GUI{EditFavGroup}->{JIDPullDown}->{top}->
      Label(-text=>"Server:",
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -width=>$GUI{width}->{jarl}->{config}->{label},
	    -anchor=>"e"
	   )->pack(-side=>'left',
		   -anchor=>'e');
  $serverList =
    $GUI{EditFavGroup}->{JIDPullDown}->{top}->
      EntryPullDown(-textvariable=>\$GUI{EditFavGroup}->{vars}->{server},
		    -width=>$GUI{width}->{jarl}->{profileeditor}->{entry},
		    -background=>$GUI{color}->{bg}->{normal},
		    -foreground=>$GUI{color}->{fg}->{dark},
		    -entrybackground=>$GUI{color}->{bg}->{light},
		    -entryforeground=>$GUI{color}->{fg}->{dark},
		    -font=>$GUI{fonts}->{normal},
		    -buttonborderwidth=>1,
		    -elements=>[keys(%groupchatJIDs)],
		   )->pack(-side=>'left',
			   -anchor=>'w');

  $GUI{EditFavGroup}->{Nick1}->{top} =
    $GUI{EditFavGroup}->{top}->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'both',
		   -expand=>1);
  $GUI{EditFavGroup}->{Nick1}->{Label} =
    $GUI{EditFavGroup}->{Nick1}->{top}->
      Label(-text=>"Nick:",
	    -width=>$GUI{width}->{jarl}->{profileeditor}->{label},
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -anchor=>'e'
	   )->pack(-side=>'left',
		   -anchor=>'e');
  $GUI{EditFavGroup}->{Nick1}->{Entry} =
    $GUI{EditFavGroup}->{Nick1}->{top}->
      Entry(-textvariable=>\$GUI{EditFavGroup}->{vars}->{nick1},
	    -width=>$GUI{width}->{jarl}->{profileeditor}->{entry},
	    -background=>$GUI{color}->{bg}->{light},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -state=>"normal"
	   )->pack(-side=>'left',
		   -fill=>"x",
		   -expand=>1,
		   -anchor=>'w');

#  $GUI{EditFavGroup}->{Nick2}->{top} =
#    $GUI{EditFavGroup}->{top}->
#      Frame(-background=>$GUI{color}->{bg}->{normal},
#	    -foreground=>$GUI{color}->{fg}->{dark},
#	   )->pack(-side=>'top',
#		   -fill=>'both',
#		   -expand=>1);
#  $GUI{EditFavGroup}->{Nick2}->{Label} =
#    $GUI{EditFavGroup}->{Nick2}->{top}->
#      Label(-text=>"Nick2:",
#	    -width=>$GUI{width}->{jarl}->{profileeditor}->{label},
#	    -background=>$GUI{color}->{bg}->{normal},
#	    -foreground=>$GUI{color}->{fg}->{dark},
#	    -font=>$GUI{fonts}->{normal},
#	    -anchor=>'e'
#	   )->pack(-side=>'left',
#		   -anchor=>'e');
#  $GUI{EditFavGroup}->{Nick2}->{Entry} =
#    $GUI{EditFavGroup}->{Nick2}->{top}->
#      Entry(-textvariable=>\$GUI{EditFavGroup}->{vars}->{nick2},
#	    -width=>$GUI{width}->{jarl}->{profileeditor}->{entry},
#	    -background=>$GUI{color}->{bg}->{light},
#	    -foreground=>$GUI{color}->{fg}->{dark},
#	    -font=>$GUI{fonts}->{normal},
#	    -state=>"normal"
#	   )->pack(-side=>'left',
#		   -fill=>"x",
#		   -expand=>1,
#		   -anchor=>'w');



    $GUI{EditFavGroup}->{Buttons}->{top} = 
      $GUI{EditFavGroup}->{top}->
	Frame(-background=>$GUI{color}->{bg}->{normal},
	      -foreground=>$GUI{color}->{fg}->{dark},
	     )->pack(-side=>"bottom",
		     -fill=>"both",
		     -expand=>1);
    $GUI{EditFavGroup}->{Buttons}->{Close} =
      $GUI{EditFavGroup}->{Buttons}->{top}->
	Button(-text=>"Close",
	       -background=>$GUI{color}->{bg}->{normal},
	       -foreground=>$GUI{color}->{fg}->{dark},
	       -disabledforeground=>$GUI{color}->{fg}->{light},
	       -font=>$GUI{fonts}->{normal},
	       -command=>sub{
		 &jarlConfigIF_EditFavGroupCloseCB();
	       }
	      )->pack(-side=>"right",
		      -pady=>$GUI{height}->{jarl}->{rosteritem}->{pad},
		      -padx=>$GUI{width}->{jarl}->{rosteritem}->{pad});

    $GUI{EditFavGroup}->{Buttons}->{Save} =
      $GUI{EditFavGroup}->{Buttons}->{top}->
	Button(-text=>"Save",
	       -background=>$GUI{color}->{bg}->{normal},
	       -foreground=>$GUI{color}->{fg}->{dark},
	       -disabledforeground=>$GUI{color}->{fg}->{light},
	       -font=>$GUI{fonts}->{normal},
	       -command=>sub{

		 $serverList->SaveElement();
		 foreach my $server ($serverList->GetElements()) {
		   $groupchatJIDs{$server} = 1;
		 }

		 &jarlConfigIF_EditFavGroupSaveCB();
	       }
	      )->pack(-side=>"right",
		      -pady=>$GUI{height}->{jarl}->{rosteritem}->{pad},
		      -padx=>$GUI{width}->{jarl}->{rosteritem}->{pad});

}


##############################################################################
#
# jarlConfigIF_PopulateFavGroupList - populate the listbox
#
##############################################################################
sub jarlConfigIF_PopulateFavGroupList {

  $GUI{Config}->{FavGroups}->{List}->{MulColListbox}->delete(0,"end");

  foreach $group (sort {$a cmp $b} keys(%{$config{favgroups}})) {
    $GUI{Config}->{FavGroups}->{List}->{MulColListbox}->
      insert({
	      name=>$group,
	      channel=>$config{favgroups}->{$group}->{channel},
	      server=>$config{favgroups}->{$group}->{server},
	      nick1=>$config{favgroups}->{$group}->{nick1},
#	      nick2=>$config{favgroups}->{$group}->{nick2}
	     }
	    );
  }
}


##############################################################################
#
# jarlConfigIF_EditFavGroupSaveCB - save this favorite group
#
##############################################################################
sub jarlConfigIF_EditFavGroupSaveCB {

  if ($GUI{EditFavGroup}->{vars}->{oldname} ne $GUI{EditFavGroup}->{vars}->{name}) {
    delete($config{favgroups}->{$GUI{EditFavGroup}->{vars}->{oldname}})
      if exists($config{favgroups}->{$GUI{EditFavGroup}->{vars}->{oldname}});
  }

  $config{favgroups}->{$GUI{EditFavGroup}->{vars}->{name}}->{channel} =
    $GUI{EditFavGroup}->{vars}->{channel};
  $config{favgroups}->{$GUI{EditFavGroup}->{vars}->{name}}->{server} =
    $GUI{EditFavGroup}->{vars}->{server};
  $config{favgroups}->{$GUI{EditFavGroup}->{vars}->{name}}->{nick1} =
    $GUI{EditFavGroup}->{vars}->{nick1};
  $config{favgroups}->{$GUI{EditFavGroup}->{vars}->{name}}->{nick2} =
    $GUI{EditFavGroup}->{vars}->{nick2};

  &jarlConfigIF_PopulateFavGroupList();
  &jarlMainIF_PopulateFavGroupsMenu();

  &jarlConfigIF_EditFavGroupCloseCB();
}


##############################################################################
#
# jarlConfigIF_EditFavGroupCloseCB - close the Favorite Group Editor GUI
#
##############################################################################
sub jarlConfigIF_EditFavGroupCloseCB {
  $GUI{EditFavGroup}->{window}->destroy;
  delete($GUI{EditFavGroup});
}


1;
