##############################################################################
#
# Jarl - Debug CLI Code
#
#   Perl code to handle the interface with the user.
#
##############################################################################

##############################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#  Jabber
#  Copyright (C) 1998-1999 The Jabber Team http://jabber.org/
#
##############################################################################


##############################################################################
#
# jarlDebugIF_AddXML - add the specified XML with the specified type.
#
##############################################################################
sub jarlDebugIF_AddXML {
  my ($type,$xml) = @_;

  return if ($config{showdebug} == 0);

  my $typeTag = lc($type);
  $typeTag = "error" if ($xml =~ /type\s*\=\s*\'?\"?error\'?\"?/i);

  $TabBar->Print("__jarl__:tabbar","debug","timestamp","[".&Net::Jabber::GetTimeStamp("local",time,"shortest")."] ");
  $TabBar->Print("__jarl__:tabbar","debug",$typeTag,"$type: $xml\n");
}


##############################################################################
#
# jarlDebugIF_HandleCommand - take the command line for the debug tab and
#                             parse it according to these rules.
#
##############################################################################
sub jarlDebugIF_HandleCommand {
  my $command = shift;

  return if ($command eq "");

  if ($command =~ /^\/__jarl__\:up$/) {
    &jarlDebugIF_CurrentSay(&jarlDebug_HistoryUp());
    return;
  }
  if ($command =~ /^\/__jarl__\:down$/) {
    &jarlDebugIF_CurrentSay(&jarlDebug_HistoryDown());
    return;
  }

  return if ($command =~ /^\/__jarl__\:/);

  &jarlDebugIF_CurrentSay($command);
  $jabber{client}->Send($command);
  &jarlDebug_AddHistory($command);
  &jarlDebugIF_CurrentSay("");
}


##############################################################################
#
# jarlDebugIF_CurrentSay - if $value is defined then the Entry contents
#                          are set to $value, otherwise the contents of
#                          the Entry are returned.
#
##############################################################################
sub jarlDebugIF_CurrentSay {
  my ($value) =  @_;
  if (defined($value)) {
    $GUI{input} = (($value eq "") ? undef : $value);
    $GUI{inputpos} = length($value);

    &jarlMainIF_DrawPrompt();
  }
  return (defined($GUI{input}) ? $GUI{input} : "");
}


1;
