##############################################################################
#
# Jarl - Error TK Interface Code
#
#   Perl code to handle showing the Jarl Error GUI and error messages.
#
##############################################################################

##############################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#  Jabber
#  Copyright (C) 1998-1999 The Jabber Team http://jabber.org/
#
##############################################################################

##############################################################################
#
# jarlErrorIF_Popup - creates the Error GUI and displays it.
#
##############################################################################
sub jarlErrorIF_Popup {
  my ($code,$string) = @_;

  &jarlMainIF_StatusAdd("ERROR: $code") unless ($code eq "");
  &jarlMainIF_StatusAdd("ERROR: $string");

  return if Exists($GUI{ERROR}->{top});

  $GUI{ERROR}->{top} = $GUI{top}->Toplevel();
  $GUI{ERROR}->{top}->title("ERROR: $code");
  $GUI{ERROR}->{top}->withdraw();
  $GUI{ERROR}->{top}->resizable(0,0);

  $GUI{ERROR}->{String}->{top} =
    $GUI{ERROR}->{top}->
      Frame(-foreground=>$GUI{color}->{fg}->{dark},
	    -background=>$GUI{color}->{bg}->{normal},
	   )->pack(-side=>"top",
		   -fill=>"both",
		   -padx=>$GUI{width}->{pad},
		   -pady=>$GUI{height}->{pad});

  $GUI{ERROR}->{String}->{top}->
    Label(-text=>"ERROR: $code",
	  -font=>$GUI{fonts}->{header},
	  -foreground=>$GUI{color}->{fg}->{dark},
	  -background=>$GUI{color}->{bg}->{normal},
	  -anchor=>"w",
	  -justify=>"left"
	 )->pack(-side=>"top",
		 -fill=>"both");
  $GUI{ERROR}->{String}->{top}->
    Label(-text=>$string,
	  -font=>$GUI{fonts}->{normal},
	  -foreground=>$GUI{color}->{fg}->{dark},
	  -background=>$GUI{color}->{bg}->{normal},
	  -anchor=>"w",
	  -justify=>"left"
	 )->pack(-side=>"top",
		 -fill=>"both");

  $GUI{ERROR}->{Button}->{top} =
    $GUI{ERROR}->{top}->
      Frame(-foreground=>$GUI{color}->{fg}->{dark},
	    -background=>$GUI{color}->{bg}->{normal},
	    -relief=>"sunken",
	    -borderwidth=>2,
	   )->pack(-side=>"bottom",
		   -padx=>$GUI{width}->{pad},
		   -pady=>$GUI{height}->{pad});

  $GUI{ERROR}->{Button}->{OK} =
    $GUI{ERROR}->{Button}->{top}->
      Button(-text=>"OK",
	     -font=>$GUI{fonts}->{normal},
	     -foreground=>$GUI{color}->{fg}->{dark},
	     -background=>$GUI{color}->{bg}->{normal},
	     -command=>sub{
	       $GUI{ERROR}->{top}->grabRelease();
	       $GUI{ERROR}->{top}->destroy();
	       delete($GUI{ERROR});
	     }
	    )->pack(-side=>"bottom");

  $GUI{ERROR}->{Button}->{OK}->focus();

  $GUI{ERROR}->{top}->transient($GUI{ERROR}->{top}->Parent->toplevel);
  $GUI{ERROR}->{top}->protocol('WM_DELETE_WINDOW' => sub {});

  $GUI{ERROR}->{top}->geometry("+".int(($GUI{top}->screenwidth()-$GUI{ERROR}->{top}->reqwidth())/2)."+".int(($GUI{top}->screenheight()-$GUI{ERROR}->{top}->reqheight())/2));

  $GUI{ERROR}->{top}->Popup();

  $GUI{ERROR}->{top}->grabGlobal();
}


1;
