##############################################################################
#
# Jarl - GPG CLI Interface Functions
#   Perl code to handle the interface to the GPG code.
#
##############################################################################

##############################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#  Jabber
#  Copyright (C) 1998-1999 The Jabber Team http://jabber.org/
#
##############################################################################

##############################################################################
#
# jarlGPGIF_PromptPassphrase - prompt the user for their passphrase
#
##############################################################################
sub jarlGPGIF_PromptPassphrase {

  my $ask = &jarlMainIF_Prompt(prompt=>"Enable GPG? ",
			       default=>"y",
			       options=>["y","n"]);

  if ($ask eq "n") {
    $config{gpg}->{active} = -1;
    return;
  }

  my $passphrase = "";
  while(1) {
    $passphrase = &jarlMainIF_Prompt(prompt=>"GPG Passphrase",
				     password=>1);
    next if ($passphrase eq "");
    next if (&jarlGPG_TestPassphrase($passphrase) == 0);
    last;
  }
  $config{gpg}->{passphrase} = $passphrase;
}


1;
