##############################################################################
#
# Jarl - Login Command Line Interface Code
#
#   Perl code to handle showing the Jarl Login CLI and interfacing with it.
#
##############################################################################

##############################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#  Jabber
#  Copyright (C) 1998-1999 The Jabber Team http://jabber.org/
#
##############################################################################

##############################################################################
#
# jarlLoginIF_CLI - creates the Login CLI.
#
##############################################################################
sub jarlLoginIF_CLI {
  $TabBar->Print("\n");
  $TabBar->Print('        __           __'."\n");
  $TabBar->Print('       / /___ ______/ /   a Jabber Perl Client'."\n");
  $TabBar->Print('  __  / / __ `/ ___/ /      Command Line Interface'."\n");
  $TabBar->Print(' / /_/ / /_/ / /  / /        v'.$VERSION."\n");
  $TabBar->Print(' \____/\__,_/_/  /_/'."\n");
  $TabBar->Print("\n");
  $TabBar->Print("\n");

  my $status = 0;
  while ($status != 1) {

    $TabBar->RaiseTab("login");

    $TabBar->Print("Choose a profile:\n");
    $TabBar->Print("  0) Connect w/o Profile (default)\n");
    my $count = 1;
    my $index = -1;
    my @map;
    foreach my $profile (sort {$a cmp $b} keys(%profiles)) {
      $index++;
      next if ($profile eq "Connect w/o Profile");
      $TabBar->Print("  $count) $profile\n");
      $map[$count] = $index;
      $count++;
    }
    $TabBar->Print("  e) Edit Profiles\n");
    my $profile = &jarlMainIF_Prompt(prompt=>"Profile",
				     default=>0,
				     options=>[0..($count-1),"e"]);

    my $server;
    my $port;
    my $username;
    my $password;
    my $resource;
    my $priority;
    my $type;
    my $ssl;

    if ($profile eq "e") {
      &jarlProfileIF_EditorGUI();
    } elsif ($profile == 0) {

      $activeProfile = "Connect w/o Profile";

      $server = &jarlMainIF_Prompt(prompt=>"Server");

      my $count = 0;
      my $default;
      $TabBar->Print("Connection Types:\n");
      foreach my $conType (sort {$a cmp $b} keys(%connectiontypes)) {
        $default = $count if ($conType eq "TCP/IP");
        $TabBar->Print("  $count) $conType\n");
        $count++;
      }
      $type = &jarlMainIF_Prompt(prompt=>"Type",
 	 		       default=>$default,
 	 		       options=>[0..($count-1)]);
      $type = (sort {$a cmp $b} keys(%connectiontypes))[$type];

      $port = &jarlMainIF_Prompt(prompt=>"Port",
				 default=>$connectiontypes{$type}->[1]);

      $ssl = $connectiontypes{$type}->[2];
      $type = $connectiontypes{$type}->[0];

      $username = &jarlMainIF_Prompt(prompt=>"Username");
      $password = &jarlMainIF_Prompt(prompt=>"Password",
				     password=>1);
      $resource = &jarlMainIF_Prompt(prompt=>"Resource",
				     default=>"Jarl");
    } else {
      my $profileName = (sort {$a cmp $b} keys(%profiles))[$map[$profile]];

      $activeProfile = $profileName;

      $server = $profiles{$profileName}->Server();
      $username = $profiles{$profileName}->Username();
      $password = $profiles{$profileName}->Password();

      my @connectionObjs = $profiles{$profileName}->ConnectionObj();

      my $connection;
      if ($#connectionObjs > 0) {
	my $count = 0;
	$TabBar->Print("Connections:\n");
	foreach my $connectionType ( sort {$a cmp $b} @connectionObjs) {
	  $TabBar->Print("  $count) $connectionType\n");
	  $count++;
	}
	my $connectionIndex = &jarlMainIF_Prompt(prompt=>"Connection",
						 default=>0,
						 options=>[0..($count-1)]);
	$connection = ($profiles{$profileName}->ConnectionObj())[$connectionIndex];
      } else {
	$connection = ($profiles{$profileName}->ConnectionObj())[0];
      }
      $port = $profiles{$profileName}->ConnectionObj($connection)->Port();
      $type = $connectiontypes{$profiles{$profileName}->ConnectionObj($connection)->Type()}->[0];
      $ssl = $connectiontypes{$profiles{$profileName}->ConnectionObj($connection)->Type()}->[2];
      $resource = &jarlMainIF_Prompt(prompt=>"Resource",
				     default=>$profiles{$profileName}->Resource());
    }

    next if ($profile eq "e");

    $priority = &jarlMainIF_Prompt(prompt=>"Priority",
				   default=>"0");

    $TabBar->Print("\n");

    $TabBar->RaiseTab("status");

    &jarlSettings_SetConfig();

    $status = &jarlConnect(server=>$server,
			   port=>$port,
			   connectiontype=>$type,
			   ssl=>$ssl,
			   username=>$username,
			   password=>$password,
			   resource=>$resource,
			   priority=>$priority,
			  );
  }
  $TabBar->DeleteTab("login");

  $TabBar->Print("Connected!\n");
}


1;
