##############################################################################
#
# Jarl - Main Tk Interface Code
#   Perl code to handle showing the main Jarl GUI and interfacing with it in
# Tk.
#
##############################################################################

##############################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#  Jabber
#  Copyright (C) 1998-1999 The Jabber Team http://jabber.org/
#
##############################################################################

use Tk;
use Tk::Balloon;
use Tk::Font;

use Tk::MulColListbox 0.3;
use Tk::TabBar 0.6;
use Tk::EntryPullDown;

use Tk::Roster;

use vars qw( %xpmcache );

##############################################################################
#
# jarlMainIF_Init - Main initialization for Tk GUI
#
##############################################################################
sub jarlMainIF_Init {
  &jarlMainIF_StartGUI();
  &jarlMainIF_InitGUI();
  &jarlMainIF_InitFonts();
  &jarlMainIF_InitIcons();

  &jarlMainIF_GUI();

  &MainLoop();
}


##############################################################################
#
# jarlMainIF_StartGUI - the GUI creation is multi-step.  This is step 1.
#
##############################################################################
sub jarlMainIF_StartGUI {
  $GUI{top} = MainWindow->new();
  $GUI{top}->withdraw();
}


##############################################################################
#
# jarlMainIF_InitGUI - define some basic widths, heights, and colors so that
#                    the GUI feels consistant.
#
##############################################################################
sub jarlMainIF_InitGUI {
  $Debug->Log0("Init the GUI");

  $GUI{color}->{balloon}->{bg} = "pale goldenrod";
  $GUI{color}->{balloon}->{fg} = "black";

  $GUI{color}->{window}->{bg}->{dark}  = "gray75";
  $GUI{color}->{window}->{bg}->{normal} = "gray85";
  $GUI{color}->{window}->{bg}->{light} = "white";
  $GUI{color}->{window}->{fg}->{dark}  = "black";
  $GUI{color}->{window}->{fg}->{light} = "gray61";

  #
  # Main Settings
  #
  $GUI{color}->{bg}->{darkest} = "black";
  $GUI{color}->{bg}->{darkdark} = "gray70";
  $GUI{color}->{bg}->{dark} = "gray75";
  $GUI{color}->{bg}->{normaldark} = "gray80";
  $GUI{color}->{bg}->{normal} = "gray85";
  $GUI{color}->{bg}->{normallight} = "gray90";
  $GUI{color}->{bg}->{light} = "white";
  $GUI{color}->{fg}->{dark} = "black";
  $GUI{color}->{fg}->{light} = "gray61";
  $GUI{color}->{fg}->{lightest} = "gray85";

  $GUI{color}->{bg}->{list} = "steelblue";
  $GUI{color}->{fg}->{list} = "white";

  $GUI{width}->{button} = 10;
  $GUI{width}->{label} = 15;
  $GUI{width}->{entry} = 30;
  $GUI{width}->{tabs}->{thickness} = 1;
  $GUI{width}->{pad} = 5;

  $GUI{height}->{pad} = 5;

  #
  # Config Settings
  #
  $GUI{color}->{jarl}->{config}->{bg}->{dark} = "gray75";
  $GUI{color}->{jarl}->{config}->{bg}->{normal} = "gray85";
  $GUI{color}->{jarl}->{config}->{bg}->{light} = "white";
  $GUI{color}->{jarl}->{config}->{fg}->{dark} = "black";
  $GUI{color}->{jarl}->{config}->{fg}->{light} = "gray61";
  $GUI{width}->{jarl}->{config}->{profile}->{button} = 10;
  $GUI{width}->{jarl}->{config}->{label} = 15;
  $GUI{width}->{jarl}->{config}->{entry} = 30;
  $GUI{width}->{jarl}->{config}->{tabs}->{thickness} = 1;
  $GUI{width}->{jarl}->{config}->{pad} = 5;
  $GUI{height}->{jarl}->{config}->{pad} = 5;

  #
  # Profile Editor Settings
  #
  $GUI{color}->{jarl}->{profileeditor}->{bg}->{dark} = "gray75";
  $GUI{color}->{jarl}->{profileeditor}->{bg}->{normal} = "gray85";
  $GUI{color}->{jarl}->{profileeditor}->{bg}->{light} = "white";
  $GUI{color}->{jarl}->{profileeditor}->{fg}->{dark} = "black";
  $GUI{color}->{jarl}->{profileeditor}->{fg}->{light} = "gray61";
  $GUI{width}->{jarl}->{profileeditor}->{profile}->{button} = 10;
  $GUI{width}->{jarl}->{profileeditor}->{label} = 15;
  $GUI{width}->{jarl}->{profileeditor}->{entry} = 30;
  $GUI{width}->{jarl}->{profileeditor}->{tabs}->{thickness} = 1;
  $GUI{width}->{jarl}->{profileeditor}->{pad} = 5;
  $GUI{height}->{jarl}->{profileeditor}->{pad} = 5;

  #
  # Main Settings
  #
  $GUI{color}->{jarl}->{main}->{bg}->{dark} = "gray75";
  $GUI{color}->{jarl}->{main}->{bg}->{normal} = "gray85";
  $GUI{color}->{jarl}->{main}->{bg}->{light} = "white";
  $GUI{color}->{jarl}->{main}->{fg}->{link} = "blue";
  $GUI{color}->{jarl}->{main}->{fg}->{dark} = "black";
  $GUI{color}->{jarl}->{main}->{fg}->{light} = "gray61";
  $GUI{width}->{jarl}->{main}->{profile}->{button} = 10;
  $GUI{width}->{jarl}->{main}->{senderlist} = 25;
  $GUI{width}->{jarl}->{main}->{subjectlist} = 25;
  $GUI{width}->{jarl}->{main}->{datelist} = 25;
  $GUI{width}->{jarl}->{main}->{label} = 15;
  $GUI{width}->{jarl}->{main}->{entry} = 30;
  $GUI{width}->{jarl}->{main}->{tabs}->{thickness} = 1;
  $GUI{width}->{jarl}->{main}->{pad} = 5;
  $GUI{width}->{jarl}->{main}->{scrollbar} = 10;
  $GUI{height}->{jarl}->{main}->{pad} = 5;


  #
  # Main Settings
  #
  $GUI{color}->{jarl}->{newmessage}->{bg}->{dark} = "gray75";
  $GUI{color}->{jarl}->{newmessage}->{bg}->{normal} = "gray85";
  $GUI{color}->{jarl}->{newmessage}->{bg}->{light} = "white";
  $GUI{color}->{jarl}->{newmessage}->{fg}->{dark} = "black";
  $GUI{color}->{jarl}->{newmessage}->{fg}->{light} = "gray61";
  $GUI{width}->{jarl}->{newmessage}->{button} = 7;
  $GUI{width}->{jarl}->{newmessage}->{senderlist} = 25;
  $GUI{width}->{jarl}->{newmessage}->{subjectlist} = 25;
  $GUI{width}->{jarl}->{newmessage}->{datelist} = 25;
  $GUI{width}->{jarl}->{newmessage}->{label} = 15;
  $GUI{width}->{jarl}->{newmessage}->{entry} = 30;
  $GUI{width}->{jarl}->{newmessage}->{tabs}->{thickness} = 1;
  $GUI{width}->{jarl}->{newmessage}->{pad} = 5;
  $GUI{width}->{jarl}->{newmessage}->{scrollbar} = 10;
  $GUI{height}->{jarl}->{newmessage}->{pad} = 5;


  #
  # Main Settings
  #
  $GUI{color}->{jarl}->{rosteritem}->{bg}->{dark} = "gray75";
  $GUI{color}->{jarl}->{rosteritem}->{bg}->{normal} = "gray85";
  $GUI{color}->{jarl}->{rosteritem}->{bg}->{light} = "white";
  $GUI{color}->{jarl}->{rosteritem}->{fg}->{dark} = "black";
  $GUI{color}->{jarl}->{rosteritem}->{fg}->{light} = "gray61";
  $GUI{width}->{jarl}->{rosteritem}->{button} = 7;
  $GUI{width}->{jarl}->{rosteritem}->{senderlist} = 25;
  $GUI{width}->{jarl}->{rosteritem}->{subjectlist} = 25;
  $GUI{width}->{jarl}->{rosteritem}->{datelist} = 25;
  $GUI{width}->{jarl}->{rosteritem}->{label} = 10;
  $GUI{width}->{jarl}->{rosteritem}->{entry} = 30;
  $GUI{width}->{jarl}->{rosteritem}->{tabs}->{thickness} = 1;
  $GUI{width}->{jarl}->{rosteritem}->{pad} = 5;
  $GUI{width}->{jarl}->{rosteritem}->{scrollbar} = 10;
  $GUI{height}->{jarl}->{rosteritem}->{pad} = 5;


  #
  # Menu Settings
  #
  $GUI{color}->{jarl}->{menu}->{text} = "black";
  $GUI{color}->{jarl}->{menu}->{background} = "gray85";

  #
  # Roster Settings
  #
  $GUI{color}->{jarl}->{roster}->{online} = "green";
  $GUI{color}->{jarl}->{roster}->{offline} = "red";
  $GUI{color}->{jarl}->{roster}->{away} = "blue";
  $GUI{color}->{jarl}->{roster}->{fg}->{dark} = "black";
  $GUI{color}->{jarl}->{roster}->{bg}->{normal} = "gray85";

  #
  # Message Settings
  #
  $GUI{color}->{jarl}->{message}->{text} = "black";
  $GUI{color}->{jarl}->{message}->{background} = "gray85";
  $GUI{color}->{jarl}->{message}->{button} = "gray85";
}


##############################################################################
#
# jarlMainIF_InitFonts - initialize the fonts that everyone will use
#
##############################################################################
sub jarlMainIF_InitFonts {
  my $defaultSize = 10;
  if (!exists($GUI{fonts}->{login})) {
    $GUI{fonts}->{login} =
      $GUI{top}->
	fontCreate("login",
		   -family=>"helvetica",
		   -size=>$defaultSize);
  }

  if (!exists($GUI{fonts}->{normal})) {
    $GUI{fonts}->{normal} =
      $GUI{top}->
	fontCreate("normal",
		   -family=>(exists($config{font}->{family}) ?
			     $config{font}->{family} :
			     "helvetica"),
		   -size=>(exists($config{font}->{size}) ?
			   $config{font}->{size} :
			   $defaultSize),
		  );
  } else {
    $GUI{fonts}->{normal}->
      configure(-family=>(exists($config{font}->{family}) ?
			  $config{font}->{family} :
			  "helvetica"),
		-size=>(exists($config{font}->{size}) ?
			$config{font}->{size} :
			$defaultSize)
	       );
  }

  if (!exists($GUI{fonts}->{header})) {
    $GUI{fonts}->{header} =
      $GUI{top}->
	fontCreate("header",
		   -family=>(exists($config{font}->{family}) ?
			     $config{font}->{family} :
			     "helvetica"),
		   -size=>(exists($config{font}->{size}) ?
			   $config{font}->{size} :
			   $defaultSize),
		   -weight=>"bold");
  } else {
    $GUI{fonts}->{header}->
      configure(-family=>(exists($config{font}->{family}) ?
			  $config{font}->{family} :
			  "helvetica"),
		-size=>(exists($config{font}->{size}) ?
			$config{font}->{size} :
			$defaultSize)
	       );
  }

  if (!exists($GUI{fonts}->{link})) {
    $GUI{fonts}->{link} =
      $GUI{top}->
	fontCreate("link",
		   -family=>(exists($config{font}->{family}) ?
			     $config{font}->{family} :
			     "helvetica"),
		   -size=>(exists($config{font}->{size}) ?
			   $config{font}->{size} :
			   $defaultSize),
		   -underline=>1);
  } else {
    $GUI{fonts}->{link}->
      configure(-family=>(exists($config{font}->{family}) ?
			  $config{font}->{family} :
			  "helvetica"),
		-size=>(exists($config{font}->{size}) ?
			$config{font}->{size} :
			$defaultSize)
	       );
  }

  if (!exists($GUI{fonts}->{testnormal})) {
    $GUI{fonts}->{testnormal} =
      $GUI{top}->
	fontCreate("testnormal",
		   -family=>(exists($config{font}->{family}) ?
			     $config{font}->{family} :
			     "helvetica"),
		   -size=>(exists($config{font}->{size}) ?
			   $config{font}->{size} :
			   $defaultSize),
		  );
  } else {
    $GUI{fonts}->{testnormal}->
      configure(-family=>(exists($config{font}->{family}) ?
			  $config{font}->{family} :
			  "helvetica"),
		-size=>(exists($config{font}->{size}) ?
			$config{font}->{size} :
			$defaultSize)
	       );
  }

  if (!exists($GUI{fonts}->{testheader})) {
    $GUI{fonts}->{testheader} =
      $GUI{top}->
	fontCreate("testheader",
		   -family=>(exists($config{font}->{family}) ?
			     $config{font}->{family} :
			     "helvetica"),
		   -size=>(exists($config{font}->{size}) ?
			   $config{font}->{size} :
			   $defaultSize),
		   -weight=>"bold");
  } else {
    $GUI{fonts}->{testheader}->
      configure(-family=>(exists($config{font}->{family}) ?
			  $config{font}->{family} :
			  "helvetica"),
		-size=>(exists($config{font}->{size}) ?
			$config{font}->{size} :
			$defaultSize)
	       );
  }

  if (!exists($GUI{fonts}->{testlink})) {
    $GUI{fonts}->{testlink} =
      $GUI{top}->
	fontCreate("testlink",
		   -family=>(exists($config{font}->{family}) ?
			     $config{font}->{family} :
			     "helvetica"),
		   -size=>(exists($config{font}->{size}) ?
			   $config{font}->{size} :
			   $defaultSize),
		   -underline=>1);
  } else {
    $GUI{fonts}->{testlink}->
      configure(-family=>(exists($config{font}->{family}) ?
			  $config{font}->{family} :
			  "helvetica"),
		-size=>(exists($config{font}->{size}) ?
			$config{font}->{size} :
			$defaultSize)
	       );
  }
}


##############################################################################
#
# jarlMainIF_ChangeIcon - register the widget with the icon type
#
##############################################################################
sub jarlMainIF_ChangeIcon {
  my ($widget,$key,$key_old) = @_;

  return unless Exists($widget);

  $widget->configure(-image=>$GUI{Icons}->{$key});
  &jarlMainIF_RegisterIcon($widget,$key);
  &jarlMainIF_UnregisterIcon($widget,$key_old);
}


##############################################################################
#
# jarlMainIF_RegisterIcon - register the widget with the icon type
#
##############################################################################
sub jarlMainIF_RegisterIcon {
  my ($widget,$key) = @_;

  $GUI{Icons}->{widgets}->{$key}->{$widget} = $widget;
}


##############################################################################
#
# jarlMainIF_UnregisterIcon - unregister the widget with the icon type
#
##############################################################################
sub jarlMainIF_UnregisterIcon {
  my ($widget,$key) = @_;

  delete($GUI{Icons}->{widgets}->{$key}->{$widget});
}


##############################################################################
#
# jarlMainIF_InitIcon - predefine an icon so that we can easily use it later
#
##############################################################################
sub jarlMainIF_InitIcon {
  my ($key,$size,@files) = @_;

  my $realSize = (-e "$Bitmaps/$size/$files[0]") ? $size : 15;

  my @fullFiles;
  foreach my $file (@files) {
    print "WARNING: $file does not exist\n"
      if !(-e "$Bitmaps/$size/$file");

    push(@fullFiles,"$Bitmaps/$realSize/$file");
  }

  $GUI{Icons}->{$key} = $GUI{top}->Pixmap(-data=>&jarlXPM_Merge(@fullFiles));

  foreach my $widget (keys(%{$GUI{Icons}->{widgets}->{$key}})) {
    if (!Exists($GUI{Icons}->{widgets}->{$key}->{$widget})) {
      delete($GUI{Icons}->{widgets}->{$key}->{$widget});
    } else {
      $GUI{Icons}->{widgets}->{$key}->{$widget}->
	configure(-image=>$GUI{Icons}->{$key},
		  (($key eq "RadioOff") ?
		   (-selectimage=>$GUI{Icons}->{"RadioOn"}) :
		   ()
		  ),
		  (($key eq "Unchecked") ?
		   (-selectimage=>$GUI{Icons}->{"Checked"}) :
		   ()
		  ),
		 );
    }
  }
}


##############################################################################
#
# jarlMainIF_InitIcons - predefine the icons so that we can easily use them
#                      later
#
##############################################################################
sub jarlMainIF_InitIcons {

  my $widget = $GUI{top}->Label(-text=>"Test",
				-font=>$GUI{fonts}->{normal},
				-padx=>0,
				-pady=>0);
  my $height = ($widget->reqheight() - 7);

  my $size = "15";
  $size = "20" if ($height > 13);
  $size = "25" if ($height > 16);
  $size = "30" if ($height > 21);

  #
  # General Icons
  #
  # NOTE!!!
  # Must remain in the following order: Checked -> Unchecked
  #                                     RadioOn -> RadioOff
  #
  &jarlMainIF_InitIcon("Checked",$size,"checked.xpm");
  &jarlMainIF_InitIcon("Unchecked",$size,"unchecked.xpm");
  &jarlMainIF_InitIcon("RadioOn",$size,"radio_on.xpm");
  &jarlMainIF_InitIcon("RadioOff",$size,"radio_off.xpm");

  #
  # ToolBar Icons
  #
  &jarlMainIF_InitIcon("Connected",$size,"connected.xpm");
  &jarlMainIF_InitIcon("Disconnected",$size,"disconnected.xpm");
  &jarlMainIF_InitIcon("ShowOnline",$size,"show-online.xpm");
  &jarlMainIF_InitIcon("ShowMixed",$size,"show-mixed.xpm");
  &jarlMainIF_InitIcon("NewMessage",$size,"newmessage.xpm");
  &jarlMainIF_InitIcon("SendMessage",$size,"message-send.xpm");

  #
  # Roster Icons
  #
  &jarlMainIF_InitIcon("Open",$size,"open.xpm");
  &jarlMainIF_InitIcon("Closed",$size,"closed.xpm");
  &jarlMainIF_InitIcon("Resource",$size,"resource.xpm");

  &jarlMainIF_InitIcon("Available",$size,"available.xpm");
  &jarlMainIF_InitIcon("AvailableTo",$size,"available-to.xpm");
  &jarlMainIF_InitIcon("AvailableFrom",$size,"available-from.xpm");
  &jarlMainIF_InitIcon("AvailableNone",$size,
		       "available.xpm",
		       "overlay-none.xpm",
		      );

  &jarlMainIF_InitIcon("AvailableChat",$size,
		       "available.xpm",
		       "overlay-chat.xpm");

  &jarlMainIF_InitIcon("AvailableChatTo",$size,
		       "available-to.xpm",
		       "overlay-chat.xpm");
  &jarlMainIF_InitIcon("AvailableChatFrom",$size,
		       "available-from.xpm",
		       "overlay-chat.xpm");

  &jarlMainIF_InitIcon("AvailableAway",$size,
		       "available.xpm",
		       "overlay-away.xpm");
  &jarlMainIF_InitIcon("AvailableAwayTo",$size,
		       "available-to.xpm",
		       "overlay-away.xpm");
  &jarlMainIF_InitIcon("AvailableAwayFrom",$size,
		       "available-from.xpm",
		       "overlay-away.xpm");

  &jarlMainIF_InitIcon("AvailableXA",$size,
		       "available.xpm",
		       "overlay-xa.xpm");
  &jarlMainIF_InitIcon("AvailableXATo",$size,
		       "available-to.xpm",
		       "overlay-xa.xpm");
  &jarlMainIF_InitIcon("AvailableXAFrom",$size,
		       "available-from.xpm",
		       "overlay-xa.xpm");

  &jarlMainIF_InitIcon("AvailableDND",$size,
		       "available.xpm",
		       "overlay-dnd.xpm");
  &jarlMainIF_InitIcon("AvailableDNDTo",$size,
		       "available-to.xpm",
		       "overlay-dnd.xpm");
  &jarlMainIF_InitIcon("AvailableDNDFrom",$size,
		       "available-from.xpm",
		       "overlay-dnd.xpm");

  &jarlMainIF_InitIcon("Unavailable",$size,
		       "unavailable.xpm");
  &jarlMainIF_InitIcon("UnavailableTo",$size,
		       "unavailable-to.xpm");
  &jarlMainIF_InitIcon("UnavailableFrom",$size,
		       "unavailable-from.xpm");
  &jarlMainIF_InitIcon("UnavailableNone",$size,
		       "unavailable.xpm",
		       "overlay-none.xpm",
		      );

  #
  # Secure Icons
  #
  &jarlMainIF_InitIcon("AvailableSecure",$size,
		       "available.xpm",
		       "overlay-secure.xpm");
  &jarlMainIF_InitIcon("AvailableToSecure",$size,
		       "available-to.xpm",
		       "overlay-secure.xpm");
  &jarlMainIF_InitIcon("AvailableFromSecure",$size,
		       "available-from.xpm",
		       "overlay-secure.xpm");

  &jarlMainIF_InitIcon("AvailableChatSecure",$size,
		       "available.xpm",
		       "overlay-chat.xpm",
		       "overlay-secure.xpm");
  &jarlMainIF_InitIcon("AvailableChatToSecure",$size,
		       "available-to.xpm",
		       "overlay-chat.xpm",
		       "overlay-secure.xpm");
  &jarlMainIF_InitIcon("AvailableChatFromSecure",$size,
		       "available-from.xpm",
		       "overlay-chat.xpm",
		       "overlay-secure.xpm");

  &jarlMainIF_InitIcon("AvailableAwaySecure",$size,
		       "available.xpm",
		       "overlay-away.xpm",
		       "overlay-secure.xpm");
  &jarlMainIF_InitIcon("AvailableAwayToSecure",$size,
		       "available-to.xpm",
		       "overlay-away.xpm",
		       "overlay-secure.xpm");
  &jarlMainIF_InitIcon("AvailableAwayFromSecure",$size,
		       "available-from.xpm",
		       "overlay-away.xpm",
		       "overlay-secure.xpm");

  &jarlMainIF_InitIcon("AvailableXASecure",$size,
		       "available.xpm",
		       "overlay-xa.xpm",
		       "overlay-secure.xpm");
  &jarlMainIF_InitIcon("AvailableXAToSecure",$size,
		       "available-to.xpm",
		       "overlay-xa.xpm",
		       "overlay-secure.xpm");
  &jarlMainIF_InitIcon("AvailableXAFromSecure",$size,
		       "available-from.xpm",
		       "overlay-xa.xpm",
		       "overlay-secure.xpm");

  &jarlMainIF_InitIcon("AvailableDNDSecure",$size,
		       "available.xpm",
		       "overlay-dnd.xpm",
		       "overlay-secure.xpm");
  &jarlMainIF_InitIcon("AvailableDNDToSecure",$size,
		       "available-to.xpm",
		       "overlay-dnd.xpm",
		       "overlay-secure.xpm");
  &jarlMainIF_InitIcon("AvailableDNDFromSecure",$size,
		       "available-from.xpm",
		       "overlay-dnd.xpm",
		       "overlay-secure.xpm");

  #
  # Interface Icons
  #
  &jarlMainIF_InitIcon("Disk",$size,"disk.xpm");
  &jarlMainIF_InitIcon("Reply",$size,"reply.xpm");
  &jarlMainIF_InitIcon("Trash",$size,"trash.xpm");
  &jarlMainIF_InitIcon("Clear",$size,"clear.xpm");
  &jarlMainIF_InitIcon("Leave",$size,"leave.xpm");
#  &jarlMainIF_InitIcon("TopicChange",$size,"topic_change.xpm");
  &jarlMainIF_InitIcon("UserListShow",$size,"userlist_show.xpm");
  &jarlMainIF_InitIcon("UserListHide",$size,"userlist_hide.xpm");
  &jarlMainIF_InitIcon("SecureOn",$size,"secure-on.xpm");
  &jarlMainIF_InitIcon("SecureOff",$size,"secure-off.xpm");
  &jarlMainIF_InitIcon("SecureMessage",$size,"secure-message.xpm");

  #
  # MulColListbox icons
  #
  &jarlMainIF_InitIcon("MCLmarked",$size,"mcl_marked.xpm");
  &jarlMainIF_InitIcon("MCLdiamond",$size,"mcl_diamond.xpm");
  &jarlMainIF_InitIcon("MCLerror",$size,"mcl_error.xpm");
  &jarlMainIF_InitIcon("MCLsystem",$size,"mcl_system.xpm");
  &jarlMainIF_InitIcon("MCLorderup",$size,"mcl_orderup.xpm");
  &jarlMainIF_InitIcon("MCLorderdown",$size,"mcl_orderdown.xpm");
}


##############################################################################
#
# jarlMainIF_Loop - this is the Loop of code that allows Jarl to interact with
#                 Jabber and still be able to click on the GUI and have it
#                 work.
#
##############################################################################
sub jarlMainIF_Loop {
  $Debug->Log2("jarlMainIF_Loop: start");
  $jabber{checking} = 1;
  if (exists($jabber{client}) && ($jabber{client}->Connected())) {
    my $haveXML = 1;
    while($haveXML == 1) {
      $haveXML = $jabber{client}->Process(0);
      if (!defined($haveXML)) {
	if (Exists($TabBar)) {
	  $TabBar->ShowTab("status");
	  $TabBar->RaiseTab("status");
	}
	&jarlMainIF_StatusAdd("The connection to the server was lost...");
	$Debug->Log0("ERROR: the connection was lost.  (",$jabber{client}->GetErrorCode(),")");
	$jabber{reconnect} = 1;
	&jarlDisconnect();
	foreach (0..19) {
	  &jarlMainIF_StatusAdd("Waiting 5 seconds...");
	  undef($semaphore);
	  $GUI{top}->after(5000,sub{ $semaphore = 1; });
	  $GUI{top}->waitVariable(\$semaphore);
	  &jarlMainIF_StatusAdd("Attempting to reconnect...(".($_+1)."/20)");
	  last if defined(&jarlConnect());
	  &jarlMainIF_StatusAdd("Failed to reconnect...");
	}	
	if (exists($jabber{client}) && ($jabber{client}->Connected())) {
	  &jarlMainIF_StatusAdd("Reconnected to server...");
	} else {
	  $haveXML = 0;
	  &jarlMainIF_StatusAdd("Could not reconnect to server...");
	}
      }
    }
  }
  $jabber{checking} = 0;
  $GUI{top}->after(1500, sub { &jarlMainIF_Loop() });

#  my $time = &Net::Jabber::GetTimeStamp("local",undef,"normal");
#  ($jabber{time}) = ($time =~ /^(.*)\:\d\d$/);

  $Debug->Log2("jarlMainIF_Loop: end");
}


##############################################################################
#
# jarlMainIF_GUI - Step 2 in the GUI creation process.  This defines the entire
#                main GUI.
#
##############################################################################
sub jarlMainIF_GUI {
  $Debug->Log0("Start the main GUI");

  $GUI{top}->geometry("300x400");
  $GUI{top}->title("Jarl v".$VERSION);

  &jarlMainIF_MenuGUI();
  &jarlMainIF_ToolBarGUI();

  $GUI{Main}->{top} =
    $GUI{top}->
      Frame(-background=>$GUI{color}->{window}->{bg}->{normal},
	    -foreground=>$GUI{color}->{window}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'both',
		   -expand=>1);

  $TabBar =
    $GUI{Main}->{top}->
      TabBar(-background=>$GUI{color}->{jarl}->{main}->{bg}->{dark},
	     -tabthickness=>$GUI{width}->{jarl}->{main}->{tabs}->{thickness},
	     -tabfill=>$GUI{color}->{bg}->{light},
	     -tabbackground=>$GUI{color}->{bg}->{normal},
	     -tabdisabledbackground=>$GUI{color}->{bg}->{normaldark},
	     -tabforeground=>$GUI{color}->{fg}->{dark},
	     -tabfont=>$GUI{fonts}->{normal},
	     -tabpadx=>$GUI{width}->{jarl}->{main}->{pad},
	     -tabpady=>$GUI{height}->{jarl}->{main}->{pad},
	     -undockedtitleprefix=>"Jarl v$VERSION"
	    )->pack(-side=>'top',
		    -fill=>'both',
		    -expand=>1);

  $GUI{Login}->{top} = $TabBar->AddTab(-tag=>"login",
				       -text=>"Login");
  $TabBar->RaiseTab("login");
  &jarlLoginIF_GUI();

  $GUI{Roster}->{top} = $TabBar->AddTab(-tag=>"roster",
					-text=>"Roster",
					-type=>"docked");
  $GUI{Normal}->{top} = $TabBar->AddTab(-tag=>"messages",
					-text=>"Messages",
				        -type=>"docked");
  $GUI{Status}->{top} = $TabBar->AddTab(-tag=>"status",
					-text=>"Status");
  $TabBar->HideTab("status");
  $GUI{Debug}->{top} = $TabBar->AddTab(-tag=>"debug",
				       -text=>"Debug");
  $TabBar->HideTab("debug");

  $GUI{top}->deiconify();

  &jarlLoginIF_SetStatus(10);

  &jarlLoginIF_SetStatus(30);

  &jarlLoginIF_SetStatus(40);

  #---------------------------------------------------------------------------
  # Jabber Tab
  #---------------------------------------------------------------------------
  &jarlRosterIF_GUI(\$GUI{Roster}->{top});
  &jarlLoginIF_SetStatus(50);

  &jarlNormalIF_NewGUI($GUI{Normal}->{top});
  &jarlLoginIF_SetStatus(80);

  #---------------------------------------------------------------------------
  # Status Window
  #---------------------------------------------------------------------------
  $GUI{Status}->{LogHeader}->{top} =
    $GUI{Status}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	   )->pack(-side=>"top",
		   -fill=>"x");

  $GUI{Status}->{LogHeader}->{Label} =
    $GUI{Status}->{LogHeader}->{top}->
      Label(-text=>"Log",
	    -anchor=>"w",
	    -font=>$GUI{fonts}->{header},
	    -background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	   )->pack(-side=>"left",
		   -fill=>"x",
		   -padx=>5);

  $GUI{Status}->{LogHeader}->{Clear} =
    $GUI{Status}->{LogHeader}->{top}->
      Button(-image=>$GUI{Icons}->{Clear},
	     -background=>$GUI{color}->{jarl}->{newmessage}->{bg}->{normal},
	     -foreground=>$GUI{color}->{jarl}->{newmessage}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{jarl}->{newmessage}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{
	       $GUI{Status}->{Window}->{Text}->configure(-state=>"normal");
	       $GUI{Status}->{Window}->{Text}->delete("1.0","end");
	       $GUI{Status}->{Window}->{Text}->configure(-state=>"disabled");
	     }
	    )->pack(-side=>"right",
		    -padx=>5);
  &jarlMainIF_RegisterIcon($GUI{Status}->{LogHeader}->{Clear},
			 "Clear");
  $GUI{ToolBar}->{Balloon}->
    attach($GUI{Status}->{LogHeader}->{Clear},
	   -balloonmsg=>"Clear the Status Log ");

  $GUI{Status}->{Window}->{top} =
    $GUI{Status}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	    -relief=>"sunken",
	    -borderwidth=>2
	   )->pack(-side=>"top",
		   -fill=>"both",
		   -expand=>1,
		   -padx=>5,
		   -pady=>5);

  $GUI{Status}->{Window}->{Scrolled} =
    $GUI{Status}->{Window}->{top}->
      Scrolled("Text",
	       -scrollbars=>"e",
	       -background=>$GUI{color}->{jarl}->{main}->{bg}->{light},
	       -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	       -font=>$GUI{fonts}->{normal},
	       -borderwidth=>0,
	       -highlightthickness=>0,
	       -selectborderwidth=>0,
	       -exportselection=>1,
	       -takefocus=>0,
	       -wrap=>"word",
	       -state=>"disabled",
	       -height=>1,
	       -width=>1,
	      )->pack(-side=>"left",
		      -fill=>"both",
		      -expand=>1,
		      -padx=>0,
		      -pady=>0);

  $GUI{Status}->{Window}->{Scrollbar} =
    $GUI{Status}->{Window}->{Scrolled}->Subwidget("yscrollbar");
  $GUI{Status}->{Window}->{Scrollbar}->
    configure(-width=>10,
	      -borderwidth=>1,
	      -relief=>"flat");
  $GUI{Status}->{Window}->{Text} =
    $GUI{Status}->{Window}->{Scrolled}->Subwidget("text");

  $GUI{Status}->{Window}->{Text}->bind("Tk::Text","<Button-3>",sub{});

  $GUI{Status}->{Window}->{Text}->
    bind("<Button-4>",
	 sub{
	   $GUI{Status}->{Window}->{Text}->yviewScroll(-1,"units");
	 });
  $GUI{Status}->{Window}->{Text}->
    bind("<Button-5>",
	 sub{
	   $GUI{Status}->{Window}->{Text}->yviewScroll(1,"units");
	 });

  #---------------------------------------------------------------------------
  # Debug Window
  #---------------------------------------------------------------------------
  &jarlDebugIF_NewGUI();

  &jarlLoginIF_SetStatus(90);

  $GUI{StatusBar}->{top} =
    $GUI{top}->
      Frame(-borderwidth=>1,
	    -relief=>"raised",
	    -background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	   )->pack(-side=>"bottom",
		   -fill=>"x");

  $GUI{StatusBar}->{Icon} =
    $GUI{StatusBar}->{top}->
      Label(-image=>$GUI{Icons}->{Unavailable},
	    -relief=>"sunken",
	    -borderwidth=>1,
	    -background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	   )->pack(-side=>"left",
		   -pady=>1,
		   -padx=>2);
  &jarlMainIF_RegisterIcon($GUI{StatusBar}->{Icon},"Unavailable");
  $GUI{StatusBar}->{vars}->{CurrentIcon} = "Unavailable";

  $GUI{StatusBar}->{PresenceString} =
    $GUI{StatusBar}->{top}->
      Label(-textvariable=>\$jabber{presenceString},
	    -relief=>"sunken",
	    -borderwidth=>1,
	    -background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -anchor=>"w",
	    -padx=>2,
	   )->pack(-side=>"left",
		   -fill=>"x",
		   -expand=>1,
		   -pady=>1,
		   -padx=>2);

  $jabber{presenceString} = "Waiting to connect";

#  $GUI{StatusBar}->{Clock} =
#    $GUI{StatusBar}->{top}->
#      Label(-textvariable=>\$jabber{time},
#	    -relief=>"sunken",
#	    -width=>15,
#	    -borderwidth=>1,
#	    -background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
#	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
#	    -font=>$GUI{fonts}->{normal},
#	   )->pack(-side=>"right",
#		   -pady=>1,
#		   -padx=>2);

#  my $time = &Net::Jabber::GetTimeStamp("local",undef,"normal");
#  ($jabber{time}) = ($time =~ /^(.*)\:\d\d$/);

#  $TabBar->RaiseTab("status");

  $Debug->Log1("jarlMainGUI: finish");
  &jarlLoginIF_SetStatus(100);

  $GUI{top}->deiconify();
  $GUI{top}->lower($GUI{Login}->{window}) if Exists($GUI{Login}->{window});

  $GUI{Login}->{Connect}->configure(state=>"normal");

  $GUI{top}->after(1500, sub { &jarlMainIF_Loop() });
}


##############################################################################
#
# jarlMainIF_MenuGUI - define the main menu bar and populate it
#
##############################################################################
sub jarlMainIF_MenuGUI {
  $GUI{menuBar} =
    $GUI{top}->
      Frame(-borderwidth=>1,
	    -relief=>"raised",
	    -background=>$GUI{color}->{jarl}->{menu}->{background},
	    -foreground=>$GUI{color}->{jarl}->{menu}->{text},
	   )->pack(-side=>"top",
		   -anchor=>"w",
		   -fill=>"x");

  &jarlMainIF_FileMenu();
  &jarlMainIF_AgentsMenu();
  &jarlMainIF_PresenceMenu();
  &jarlMainIF_RosterMenu();
  &jarlMainIF_HelpMenu();
}


##############################################################################
#
# jarlMainIF_FileMenu - define the File menu and populate it
#
##############################################################################
sub jarlMainIF_FileMenu {

  $GUI{fileMenu}->{menu} =
    $GUI{menuBar}->
      Menubutton(-text=>"Jarl",
		 -relief=>"flat",
		 -borderwidth=>2,
		 -tearoff=>0,
		 -font=>$GUI{fonts}->{normal},
		 -background=>$GUI{color}->{jarl}->{menu}->{background},
		 -foreground=>$GUI{color}->{jarl}->{menu}->{text},
		)->pack(-side=>"left");

  $GUI{fileMenu}->{menu}->
    command(-label=>"Config...",
	    -font=>$GUI{fonts}->{normal},
	    -background=>$GUI{color}->{jarl}->{menu}->{background},
	    -foreground=>$GUI{color}->{jarl}->{menu}->{text},
	    -command=>sub{
	      &jarlConfigIF_GUI();
	    });

  $GUI{fileMenu}->{menu}->
    command(-label=>"Profiles...",
	    -font=>$GUI{fonts}->{normal},
	    -background=>$GUI{color}->{jarl}->{menu}->{background},
	    -foreground=>$GUI{color}->{jarl}->{menu}->{text},
	    -command=>sub{
	      &jarlProfileIF_EditorGUI();
	    });

  $GUI{fileMenu}->{menu}->
    separator(-background=>$GUI{color}->{jarl}->{menu}->{background});

  $GUI{fileMenu}->{groupchat} =
    $GUI{fileMenu}->{menu}->
      command(-label=>"Groupchat",
	      -font=>$GUI{fonts}->{normal},
	      -background=>$GUI{color}->{jarl}->{menu}->{background},
	      -foreground=>$GUI{color}->{jarl}->{menu}->{text},
	      -state=>"normal",
	      -command=>sub{
		&jarlGroupChatIF_GUI();
	      });

  $GUI{fileMenu}->{favgroups}->{menu} =
    $GUI{fileMenu}->{menu}->
      Menu(-tearoff=>0,
	   -borderwidth=>2,
	   -relief=>"raised",
	   -font=>$GUI{fonts}->{normal},
	   -background=>$GUI{color}->{bg}->{normal},
	   -foreground=>$GUI{color}->{fg}->{dark}
	  );

  $GUI{fileMenu}->{menu}->
    cascade(-label=>"Favorite Groups",
	    -menu=>$GUI{fileMenu}->{favgroups}->{menu},
	    -font=>$GUI{fonts}->{normal},
	    -background=>$GUI{color}->{jarl}->{menu}->{background},
	    -foreground=>$GUI{color}->{jarl}->{menu}->{text},
	    -state=>"normal"
	   );

  $GUI{fileMenu}->{menu}->
    separator(-background=>$GUI{color}->{jarl}->{menu}->{background});

  $GUI{fileMenu}->{ShowStatus} =
    $GUI{fileMenu}->{menu}->
      command(-label=>"Show Status",
	      -font=>$GUI{fonts}->{normal},
	      -background=>$GUI{color}->{jarl}->{menu}->{background},
	      -foreground=>$GUI{color}->{jarl}->{menu}->{text},
	      -command=>sub{
		if (Exists($TabBar) && $TabBar->ismapped()) {
		  $config{showstatus} ^= 1;
		  if ($config{showstatus} == 1) {
		    $TabBar->ShowTab("status");
		    $GUI{fileMenu}->{ShowStatus}->configure(-label=>"Hide Status");
		  } else {
		    $TabBar->HideTab("status");
		    $GUI{fileMenu}->{ShowStatus}->configure(-label=>"Show Status");
		  }
		}
	      }
	     );

  $GUI{fileMenu}->{ShowDebug} =
    $GUI{fileMenu}->{menu}->
      command(-label=>"Show Debug",
	      -font=>$GUI{fonts}->{normal},
	      -background=>$GUI{color}->{jarl}->{menu}->{background},
	      -foreground=>$GUI{color}->{jarl}->{menu}->{text},
	      -command=>sub{
		if (Exists($TabBar) && $TabBar->ismapped()) {
		  $config{showdebug} ^= 1;
		  if ($config{showdebug} == 1) {
		    $TabBar->ShowTab("debug");
		    $GUI{fileMenu}->{ShowDebug}->configure(-label=>"Hide Debug");
		  } else {
		    $TabBar->HideTab("debug");
		    $GUI{fileMenu}->{ShowDebug}->configure(-label=>"Show Debug");
		  }
		}
	      }
	     );

  $GUI{fileMenu}->{menu}->
    separator(-background=>$GUI{color}->{jarl}->{menu}->{background});

  $GUI{fileMenu}->{menu}->
    command(-label=>"Logout",
	    -font=>$GUI{fonts}->{normal},
	    -background=>$GUI{color}->{jarl}->{menu}->{background},
	    -foreground=>$GUI{color}->{jarl}->{menu}->{text},
	    -command=>sub{
	      &jarlDisconnect();
	      delete($jabber{server});
	      delete($jabber{port});
	      delete($jabber{connectiontype});
	      delete($jabber{username});
	      delete($jabber{password});
	      delete($jabber{resource});
	      delete($jabber{ssl});
	      $TabBar->ShowTab("login");
	    });
  $GUI{fileMenu}->{menu}->
    command(-label=>"Quit",
	    -font=>$GUI{fonts}->{normal},
	    -background=>$GUI{color}->{jarl}->{menu}->{background},
	    -foreground=>$GUI{color}->{jarl}->{menu}->{text},
	    -command=>sub{
	      &jarlDisconnect();
	      $GUI{top}->destroy;
	    });
}


##############################################################################
#
# jarlMainIF_PopulateFavGroupsMenu - populate the favorite groups cascading menu
#
##############################################################################
sub jarlMainIF_PopulateFavGroupsMenu {

  while($GUI{fileMenu}->{favgroups}->{menu}->type(0) ne "") {
    $GUI{fileMenu}->{favgroups}->{menu}->delete(0);
  }

  if (scalar(keys(%{$config{favgroups}})) == 0) {
    $GUI{fileMenu}->{favgroups}->{menu}->
      command(-label=>"none",
	      -font=>$GUI{fonts}->{normal},
	      -background=>$GUI{color}->{bg}->{normal},
	      -foreground=>$GUI{color}->{fg}->{dark},
	      -state=>"disabled"
	     );
  } else {
    foreach my $group (sort {$a cmp $b} keys(%{$config{favgroups}})) {
      $GUI{fileMenu}->{favgroups}->{menu}->
	command(-label=>$group,
		-font=>$GUI{fonts}->{normal},
		-background=>$GUI{color}->{bg}->{normal},
		-foreground=>$GUI{color}->{fg}->{dark},
		-command=>sub{
		  &jarlGroupChat_Join($config{favgroups}->{$group}->{channel}."\@".$config{favgroups}->{$group}->{server},$config{favgroups}->{$group}->{nick1});
		}
	       );
    }
  }
}


##############################################################################
#
# jarlMainIF_AgentsMenu - define the Agents Menu and populate it
#
##############################################################################
sub jarlMainIF_AgentsMenu {

  $GUI{agentsMenu}->{menu} =
    $GUI{menuBar}->
      Menubutton(-text=>"Agents",
		 -relief=>"flat",
		 -borderwidth=>2,
		 -tearoff=>0,
		 -font=>$GUI{fonts}->{normal},
		 -background=>$GUI{color}->{jarl}->{menu}->{background},
		 -foreground=>$GUI{color}->{jarl}->{menu}->{text},
		)->pack(-side=>"left");

  $GUI{agentsMenu}->{menu}->
    separator(-background=>$GUI{color}->{jarl}->{menu}->{background});

  $GUI{agentsMenu}->{menu}->
    command(-label=>"Custom list coming soon...",
	    -font=>$GUI{fonts}->{normal},
	    -background=>$GUI{color}->{jarl}->{menu}->{background},
	    -foreground=>$GUI{color}->{jarl}->{menu}->{text},
	    -state=>"disabled",
	    -command=>sub{
	    });

}


##############################################################################
#
# jarlMainIF_InitFonts - initialize the Fonts
#
##############################################################################
sub jarlMainIF_PopulateAgentsMenu {

  while($GUI{agentsMenu}->{menu}->menu->type(0) ne "separator") {
    $GUI{agentsMenu}->{menu}->menu->delete(0);
  }

  undef %agents;
  undef %transportJIDs;
  undef %groupchatJIDs;
  undef %searchJIDs;

  %agents = $jabber{client}->AgentsGet(to=>$jabber{server})
    if (exists($jabber{client}) && ($jabber{client}->Connected()));

  if (!defined(%agents)) {
    $GUI{agentsMenu}->{menu}->menu->
      insert(0,
	     "command",
	     -label=>"none",
	     -font=>$GUI{fonts}->{normal},
	     -background=>$GUI{color}->{jarl}->{menu}->{background},
	     -foreground=>$GUI{color}->{jarl}->{menu}->{text},
	     -state=>"disabled"
	    );
  } else {

    my $agentJID;
    foreach $agentJID (sort {$agents{$b}->{order} <=> $agents{$a}->{order}} keys(%agents)) {
      $GUI{agentsMenu}->{menu}->menu->
	insert(0,
	       "command",
	       -label=>$agents{$agentJID}->{name},
	       -font=>$GUI{fonts}->{normal},
	       -background=>$GUI{color}->{jarl}->{menu}->{background},
	       -foreground=>$GUI{color}->{jarl}->{menu}->{text},
	       -command=>sub{
		 &jarlAgentIF_GUI($agentJID,%{$agents{$agentJID}});
	       }
	      );
      $transportJIDs{$agentJID} = 1;
      $searchJIDs{$agentJID} = 1 if ($agents{$agentJID}->{search} == 1);
      $groupchatJIDs{$agentJID} = 1 if ($agents{$agentJID}->{groupchat} == 1);
    }
  }

#  if (scalar(keys(%groupchatJIDs)) == 0) {
#    $GUI{fileMenu}->{groupchat}->configure(-state=>"disabled");
#  } else {
#    $GUI{fileMenu}->{groupchat}->configure(-state=>"normal");
#  }

  if (scalar(keys(%searchJIDs)) == 0) {
    $GUI{rosterMenu}->{search}->configure(-state=>"disabled");
  } else {
    $GUI{rosterMenu}->{search}->configure(-state=>"normal");
  }

}


##############################################################################
#
# jarlMainIF_PresenceMenu - define the Presence menu and populate it
#
##############################################################################
sub jarlMainIF_PresenceMenu {

  $GUI{presenceMenu}->{menu} =
    $GUI{menuBar}->
      Menubutton(-text=>"Presence",
		 -relief=>"flat",
		 -borderwidth=>2,
		 -tearoff=>0,
		 -font=>$GUI{fonts}->{normal},
		 -background=>$GUI{color}->{jarl}->{menu}->{background},
		 -foreground=>$GUI{color}->{jarl}->{menu}->{text},
		)->pack(-side=>"left");

  $GUI{presenceMenu}->{menu}->
    command(-label=>"Available",
	    -font=>$GUI{fonts}->{normal},
	    -background=>$GUI{color}->{jarl}->{menu}->{background},
	    -foreground=>$GUI{color}->{jarl}->{menu}->{text},
	    -command=>sub{
	      $jabber{presence}->Set(status=>"Online");
	    });

  $GUI{presenceMenu}->{menu}->
    command(-label=>"Unavailable",
	    -font=>$GUI{fonts}->{normal},
	    -background=>$GUI{color}->{jarl}->{menu}->{background},
	    -foreground=>$GUI{color}->{jarl}->{menu}->{text},
	    -command=>sub{
	      $jabber{presence}->Set(type=>"unavailable",
				     status=>"Offline");
	    });

  $GUI{presenceMenu}->{menu}->
    command(-label=>"Free for Chat",
	    -font=>$GUI{fonts}->{normal},
	    -background=>$GUI{color}->{jarl}->{menu}->{background},
	    -foreground=>$GUI{color}->{jarl}->{menu}->{text},
	    -command=>sub{
	      $jabber{presence}->Set(show=>"chat",
				     status=>"I want to chat");
	    });

  $GUI{presenceMenu}->{menu}->
    separator(-background=>$GUI{color}->{jarl}->{menu}->{background});

  my $presenceType;
  foreach $presenceType ("dnd","away","xa") {

    $GUI{presenceMenu}->{$presenceType}->{menu} =
      $GUI{presenceMenu}->{menu}->
	Menu(-tearoff=>0,
	     -borderwidth=>2,
	     -relief=>"raised",
	     -font=>$GUI{fonts}->{normal},
	     -background=>$GUI{color}->{jarl}->{menu}->{background},
	     -foreground=>$GUI{color}->{jarl}->{menu}->{text});

    my $index;
    foreach $index (0..$#{$config{presence}->{$presenceType}->{status}}) {
      $GUI{presenceMenu}->{$presenceType}->{menu}->
	command(-label=>$config{presence}->{$presenceType}->{status}->[$index],
		-font=>$GUI{fonts}->{normal},
		-background=>$GUI{color}->{jarl}->{menu}->{background},
		-foreground=>$GUI{color}->{jarl}->{menu}->{text},
		-command=>sub{
		  $jabber{presence}->Set(show=>$presenceType,
					 status=>$config{presence}->{$presenceType}->{status}->[$index]);
		});
    }

    $GUI{presenceMenu}->{menu}->
      cascade(-label=>$config{presence}->{$presenceType}->{name},
	      -menu=>$GUI{presenceMenu}->{$presenceType}->{menu},
	      -font=>$GUI{fonts}->{normal},
	      -background=>$GUI{color}->{jarl}->{menu}->{background},
	      -foreground=>$GUI{color}->{jarl}->{menu}->{text});
  }

  $GUI{presenceMenu}->{menu}->
    separator(-background=>$GUI{color}->{jarl}->{menu}->{background});

  $GUI{presenceMenu}->{menu}->
    command(-label=>"Custom Presence...",
	    -font=>$GUI{fonts}->{normal},
	    -background=>$GUI{color}->{jarl}->{menu}->{background},
	    -foreground=>$GUI{color}->{jarl}->{menu}->{text},
	    -command=>sub{
	      &jarlPresenceIF_CustomGUI();
	    });

}


##############################################################################
#
# jarlMainIF_RosterMenu - define the Roster menu and populate it
#
##############################################################################
sub jarlMainIF_RosterMenu {

  $GUI{rosterMenu}->{menu} =
    $GUI{menuBar}->
      Menubutton(-text=>"Roster",
		 -relief=>"flat",
		 -borderwidth=>2,
		 -tearoff=>0,
		 -font=>$GUI{fonts}->{normal},
		 -background=>$GUI{color}->{jarl}->{menu}->{background},
		 -foreground=>$GUI{color}->{jarl}->{menu}->{text},
		)->pack(-side=>"left");

  $GUI{rosterMenu}->{search} =
    $GUI{rosterMenu}->{menu}->
      command(-label=>"Search for User",
	      -font=>$GUI{fonts}->{normal},
	      -background=>$GUI{color}->{jarl}->{menu}->{background},
	      -foreground=>$GUI{color}->{jarl}->{menu}->{text},
	      -state=>"normal",
	      -command=>sub{
		&jarlSearchIF_GUI();
	      });

  $GUI{rosterMenu}->{menu}->
    separator(-background=>$GUI{color}->{jarl}->{menu}->{background});

  $GUI{rosterMenu}->{menu}->
    command(-label=>"Add Roster Item",
	    -font=>$GUI{fonts}->{normal},
	    -background=>$GUI{color}->{jarl}->{menu}->{background},
	    -foreground=>$GUI{color}->{jarl}->{menu}->{text},
	    -command=>sub {
	      &jarlRosterIF_EditItemGUI();
	    }
	   );
  $GUI{rosterMenu}->{menu}->
    command(-label=>"Edit Roster Item",
	    -font=>$GUI{fonts}->{normal},
	    -background=>$GUI{color}->{jarl}->{menu}->{background},
	    -foreground=>$GUI{color}->{jarl}->{menu}->{text},
	    -command=>sub{
	      return unless (defined($Roster->Selected()) &&
			     ($Roster->Selected() ne ""));
	      my $toJID = new Net::Jabber::JID($Roster->Selected());
	      &jarlRosterIF_EditItemGUI($toJID);
	    }
	   );
  $GUI{rosterMenu}->{menu}->
    command(-label=>"Delete Roster Item",
	    -font=>$GUI{fonts}->{normal},
	    -background=>$GUI{color}->{jarl}->{menu}->{background},
	    -foreground=>$GUI{color}->{jarl}->{menu}->{text},
	    -command=>sub{
	      return unless (defined($Roster->Selected()) &&
			     ($Roster->Selected() ne ""));
	      my $toJID = new Net::Jabber::JID($Roster->Selected());
	      &jarlRosterIF_VerifyDelete($toJID);
	    }
	   );
}


##############################################################################
#
# jarlMainIF_HelpMenu - define the Help menu and populate it
#
##############################################################################
sub jarlMainIF_HelpMenu {

  $GUI{helpMenu} =
    $GUI{menuBar}->
      Menubutton(-text=>"Help",
		 -relief=>"flat",
		 -borderwidth=>2,
		 -tearoff=>0,
		 -font=>$GUI{fonts}->{normal},
		 -background=>$GUI{color}->{jarl}->{menu}->{background},
		 -foreground=>$GUI{color}->{jarl}->{menu}->{text},
		)->pack(-side=>"right");

  $GUI{helpMenu}->
    command(-label=>"Help",
	    -font=>$GUI{fonts}->{normal},
	    -background=>$GUI{color}->{jarl}->{menu}->{background},
	    -foreground=>$GUI{color}->{jarl}->{menu}->{text},
	    -state=>"disabled",
	    -command=>sub{
	    }
	   );

  $GUI{helpMenu}->
    separator(-background=>$GUI{color}->{jarl}->{menu}->{background});


  $GUI{helpMenu}->
    command(-label=>"Jabber.org",
	    -font=>$GUI{fonts}->{normal},
	    -background=>$GUI{color}->{jarl}->{menu}->{background},
	    -foreground=>$GUI{color}->{jarl}->{menu}->{text},
	    -command=>sub{
	      &jarlFetchURL("http://jabber.org");
	    }
	   );

  $GUI{helpMenu}->
    command(-label=>"Jabber.org Docs",
	    -font=>$GUI{fonts}->{normal},
	    -background=>$GUI{color}->{jarl}->{menu}->{background},
	    -foreground=>$GUI{color}->{jarl}->{menu}->{text},
	    -command=>sub{
	      &jarlFetchURL("http://docs.jabber.org");
	    }
	   );

  $GUI{helpMenu}->
    command(-label=>"JabberCentral",
	    -font=>$GUI{fonts}->{normal},
	    -background=>$GUI{color}->{jarl}->{menu}->{background},
	    -foreground=>$GUI{color}->{jarl}->{menu}->{text},
	    -command=>sub{
	      &jarlFetchURL("http://www.jabbercentral.com");
	     }
	   );

  $GUI{helpMenu}->
    separator(-background=>$GUI{color}->{jarl}->{menu}->{background});

  $GUI{helpMenu}->
    command(-label=>"About",
	    -font=>$GUI{fonts}->{normal},
	    -background=>$GUI{color}->{jarl}->{menu}->{background},
	    -foreground=>$GUI{color}->{jarl}->{menu}->{text},
	    -command=>sub{
	      &jarlMainIF_About();
	    }
	   );
}


##############################################################################
#
# jarlMainIF_ToolBarGUI - define the toolbar, create the buttons and hook them
#                       up to do things when they are clicked.
#
##############################################################################
sub jarlMainIF_ToolBarGUI {
#  $GUI{ToolBar}->{top} =
#    $GUI{top}->
#      Frame(-borderwidth=>1,
#	    -relief=>"raised",
#	    -background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
#	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
#	   )->pack(-side=>"top",
#		   -anchor=>"w",
#		   -fill=>"x");

  $GUI{ToolBar}->{Balloon} =
    $GUI{top}->
      Balloon(-background=>$GUI{color}->{balloon}->{bg},
	      -foreground=>$GUI{color}->{balloon}->{fg},
	      -font=>$GUI{fonts}->{normal},
	      -initwait=>500
	     );
}


##############################################################################
#
# jarlMainIF_BuildForm - in some GUIs we need to build fields based on results
#                        from the server.  This function is a generalized way
#                        to do that.
#
##############################################################################
sub jarlMainIF_BuildForm {
  my (%form) = @_;

  foreach my $index (0..$#{$form{form}}) {
    next if (!defined($form{form}->[$index]) || ($form{form}->[$index] eq ""));
    my @options = @{delete($form{form}->[$index]->{options})};
    my @newOptions = ();
    foreach my $option (@options) {
      push(@newOptions,
	   [
	    (exists($option->{label}) ? $option->{label} : $option->{value}),
	    $option->{value}
	   ]);
    }
    $form{form}->[$index]->{type} = "listbox"
      if (($#newOptions > 10) &&
	  ($form{form}->[$index]->{type} eq "pulldown"));
    &jarlMainIF_AddField(widget=>$form{widget},
			 %{$form{form}->[$index]},
			 options=>\@newOptions
			);
  }
}


##############################################################################
#
# jarlMainIF_AddField - in some GUIs we need to add fields based on the result
#                     from the server.  This function is a generalized way
#                     to do that.
#
##############################################################################
sub jarlMainIF_AddField {
  my (%field) = @_;

  $field{widget}->{vars}->{$field{var}} = $field{value}
    if exists($field{value});
  $field{label} = ucfirst($field{var}) unless exists($field{label});

  $field{widget}->{Fields}->{$field{var}}->{top} =
    $field{widget}->{top}->
      Frame(-background=>$GUI{color}->{window}->{bg}->{normal},
	    -foreground=>$GUI{color}->{window}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'x');
  $field{widget}->{Fields}->{$field{var}}->{Label} =
    $field{widget}->{Fields}->{$field{var}}->{top}->
      Label(-text=>"$field{label}:",
	    -width=>$GUI{width}->{jarl}->{profileeditor}->{label},
	    -background=>$GUI{color}->{jarl}->{profileeditor}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{profileeditor}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -anchor=>'e'
	   )->pack(-side=>'left',
		   -anchor=>'e');
  if (($field{type} eq "entry") || ($field{type} eq "password")) {
    $field{widget}->{Fields}->{$field{var}}->{Entry} =
      $field{widget}->{Fields}->{$field{var}}->{top}->
	Entry(-textvariable=>\$field{widget}->{vars}->{$field{var}},
	      -width=>$GUI{width}->{jarl}->{profileeditor}->{entry},
	      -background=>$GUI{color}->{jarl}->{profileeditor}->{bg}->{light},
	      -foreground=>$GUI{color}->{jarl}->{profileeditor}->{fg}->{dark},
	      -font=>$GUI{fonts}->{normal},
	      -state=>"normal"
	     )->pack(-side=>'left',
		     -anchor=>'w');
    $field{widget}->{Fields}->{$field{var}}->{Entry}->configure(-show=>"*")
      if ($field{type} eq "password");
  }
  if ($field{type} eq "pulldown") {
    my $foo;
    $field{widget}->{Fields}->{$field{var}}->{Option} =
      $field{widget}->{Fields}->{$field{var}}->{top}->
	Optionmenu(-options=>[ @{$field{options}} ],
		   -textvariable=>\$foo,
		   -variable=>\$field{widget}->{vars}->{$field{var}},
		   -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
		   -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
		   -font=>$GUI{fonts}->{normal}
		  )->pack(-side=>'left',
			  -anchor=>'w');
  }
  if ($field{type} eq "listbox") {
    my $foo;
    $field{widget}->{Fields}->{$field{var}}->{Option} =
      $field{widget}->{Fields}->{$field{var}}->{top}->
	Listbox(-options=>[ @{$field{options}} ],
		   -textvariable=>\$foo,
		   -variable=>\$field{widget}->{vars}->{$field{var}},
		   -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
		   -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
		   -font=>$GUI{fonts}->{normal}
		  )->pack(-side=>'left',
			  -anchor=>'w');
  }
}


##############################################################################
#
# jarlMainIF_StatusBarChangeStatus - change the status bar status message for
#                                    a short time and then set it back to the
#                                    the previous state.
#
##############################################################################
sub jarlMainIF_StatusBarChangeStatus {
  my ($status) = @_;

  $Debug->Log3("jarlMainIF_StatusBarChangeStatus: start");
  $Debug->Log3("jarlMainIF_StatusBarChangeStatus: status($status)");

  if (exists($jabber{statusID})) {
    $Debug->Log3("jarlMainIF_StatusBarChangeStatus: there is a current status... cancel it");
    $jabber{statusID}->cancel();
  } else {
    $Debug->Log3("jarlMainIF_StatusBarChangeStatus: this is a new status... save current string as the default");
    $jabber{oldPresenceString} = $jabber{presenceString};
  }

  if ($status eq "") {
    $Debug->Log3("jarlMainIF_StatusBarChangeStatus: no status specified... save the current string as the default");
    $jabber{oldPresenceString} = $jabber{presenceString};
    return;
  }

  $jabber{presenceString} = $status;

  $jabber{statusID} =
    $GUI{top}->
      after(5000,
	    sub{
	      $Debug->Log3("jarlMainIF_StatusBarChangeStatus: after callback");
	      $Debug->Log3("jarlMainIF_StatusBarChangeStatus: restore original status");
	      $jabber{presenceString} = $jabber{oldPresenceString};
	      delete($jabber{statusID});
	    });

  $Debug->Log3("jarlMainIF_StatusBarChangeStatus: finish");
}


##############################################################################
#
# jarlMainIF_StatusBarChangePresence - change the status bar presence icon and
#                                      message for the users current status.
#
#       This function is called from Jarl::Presence and must exist in all
#     interface packages, even if just a stub.
#
##############################################################################
sub jarlMainIF_StatusBarChangePresence {
  my ($presence) = @_;
  my $string;

  if (ref($presence) eq "Net::Jabber::Presence") {
    $string = (($presence->GetType() eq "") ?
	       "available" :
	       $presence->GetType()
	      );
    $string = $presence->GetShow() if ($presence->GetShow() ne "");
    $string .= ": ".$presence->GetStatus() if ($presence->GetStatus() ne "");
  } else {
    $string = $presence;
  }
  my ($icon) = ($string =~ /^([^\:]+)\:?/);

  $jabber{presenceString} = "$jabber{username} is $string";
  &jarlMainIF_StatusBarChangeStatus();

  my $newIcon = &jarlRoster_PresenceIcon($Roster,$icon);
  &jarlMainIF_ChangeIcon($GUI{StatusBar}->{Icon},
		       $newIcon,
		       $GUI{StatusBar}->{vars}->{CurrentIcon});
  $GUI{StatusBar}->{vars}->{CurrentIcon} = $newIcon;
}


##############################################################################
#
# jarlMainIF_UpdateOnlineOnly - function call that tells the main roster what
#                             mode to be in and what the icon should be for
#                             toolbar.
#
##############################################################################
sub jarlMainIF_UpdateOnlineOnly {
  $Roster->ShowOnlineOnly() if ($config{onlineonly} == 1);
  $Roster->ShowAll() if ($config{onlineonly} == 0);

  &jarlMainIF_ChangeIcon($GUI{Roster}->{ToolBar}->{RosterShow},
		       ($config{onlineonly} == 1 ?
			"ShowOnline" :
			"ShowMixed"),
		       ($config{onlineonly} == 1 ?
			"ShowMixed" :
			"ShowOnline"));
}


##############################################################################
#
# jarlMainIF_UpdateShowStatus - function call that sets whether or not the
#                               Status Tab is visible or not
#
##############################################################################
sub jarlMainIF_UpdateShowStatus {

  if ($config{showstatus} == 1) {
    $TabBar->ShowTab("status");
    $GUI{fileMenu}->{ShowStatus}->configure(-label=>"Hide Status");
  } else {
    $TabBar->HideTab("status");
    $GUI{fileMenu}->{ShowStatus}->configure(-label=>"Show Status");
  }
}


##############################################################################
#
# jarlMainIF_UpdateShowDebug - function call that sets whether or not the Debug
#                            Tab is visible or not
#
##############################################################################
sub jarlMainIF_UpdateShowDebug {

  if ($config{showdebug} == 1) {
    $TabBar->ShowTab("debug");
    $GUI{fileMenu}->{ShowDebug}->configure(-label=>"Hide Debug");
  } else {
    $TabBar->HideTab("debug");
    $GUI{fileMenu}->{ShowDebug}->configure(-label=>"Show Debug");
  }
}


##############################################################################
#
# jarlMainIF_UpdateFontChange - Tk::Font is cool and all, but you can't bind to
#                             it.  Some of the custom GUI stuff needs to be
#                             resized if the font changes, hence this function
#                             was born to call the Refresh function in all of
#                             those objects if they exist.
#
##############################################################################
sub jarlMainIF_UpdateFontChange {

  &jarlMainIF_InitIcons();

  $TabBar->Refresh()
    if Tk::Exists($TabBar);
  $GUI{Config}->{TabBar}->Refresh()
    if Tk::Exists($GUI{Config}->{TabBar});
  foreach my $agent (keys(%{$GUI{Agent}})) {
    $GUI{Agent}->{$agent}->{TabBar}->Refresh()
      if Exists($GUI{Agent}->{$agent}->{TabBar});
    $GUI{Agent}->{$agent}->{Search}->{Results}->{MulColListbox}->Refresh()
      if Tk::Exists($GUI{Agent}->{$agent}->{Search}->{Results}->{MulColListbox});
  }

  $GUI{MessageList}->{MulColListbox}->Refresh()
    if Tk::Exists($GUI{MessageList}->{MulColListbox});
  $GUI{Headline}->{MulColListbox}->Refresh()
    if Tk::Exists($GUI{Headline}->{MulColListbox});
  $GUI{Search}->{Results}->{MulColListbox}->Refresh()
    if Tk::Exists($GUI{Search}->{Results}->{MulColListbox});
  $GUI{Config}->{FavGroups}->{List}->{MulColListbox}->Refresh()
    if Tk::Exists($GUI{Config}->{FavGroups}->{List}->{MulColListbox});

  $Roster->Refresh() if Tk::Exists($Roster);
  foreach my $tag (keys(%{$GUI{GroupChat}})) {
    $groupchatRosters{$tag}->Refresh() if Tk::Exists($groupchatRosters{$tag});
  }
}


##############################################################################
#
# jarlMainIF_StatusAdd - add a message to the status window
#
##############################################################################
sub jarlMainIF_StatusAdd {
  my ($stuff) = @_;

  my $string = "";
  my $status = "";

  if (ref($stuff) eq "") {
    $status = $stuff;
    $string = $stuff."\n";
  }
  if (ref($stuff) eq "Net::Jabber::Presence") {
    $string .= "AVBL: " if (($stuff->GetType() eq "available") ||
			    ($stuff->GetType() eq ""));
    $string .= "UNAV: " if ($stuff->GetType() eq "unavailable");
    $string .= "S10N: ".$stuff->GetType()." "
      if (($stuff->GetType() eq "subscribe") ||
	  ($stuff->GetType() eq "unsubscribe") ||
	  ($stuff->GetType() eq "subscribed") ||
	  ($stuff->GetType() eq "unsubscribed"));
    my $fromJID = $stuff->GetFrom("jid");
    $string .= &jarlRoster_GetNick($fromJID);
    $string .= "/".$fromJID->GetResource()
      if (!exists($transportJIDs{$fromJID->GetServer()}) &&
	  ($fromJID->GetResource() ne ""));
    $string .= " - ".$stuff->GetStatus() if ($stuff->GetStatus() ne "");
    $string .= "\n";
  }

  if (Exists($GUI{Status}->{Window}->{Text})) {
    $GUI{Status}->{Window}->{Text}->configure(-state=>"normal");
    $GUI{Status}->{Window}->{Text}->insert("end",$jabber{oldstatus}.$string);
    my ($top,$bottom) = $GUI{Status}->{Window}->{Text}->yview();
    $GUI{Status}->{Window}->{Text}->yview("moveto",100) if ($bottom > .9) || ($bottom == $top);
    $GUI{Status}->{Window}->{Text}->configure(-state=>"disabled");
    $jabber{oldstatus} = "";
  } else {
    $jabber{oldstatus} .= $string;
  }

  &jarlMainIF_StatusBarChangeStatus($status) unless ($status eq "");

  $GUI{Status}->{Window}->{Text}->update();
}


##############################################################################
#
# jarlMainIF_Update - update the GUI so that the user doesn't think that the GUI
#                   has gone on hiatus.
#
##############################################################################
sub jarlMainIF_Update {
  $GUI{top}->update();
}


##############################################################################
#
# jarlMainIF_LoggedIn - do any GUI code that needs to be done when we are logged
#                     in.
#
##############################################################################
sub jarlMainIF_LoggedIn {
  &jarlMainIF_ChangeIcon($GUI{Roster}->{ToolBar}->{Connection},"Connected","Disconnected");
  &jarlMainIF_UpdateShowStatus();
  $TabBar->RaiseTab("roster");
}


##############################################################################
#
# jarlMainIF_LoggedOut - do any GUI code that needs to be done when we are
#                      logged out.
#
##############################################################################
sub jarlMainIF_LoggedOut {
  &jarlMainIF_ChangeIcon($GUI{Roster}->{ToolBar}->{Connection},"Disconnected","Connected");
}


##############################################################################
#
# jarlMainIF_AlertUser - do something to get the users attention.  Ring
#                        the bell or what not.
#
##############################################################################
sub jarlMainIF_AlertUser {
  $GUI{top}->bell();
}


##############################################################################
#
# jarlMainIF_About - splash screen showing some fun messages
#
##############################################################################
sub jarlMainIF_About {
  my $about =
    $GUI{top}->Toplevel(-background=>$GUI{color}->{window}->{bg}->{normal},
                        -foreground=>$GUI{color}->{window}->{fg}->{dark});
  $about->withdraw();
  $about->title("About Jarl");
  $about->resizable(0,0);

  $about->
    Button(-text=>"Close",
	   -font=>$GUI{fonts}->{login},
	   -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	   -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	   -command=>sub{
	     $about->destroy();
	   })->pack(-side=>"bottom");

  my $logoTop =
    $about->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
            -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
           )->pack(-side=>"left",
                   -fill=>"both",
                   -expand=>1);

  my $bitmap =
    $about->Pixmap(-file=>"$Bitmaps/logo.xpm");

  $logoTop->
    Label(-image=>$bitmap,
	  -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	  -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	  -relief=>"sunken",
	  -borderwidth=>2
	 )->pack(-side=>"top",
		 -pady=>0,
		 -padx=>0);

  my $textTop =
    $about->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
            -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
           )->pack(-side=>"right",
                   -fill=>"both",
                   -expand=>1);

  $textTop->
    Label(-text=>"Jarl is a Perl Jabber client written by Ryan Eatmon (reatmon\@jabber.org).  It was designed to be modular and support various user interfaces, while maintaining a consistent feature set.",
	  -wraplength=>250,
	  -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	  -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	  -font=>$GUI{fonts}->{login},
	  -justify=>"left",
	  -anchor=>"w",
	 )->pack(-side=>"top",
		 -fill=>"x",
		 -pady=>2,
		 -padx=>0);

  $textTop->
    Label(-text=>"See what others are saying about Jarl:",
	  -wraplength=>250,
	  -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	  -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	  -font=>$GUI{fonts}->{login},
	  -justify=>"left",
	  -anchor=>"w",
	 )->pack(-side=>"top",
		 -fill=>"x",
		 -pady=>2,
		 -padx=>0);

  $textTop->
    Label(-text=>"It may be feature-rich, but it's a big, chunky monster when it comes to taking up room on your screen. - Maximum Linux",
	  -wraplength=>250,
	  -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	  -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	  -font=>$GUI{fonts}->{login},
	  -justify=>"left",
	  -anchor=>"w",
	 )->pack(-side=>"top",
		 -fill=>"x",
		 -anchor=>"w",
		 -pady=>2,
		 -padx=>10);

  $about->deiconify();
}


1;
