##############################################################################
#
# Jarl - Normal Tk Interface Code
#
#   Perl Tk code to handle interfacing with the user and dealing with
# display received normals and editting outgoing ones.
#
##############################################################################

##############################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#  Jabber
#  Copyright (C) 1998-1999 The Jabber Team http://jabber.org/
#
##############################################################################


##############################################################################
#
# jarlNormalIF_PopupGUI - defines the normal popup GUI and slates it towards
#                         the messageid specified.
#
##############################################################################
sub jarlNormalIF_PopupGUI {
  my(@mids) = @_;

  $GUI{NormalPopup} =
    $GUI{Main}->{top}->
      Menu(-tearoff=>0,
	   -borderwidth=>2,
	   -relief=>"raised",
	   -background=>$GUI{color}->{jarl}->{menu}->{background},
	   -foreground=>$GUI{color}->{jarl}->{menu}->{text},
	  );

  $GUI{NormalPopup}->
    add("command",
	-label=>($#mids > 0) ? "Delete Messages" : "Delete Message",
	-font=>$GUI{fonts}->{normal},
	-foreground=>$GUI{color}->{jarl}->{menu}->{text},
	-background=>$GUI{color}->{jarl}->{menu}->{background},
	-command=>sub{
	  &jarlNormal_DeleteMessage(@mids);
	  &jarlNormalIF_ShowMessage();
	});

#  if ($#mids == 0) {
  if (($#mids == 0) && ($GUI{MessageList}->{MulColListbox}->get("type",$GUI{MessageList}->{MulColListbox}->curselection) eq "normal")) {
    $GUI{NormalPopup}->
      add("command",
	  -label=>"Reply to Message",
	  -font=>$GUI{fonts}->{normal},
	  -foreground=>$GUI{color}->{jarl}->{menu}->{text},
	  -background=>$GUI{color}->{jarl}->{menu}->{background},
	  -command=>sub{
	    &jarlNormal_Compose("reply",$mids[0]);
	  });

    $GUI{NormalPopup}->
      add("command",
	  -label=>"Add User to Roster",
	  -state=>"disabled",
	  -font=>$GUI{fonts}->{normal},
	  -foreground=>$GUI{color}->{jarl}->{menu}->{text},
	  -background=>$GUI{color}->{jarl}->{menu}->{background},
	  -command=>sub{
#	    &jarlNormal_SubscribeMessage($mids[0]);
	  });
  }
}


sub jarlNormalIF_NewGUI {
  my ($widget) = @_;

  my $upperFrame =
    $widget->
      Frame(-background=>$GUI{color}->{window}->{bg}->{normal},
	    -foreground=>$GUI{color}->{window}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'x');

  my $middleFrame =
    $widget->
      Frame(-background=>$GUI{color}->{window}->{bg}->{normal},
	    -foreground=>$GUI{color}->{window}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'both',
		   -expand=>1);

  my $lowerFrame =
    $widget->
      Frame(-background=>$GUI{color}->{window}->{bg}->{normal},
	    -foreground=>$GUI{color}->{window}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'both',
		   -expand=>1);

  &jarlNormalIF_ToolBarGUI($upperFrame);
  &jarlNormalIF_ListGUI($middleFrame);
  &jarlNormalIF_BodyGUI($lowerFrame);
}


##############################################################################
#
# jarlNormalIF_ToolBarGUI - creates the normal toolbar GUI.
#
##############################################################################
sub jarlNormalIF_ToolBarGUI {
  my ($frame) = @_;

  my $toolbar =
    $frame->
      Frame(-borderwidth=>0,
	    -relief=>"flat",
	    -background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	   )->pack(-side=>"top",
		   -anchor=>"w",
		   -fill=>"x");

  $GUI{Normal}->{ToolBar}->{Reply} =
    $toolbar->
      Button(-image=>$GUI{Icons}->{Reply},
	     -relief=>"flat",
	     -borderwidth=>1,
	     -state=>"disabled",
	     -background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	     -command=>sub {
	       my @cur = $GUI{MessageList}->{MulColListbox}->curselection();
	       return if ($#cur != 0);
	       &jarlNormal_Compose("reply",$GUI{MessageList}->{MulColListbox}->get("mid",$GUI{MessageList}->{MulColListbox}->curselection));
	     })->pack(-side=>"left",
		      -pady=>2,
		      -padx=>5);
  &jarlMainIF_RegisterIcon($GUI{Normal}->{ToolBar}->{Reply},"Reply");
  $GUI{ToolBar}->{Balloon}->
    attach($GUI{Normal}->{ToolBar}->{Reply},
	   -balloonmsg=>"Reply to message ");
  $GUI{Normal}->{ToolBar}->{Reply}->
    bind("<Enter>",
	 sub {
	       $GUI{Normal}->{ToolBar}->{Reply}->configure(-relief=>"raised");
	 });
  $GUI{Normal}->{ToolBar}->{Reply}->
    bind("<Leave>",
	 sub {
	   $GUI{Normal}->{ToolBar}->{Reply}->configure(-relief=>"flat");
	 });

  my $trashCan =
    $toolbar->
      Button(-image=>$GUI{Icons}->{Trash},
	     -relief=>"flat",
	     -borderwidth=>1,
	     -background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	     -command=>sub {
	       my @mids = $GUI{MessageList}->{MulColListbox}->get("mid",$GUI{MessageList}->{MulColListbox}->curselection());
	       &jarlNormal_DeleteMessage(@mids);
	       &jarlNormalIF_ShowMessage();
	     })->pack(-side=>"left",
		      -pady=>2,
		      -padx=>5);
  &jarlMainIF_RegisterIcon($trashCan,"Trash");
  $GUI{ToolBar}->{Balloon}->
    attach($trashCan,
	   -balloonmsg=>"Delete Selected Messages ");
  $trashCan->
    bind("<Enter>",
	 sub {
	       $trashCan->configure(-relief=>"raised");
	 });
  $trashCan->
    bind("<Leave>",
	 sub {
	   $trashCan->configure(-relief=>"flat");
	 });
}


##############################################################################
#
# jarlNormalIF_ListGUI - creates the normal list GUI.
#
##############################################################################
sub jarlNormalIF_ListGUI {
  my ($frame) = @_;

  $GUI{MessageList}->{top} =
    $frame->
      Frame(-background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	   )->pack(-side=>"top",
		   -fill=>"both",
		   -expand=>1);

#  $GUI{MessageList}->{Header} =
#    $GUI{MessageList}->{top}->
#      Label(-text=>"Messages",
#	    -anchor=>"w",
#	    -font=>$GUI{fonts}->{header},
#	    -background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
#	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
#	   )->pack(-side=>"top",
#		   -fill=>"x");

  $GUI{MessageList}->{MulColListbox} =
    $GUI{MessageList}->{top}->
      MulColListbox(-headerbackground=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
		    -headerforeground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
		    -headerborderwidth=>1,
		    -marker=>1,
		    -markerstyle=>"diamond",
		    -background=>$GUI{color}->{bg}->{light},
		    -foreground=>$GUI{color}->{fg}->{dark},
		    -relief=>"sunken",
		    -borderwidth=>2,
		    -height=>0,
		    -width=>0,
		    -font=>$GUI{fonts}->{normal},
		    -selectmode=>"multiple",
		    -selectbackground=>$GUI{color}->{bg}->{list},
		    -selectforeground=>$GUI{color}->{fg}->{list},
		    -scrollbarborderwidth=>1,
		    -scrollbarrelief=>"flat",
		    -sortby=>"time"
		   )->pack(-side=>"top",
			   -fill=>"both",
			   -expand=>1,
			   -padx=>5,
			   -pady=>5);

  $GUI{MessageList}->{MulColListbox}->
    AddColumn(-header=>"Sender",
	      -key=>"sender");
  $GUI{MessageList}->{MulColListbox}->
    AddColumn(-header=>"Subject",
	      -key=>"subject");
  $GUI{MessageList}->{MulColListbox}->
    AddColumn(-header=>"Date",
	      -key=>"date",
	      -sortby=>"time");

  $GUI{MessageList}->{MulColListbox}->
    bind("<Button-1>",
	 sub {
	   return
	     if ($GUI{MessageList}->{MulColListbox}->curselection eq "");
	   $GUI{Normal}->{ToolBar}->{Reply}->configure(-state=>"normal") if ($GUI{MessageList}->{MulColListbox}->get("encrypted",$GUI{MessageList}->{MulColListbox}->curselection()) eq "normal")
	   &jarlNormalIF_ShowMessage($GUI{MessageList}->{MulColListbox}->get("encrypted",$GUI{MessageList}->{MulColListbox}->curselection),@{$GUI{MessageList}->{MulColListbox}->get("body",$GUI{MessageList}->{MulColListbox}->curselection)});
	 }
	);

  $GUI{MessageList}->{MulColListbox}->
    bind("<Shift-Button-1>",
	 sub {
	   my @cur = $GUI{MessageList}->{MulColListbox}->curselection();
	   $GUI{Normal}->{ToolBar}->{Reply}->configure(-state=>"disabled") if ($#cur != 0);
	 }
	);
  $GUI{MessageList}->{MulColListbox}->
    bind("<Control-Button-1>",
	 sub {
	   my @cur = $GUI{MessageList}->{MulColListbox}->curselection();
	   $GUI{Normal}->{ToolBar}->{Reply}->configure(-state=>"disabled") if ($#cur != 0);
	 }
	);

  $GUI{MessageList}->{MulColListbox}->
    bind("<Button-3>",
         [ sub{
             my ($mcl,$y) = @_;
	     my $nearest = $mcl->nearest($y);
	     return if ($nearest == -1);
	     if (!$mcl->selected($nearest)) {
	       $mcl->selectionClear(0,"end");
	       $mcl->selectionSet($nearest);
	       $mcl->viewed($nearest);
	       &jarlNormalIF_ShowMessage($GUI{MessageList}->{MulColListbox}->get("encrypted",$nearest),@{$GUI{MessageList}->{MulColListbox}->get("body",$nearest)});
	     }
	     my @mids = $mcl->get("mid",$mcl->curselection);
	     &jarlNormalIF_PopupGUI(@mids);
             $GUI{NormalPopup}->Popup(-popover=>"cursor",
				      -popanchor=>"nw");
           },
           Ev('y')
         ]
        );
}


##############################################################################
#
# jarlNormalIF_ShowMessage - shows the selected message.
#
##############################################################################
sub jarlNormalIF_ShowMessage {
  my ($encrypted,@body) = @_;

  $GUI{MessageBody}->{Body}->{Text}->configure(-state=>"normal");
  $GUI{MessageBody}->{Body}->{Text}->delete("1.0","end");
  if (defined($encrypted) && ($encrypted == 1)) {
    my $secureIcon =
      $GUI{MessageBody}->{Body}->{Text}->
	Label(-image=>$GUI{Icons}->{SecureMessage},
	      -background=>$GUI{color}->{bg}->{light});
    &jarlMainIF_RegisterIcon($secureIcon,"SecureMessage");
    $GUI{MessageBody}->{Body}->{Text}->
      windowCreate("end",
		   -window=>$secureIcon);
    $GUI{MessageBody}->{Body}->{Text}->insert("end","\n");
  }

  while ($#body > -1) {
    my $pieceType = shift(@body);
    my $piece = shift(@body);

    my @tagList = ( $pieceType, $type, $type."$currentID");
    if ($pieceType eq "link") {
      push(@tagList, "link-$piece");
      $GUI{MessageBody}->{Body}->{Text}->
	tagBind("link-$piece",
		"<Button-1>",
		sub{
		  &jarlFetchURL($piece);
		});
    }

    $GUI{MessageBody}->{Body}->{Text}->
      insert("end", $piece, \@tagList);

    $priority = "medium" if ($pieceType eq "highlight");
  }

  $GUI{MessageBody}->{Body}->{Text}->configure(-state=>"disabled");
}


##############################################################################
#
# jarlNormalIF_BodyGUI - creates the message body GUI.
#
##############################################################################
sub jarlNormalIF_BodyGUI {
  my ($frame) = @_;

  $GUI{MessageBody}->{top} =
    $frame->
      Frame(-background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	   )->pack(-side=>"top",
		   -fill=>"both",
		   -expand=>1);

  $GUI{MessageBody}->{Body}->{top} =
    $GUI{MessageBody}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	    -relief=>"sunken",
	    -borderwidth=>2
	   )->pack(-side=>"top",
		   -fill=>"both",
		   -expand=>1,
		   -padx=>5,
		   -pady=>5);

  $GUI{MessageBody}->{Body}->{Scrolled} =
    $GUI{MessageBody}->{Body}->{top}->
      Scrolled("Text",
	       -scrollbars=>"oe",
	       -background=>$GUI{color}->{jarl}->{main}->{bg}->{light},
	       -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	       -font=>$GUI{fonts}->{normal},
	       -height=>5,
	       -width=>0,
	       -borderwidth=>0,
	       -highlightthickness=>0,
	       -selectborderwidth=>0,
	       -exportselection=>1,
	       -takefocus=>0,
	       -wrap=>"word",
	       -state=>"disabled"
	      )->pack(-side=>"left",
		      -fill=>"both",
		      -expand=>1,
		      -padx=>0,
		      -pady=>0);

  $GUI{MessageBody}->{Body}->{Scrollbar} =
    $GUI{MessageBody}->{Body}->{Scrolled}->Subwidget("yscrollbar");
  $GUI{MessageBody}->{Body}->{Scrollbar}->
    configure(-width=>10,
	      -borderwidth=>1,
	      -relief=>"flat");
  $GUI{MessageBody}->{Body}->{Text} =
    $GUI{MessageBody}->{Body}->{Scrolled}->Subwidget("text");

  $GUI{MessageBody}->{Body}->{Text}->
    tagConfigure("server",
		 -foreground=>"green4");
  $GUI{MessageBody}->{Body}->{Text}->
    tagConfigure("me",
		 -foreground=>"red");
  $GUI{MessageBody}->{Body}->{Text}->
    tagConfigure("notme",
		 -foreground=>"blue");
  $GUI{MessageBody}->{Body}->{Text}->
    tagConfigure("highlight",
		 -foreground=>"red");
  $GUI{MessageBody}->{Body}->{Text}->
    tagConfigure("timestamp",
		 -foreground=>"gray30");
  $GUI{MessageBody}->{Body}->{Text}->
    tagConfigure("action",
		 -foreground=>"purple");
  $GUI{MessageBody}->{Body}->{Text}->
    tagConfigure("link",
		 -foreground=>"blue",
		 -font=>$GUI{fonts}->{link});

  $GUI{MessageBody}->{Body}->{Text}->
    tagBind("link",
	    "<Enter>",
	    sub{
	      $GUI{MessageBody}->{Body}->{Text}->
		configure(-cursor=>"hand2");
	    });
  $GUI{MessageBody}->{Body}->{Text}->
    tagBind("link",
	    "<Leave>",
	    sub{
	      $GUI{MessageBody}->{Body}->{Text}->
		configure(-cursor=>"xterm");
	    });

  $GUI{MessageBody}->{Body}->{Text}->
    bind("<Button-4>",
	 sub{
	   $GUI{MessageBody}->{Body}->{Text}->
	     yviewScroll(-1,"units");
	 });
  $GUI{MessageBody}->{Body}->{Text}->
    bind("<Button-5>",
	 sub{
	   $GUI{MessageBody}->{Body}->{Text}->
	     yviewScroll(1,"units");
	 });
}


##############################################################################
#
# jarlNormalIF_NewNormal - function to do all GUI calls needed to create a
#                          new compose.
#
##############################################################################
sub jarlNormalIF_NewNormal {
  my ($tag) = @_;

  my $tabText = "Normal";
  $tabText .= " - ".&jarlNormal_NormalID($tag)
    if (&jarlNormal_NormalID($tag));
  $GUI{Normal}->{$tag}->{top} =
    $TabBar->AddTab(-type=>"docked",
                                 -tag=>$tag,
                                 -text=>$tabText);
  &jarlNormalIF_ComposeGUI($tag);
  &jarlNormalIF_RaiseNormal($tag);
}


##############################################################################
#
# jarlNormalIF_RaiseNormal - function to bring the specified chat to the top
#                            of the window list.
#
##############################################################################
sub jarlNormalIF_RaiseNormal {
  my ($tag) = @_;
  $TabBar->RaiseTab($tag);
}


##############################################################################
#
# jarlNormalIF_ComposeGUI - creates a new message window.
#
##############################################################################
sub jarlNormalIF_ComposeGUI {
  my ($tag) = @_;

  $GUI{Normal}->{$tag}->{ButtonsTop}->{top} =
    $GUI{Normal}->{$tag}->{top}->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	   )->pack(-side=>"top",
		   -fill=>"x");

  $GUI{Normal}->{$tag}->{ButtonsTop}->{Send} =
    $GUI{Normal}->{$tag}->{ButtonsTop}->{top}->
      Button(-image=>$GUI{Icons}->{SendMessage},
	     -background=>$GUI{color}->{bg}->{normal},
	     -foreground=>$GUI{color}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -relief=>"flat",
	     -borderwidth=>1,
	     -command=>sub{
	       &jarlNormalIF_Send($tag);
	     }
	    )->pack(-side=>"left",
		    -padx=>$GUI{width}->{jarl}->{config}->{pad});
  &jarlMainIF_RegisterIcon($GUI{Normal}->{$tag}->{ButtonsTop}->{Send},
			   "SendMessage");
  $GUI{ToolBar}->{Balloon}->
    attach($GUI{Normal}->{$tag}->{ButtonsTop}->{Send},
	   -balloonmsg=>"Send the Message ");
  $GUI{Normal}->{$tag}->{ButtonsTop}->{Send}->
    bind("<Enter>",
	 sub {
	   $GUI{Normal}->{$tag}->{ButtonsTop}->{Send}->
	     configure(-relief=>"raised");
	 });
  $GUI{Normal}->{$tag}->{ButtonsTop}->{Send}->
    bind("<Leave>",
	 sub {
	   $GUI{Normal}->{$tag}->{ButtonsTop}->{Send}->
	     configure(-relief=>"flat");
	 });

  $GUI{Normal}->{$tag}->{ButtonsTop}->{Secure} =
    $GUI{Normal}->{$tag}->{ButtonsTop}->{top}->
      Button(-image=>(($GUI{Normal}->{$tag}->{vars}->{secure} == 1) ?
		      $GUI{Icons}->{SecureOn} :
		      $GUI{Icons}->{SecureOff}),
	     -background=>$GUI{color}->{bg}->{normal},
	     -foreground=>$GUI{color}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -relief=>"flat",
	     -borderwidth=>1,
	     -command=>sub{
               if (&jarlNormal_Secure($tag) == 0) {
                 &jarlNormal_UserSecure($tag,1);
                 &jarlNormal_SecureMessage($tag);
               } else {
                 &jarlNormal_UserSecure($tag,0);
                 &jarlNormal_UnsecureMessage($tag);
               }
	     }
	    )->pack(-side=>"left",
		    -padx=>$GUI{width}->{jarl}->{config}->{pad});
  &jarlMainIF_RegisterIcon($GUI{Normal}->{$tag}->{ButtonsTop}->{Secure},
			 (($GUI{Normal}->{$tag}->{vars}->{secure} == 1) ?
			  "SecureOn" :
			  "SecureOff"));
  $GUI{ToolBar}->{Balloon}->
    attach($GUI{Normal}->{$tag}->{ButtonsTop}->{Secure},
	   -balloonmsg=>"Secure the Message ");
  $GUI{Normal}->{$tag}->{ButtonsTop}->{Secure}->
    bind("<Enter>",
	 sub {
	   $GUI{Normal}->{$tag}->{ButtonsTop}->{Secure}->
	     configure(-relief=>"raised");
	 });
  $GUI{Normal}->{$tag}->{ButtonsTop}->{Secure}->
    bind("<Leave>",
	 sub {
	   $GUI{Normal}->{$tag}->{ButtonsTop}->{Secure}->
	     configure(-relief=>"flat");
	 });


  $GUI{Normal}->{$tag}->{To}->{top} =
    $GUI{Normal}->{$tag}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{newmessage}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{newmessage}->{fg}->{dark},
	   )->pack(-side=>"top",
		   -fill=>"x",
		   -padx=>5);
  $GUI{Normal}->{$tag}->{To}->{Label} =
    $GUI{Normal}->{$tag}->{To}->{top}->
      Label(-text=>"To:",
	    -width=>$GUI{width}->{jarl}->{newmessage}->{label},
	    -anchor=>"e",
	    -font=>$GUI{fonts}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{newmessage}->{fg}->{dark},
	    -background=>$GUI{color}->{jarl}->{newmessage}->{bg}->{normal}
	   )->pack(-side=>"left",
		   -fill=>"y",
		   -anchor=>"e");
  $GUI{Normal}->{$tag}->{To}->{Entry} =
    $GUI{Normal}->{$tag}->{To}->{top}->
      Entry(-textvariable=>\$GUI{Normal}->{$tag}->{vars}->{to},
	    -background=>$GUI{Normal}->{$tag}->{vars}->{to} ne "" ? $GUI{color}->{jarl}->{newmessage}->{bg}->{normal} : $GUI{color}->{jarl}->{newmessage}->{bg}->{light},
	    -foreground=>$GUI{color}->{jarl}->{newmessage}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -state=>$GUI{Normal}->{$tag}->{vars}->{to} ne "" ? "disabled" : "normal"
	   )->pack(-side=>'left',
		   -anchor=>'w',
		   -fill=>"x",
		   -expand=>1);

  if (ref($GUI{Normal}->{$tag}->{vars}->{toJID}) eq "Net::Jabber::JID") {

    $GUI{Normal}->{$tag}->{Resource}->{Label} =
      $GUI{Normal}->{$tag}->{To}->{top}->
	Label(-text=>"Resource:",
	      -width=>$GUI{width}->{jarl}->{newmessage}->{label},
	      -anchor=>"e",
	      -font=>$GUI{fonts}->{normal},
	      -foreground=>$GUI{color}->{jarl}->{newmessage}->{fg}->{dark},
	      -background=>$GUI{color}->{jarl}->{newmessage}->{bg}->{normal}
	     )->pack(-side=>"left",
		     -fill=>"y",
		     -anchor=>"e");

    my @options = $jabber{client}->
      PresenceDBResources($GUI{Normal}->{$tag}->{vars}->{toJID});
    @options = () unless defined(@options);
    unshift(@options,"");

    $GUI{Normal}->{$tag}->{Resource}->{Option} =
      $GUI{Normal}->{$tag}->{To}->{top}->
	Optionmenu(-options=>\@options,
		   -variable=>\$GUI{Normal}->{$tag}->{vars}->{resource},
		   -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
		   -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
		   -font=>$GUI{fonts}->{normal},
		   -command=> sub {
		     $GUI{Normal}->{$tag}->{vars}->{toJID}->
		       SetResource($GUI{Normal}->{$tag}->{vars}->{resource});
		     $GUI{Normal}->{$tag}->{vars}->{to} =
		       $GUI{Normal}->{$tag}->{vars}->{toJID}->GetJID("full");
		   }
		  )->pack(-side=>'left',
			  -anchor=>'w');
  }

  $GUI{Normal}->{$tag}->{Subject}->{top} =
    $GUI{Normal}->{$tag}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{newmessage}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{newmessage}->{fg}->{dark},
	   )->pack(-side=>"top",
		   -fill=>"x",
		   -padx=>5);
  $GUI{Normal}->{$tag}->{Subject}->{Label} =
    $GUI{Normal}->{$tag}->{Subject}->{top}->
      Label(-text=>"Subject:",
	    -width=>$GUI{width}->{jarl}->{newmessage}->{label},
	    -anchor=>"e",
	    -font=>$GUI{fonts}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{newmessage}->{fg}->{dark},
	    -background=>$GUI{color}->{jarl}->{newmessage}->{bg}->{normal}
	   )->pack(-side=>"left",
		   -fill=>"y",
		   -anchor=>"e");
  $GUI{Normal}->{$tag}->{Subject}->{Entry} =
    $GUI{Normal}->{$tag}->{Subject}->{top}->
      Entry(-textvariable=>\$GUI{Normal}->{$tag}->{vars}->{subject},
	    -background=>$GUI{color}->{jarl}->{newmessage}->{bg}->{light},
	    -foreground=>$GUI{color}->{jarl}->{newmessage}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	   )->pack(-side=>'left',
		   -anchor=>'w',
		   -fill=>"x",
		   -expand=>1);

  $GUI{Normal}->{$tag}->{Body}->{top} =
    $GUI{Normal}->{$tag}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{newmessage}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{newmessage}->{fg}->{dark},
	    -relief=>"sunken",
	    -borderwidth=>2,
	   )->pack(-side=>"top",
		   -fill=>"both",
		   -padx=>$GUI{width}->{jarl}->{newmessage}->{pad},
		   -pady=>$GUI{height}->{jarl}->{newmessage}->{pad},
		   -expand=>1);
  $GUI{Normal}->{$tag}->{Body}->{Scrolled} =
    $GUI{Normal}->{$tag}->{Body}->{top}->
      Scrolled("Text",
	       -scrollbars=>"oe",
	       -background=>$GUI{color}->{jarl}->{main}->{bg}->{light},
	       -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	       -font=>$GUI{fonts}->{normal},
	       -height=>0,
	       -width=>0,
	       -borderwidth=>0,
	       -highlightthickness=>0,
	       -selectborderwidth=>0,
	       -exportselection=>1,
	       -wrap=>"word",
	      )->pack(-side=>"left",
		      -fill=>"both",
		      -expand=>1,
		      -padx=>0,
		      -pady=>0);

  $GUI{Normal}->{$tag}->{Body}->{Scrollbar} =
    $GUI{Normal}->{$tag}->{Body}->{Scrolled}->Subwidget("yscrollbar");
  $GUI{Normal}->{$tag}->{Body}->{Scrollbar}->
    configure(-width=>10,
	      -borderwidth=>1,
	      -relief=>"flat");
  $GUI{Normal}->{$tag}->{Body}->{Text} =
    $GUI{Normal}->{$tag}->{Body}->{Scrolled}->Subwidget("text");

  $GUI{Normal}->{$tag}->{Body}->{Text}->
    bind("<Button-4>",
	 sub{
	   $GUI{Normal}->{$tag}->{Body}->{Text}->
	     yviewScroll(-1,"units");
	 });
  $GUI{Normal}->{$tag}->{Body}->{Text}->
    bind("<Button-5>",
	 sub{
	   $GUI{Normal}->{$tag}->{Body}->{Text}->
	     yviewScroll(1,"units");
	 });

  $GUI{Normal}->{$tag}->{Body}->{Text}->
    bind("<Control-Enter>",sub{
	   &jarlNormalIF_Send($tag);
	 });
  $GUI{Normal}->{$tag}->{Body}->{Text}->
    bind("<Control-Return>",sub{
	   &jarlNormalIF_Send($tag);
	 });

  $GUI{Normal}->{$tag}->{ButtonsBottom}->{top} =
    $GUI{Normal}->{$tag}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{newmessage}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{newmessage}->{fg}->{dark},
	   )->pack(-side=>"top",
		   -fill=>"x");
  $GUI{Normal}->{$tag}->{ButtonsBottom}->{Cancel} =
    $GUI{Normal}->{$tag}->{ButtonsBottom}->{top}->
      Button(-text=>"Cancel",
	     -width=>$GUI{width}->{jarl}->{newmessage}->{button},
	     -background=>$GUI{color}->{jarl}->{newmessage}->{bg}->{normal},
	     -foreground=>$GUI{color}->{jarl}->{newmessage}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{jarl}->{newmessage}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{
	       &jarlNormalIF_Close($tag);
	     }
	    )->pack(-side=>"right",
		    -padx=>$GUI{width}->{jarl}->{config}->{pad});

  $TabBar->RaiseTab($tag);

}


##############################################################################
#
# jarlNormalIF_Send - do everything needed to send this message and close it.
#
##############################################################################
sub jarlNormalIF_Send {
  my ($tag) = @_;

  &jarlNormal_Send($tag);
  &jarlNormalIF_Close($tag);
}


##############################################################################
#
# jarlNormalIF_Close - do everything needed to close down the fort.
#
##############################################################################
sub jarlNormalIF_Close {
  my ($tag) = @_;

  &jarlNormal_DeleteNormal($tag);
  $TabBar->DeleteTab($tag);
  delete($GUI{Normal}->{$tag});
}


##############################################################################
#
# jarlNormalIF_CurrentTo - if $value is defined then the Entry contents are
#                          set to $value, otherwise the contents of the Entry
#                          are returned.
#
##############################################################################
sub jarlNormalIF_CurrentTo {
  my ($tag,$value) =  @_;
  $Debug->Log3("jarlNormalIF_CurrentTo: tag($tag) value($value)");
  if (defined($value)) {
    $Debug->Log3("jarlNormalIF_CurrentTo: set the entry to value($value)");
    $GUI{Normal}->{$tag}->{To}->{Entry}->delete(0,"end");
    $GUI{Normal}->{$tag}->{To}->{Entry}->insert(0,$value->GetJID());
    $GUI{Normal}->{$tag}->{To}->{Entry}->icursor("end");
    $GUI{Normal}->{$tag}->{To}->{Entry}->xview(0);
    $GUI{Normal}->{$tag}->{vars}->{resource} = $value->GetResource();
    return;
  }
  my $toJID = $GUI{Normal}->{$tag}->{To}->{Entry}->get();
  $toJID .= "/".$GUI{Normal}->{$tag}->{vars}->{resource}
    unless ($GUI{Normal}->{$tag}->{vars}->{resource} eq "");
  $Debug->Log3("jarlNormalIF_CurrentTo: return(".$toJID.")");
  return new Net::Jabber::JID($toJID);
}


##############################################################################
#
# jarlNormalIF_CurrentSubject - if $value is defined then the Entry contents
#                               are set to $value, otherwise the contents of
#                               the Entry are returned.
#
##############################################################################
sub jarlNormalIF_CurrentSubject {
  my ($tag,$value) =  @_;
  $Debug->Log3("jarlNormalIF_CurrentSubject: tag($tag) value($value)");
  if (defined($value)) {
    $Debug->Log3("jarlNormalIF_CurrentSubject: set the entry to value($value)");
    $GUI{Normal}->{$tag}->{Subject}->{Entry}->delete(0,"end");
    $GUI{Normal}->{$tag}->{Subject}->{Entry}->insert(0,$value);
    $GUI{Normal}->{$tag}->{Subject}->{Entry}->icursor("end");
    $GUI{Normal}->{$tag}->{Subject}->{Entry}->xview(0);
    return;
  }
  $Debug->Log3("jarlNormalIF_CurrentTo: return(".$GUI{Normal}->{$tag}->{Subject}->{Entry}->get().")");
  return $GUI{Normal}->{$tag}->{Subject}->{Entry}->get();
}


##############################################################################
#
# jarlNormalIF_CurrentBody - if $value is defined then the Text contents are
#                            set to $value, otherwise the contents of the Text
#                            are returned.
#
##############################################################################
sub jarlNormalIF_CurrentBody {
  my ($tag,$value) =  @_;
  $Debug->Log3("jarlNormalIF_CurrentBody: tag($tag) value($value)");
  if (defined($value)) {
    $Debug->Log3("jarlNormalIF_CurrentBody: set the entry to value($value)");
    $GUI{Normal}->{$tag}->{Body}->{Text}->delete("1.0","end");
    $GUI{Normal}->{$tag}->{Body}->{Text}->insert("end",$value);
    $GUI{Normal}->{$tag}->{Body}->{Text}->markSet("insert","1.0");
    $GUI{Normal}->{$tag}->{Body}->{Text}->xviewMoveto(0);
    $GUI{Normal}->{$tag}->{Body}->{Text}->yviewMoveto(0);
    return;
  }
  $Debug->Log3("jarlNormalIF_CurrentBody: return(".$GUI{Normal}->{$tag}->{Body}->{Text}->get("1.0","end").")");
  return $GUI{Normal}->{$tag}->{Body}->{Text}->get("1.0","end");
}


##############################################################################
#
# jarlNormalIF_Secure - make the message with the specified JID secure
#                             (if possible)
#
##############################################################################
sub jarlNormalIF_Secure {
  my ($tag,$value) = @_;

  &jarlMainIF_ChangeIcon($GUI{Normal}->{$tag}->{ButtonsTop}->{Secure},
			 (($value == 1) ? "SecureOn" : "SecureOff"),
			 (($value == 1) ? "SecureOff" : "SecureOn"),
			);
}


##############################################################################
#
# jarlNormalIF_AddMessage - add the specified message into memory and the GUI.
#
##############################################################################
sub jarlNormalIF_AddMessage {
  my ($mid,%args) = @_;

  $args{mid} = $mid;
  $args{mcl_style} = delete($args{type}) unless ($args{type} eq "normal");

  $GUI{MessageList}->{MulColListbox}->insert(\%args);

  $TabBar->HighlightTab("messages");
}


##############################################################################
#
# jarlNormalIF_DeleteMessage - add the specified message into memory and the GUI.
#
##############################################################################
sub jarlNormalIF_DeleteMessage {
  my (@mid) = @_;

  $GUI{MessageList}->{MulColListbox}->delete($GUI{MessageList}->{MulColListbox}->search("mid",@mid));
}


1;
