##############################################################################
#
# Jarl - Profile CLI Interface Code
#   Perl code to handle showing the Jarl Profile Editor GUI and interfacing
# with it.
#
##############################################################################

##############################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#  Jabber
#  Copyright (C) 1998-1999 The Jabber Team http://jabber.org/
#
##############################################################################

use vars qw( %profileHash );

##############################################################################
#
# jarlProfileIF_EditorGUI - opens the Profile Editor GUI.
#
##############################################################################
sub jarlProfileIF_EditorGUI {

  my $command = "";

  while ($command ne "q") {
    $TabBar->Print("__jarl__:tabbar:transient","\n");
    $TabBar->Print("__jarl__:tabbar:transient","Profile Editor:\n");
    $TabBar->Print("__jarl__:tabbar:transient","  e) Edit Profile\n");
    $TabBar->Print("__jarl__:tabbar:transient","  d) Delete Profile\n");
    $TabBar->Print("__jarl__:tabbar:transient","  n) New Profile\n");
    $TabBar->Print("__jarl__:tabbar:transient","  q) Close Profile Editor\n");
    $command= &jarlMainIF_Prompt(prompt=>"Command:",
				 options=>["e","d","n","q"],
				 default=>"n");

    if ($command eq "n") {
      &jarlProfileIF_EditProfile();
    } elsif ($command eq "e") {
      $TabBar->Print("__jarl__:tabbar:transient","Profiles:\n");
      my $count = 0;
      my $index = -1;
      my @map;
      foreach my $profile (sort {$a cmp $b} keys(%profiles)) {
	$index++;
	next if ($profile eq "Connect w/o Profile");
	$TabBar->Print("__jarl__:tabbar:transient","  $count) $profile\n");
	$map[$count] = $index;
	$count++;
      }
      $TabBar->Print("__jarl__:tabbar:transient","  q) Cancel Edit Profile\n");
      my $profile = &jarlMainIF_Prompt(prompt=>"Profile:",
				       options=>[0..($count-1),"q"],
				       default=>(($count == 0) ? "q" : 0));
      next if ($profile eq "q");

      &jarlProfileIF_EditProfile((sort {$a cmp $b} keys(%profiles))[$map[$profile]]);
    } elsif ($command eq "d") {

    }
  }
}


sub jarlProfileIF_EditProfile {
  my ($profile) = @_;

  $profile = "" if !defined($profile);

  my $accounttype = (($profile eq "") ? "new" : "exist");

  if($profile ne "") {
    $profileHash{profile} = $profiles{$profile}->Name();
    $profileHash{server} = $profiles{$profile}->Server();
    $profileHash{account}->{username} = $profiles{$profile}->Username();
    $profileHash{account}->{password1} = $profiles{$profile}->Password();
    $profileHash{account}->{password2} = $profiles{$profile}->Password();
    $profileHash{account}->{resource} = $profiles{$profile}->Resource();

    foreach my $connectionName ($profiles{$profile}->ConnectionObj()) {
      my $connection = $profiles{$profile}->ConnectionObj($connectionName);

      $profileHash{connections}->{$connectionName}->{type} =
	$connection->Type();
      $profileHash{connections}->{$connectionName}->{port} =
	$connection->Port();
    }
  }

  #---------------------------------------------------------------------------
  #
  # Connection Type
  #
  #---------------------------------------------------------------------------
  if ($profile eq "") {
    $TabBar->Print("__jarl__:tabbar:transient",(($profile eq "") ? "New Profile" : "Edit Profile: $profile"),"\n");
    $TabBar->Print("__jarl__:tabbar:transient","\n");

    $TabBar->Print("__jarl__:tabbar:transient","First we need to know the status of the account that is going to be attached to this profile:\n");

    $TabBar->Print("__jarl__:tabbar:transient","  n)New Account\n");
    $TabBar->Print("__jarl__:tabbar:transient","  e)Existing Account\n");
    $accounttype = &jarlMainIF_Prompt(prompt=>"Type",
				      options=>["n","e"],
				      default=>"n");
    $accounttype = (($accounttype eq "n") ? "new" : "exist");
  }

  #---------------------------------------------------------------------------
  #
  # Profile Name and Server information
  #
  #---------------------------------------------------------------------------

  if ($profile eq "") {
    $profileHash{profile} = &jarlMainIF_Prompt(prompt=>"Profile Name");
    $profileHash{server} = &jarlMainIF_Prompt(prompt=>"Server");
  }

  #---------------------------------------------------------------------------
  #
  # Connections - Connections manager/editor
  #
  #---------------------------------------------------------------------------
  $TabBar->Print("__jarl__:tabbar:transient","\n");
  $TabBar->Print("__jarl__:tabbar:transient","Connections:\n");

  if ($profile eq "") {
    $profileHash{connections}->{"Normal"}->{type} = "TCP/IP";
    $profileHash{connections}->{"Normal"}->{port} = 5222;
  }

  my $command = "";
  while ($command ne "q") {
    $TabBar->Print("__jarl__:tabbar:transient","\n");
    $TabBar->Print("__jarl__:tabbar:transient","Connection Editor:\n");
    $TabBar->Print("__jarl__:tabbar:transient","  e) Edit Connection\n");
    $TabBar->Print("__jarl__:tabbar:transient","  d) Delete Connection\n");
    $TabBar->Print("__jarl__:tabbar:transient","  n) New Connection\n");
    $TabBar->Print("__jarl__:tabbar:transient","  q) Close Connection Editor\n");
    $command= &jarlMainIF_Prompt(prompt=>"Command:",
				 options=>["e","d","n","q"],
				 default=>"n");

    if ($command eq "n") {
      &jarlProfileIF_EditConnection();
    } elsif ($command eq "e") {
      my $connection = &jarlProfileIF_PromptForConnection(1);
      next unless defined($connection);
      &jarlProfileIF_EditConnection($connection);
    } elsif ($command eq "d") {
      my $connection = &jarlProfileIF_PromptForConnection(1);
      next unless defined($connection);
      delete($profileHash{connections}->{$connection});
    }
  }

  $TabBar->Print("__jarl__:tabbar:transient","\n");
  $TabBar->Print("__jarl__:tabbar:transient","Default Connection Selection:\n");
  $profileHash{connectionProfile} = &jarlProfileIF_PromptForConnection();

  #---------------------------------------------------------------------------
  #
  # Account Info
  #
  #---------------------------------------------------------------------------
  if ($profileHash{accounttype} eq "new") {
    my $Register =
      new Net::Jabber::Client(debuglevel=>$optctl{debug},
			      debugtime=>1);

    my $status =
      $Register->
	Connect(connectiontype=>$connectiontypes{$profileHash{connections}->{$profileHash{connectionprofile}}->{type}}->[0],
		hostname=>$profileHash{server},
		port=>$profileHash{connections}->{$profileHash{connectionprofile}}->{port});

    if (!(defined($status))) {
      &jarlErrorIF_Popup("","Cannot not connect to $profileHash{server}:$profileHash{connections}->{$profileHash{connectionprofile}}->{port}.");
      return;
    }

    my %fields = $Register->RegisterRequest(to=>$profileHash{server});

    %fields = %{$fields{fields}};
    delete($fields{registered});

    $Register->Disconnect();

    $TabBar->Print("__jarl__:tabbar:transient","Instructions: $fields{instructions}\n") if exists($fields{instructions});

    foreach my $field (sort {$a cmp $b} keys(%fields)) {
      next if ($field eq "username");
      next if ($field eq "password");
      next if ($field eq "instructions");
      next if ($field eq "key");
      &jarlProfileIF_EditorField($GUI{EditProfile}->{UserInfo},"register",$field,$fields{$field},1);
    }

    if ($profile ne "") {
      $profileHash{account}->{username} = $profiles{$profile}->{username};
      $profileHash{account}->{password1} = $profiles{$profile}->{password};
      $profileHash{account}->{password2} = $profiles{$profile}->{password};
      $profileHash{account}->{resource} = $profiles{$profile}->{resource};
    }
  }

  #---------------------------------------------------------------------------
  #
  # Account...  username, password, default resource
  #
  #---------------------------------------------------------------------------

  $profileHash{account}->{username} =
    &jarlMainIF_Prompt(prompt=>"Username",
		       default=>$profileHash{account}->{username});
  my $block = 1;
  while($block) {
    $profileHash{account}->{password1} =
      &jarlMainIF_Prompt(prompt=>"Password",
			 password=>1,
			 default=>$profileHash{account}->{password1});
    $profileHash{account}->{password2} =
      &jarlMainIF_Prompt(prompt=>"Password Again",
			 password=>1,
			 default=>$profileHash{account}->{password2});
    $block = 0 if ($profileHash{account}->{password1} eq $profileHash{account}->{password2});
  }
  $profileHash{account}->{resource} =
    &jarlMainIF_Prompt(prompt=>"Resource",
		       default=>$profileHash{account}->{resource});

  if ($profileHash{accounttype} eq "exist") {
    my $Register = new Net::Jabber::Client(debuglevel=>$optctl{debug},
					   debugtime=>1);

    my $status =
      $Register->
	Connect(connectiontype=>$connectiontypes{$profileHash{connections}->{$profileHash{connectionprofile}}->{type}}->[0],
		hostname=>$profileHash{server},
		port=>$profileHash{connections}->{$profileHash{connectionprofile}}->{port});

    if (!(defined($status))) {
      &jarlErrorIF_Popup("","Cannot not connect to $profileHash{server}:$profileHash{connection}->{port}.");
      return;
    }

    my @result =
      $Register->AuthSend(username=>$profileHash{account}->{username},
			  password=>$profileHash{account}->{password1},
			  resource=>"__jarl__:registration");

    if ($result[0] ne "ok") {
      &jarlErrorIF_Popup(@result);
      $Debug->Log0("ERROR: Could not login to server:",@result);

      $Register->Disconnect();
      return;
    }

    my %fields = $Register->RegisterRequest(to=>$profileHash{server});

    %fields = %{$fields{fields}};
    delete($fields{registered});

    $Register->Disconnect();

    foreach my $field (sort {$a cmp $b} keys(%fields)) {
      next if ($field eq "username");
      next if ($field eq "password");
      next if ($field eq "instructions");
      next if ($field eq "key");
      &jarlProfileIF_EditorField($GUI{EditProfile}->{UserInfo},"register",$field,$fields{$field},1);
    }
  }

  #---------------------------------------------------------------------------
  #
  # User info...  the fields are pulled from the server.
  #
  #---------------------------------------------------------------------------
  $GUI{EditProfile}->{UserInfo}->{Header}->{top} =
    $GUI{EditProfile}->{UserInfo}->{top}->
      Frame(-background=>$GUI{color}->{window}->{bg}->{normal},
	    -foreground=>$GUI{color}->{window}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'both',
		   -expand=>1);
  $GUI{EditProfile}->{UserInfo}->{Header}->{Label} =
    $GUI{EditProfile}->{UserInfo}->{Header}->{top}->
      Label(-text=>"User Info",
	    -background=>$GUI{color}->{bg}->{darkest},
	    -foreground=>$GUI{color}->{fg}->{lightest},
	    -font=>$GUI{fonts}->{header},
	    -anchor=>'w'
	   )->pack(-side=>'left',
		   -fill=>'both',
		   -expand=>1,
		   -anchor=>'e');

  $GUI{EditProfile}->{UserInfo}->{Buttons}->{top} =
    $GUI{EditProfile}->{UserInfo}->{top}->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	   )->pack(-side=>'bottom',
		   -fill=>'both',
		   -expand=>1);
  $GUI{EditProfile}->{UserInfo}->{Buttons}->{Finish} =
    $GUI{EditProfile}->{UserInfo}->{Buttons}->{top}->
      Button(-text=>"Finish",
	     -width=>7,
	     -background=>$GUI{color}->{bg}->{normal},
	     -foreground=>$GUI{color}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{

	       my $field;
	       foreach $field (keys(%{$GUI{EditProfile}->{UserInfo}->{Fields}})) {
		 next if ($field eq "instructions");
		 return if ($profileHash{register}->{$field} eq "");
	       }

	       if ($profileHash{accounttype} eq "exist") {
		 &jarlProfileIF_SaveProfile();
	       }
	       if ($profileHash{accounttype} eq "new") {
		 my $Register =
		   new Net::Jabber::Client(debuglevel=>$optctl{debug},
					   debugtime=>1);

		 my $status =
		   $Register->
		     Connect(connectiontype=>$connectiontypes{$profileHash{connections}->{$profileHash{connectionprofile}}->{type}}->[0],
			     hostname=>$profileHash{server},
			     port=>$profileHash{connections}->{$profileHash{connectionprofile}}->{port});

		 if (!(defined($status))) {
		   &jarlError_Popup("","Cannot not connect to $profileHash{server}:$profileHash{connection}->{port}.");
		   return;
		 }

		 my %fields = $Register->RegisterRequest(to=>$profileHash{server});

		 %fields = %{$fields{fields}};
		 delete($fields{registered});

		 $fields{username} = 
		   $profileHash{account}->{username};
		 $fields{password} = 
		   $profileHash{account}->{password1};

		 foreach $field (keys(%{$GUI{EditProfile}->{UserInfo}->{Fields}})) {
		   next if ($field eq "instructions");
		   $fields{$field} = 
		     $profileHash{register}->{$field};
		 }

		 my @result = $Register->RegisterSend(to=>$profileHash{server},
						      %fields);

		 if ($result[0] ne "ok") {
		   &jarlErrorIF_Popup(@result);
		   $Debug->Log0("ERROR: Could not register with server:",@result);
		   $Register->Disconnect();
		   return;
		 }

		 $Register->Disconnect();

		 &jarlProfileIF_SaveProfile();
	       }

	       $GUI{EditProfile}->{TabBar}->RaiseTab("done");
	     }
	    )->pack(-side=>"right",
		    -padx=>$GUI{width}->{jarl}->{config}->{pad});
  $GUI{EditProfile}->{UserInfo}->{Buttons}->{Cancel} =
    $GUI{EditProfile}->{UserInfo}->{Buttons}->{top}->
      Button(-text=>"Cancel",
	     -width=>7,
	     -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	     -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{jarl}->{config}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{
	       &jarlProfileIF_EditProfileCloseCB();
	     }
	    )->pack(-side=>"right",
		    -padx=>$GUI{width}->{jarl}->{config}->{pad});
  $GUI{EditProfile}->{UserInfo}->{Buttons}->{Back} =
    $GUI{EditProfile}->{UserInfo}->{Buttons}->{top}->
      Button(-text=>"<< Back",
	     -width=>7,
	     -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	     -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{jarl}->{config}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{
	       $GUI{EditProfile}->{TabBar}->RaiseTab("account");
	     }
	    )->pack(-side=>"right",
		    -padx=>$GUI{width}->{jarl}->{config}->{pad});


  #---------------------------------------------------------------------------
  #
  # Done tab.  Just clean up and tell the user if it was successful or not.
  #
  #---------------------------------------------------------------------------
  $GUI{EditProfile}->{Done}->{Header}->{top} =
    $GUI{EditProfile}->{Done}->{top}->
      Frame(-background=>$GUI{color}->{window}->{bg}->{normal},
	    -foreground=>$GUI{color}->{window}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'both',
		   -expand=>1);
  $GUI{EditProfile}->{Done}->{Header}->{Label} =
    $GUI{EditProfile}->{Done}->{Header}->{top}->
      Label(-text=>"Done",
	    -background=>$GUI{color}->{bg}->{darkest},
	    -foreground=>$GUI{color}->{fg}->{lightest},
	    -font=>$GUI{fonts}->{header},
	    -anchor=>'w'
	   )->pack(-side=>'left',
		   -fill=>'both',
		   -expand=>1,
		   -anchor=>'e');

  $GUI{EditProfile}->{Done}->{Message}->{top} =
    $GUI{EditProfile}->{Done}->{top}->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'both',
		   -expand=>1);
  $GUI{EditProfile}->{Done}->{Message}->{Label} =
    $GUI{EditProfile}->{Done}->{Message}->{top}->
      Label(-text=>"Success!  Your profile has been created.  You may now click the Close button below and return to the Profile Editor and access your new profile.",
	    -wraplength=>250,
	    -justify=>"left",
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -anchor=>'e'
	   )->pack(-side=>'left',
		   -anchor=>'e');

  $GUI{EditProfile}->{Done}->{Buttons}->{top} =
    $GUI{EditProfile}->{Done}->{top}->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	   )->pack(-side=>'bottom',
		   -fill=>'both',
		   -expand=>1);
  $GUI{EditProfile}->{Done}->{Buttons}->{Close} =
    $GUI{EditProfile}->{Done}->{Buttons}->{top}->
      Button(-text=>"Close",
	     -width=>7,
	     -background=>$GUI{color}->{bg}->{normal},
	     -foreground=>$GUI{color}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{
	       &jarlProfileIF_EditProfileCloseCB();
	     }
	    )->pack(-side=>"right",
		    -padx=>$GUI{width}->{jarl}->{config}->{pad});

  #---------------------------------------------------------------------------
  #
  # Raise the first tab
  #
  #---------------------------------------------------------------------------
  $GUI{EditProfile}->{TabBar}->RaiseTab("connections") if ($profile ne "");
  $GUI{EditProfile}->{TabBar}->RaiseTab("start") if ($profile eq "");
}


sub jarlProfileIF_PromptForConnection {
  my $cancel = shift;
  $cancel = 0 unless defined($cancel);

  $TabBar->Print("__jarl__:tabbar:transient","Connections:\n");

  my $count = 0;
  foreach my $connection (sort {$a cmp $b} keys(%{$profileHash{connections}})) {
    $TabBar->Print("__jarl__:tabbar:transient","  $count) $connection\n");
    $count++;
  }
  return if (($cancel == 0) && ($count == 0));
  $TabBar->Print("__jarl__:tabbar:transient","  c) Cancel\n") if ($cancel);
  my $connection = &jarlMainIF_Prompt(prompt=>"Connection:",
				      options=>[0..($count-1),($cancel ? ("c") : ())],
				      default=>(($count == 0) ? "c" : 0));
  return if ($connection eq "c");
  return (sort {$a cmp $b} keys(%{$profileHash{connections}}))[$connection];
}




sub jarlProfileIF_EditConnection {
  my $connection = shift;

  $connection = "" unless defined($connection);

  my %connection;
  if ($connection ne "") {
    $connection{name} = $connection;
    $connection{oldName} = $connection;
    $connection{type} = $profileHash{connections}->{$connection}->{type};
    $connection{port} = $profileHash{connections}->{$connection}->{port};
  } else {
    $connection{type} = "TCP/IP";
    $connection{port} = "5222";
  }

  $connection{name} =
    &jarlMainIF_Prompt(prompt=>"Name",
		       (exists($connection{name}) ?
			(default=>$connection{name}) :
			())
		      );

  my $count = 0;
  my $default;
  $TabBar->Print("Connection Types:\n");
  foreach my $conType (sort {$a cmp $b} keys(%connectiontypes)) {
    $default = $count if ($conType eq "TCP/IP");
    $TabBar->Print("  $count) $conType\n");
    $count++;
  }
  my $type = &jarlMainIF_Prompt(prompt=>"Type",
				default=>$default,
				options=>[0..($count-1)]);
  $connection{type} = (sort {$a cmp $b} keys(%connectiontypes))[$type];

  $connection{port} = &jarlMainIF_Prompt(prompt=>"Port",
					 default=>$connectiontypes{$connection{type}}->[1]);

  delete($profileHash{connections}->{$connection{oldname}}) 
    if (exists($connection{oldname}) && ($connection{name} ne $connection{oldname}));
  $profileHash{connections}->{$connection{name}}->{type} = $connection{type};
  $profileHash{connections}->{$connection{name}}->{port} = $connection{port};
}


sub jarlProfileIF_SaveProfile {
  my ($profile) = @_;

  $profile = "" unless defined($profile);

  my $profileName = $profileHash{profile};

  if (!exists($profiles{$profileName})) {
    $profiles{$profileName} = new Jarl::Profile();
  }

  $profiles{$profileName}->Name($profileName);
  $profiles{$profileName}->Server($profileHash{server});
  $profiles{$profileName}->Username($profileHash{account}->{username});
  $profiles{$profileName}->Password($profileHash{account}->{password1});
  $profiles{$profileName}->Resource($profileHash{account}->{resource});

  delete($profiles{$profile}) if ($profile ne $profileName);

  $profiles{$profileName}->ConnectionObjClear();
  $profiles{$profileName}->ConnectionProfile($profileHash{connectionprofile});
  
  foreach my $connectionName (keys(%{$profileHash{connections}})) {
    my $connection = new Jarl::Profile::Connection();    
    $connection->Name($connectionName);
    $connection->Port($profileHash{connections}->{$connectionName}->{port});
    $connection->Type($profileHash{connections}->{$connectionName}->{type});
    $profiles{$profileName}->ConnectionObj($connectionName,$connection);
  }

  &jarlProfileIF_DepopulateProfileList();
  &jarlProfileIF_PopulateProfileList();

  $profiles{$profileName}->Save();
}


##############################################################################
#
# jarlProfileIF_EditorField - creates a field in the edit based on some 
#                           settings.
#
##############################################################################
sub jarlProfileIF_EditorField {
  my ($widget,$hash,$field,$fieldValue,$show) = @_;

  $profileHash{$hash}->{$field} = $fieldValue;

  $widget->{Fields}->{$field}->{top} =
    $widget->{top}->
      Frame(-background=>$GUI{color}->{window}->{bg}->{normal},
	    -foreground=>$GUI{color}->{window}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'both',
		   -expand=>1);
  $widget->{Fields}->{$field}->{Label} =
    $widget->{Fields}->{$field}->{top}->
      Label(-text=>ucfirst($field).":",
	    -width=>$GUI{width}->{jarl}->{profileeditor}->{label},
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -anchor=>'e'
	   )->pack(-side=>'left',
		   -anchor=>'e');
  $widget->{Fields}->{$field}->{Entry} =
    $widget->{Fields}->{$field}->{top}->
      Entry(-textvariable=>\$profileHash{$hash}->{$field},
	    -width=>$GUI{width}->{jarl}->{profileeditor}->{entry},
	    -background=>$GUI{color}->{bg}->{light},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -state=>"normal"
	   )->pack(-side=>'left',
		   -anchor=>'w');
  $widget->{Fields}->{$field}->{Entry}->configure(-show=>"*") if ($show == 0);
}


1;
