##############################################################################
#
# Jarl - Profile Tk Interface Code
#   Perl code to handle showing the Jarl Profile Editor GUI and interfacing
# with it.
#
##############################################################################

##############################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#  Jabber
#  Copyright (C) 1998-1999 The Jabber Team http://jabber.org/
#
##############################################################################


##############################################################################
#
# jarlProfileIF_EditorGUI - opens the Profile Editor GUI.
#
##############################################################################
sub jarlProfileIF_EditorGUI {

  if (exists($GUI{ProfileEditor})) {
    $GUI{ProfileEditor}->{window}->raise();
    return;
  }

  $GUI{ProfileEditor}->{window} =
    $GUI{top}->
      Toplevel(-background=>$GUI{color}->{window}->{bg}->{normal},
	       -foreground=>$GUI{color}->{window}->{fg}->{dark});
  $GUI{ProfileEditor}->{window}->title("Profile Editor");
  $GUI{ProfileEditor}->{window}->resizable(0,0);

  $GUI{ProfileEditor}->{Left} =
    $GUI{ProfileEditor}->{window}->
      Frame(-background=>$GUI{color}->{window}->{bg}->{normal},
	    -foreground=>$GUI{color}->{window}->{fg}->{dark}
	   )->pack(-side=>"left",
		   -expand=>1,
		   -fill=>"both",
		   -pady=>$GUI{height}->{pad},
		   -padx=>$GUI{width}->{pad});

  $GUI{ProfileEditor}->{Right} =
    $GUI{ProfileEditor}->{window}->
      Frame(-background=>$GUI{color}->{window}->{bg}->{normal},
	    -foreground=>$GUI{color}->{window}->{fg}->{dark}
	   )->pack(-side=>"right",
		   -expand=>1,
		   -fill=>"both",
		   -pady=>$GUI{height}->{pad},
		   -padx=>$GUI{width}->{pad});

  $GUI{ProfileEditor}->{Profiles}->{top} =
    $GUI{ProfileEditor}->{Left}->
      Frame(-background=>$GUI{color}->{window}->{bg}->{normal},
	    -foreground=>$GUI{color}->{window}->{fg}->{dark},
	    -borderwidth=>2,
	    -relief=>"sunken",
	   )->pack(-side=>"right",
		   -fill=>"y",
		   -pady=>$GUI{height}->{pad},
		   -padx=>$GUI{width}->{pad});

  $GUI{ProfileEditor}->{Profiles}->{Scrolled} =
    $GUI{ProfileEditor}->{Profiles}->{top}->
      Scrolled("Listbox",
               -scrollbars=>"osoe",
               -width=>30,
               -height=>10,
               -highlightthickness=>0,
               -background=>$GUI{color}->{bg}->{light},
               -foreground=>$GUI{color}->{fg}->{dark},
               -selectbackground=>$GUI{color}->{bg}->{normal},
               -selectforeground=>$GUI{color}->{fg}->{dark},
               -font=>$GUI{fonts}->{normal},
               -selectmode=>"single",
               -exportselection=>0,
               -borderwidth=>0,
               -selectborderwidth=>0,
               -relief=>"flat",
              )->pack(-side=>"left",
                      -fill=>"both",
                      -padx=>0);

  $GUI{ProfileEditor}->{Profiles}->{YScrollbar} = 
    $GUI{ProfileEditor}->{Profiles}->{Scrolled}->
      Subwidget("yscrollbar");
  $GUI{ProfileEditor}->{Profiles}->{YScrollbar}->
    configure(-width=>10,
              -borderwidth=>1,
              -highlightthickness=>0,
              -relief=>"flat");
  $GUI{ProfileEditor}->{Profiles}->{XScrollbar} = 
    $GUI{ProfileEditor}->{Profiles}->{Scrolled}->
      Subwidget("xscrollbar");
  $GUI{ProfileEditor}->{Profiles}->{XScrollbar}->
    configure(-width=>10,
              -borderwidth=>1,
              -highlightthickness=>0,
              -relief=>"flat");
  $GUI{ProfileEditor}->{Profiles}->{Listbox} = 
    $GUI{ProfileEditor}->{Profiles}->{Scrolled}->
      Subwidget("listbox");

  &jarlProfileIF_PopulateProfileList();

  $GUI{ProfileEditor}->{Profiles}->{Listbox}->
    bind("<Double-Button-1>",
         sub {
	   my $selection = 
	     $GUI{ProfileEditor}->{Profiles}->{Listbox}->curselection();
	   return if ($selection eq "");

	   my $profile = 
	     $GUI{ProfileEditor}->{Profiles}->{Listbox}->get($selection);

           &jarlProfileIF_EditProfile($profile);
         });

  $GUI{ProfileEditor}->{Buttons}->{New} =
    $GUI{ProfileEditor}->{Right}->
      Button(-text=>"New",
	     -width=>7,
	     -background=>$GUI{color}->{bg}->{normal},
	     -foreground=>$GUI{color}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{
	       &jarlProfileIF_EditProfile();
	     }
	    )->pack(-side=>"top",
		    -pady=>$GUI{height}->{pad},
		    -padx=>$GUI{width}->{pad});

  $GUI{ProfileEditor}->{Buttons}->{Edit} =
    $GUI{ProfileEditor}->{Right}->
      Button(-text=>"Edit",
	     -width=>7,
	     -background=>$GUI{color}->{bg}->{normal},
	     -foreground=>$GUI{color}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{
	       my $profile= 
		 $GUI{ProfileEditor}->{Profiles}->{Listbox}->
		   get($GUI{ProfileEditor}->{Profiles}->{Listbox}->curselection());
	       
	       return if $profile eq "";
	       
	       &jarlProfileIF_EditProfile($profile);
	     }
	    )->pack(-side=>"top",
		    -pady=>$GUI{height}->{pad},
		    -padx=>$GUI{width}->{pad});

  $GUI{ProfileEditor}->{Buttons}->{Delete} =
    $GUI{ProfileEditor}->{Right}->
      Button(-text=>"Delete",
	     -width=>7,
	     -background=>$GUI{color}->{bg}->{normal},
	     -foreground=>$GUI{color}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{
	       my $profile =
		 $GUI{ProfileEditor}->{Profiles}->{Listbox}->
		   get($GUI{ProfileEditor}->{Profiles}->{Listbox}->curselection());
	       
	       return if $profile eq "";
	       $profiles{$profile}->Erase();
	       delete($profiles{$profile});
	       &jarlProfileIF_DepopulateProfileList();
	       &jarlProfileIF_PopulateProfileList();
	     }
	    )->pack(-side=>"top",
		    -pady=>$GUI{height}->{pad},
		    -padx=>$GUI{width}->{pad});

  
  $GUI{ProfileEditor}->{Buttons}->{Close} =
    $GUI{ProfileEditor}->{Right}->
      Button(-text=>"Close",
	     -width=>7,
	     -background=>$GUI{color}->{bg}->{normal},
	     -foreground=>$GUI{color}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{
	       if (Exists($GUI{Login}->{ProfilePullDown}->{Option})) {
		 my @newProfiles = ("Connect w/o Profile");
		 my $prof;
		 foreach $prof (sort {$a cmp $b} keys(%profiles)) {
		   next if ($prof eq "Connect w/o Profile");
		   push(@newProfiles,$prof);
		 }
		 $GUI{Login}->{ProfilePullDown}->{Option}->
		   configure(-options=>\@newProfiles);
	       }

	       &jarlProfileIF_ProfileEditorCloseCB();
     }
	    )->pack(-side=>"top",
		    -pady=>$GUI{height}->{pad},
		    -padx=>$GUI{width}->{pad});


}


sub jarlProfileIF_PopulateProfileList {
  foreach my $profile (sort {$a cmp $b} keys(%profiles)) {
    next if ($profile eq "Connect w/o Profile");
    $GUI{ProfileEditor}->{Profiles}->{Listbox}->insert("end",$profile);
  }
}


sub jarlProfileIF_DepopulateProfileList {
  $GUI{ProfileEditor}->{Profiles}->{Listbox}->delete(0,"end");
}


###########################################################################
#
# jarlProfileIF_ProfileEditorCloseCB - close the EditProfile GUI.
#
###########################################################################
sub jarlProfileIF_ProfileEditorCloseCB {
  $GUI{ProfileEditor}->{window}->destroy;
  delete($GUI{ProfileEditor});
}




sub jarlProfileIF_EditProfile {
  my ($profile) = @_;

  if (Exists($GUI{EditProfile}->{window})) {
    $GUI{EditProfile}->{window}->raise();
    return;
  }

  $profile = "" if !defined($profile);

  $GUI{EditProfile}->{vars}->{accounttype} = "new";
  $GUI{EditProfile}->{vars}->{accounttype} = "exist" if ($profile ne "");

  if($profile ne "") {
    $GUI{EditProfile}->{vars}->{profile} =
      $profiles{$profile}->Name();
    $GUI{EditProfile}->{vars}->{server} =
      $profiles{$profile}->Server();
    $GUI{EditProfile}->{vars}->{account}->{username} =
      $profiles{$profile}->Username();
    $GUI{EditProfile}->{vars}->{account}->{password1} =
      $profiles{$profile}->Password();
    $GUI{EditProfile}->{vars}->{account}->{password2} =
      $profiles{$profile}->Password();
    $GUI{EditProfile}->{vars}->{account}->{resource} =
      $profiles{$profile}->Resource();

    foreach my $connectionName ($profiles{$profile}->ConnectionObj()) {
      my $connection = $profiles{$profile}->ConnectionObj($connectionName);

      $GUI{EditProfile}->{vars}->{connections}->{$connectionName}->{type} =
	$connection->Type();
      $GUI{EditProfile}->{vars}->{connections}->{$connectionName}->{port} =
	$connection->Port();
    }
  }




  $GUI{EditProfile}->{window} = 
    $GUI{top}->
      Toplevel(-background=>$GUI{color}->{window}->{bg}->{normal},
	       -foreground=>$GUI{color}->{window}->{fg}->{dark});
  $GUI{EditProfile}->{window}->
    title(($profile eq "") ? "New Profile" : "Edit Profile: $profile");
  $GUI{EditProfile}->{window}->resizable(0,0);

  $GUI{EditProfile}->{TabBar} =
    $GUI{EditProfile}->{window}->
      TabBar(-background=>$GUI{color}->{jarl}->{main}->{bg}->{dark},
             -tabthickness=>$GUI{width}->{jarl}->{main}->{tabs}->{thickness},
             -tabfill=>$GUI{color}->{jarl}->{main}->{bg}->{light},
             -tabbackground=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
             -tabforeground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
             -tabfont=>$GUI{fonts}->{normal},
             -tabpadx=>$GUI{width}->{jarl}->{main}->{pad},
             -tabpady=>$GUI{height}->{jarl}->{main}->{pad},
            )->pack(-side=>'top',
                    -fill=>'both',
                    -expand=>1);

  $GUI{EditProfile}->{TabBar}->HideCanvas();

  $GUI{EditProfile}->{Start}->{top} =
    $GUI{EditProfile}->{TabBar}->AddTab(-tag=>"start",
					-text=>"Start");
  $GUI{EditProfile}->{Config}->{top} =
    $GUI{EditProfile}->{TabBar}->AddTab(-tag=>"config",
					-text=>"Name and Server");
  $GUI{EditProfile}->{Connections}->{top} = 
    $GUI{EditProfile}->{TabBar}->AddTab(-tag=>"connections",
					-text=>"Connections");
  $GUI{EditProfile}->{Account}->{top} =
    $GUI{EditProfile}->{TabBar}->AddTab(-tag=>"account",
					-text=>"Account");
  $GUI{EditProfile}->{UserInfo}->{top} =
    $GUI{EditProfile}->{TabBar}->AddTab(-tag=>"userinfo",
					-text=>"User Info");
  $GUI{EditProfile}->{Done}->{top} =
    $GUI{EditProfile}->{TabBar}->AddTab(-tag=>"done",
					-text=>"Done");

  #---------------------------------------------------------------------------
  #
  # Start - Determine is this is a new account or an existing one.
  #
  #---------------------------------------------------------------------------

  $GUI{EditProfile}->{Start}->{Header}->{top} =
    $GUI{EditProfile}->{Start}->{top}->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'both',
		   -expand=>1);
  $GUI{EditProfile}->{Start}->{Header}->{Label} =
    $GUI{EditProfile}->{Start}->{Header}->{top}->
      Label(-text=>"Start",
	    -background=>$GUI{color}->{bg}->{darkest},
	    -foreground=>$GUI{color}->{fg}->{lightest},
	    -font=>$GUI{fonts}->{header},
	    -anchor=>'w'
	   )->pack(-side=>'left',
		   -fill=>'both',
		   -expand=>1,
		   -anchor=>'e');

  $GUI{EditProfile}->{Start}->{Instructions}->{top} =
    $GUI{EditProfile}->{Start}->{top}->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'both',
		   -expand=>1);
  $GUI{EditProfile}->{Start}->{Instructions}->{Label} =
    $GUI{EditProfile}->{Start}->{Instructions}->{top}->
      Label(-text=>"First we need to know the status of the account that is going to be attached to this profile:",
	    -wraplength=>250,
	    -justify=>"left",
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -anchor=>'e'
	   )->pack(-side=>'left',
		   -anchor=>'e');

  $GUI{EditProfile}->{Start}->{Choices}->{top} =
    $GUI{EditProfile}->{Start}->{top}->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'both',
		   -expand=>1);

  $GUI{EditProfile}->{Start}->{Choices}->{NewAccount}->{top} =
    $GUI{EditProfile}->{Start}->{Choices}->{top}->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'both',
		   -expand=>1);
  $GUI{EditProfile}->{Start}->{Choices}->{NewAccount}->{Radio} =
    $GUI{EditProfile}->{Start}->{Choices}->{NewAccount}->{top}->
      Radiobutton(-value=>"new",
		  -variable=>\$GUI{EditProfile}->{vars}->{accounttype},
		  -activebackground=>$GUI{color}->{bg}->{normal},
		  -background=>$GUI{color}->{bg}->{normal},
		  -foreground=>$GUI{color}->{fg}->{dark},
		  -font=>$GUI{fonts}->{normal},
		  -selectimage=>$GUI{Icons}->{RadioOn},
		  -image=>$GUI{Icons}->{RadioOff},
		  -indicatoron=>0,
		  -borderwidth=>0,
		  -selectcolor=>$GUI{color}->{bg}->{normal},
		 )->pack(-side=>'left',
			 -anchor=>'w');
  &jarlMainIF_RegisterIcon($GUI{EditProfile}->{Start}->{Choices}->{NewAccount}->{Radio},"RadioOff");
  $GUI{EditProfile}->{Start}->{Choices}->{NewAccount}->{Label} =
    $GUI{EditProfile}->{Start}->{Choices}->{NewAccount}->{top}->
      Label(-text=>"New Account",
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	   )->pack(-side=>'left',
		   -anchor=>'w');
  $GUI{EditProfile}->{Start}->{Choices}->{NewAccount}->{Label}->
    bind("<Button-1>",sub{ $GUI{EditProfile}->{vars}->{accounttype} = "new"; });

  $GUI{EditProfile}->{Start}->{Choices}->{ExistingAccount}->{top} =
    $GUI{EditProfile}->{Start}->{Choices}->{top}->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'both',
		   -expand=>1);
  $GUI{EditProfile}->{Start}->{Choices}->{ExistingAccount}->{Radio} =
    $GUI{EditProfile}->{Start}->{Choices}->{ExistingAccount}->{top}->
      Radiobutton(-value=>"exist",
		  -variable=>\$GUI{EditProfile}->{vars}->{accounttype},
		  -activebackground=>$GUI{color}->{bg}->{normal},
		  -background=>$GUI{color}->{bg}->{normal},
		  -foreground=>$GUI{color}->{fg}->{dark},
		  -font=>$GUI{fonts}->{normal},
		  -selectimage=>$GUI{Icons}->{RadioOn},
		  -image=>$GUI{Icons}->{RadioOff},
		  -indicatoron=>0,
		  -borderwidth=>0,
		  -selectcolor=>$GUI{color}->{bg}->{normal},
		 )->pack(-side=>'left',
			 -anchor=>'w');
  &jarlMainIF_RegisterIcon($GUI{EditProfile}->{Start}->{Choices}->{ExistingAccount}->{Radio},"RadioOff");
  $GUI{EditProfile}->{Start}->{Choices}->{ExistingAccount}->{Label} =
    $GUI{EditProfile}->{Start}->{Choices}->{ExistingAccount}->{top}->
      Label(-text=>"Existing Account",
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	   )->pack(-side=>'left',
		   -anchor=>'w');
  $GUI{EditProfile}->{Start}->{Choices}->{ExistingAccount}->{Label}->
    bind("<Button-1>",sub{ $GUI{EditProfile}->{vars}->{accounttype} = "exist"; });

  $GUI{EditProfile}->{Start}->{Buttons}->{top} =
    $GUI{EditProfile}->{Start}->{top}->
      Frame(-background=>$GUI{color}->{window}->{bg}->{normal},
	    -foreground=>$GUI{color}->{window}->{fg}->{dark},
	   )->pack(-side=>'bottom',
		   -fill=>'both',
		   -expand=>1);
  $GUI{EditProfile}->{Start}->{Buttons}->{Next} =
    $GUI{EditProfile}->{Start}->{Buttons}->{top}->
      Button(-text=>"Next >>",
	     -width=>7,
	     -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	     -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{jarl}->{config}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{
	       $GUI{EditProfile}->{TabBar}->RaiseTab("config");
	     }
	    )->pack(-side=>"right",
		    -padx=>$GUI{width}->{jarl}->{config}->{pad});
  $GUI{EditProfile}->{Start}->{Buttons}->{Cancel} =
    $GUI{EditProfile}->{Start}->{Buttons}->{top}->
      Button(-text=>"Cancel",
	     -width=>7,
	     -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	     -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{jarl}->{config}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{
	       &jarlProfileIF_EditProfileCloseCB();
	     }
	    )->pack(-side=>"right",
		    -padx=>$GUI{width}->{jarl}->{config}->{pad});

  #---------------------------------------------------------------------------
  #
  # Config - Profile Name and Server information
  #
  #---------------------------------------------------------------------------

  $GUI{EditProfile}->{Config}->{Header}->{top} =
    $GUI{EditProfile}->{Config}->{top}->
      Frame(-background=>$GUI{color}->{window}->{bg}->{normal},
	    -foreground=>$GUI{color}->{window}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'both',
		   -expand=>1);
  $GUI{EditProfile}->{Config}->{Header}->{Label} =
    $GUI{EditProfile}->{Config}->{Header}->{top}->
      Label(-text=>"Config",
	    -background=>$GUI{color}->{bg}->{darkest},
	    -foreground=>$GUI{color}->{fg}->{lightest},
	    -font=>$GUI{fonts}->{header},
	    -anchor=>'w'
	   )->pack(-side=>'left',
		   -fill=>'both',
		   -expand=>1,
		   -anchor=>'e');

  $GUI{EditProfile}->{Config}->{ProfileName}->{top} =
    $GUI{EditProfile}->{Config}->{top}->
      Frame(-background=>$GUI{color}->{window}->{bg}->{normal},
	    -foreground=>$GUI{color}->{window}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'both',
		   -expand=>1);
  $GUI{EditProfile}->{Config}->{ProfileName}->{Label} =
    $GUI{EditProfile}->{Config}->{ProfileName}->{top}->
      Label(-text=>"Profile Name:",
	    -width=>15,
	    -background=>$GUI{color}->{jarl}->{profileeditor}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{profileeditor}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -anchor=>'e'
	   )->pack(-side=>'left',
		   -anchor=>'e');
  $GUI{EditProfile}->{Config}->{ProfileName}->{Entry} =
    $GUI{EditProfile}->{Config}->{ProfileName}->{top}->
      Entry(-textvariable=>\$GUI{EditProfile}->{vars}->{profile},
	    -width=>$GUI{width}->{jarl}->{config}->{entry},
	    -background=>$GUI{color}->{jarl}->{config}->{bg}->{light},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	   )->pack(-side=>'left',
		   -anchor=>'w');

  $GUI{EditProfile}->{Config}->{Server}->{top} =
    $GUI{EditProfile}->{Config}->{top}->
      Frame(-background=>$GUI{color}->{window}->{bg}->{normal},
	    -foreground=>$GUI{color}->{window}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'both',
		   -expand=>1);
  $GUI{EditProfile}->{Config}->{Server}->{Label} =
    $GUI{EditProfile}->{Config}->{Server}->{top}->
      Label(-text=>"Server:",
	    -width=>15,
	    -background=>$GUI{color}->{jarl}->{profileeditor}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{profileeditor}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -anchor=>'e'
	   )->pack(-side=>'left',
		   -anchor=>'e');
  $GUI{EditProfile}->{Config}->{Server}->{Entry} =
    $GUI{EditProfile}->{Config}->{Server}->{top}->
      Entry(-textvariable=>\$GUI{EditProfile}->{vars}->{server},
	    -width=>$GUI{width}->{jarl}->{config}->{entry},
	    -background=>$GUI{color}->{jarl}->{config}->{bg}->{light},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	   )->pack(-side=>'left',
		   -anchor=>'w');

  $GUI{EditProfile}->{Config}->{Buttons}->{top} =
    $GUI{EditProfile}->{Config}->{top}->
      Frame(-background=>$GUI{color}->{window}->{bg}->{normal},
	    -foreground=>$GUI{color}->{window}->{fg}->{dark},
	   )->pack(-side=>'bottom',
		   -fill=>'both',
		   -expand=>1);
  $GUI{EditProfile}->{Config}->{Buttons}->{Next} =
    $GUI{EditProfile}->{Config}->{Buttons}->{top}->
      Button(-text=>"Next >>",
	     -width=>7,
	     -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	     -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{jarl}->{config}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{
	       return 
		 unless (($GUI{EditProfile}->{vars}->{profile} ne "") &&
			 ($GUI{EditProfile}->{vars}->{server} ne ""));
	       $GUI{EditProfile}->{TabBar}->RaiseTab("connections");
	     }
	    )->pack(-side=>"right",
		    -padx=>$GUI{width}->{jarl}->{config}->{pad});
  $GUI{EditProfile}->{Config}->{Buttons}->{Cancel} =
    $GUI{EditProfile}->{Config}->{Buttons}->{top}->
      Button(-text=>"Cancel",
	     -width=>7,
	     -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	     -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{jarl}->{config}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{
	       &jarlProfileIF_EditProfileCloseCB();
	     }
	    )->pack(-side=>"right",
		    -padx=>$GUI{width}->{jarl}->{config}->{pad});
  if ($profile eq "") {
    $GUI{EditProfile}->{Config}->{Buttons}->{Back} =
      $GUI{EditProfile}->{Config}->{Buttons}->{top}->
	Button(-text=>"<< Back",
	       -width=>7,
	       -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	       -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	       -disabledforeground=>$GUI{color}->{jarl}->{config}->{fg}->{light},
	       -font=>$GUI{fonts}->{normal},
	       -command=>sub{
		 $GUI{EditProfile}->{TabBar}->RaiseTab("start");
	       }
	      )->pack(-side=>"right",
		      -padx=>$GUI{width}->{jarl}->{config}->{pad});
  }

  #---------------------------------------------------------------------------
  #
  # Connections - Connections manager/editor
  #
  #---------------------------------------------------------------------------
  $GUI{EditProfile}->{Connections}->{Header}->{top} =
    $GUI{EditProfile}->{Connections}->{top}->
      Frame(-background=>$GUI{color}->{window}->{bg}->{normal},
	    -foreground=>$GUI{color}->{window}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'both',
		   -expand=>1);
  $GUI{EditProfile}->{Connections}->{Header}->{Label} =
    $GUI{EditProfile}->{Connections}->{Header}->{top}->
      Label(-text=>"Connections",
	    -background=>$GUI{color}->{bg}->{darkest},
	    -foreground=>$GUI{color}->{fg}->{lightest},
	    -font=>$GUI{fonts}->{header},
	    -anchor=>'w'
	   )->pack(-side=>'left',
		   -fill=>'both',
		   -expand=>1,
		   -anchor=>'e');

  if ($profile eq "") {
    $GUI{EditProfile}->{vars}->{connections}->{"Normal"}->{type} = "TCP/IP";
    $GUI{EditProfile}->{vars}->{connections}->{"Normal"}->{port} = 5222;
  }

  $GUI{EditProfile}->{Connections}->{Left}->{top} =
    $GUI{EditProfile}->{Connections}->{top}->
      Frame(-background=>$GUI{color}->{window}->{bg}->{normal},
	    -foreground=>$GUI{color}->{window}->{fg}->{dark},
	   )->pack(-side=>"left",
		   -fill=>"y",
		   -pady=>$GUI{height}->{pad},
		   -padx=>$GUI{width}->{pad});

  $GUI{EditProfile}->{Connections}->{List}->{top} =
    $GUI{EditProfile}->{Connections}->{Left}->{top}->
      Frame(-background=>$GUI{color}->{window}->{bg}->{normal},
	    -foreground=>$GUI{color}->{window}->{fg}->{dark},
	    -borderwidth=>2,
	    -relief=>"sunken",
	   )->pack(-side=>"top",
		   -fill=>"y",
		   -pady=>$GUI{height}->{pad},
		   -padx=>$GUI{width}->{pad});

  $GUI{EditProfile}->{Connections}->{List}->{Scrolled} =
    $GUI{EditProfile}->{Connections}->{List}->{top}->
      Scrolled("Listbox",
               -scrollbars=>"osoe",
               -width=>15,
               -height=>5,
               -highlightthickness=>0,
               -background=>$GUI{color}->{bg}->{light},
               -foreground=>$GUI{color}->{fg}->{dark},
               -selectbackground=>$GUI{color}->{bg}->{normal},
               -selectforeground=>$GUI{color}->{fg}->{dark},
               -font=>$GUI{fonts}->{normal},
               -selectmode=>"single",
               -exportselection=>0,
               -borderwidth=>0,
               -selectborderwidth=>0,
               -relief=>"flat",
              )->pack(-side=>"left",
                      -fill=>"both",
                      -padx=>0);

  $GUI{EditProfile}->{Connections}->{List}->{YScrollbar} = 
    $GUI{EditProfile}->{Connections}->{List}->{Scrolled}->
      Subwidget("yscrollbar");
  $GUI{EditProfile}->{Connections}->{List}->{YScrollbar}->
    configure(-width=>10,
              -borderwidth=>1,
              -highlightthickness=>0,
              -relief=>"flat");
  $GUI{EditProfile}->{Connections}->{List}->{XScrollbar} = 
    $GUI{EditProfile}->{Connections}->{List}->{Scrolled}->
      Subwidget("xscrollbar");
  $GUI{EditProfile}->{Connections}->{List}->{XScrollbar}->
    configure(-width=>10,
              -borderwidth=>1,
              -highlightthickness=>0,
              -relief=>"flat");
  $GUI{EditProfile}->{Connections}->{List}->{Listbox} = 
    $GUI{EditProfile}->{Connections}->{List}->{Scrolled}->
      Subwidget("listbox");

  $GUI{EditProfile}->{Connections}->{List}->{Listbox}->
    bind("<Double-Button-1>",
         sub {
	   my $selection = 
	     $GUI{EditProfile}->{Connections}->{List}->{Listbox}->
	       curselection();
	   return if ($selection eq "");

	   my $connection = 
	     $GUI{EditProfile}->{Connections}->{List}->{Listbox}->
	       get($selection);

           &jarlProfileIF_EditConnection($connection);
         });

  $GUI{EditProfile}->{Connections}->{Default}->{top} =
    $GUI{EditProfile}->{Connections}->{Left}->{top}->
      Frame(-background=>$GUI{color}->{window}->{bg}->{normal},
	    -foreground=>$GUI{color}->{window}->{fg}->{dark},
	   )->pack(-side=>"top",
		   -fill=>"x",
		   -pady=>$GUI{height}->{pad},
		   -padx=>$GUI{width}->{pad});

  $GUI{EditProfile}->{Connections}->{Default}->{Option} = 
    $GUI{EditProfile}->{Connections}->{Default}->{top}->
      Optionmenu(-options=>[],
		 -variable=>\$GUI{EditProfile}->{vars}->{connectionprofile},
		 -background=>$GUI{color}->{bg}->{normal},
		 -foreground=>$GUI{color}->{fg}->{dark},
		 -font=>$GUI{fonts}->{normal},
		)->pack(-side=>'left',
			-anchor=>'w');


  &jarlProfileIF_PopulateConnectionList();

  $GUI{EditProfile}->{Connections}->{ProfileButtons}->{top} =
    $GUI{EditProfile}->{Connections}->{top}->
      Frame(-background=>$GUI{color}->{window}->{bg}->{normal},
	    -foreground=>$GUI{color}->{window}->{fg}->{dark},
	   )->pack(-side=>"left",
		   -fill=>"y",
		   -pady=>$GUI{height}->{pad},
		   -padx=>$GUI{width}->{pad});

  $GUI{EditProfile}->{Connections}->{ProfileButtons}->{top}->
    Button(-text=>"New",
	   -width=>7,
	     -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	     -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{jarl}->{config}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{
	       &jarlProfileIF_EditConnection();
	     }
	  )->pack(-side=>"top");
  
  $GUI{EditProfile}->{Connections}->{ProfileButtons}->{top}->
    Button(-text=>"Edit",
	   -width=>7,
	   -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	   -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	   -disabledforeground=>$GUI{color}->{jarl}->{config}->{fg}->{light},
	   -font=>$GUI{fonts}->{normal},
	   -command=>sub{
	     my $selection = 
	       $GUI{EditProfile}->{Connections}->{List}->{Listbox}->
		 curselection();
	     return if ($selection eq "");
	     
	     my $connection = 
	       $GUI{EditProfile}->{Connections}->{List}->{Listbox}->
		 get($selection);
	     	  
	     &jarlProfileIF_EditConnection($connection);
	   }
	  )->pack(-side=>"top");
  
  $GUI{EditProfile}->{Connections}->{ProfileButtons}->{top}->
    Button(-text=>"Save",
	   -width=>7,
	   -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	   -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	   -disabledforeground=>$GUI{color}->{jarl}->{config}->{fg}->{light},
	   -font=>$GUI{fonts}->{normal},
	   -command=>sub{
	     &jarlProfileIF_SaveConnection();
	   }
	  )->pack(-side=>"top");
  
  $GUI{EditProfile}->{Connections}->{ProfileButtons}->{top}->
    Button(-text=>"Delete",
	   -width=>7,
	   -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	   -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	   -disabledforeground=>$GUI{color}->{jarl}->{config}->{fg}->{light},
	   -font=>$GUI{fonts}->{normal},
	   -command=>sub{

	     my $selection = 
	       $GUI{EditProfile}->{Connections}->{List}->{Listbox}->
		 curselection();
	     return if ($selection eq "");

	     my $connection = 
	       $GUI{EditProfile}->{Connections}->{List}->{Listbox}->
		 get($selection);
	     
	     delete($GUI{EditProfile}->{vars}->{connections}->{$connection});

	     &jarlProfileIF_DepopulateConnectionList();
	     &jarlProfileIF_PopulateConnectionList();
	   }
	  )->pack(-side=>"top");



  $GUI{EditProfile}->{Connections}->{Name}->{top} =
    $GUI{EditProfile}->{Connections}->{top}->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'both',
		   -expand=>1);
  $GUI{EditProfile}->{Connections}->{Name}->{Label} =
    $GUI{EditProfile}->{Connections}->{Name}->{top}->
      Label(-text=>"Connection Name:",
	    -width=>15,
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -anchor=>'e'
	   )->pack(-side=>'left',
		   -anchor=>'e');
  $GUI{EditProfile}->{Connections}->{Name}->{Entry} =
    $GUI{EditProfile}->{Connections}->{Name}->{top}->
      Entry(-textvariable=>\$GUI{EditProfile}->{vars}->{connection}->{name},
	    -width=>$GUI{width}->{jarl}->{config}->{entry},
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -state=>"disabled"
	   )->pack(-side=>'left',
		   -anchor=>'w');

  $GUI{EditProfile}->{Connections}->{Type}->{top} =
    $GUI{EditProfile}->{Connections}->{top}->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark}
	   )->pack(-side=>"top",
		   -fill=>"both",
		   -expand=>1);
  $GUI{EditProfile}->{Connections}->{Type}->{Label} =
    $GUI{EditProfile}->{Connections}->{Type}->{top}->
      Label(-text=>"Type:",
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -width=>15,
	    -anchor=>"e"
	   )->pack(-side=>'left',
		   -anchor=>'e');
  $GUI{EditProfile}->{Connections}->{Type}->{Option} =
    $GUI{EditProfile}->{Connections}->{Type}->{top}->
      Optionmenu(-options=>[sort( {$a cmp $b} keys(%connectiontypes)) ],
		 -variable=>\$GUI{EditProfile}->{vars}->{connection}->{type},
		 -background=>$GUI{color}->{bg}->{normal},
		 -foreground=>$GUI{color}->{fg}->{dark},
		 -font=>$GUI{fonts}->{normal},
		 -state=>"disabled",
		 -command=>sub{
		   $GUI{EditProfile}->{vars}->{connection}->{port} =
		     $connectiontypes{$GUI{EditProfile}->{vars}->{connection}->{type}}->[1];
		 }
		)->pack(-side=>'left',
			-anchor=>'w');

  $GUI{EditProfile}->{Connections}->{Port}->{top} =
    $GUI{EditProfile}->{Connections}->{top}->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'both',
		   -expand=>1);
  $GUI{EditProfile}->{Connections}->{Port}->{Label} =
    $GUI{EditProfile}->{Connections}->{Port}->{top}->
      Label(-text=>"Port:",
	    -width=>15,
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -anchor=>'e'
	   )->pack(-side=>'left',
		   -anchor=>'e');
  $GUI{EditProfile}->{Connections}->{Port}->{Entry} =
    $GUI{EditProfile}->{Connections}->{Port}->{top}->
      Entry(-textvariable=>\$GUI{EditProfile}->{vars}->{connection}->{port},
	    -width=>$GUI{width}->{jarl}->{config}->{entry},
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -state=>"disabled",
	   )->pack(-side=>'left',
		   -anchor=>'w');
  
  $GUI{EditProfile}->{Connections}->{Buttons}->{top} =
    $GUI{EditProfile}->{Connections}->{top}->
      Frame(-background=>$GUI{color}->{window}->{bg}->{normal},
	    -foreground=>$GUI{color}->{window}->{fg}->{dark},
	   )->pack(-side=>'bottom',
		   -fill=>'both',
		   -expand=>1);
  $GUI{EditProfile}->{Connections}->{Buttons}->{Next} =
    $GUI{EditProfile}->{Connections}->{Buttons}->{top}->
      Button(-text=>"Next >>",
	     -width=>7,
	     -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	     -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{jarl}->{config}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{
	       return
		 unless ($GUI{EditProfile}->{vars}->{connectionprofile} ne "");

	       if ($GUI{EditProfile}->{vars}->{accounttype} eq "new") {
		 my $Register =
		   new Net::Jabber::Client(debuglevel=>$optctl{debug},
					   debugtime=>1);

		 my $status =
		   $Register->
		     Connect(connectiontype=>$connectiontypes{$GUI{EditProfile}->{vars}->{connections}->{$GUI{EditProfile}->{vars}->{connectionprofile}}->{type}}->[0],
			     hostname=>$GUI{EditProfile}->{vars}->{server},
			     port=>$GUI{EditProfile}->{vars}->{connections}->{$GUI{EditProfile}->{vars}->{connectionprofile}}->{port},
			     ssl=>$connectiontypes{$GUI{EditProfile}->{vars}->{connections}->{$GUI{EditProfile}->{vars}->{connectionprofile}}->{type}}->[2],
			    );

		 if (!(defined($status))) {
		   &jarlErrorIF_Popup("","Cannot not connect to $GUI{EditProfile}->{vars}->{server}:$GUI{EditProfile}->{vars}->{connections}->{$GUI{EditProfile}->{vars}->{connectionprofile}}->{port}: ".$Register->GetErrorCode);
		   return;
		 }

		 my %fields = $Register->RegisterRequest(to=>$GUI{EditProfile}->{vars}->{server});

		 %fields = %{$fields{fields}};
		 delete($fields{registered});

		 $Register->Disconnect();

		 my $widget;
		 foreach $widget (keys(%{$GUI{EditProfile}->{UserInfo}->{Fields}})) {
		   next if ($widget eq "top");
		   $GUI{EditProfile}->{UserInfo}->{Fields}->{$widget}->{top}->packForget();
		   delete($GUI{EditProfile}->{UserInfo}->{Fields}->{$widget});
		 }

		 if (!Exists($GUI{EditProfile}->{Account}->{instructions}->{Label})) {
		   $GUI{EditProfile}->{Account}->{instructions}->{Label} =
		     $GUI{EditProfile}->{Account}->{instructions}->{top}->
		       Label(-text=>"Instructions:",
			     -width=>$GUI{width}->{jarl}->{profileeditor}->{label},
			     -background=>$GUI{color}->{bg}->{normal},
			     -foreground=>$GUI{color}->{fg}->{dark},
			     -font=>$GUI{fonts}->{normal},
			     -anchor=>'ne'
			    )->pack(-side=>'left',
				    -anchor=>'e');
		   $GUI{EditProfile}->{Account}->{instructions}->{Value} =
		     $GUI{EditProfile}->{Account}->{instructions}->{top}->
		       Label(-text=>$fields{instructions},
			     -wraplength=>250,
			     -justify=>"left",
			     -background=>$GUI{color}->{bg}->{normal},
			     -foreground=>$GUI{color}->{fg}->{dark},
			     -font=>$GUI{fonts}->{normal},
			     -anchor=>'w'
			    )->pack(-side=>'left',
				    -anchor=>'w');
		 }

		 if (exists($fields{instructions})) {
		   $GUI{EditProfile}->{Account}->{instructions}->{Value}->
		     configure(-text=>$fields{instructions});
		   
		   $GUI{EditProfile}->{UserInfo}->{Fields}->{instructions}->{top} =
		     $GUI{EditProfile}->{UserInfo}->{top}->
		       Frame(-background=>$GUI{color}->{bg}->{normal},
			     -foreground=>$GUI{color}->{fg}->{dark},
			  )->pack(-side=>'top',
				  -fill=>'both',
				  -expand=>1);
		   $GUI{EditProfile}->{UserInfo}->{Fields}->{instructions}->{top}->
		     Label(-text=>"Instructions:",
			   -width=>$GUI{width}->{jarl}->{profileeditor}->{label},
			   -background=>$GUI{color}->{bg}->{normal},
			   -foreground=>$GUI{color}->{fg}->{dark},
			   -font=>$GUI{fonts}->{normal},
			   -anchor=>'ne'
			  )->pack(-side=>'left',
				  -anchor=>'e');
		   $GUI{EditProfile}->{UserInfo}->{Fields}->{instructions}->{top}->
		     Label(-text=>$fields{instructions},
			   -wraplength=>250,
			   -justify=>"left",
			   -background=>$GUI{color}->{bg}->{normal},
			   -foreground=>$GUI{color}->{fg}->{dark},
			   -font=>$GUI{fonts}->{normal},
			   -anchor=>'w'
			  )->pack(-side=>'left',
				  -anchor=>'w');
		 }
		 
		 my $field;
		 foreach $field (sort {$a cmp $b} keys(%fields)) {
		   next if ($field eq "username");
		   next if ($field eq "password");
		   next if ($field eq "instructions");
		   next if ($field eq "key");
		   &jarlProfileIF_EditorField($GUI{EditProfile}->{UserInfo},"register",$field,$fields{$field},1);
		 }
		 
		 if ($profile ne "") {
		   $GUI{EditProfile}->{vars}->{account}->{username} =
		     $profiles{$profile}->{username};
		   $GUI{EditProfile}->{vars}->{account}->{password1} =
		     $profiles{$profile}->{password};
		   $GUI{EditProfile}->{vars}->{account}->{password2} =
		     $profiles{$profile}->{password};
		   $GUI{EditProfile}->{vars}->{account}->{resource} =
		     $profiles{$profile}->{resource};
		 }
	       }

	       $GUI{EditProfile}->{TabBar}->RaiseTab("account");
	     }
	    )->pack(-side=>"right",
		    -padx=>$GUI{width}->{jarl}->{config}->{pad});
  $GUI{EditProfile}->{Connections}->{Buttons}->{Cancel} =
    $GUI{EditProfile}->{Connections}->{Buttons}->{top}->
      Button(-text=>"Cancel",
	     -width=>7,
	     -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	     -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{jarl}->{config}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{
	       &jarlProfileIF_EditProfileCloseCB();
	     }
	    )->pack(-side=>"right",
		    -padx=>$GUI{width}->{jarl}->{config}->{pad});
  $GUI{EditProfile}->{Connections}->{Buttons}->{Back} =
    $GUI{EditProfile}->{Connections}->{Buttons}->{top}->
      Button(-text=>"<< Back",
	     -width=>7,
	     -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	     -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{jarl}->{config}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{
	       $GUI{EditProfile}->{TabBar}->RaiseTab("config");
	     }
	    )->pack(-side=>"right",
		    -padx=>$GUI{width}->{jarl}->{config}->{pad});


  #---------------------------------------------------------------------------
  #
  # Account...  username, password, default resource
  #
  #---------------------------------------------------------------------------
  $GUI{EditProfile}->{Account}->{Header}->{top} =
    $GUI{EditProfile}->{Account}->{top}->
      Frame(-background=>$GUI{color}->{window}->{bg}->{normal},
	    -foreground=>$GUI{color}->{window}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'both',
		   -expand=>1);
  $GUI{EditProfile}->{Account}->{Header}->{Label} =
    $GUI{EditProfile}->{Account}->{Header}->{top}->
      Label(-text=>"Account",
	    -background=>$GUI{color}->{bg}->{darkest},
	    -foreground=>$GUI{color}->{fg}->{lightest},
	    -font=>$GUI{fonts}->{header},
	    -anchor=>'w'
	   )->pack(-side=>'left',
		   -fill=>'both',
		   -expand=>1,
		   -anchor=>'e');

  $GUI{EditProfile}->{Account}->{instructions}->{top} =
     $GUI{EditProfile}->{Account}->{top}->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'both',
		   -expand=>1);
    
  $GUI{EditProfile}->{Account}->{Username}->{top} =
    $GUI{EditProfile}->{Account}->{top}->
      Frame(-background=>$GUI{color}->{window}->{bg}->{normal},
	    -foreground=>$GUI{color}->{window}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'both',
		   -expand=>1);
  $GUI{EditProfile}->{Account}->{Username}->{Label} =
    $GUI{EditProfile}->{Account}->{Username}->{top}->
      Label(-text=>"Username:",
	    -width=>15,
	    -background=>$GUI{color}->{jarl}->{profileeditor}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{profileeditor}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -anchor=>'e'
	   )->pack(-side=>'left',
		   -anchor=>'e');
  $GUI{EditProfile}->{Account}->{Username}->{Entry} =
    $GUI{EditProfile}->{Account}->{Username}->{top}->
      Entry(-textvariable=>\$GUI{EditProfile}->{vars}->{account}->{username},
	    -width=>$GUI{width}->{jarl}->{config}->{entry},
	    -background=>$GUI{color}->{jarl}->{config}->{bg}->{light},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	   )->pack(-side=>'left',
		   -anchor=>'w');

  $GUI{EditProfile}->{Account}->{Password1}->{top} =
    $GUI{EditProfile}->{Account}->{top}->
      Frame(-background=>$GUI{color}->{window}->{bg}->{normal},
	    -foreground=>$GUI{color}->{window}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'both',
		   -expand=>1);
  $GUI{EditProfile}->{Account}->{Password1}->{Label} =
    $GUI{EditProfile}->{Account}->{Password1}->{top}->
      Label(-text=>"Password:",
	    -width=>15,
	    -background=>$GUI{color}->{jarl}->{profileeditor}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{profileeditor}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -anchor=>'e'
	   )->pack(-side=>'left',
		   -anchor=>'e');
  $GUI{EditProfile}->{Account}->{Password1}->{Entry} =
    $GUI{EditProfile}->{Account}->{Password1}->{top}->
      Entry(-textvariable=>\$GUI{EditProfile}->{vars}->{account}->{password1},
	    -width=>$GUI{width}->{jarl}->{config}->{entry},
	    -background=>$GUI{color}->{jarl}->{config}->{bg}->{light},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -show=>'*'
	   )->pack(-side=>'left',
		   -anchor=>'w');

  $GUI{EditProfile}->{Account}->{Password2}->{top} =
    $GUI{EditProfile}->{Account}->{top}->
      Frame(-background=>$GUI{color}->{window}->{bg}->{normal},
	    -foreground=>$GUI{color}->{window}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'both',
		   -expand=>1);
  $GUI{EditProfile}->{Account}->{Password2}->{Label} =
    $GUI{EditProfile}->{Account}->{Password2}->{top}->
      Label(-text=>"Verify Password:",
	    -width=>15,
	    -background=>$GUI{color}->{jarl}->{profileeditor}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{profileeditor}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -anchor=>'e'
	   )->pack(-side=>'left',
		   -anchor=>'e');
  $GUI{EditProfile}->{Account}->{Password2}->{Entry} =
    $GUI{EditProfile}->{Account}->{Password2}->{top}->
      Entry(-textvariable=>\$GUI{EditProfile}->{vars}->{account}->{password2},
	    -width=>$GUI{width}->{jarl}->{config}->{entry},
	    -background=>$GUI{color}->{jarl}->{config}->{bg}->{light},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -show=>'*'
	   )->pack(-side=>'left',
		   -anchor=>'w');

  $GUI{EditProfile}->{Account}->{Resource}->{top} =
    $GUI{EditProfile}->{Account}->{top}->
      Frame(-background=>$GUI{color}->{window}->{bg}->{normal},
	    -foreground=>$GUI{color}->{window}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'both',
		   -expand=>1);
  $GUI{EditProfile}->{Account}->{Resource}->{Label} =
    $GUI{EditProfile}->{Account}->{Resource}->{top}->
      Label(-text=>"Default Resource:",
	    -width=>15,
	    -background=>$GUI{color}->{jarl}->{profileeditor}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{profileeditor}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -anchor=>'e'
	   )->pack(-side=>'left',
		   -anchor=>'e');
  $GUI{EditProfile}->{Account}->{Resource}->{Entry} =
    $GUI{EditProfile}->{Account}->{Resource}->{top}->
      Entry(-textvariable=>\$GUI{EditProfile}->{vars}->{account}->{resource},
	    -width=>$GUI{width}->{jarl}->{config}->{entry},
	    -background=>$GUI{color}->{jarl}->{config}->{bg}->{light},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	   )->pack(-side=>'left',
		   -anchor=>'w');

  $GUI{EditProfile}->{Account}->{Buttons}->{top} =
    $GUI{EditProfile}->{Account}->{top}->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	   )->pack(-side=>'bottom',
		   -fill=>'both',
		   -expand=>1);
  $GUI{EditProfile}->{Account}->{Buttons}->{Next} =
    $GUI{EditProfile}->{Account}->{Buttons}->{top}->
      Button(-text=>"Next >>",
	     -width=>7,
	     -background=>$GUI{color}->{bg}->{normal},
	     -foreground=>$GUI{color}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{

	       &jarlErrorIF_Popup("","Passwords do not match")
		 if ($GUI{EditProfile}->{vars}->{account}->{password1} ne
		     $GUI{EditProfile}->{vars}->{account}->{password2});

	       return
		 unless (($GUI{EditProfile}->{vars}->{account}->{username} ne "") &&
			 ($GUI{EditProfile}->{vars}->{account}->{password1} ne "") &&
			 ($GUI{EditProfile}->{vars}->{account}->{password2} ne "") &&
			 ($GUI{EditProfile}->{vars}->{account}->{password1} eq $GUI{EditProfile}->{vars}->{account}->{password2}) &&
			 ($GUI{EditProfile}->{vars}->{account}->{resource} ne ""));

	       if ($GUI{EditProfile}->{vars}->{accounttype} eq "exist") {
		 my $Register =
		   new Net::Jabber::Client(debuglevel=>$optctl{debug},
					   debugtime=>1);

		 my $status =
		   $Register->
		     Connect(connectiontype=>$connectiontypes{$GUI{EditProfile}->{vars}->{connections}->{$GUI{EditProfile}->{vars}->{connectionprofile}}->{type}}->[0],
			     hostname=>$GUI{EditProfile}->{vars}->{server},
			     port=>$GUI{EditProfile}->{vars}->{connections}->{$GUI{EditProfile}->{vars}->{connectionprofile}}->{port},
			     ssl=>$connectiontypes{$GUI{EditProfile}->{vars}->{connections}->{$GUI{EditProfile}->{vars}->{connectionprofile}}->{type}}->[2],
			    );

		 if (!(defined($status))) {
		   &jarlErrorIF_Popup("","Cannot not connect to $GUI{EditProfile}->{vars}->{server}:$GUI{EditProfile}->{vars}->{connection}->{port}: ".$Register->GetErrorCode);
		   return;
		 }

		 my @result = 
		   $Register->AuthSend(username=>$GUI{EditProfile}->{vars}->{account}->{username},
				       password=>$GUI{EditProfile}->{vars}->{account}->{password1},
				       resource=>$GUI{EditProfile}->{vars}->{account}->{resource});

		 if ($result[0] ne "ok") {
		   &jarlErrorIF_Popup(@result);
		   $Debug->Log0("ERROR: Could not login to server:",@result);

		   $Register->Disconnect();
		   return;
		 }

		 my %fields = $Register->RegisterRequest(to=>$GUI{EditProfile}->{vars}->{server});

		 %fields = %{$fields{fields}};
		 delete($fields{registered});

		 $Register->Disconnect();

		 my $widget;
		 foreach $widget (keys(%{$GUI{EditProfile}->{UserInfo}->{Fields}})) {
		   next if ($widget eq "top");
		   $GUI{EditProfile}->{UserInfo}->{Fields}->{$widget}->{top}->packForget();
		   delete($GUI{EditProfile}->{UserInfo}->{Fields}->{$widget});
		 }

		 if (exists($fields{instructions})) {
		   $GUI{EditProfile}->{UserInfo}->{Fields}->{instructions}->{top} =
		     $GUI{EditProfile}->{UserInfo}->{top}->
		       Frame(-background=>$GUI{color}->{bg}->{normal},
			     -foreground=>$GUI{color}->{fg}->{dark},
			    )->pack(-side=>'top',
				    -fill=>'both',
				    -expand=>1);
		   
		   $GUI{EditProfile}->{UserInfo}->{Fields}->{instructions}->{top}->
		     Label(-text=>"Instructions:",
			   -width=>$GUI{width}->{jarl}->{profileeditor}->{label},
			   -background=>$GUI{color}->{bg}->{normal},
			   -foreground=>$GUI{color}->{fg}->{dark},
			   -font=>$GUI{fonts}->{normal},
			   -anchor=>'ne'
			  )->pack(-side=>'left',
				  -anchor=>'e');
		   $GUI{EditProfile}->{UserInfo}->{Fields}->{instructions}->{top}->
		     Label(-text=>$fields{instructions},
			   -wraplength=>250,
			   -justify=>"left",
			   -background=>$GUI{color}->{bg}->{normal},
			   -foreground=>$GUI{color}->{fg}->{dark},
			   -font=>$GUI{fonts}->{normal},
			   -anchor=>'w'
			  )->pack(-side=>'left',
				  -anchor=>'w');
		 }
		 
		 my $field;
		 foreach $field (sort {$a cmp $b} keys(%fields)) {
		   next if ($field eq "username");
		   next if ($field eq "password");
		   next if ($field eq "instructions");
		   next if ($field eq "key");
		   &jarlProfileIF_EditorField($GUI{EditProfile}->{UserInfo},"register",$field,$fields{$field},1);
		 } 
	       }
	       
	       $GUI{EditProfile}->{TabBar}->RaiseTab("userinfo");
	     }
	    )->pack(-side=>"right",
		    -padx=>$GUI{width}->{jarl}->{config}->{pad});
  $GUI{EditProfile}->{Account}->{Buttons}->{Cancel} =
    $GUI{EditProfile}->{Account}->{Buttons}->{top}->
      Button(-text=>"Cancel",
	     -width=>7,
	     -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	     -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{jarl}->{config}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{
	       &jarlProfileIF_EditProfileCloseCB();
	     }
	    )->pack(-side=>"right",
		    -padx=>$GUI{width}->{jarl}->{config}->{pad});
  $GUI{EditProfile}->{Account}->{Buttons}->{Back} =
    $GUI{EditProfile}->{Account}->{Buttons}->{top}->
      Button(-text=>"<< Back",
	     -width=>7,
	     -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	     -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{jarl}->{config}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{
	       $GUI{EditProfile}->{TabBar}->RaiseTab("connections");
	     }
	    )->pack(-side=>"right",
		    -padx=>$GUI{width}->{jarl}->{config}->{pad});

  #---------------------------------------------------------------------------
  #
  # User info...  the fields are pulled from the server.
  #
  #---------------------------------------------------------------------------
  $GUI{EditProfile}->{UserInfo}->{Header}->{top} =
    $GUI{EditProfile}->{UserInfo}->{top}->
      Frame(-background=>$GUI{color}->{window}->{bg}->{normal},
	    -foreground=>$GUI{color}->{window}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'both',
		   -expand=>1);
  $GUI{EditProfile}->{UserInfo}->{Header}->{Label} =
    $GUI{EditProfile}->{UserInfo}->{Header}->{top}->
      Label(-text=>"User Info",
	    -background=>$GUI{color}->{bg}->{darkest},
	    -foreground=>$GUI{color}->{fg}->{lightest},
	    -font=>$GUI{fonts}->{header},
	    -anchor=>'w'
	   )->pack(-side=>'left',
		   -fill=>'both',
		   -expand=>1,
		   -anchor=>'e');

  $GUI{EditProfile}->{UserInfo}->{Buttons}->{top} =
    $GUI{EditProfile}->{UserInfo}->{top}->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	   )->pack(-side=>'bottom',
		   -fill=>'both',
		   -expand=>1);
  $GUI{EditProfile}->{UserInfo}->{Buttons}->{Finish} =
    $GUI{EditProfile}->{UserInfo}->{Buttons}->{top}->
      Button(-text=>"Finish",
	     -width=>7,
	     -background=>$GUI{color}->{bg}->{normal},
	     -foreground=>$GUI{color}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{

	       my $field;
	       foreach $field (keys(%{$GUI{EditProfile}->{UserInfo}->{Fields}})) {
		 next if ($field eq "instructions");
		 return if ($GUI{EditProfile}->{vars}->{register}->{$field} eq "");
	       }

	       if ($GUI{EditProfile}->{vars}->{accounttype} eq "exist") {
		 &jarlProfileIF_SaveProfile();
	       }
	       if ($GUI{EditProfile}->{vars}->{accounttype} eq "new") {
		 my $Register =
		   new Net::Jabber::Client(debuglevel=>$optctl{debug},
					   debugtime=>1);

		 my $status =
		   $Register->
		     Connect(connectiontype=>$connectiontypes{$GUI{EditProfile}->{vars}->{connections}->{$GUI{EditProfile}->{vars}->{connectionprofile}}->{type}}->[0],
			     hostname=>$GUI{EditProfile}->{vars}->{server},
			     port=>$GUI{EditProfile}->{vars}->{connections}->{$GUI{EditProfile}->{vars}->{connectionprofile}}->{port},
			     ssl=>$connectiontypes{$GUI{EditProfile}->{vars}->{connections}->{$GUI{EditProfile}->{vars}->{connectionprofile}}->{type}}->[2],
			    );

		 if (!(defined($status))) {
		   &jarlError_Popup("","Cannot not connect to $GUI{EditProfile}->{vars}->{server}:$GUI{EditProfile}->{vars}->{connection}->{port}: ".$Register->GetErrorCode);
		   return;
		 }

		 my %fields = $Register->RegisterRequest(to=>$GUI{EditProfile}->{vars}->{server});

		 %fields = %{$fields{fields}};
		 delete($fields{registered});

		 $fields{username} =
		   $GUI{EditProfile}->{vars}->{account}->{username};
		 $fields{password} =
		   $GUI{EditProfile}->{vars}->{account}->{password1};

		 foreach $field (keys(%{$GUI{EditProfile}->{UserInfo}->{Fields}})) {
		   next if ($field eq "instructions");
		   $fields{$field} = 
		     $GUI{EditProfile}->{vars}->{register}->{$field};
		 }

		 my @result = $Register->RegisterSend(to=>$GUI{EditProfile}->{vars}->{server},
						      %fields);

		 if ($result[0] ne "ok") {
		   &jarlErrorIF_Popup(@result);
		   $Debug->Log0("ERROR: Could not register with server:",@result);
		   $Register->Disconnect();
		   return;
		 }

		 $Register->Disconnect();

		 &jarlProfileIF_SaveProfile();
	       }

	       $GUI{EditProfile}->{TabBar}->RaiseTab("done");
	     }
	    )->pack(-side=>"right",
		    -padx=>$GUI{width}->{jarl}->{config}->{pad});
  $GUI{EditProfile}->{UserInfo}->{Buttons}->{Cancel} =
    $GUI{EditProfile}->{UserInfo}->{Buttons}->{top}->
      Button(-text=>"Cancel",
	     -width=>7,
	     -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	     -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{jarl}->{config}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{
	       &jarlProfileIF_EditProfileCloseCB();
	     }
	    )->pack(-side=>"right",
		    -padx=>$GUI{width}->{jarl}->{config}->{pad});
  $GUI{EditProfile}->{UserInfo}->{Buttons}->{Back} =
    $GUI{EditProfile}->{UserInfo}->{Buttons}->{top}->
      Button(-text=>"<< Back",
	     -width=>7,
	     -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	     -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{jarl}->{config}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{
	       $GUI{EditProfile}->{TabBar}->RaiseTab("account");
	     }
	    )->pack(-side=>"right",
		    -padx=>$GUI{width}->{jarl}->{config}->{pad});


  #---------------------------------------------------------------------------
  #
  # Done tab.  Just clean up and tell the user if it was successful or not.
  #
  #---------------------------------------------------------------------------
  $GUI{EditProfile}->{Done}->{Header}->{top} =
    $GUI{EditProfile}->{Done}->{top}->
      Frame(-background=>$GUI{color}->{window}->{bg}->{normal},
	    -foreground=>$GUI{color}->{window}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'both',
		   -expand=>1);
  $GUI{EditProfile}->{Done}->{Header}->{Label} =
    $GUI{EditProfile}->{Done}->{Header}->{top}->
      Label(-text=>"Done",
	    -background=>$GUI{color}->{bg}->{darkest},
	    -foreground=>$GUI{color}->{fg}->{lightest},
	    -font=>$GUI{fonts}->{header},
	    -anchor=>'w'
	   )->pack(-side=>'left',
		   -fill=>'both',
		   -expand=>1,
		   -anchor=>'e');

  $GUI{EditProfile}->{Done}->{Message}->{top} =
    $GUI{EditProfile}->{Done}->{top}->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'both',
		   -expand=>1);
  $GUI{EditProfile}->{Done}->{Message}->{Label} =
    $GUI{EditProfile}->{Done}->{Message}->{top}->
      Label(-text=>"Success!  Your profile has been created.  You may now click the Close button below and return to the Profile Editor and access your new profile.",
	    -wraplength=>250,
	    -justify=>"left",
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -anchor=>'e'
	   )->pack(-side=>'left',
		   -anchor=>'e');

  $GUI{EditProfile}->{Done}->{Buttons}->{top} =
    $GUI{EditProfile}->{Done}->{top}->
      Frame(-background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	   )->pack(-side=>'bottom',
		   -fill=>'both',
		   -expand=>1);
  $GUI{EditProfile}->{Done}->{Buttons}->{Close} =
    $GUI{EditProfile}->{Done}->{Buttons}->{top}->
      Button(-text=>"Close",
	     -width=>7,
	     -background=>$GUI{color}->{bg}->{normal},
	     -foreground=>$GUI{color}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{
	       &jarlProfileIF_EditProfileCloseCB();
	     }
	    )->pack(-side=>"right",
		    -padx=>$GUI{width}->{jarl}->{config}->{pad});

  #---------------------------------------------------------------------------
  #
  # Raise the first tab
  #
  #---------------------------------------------------------------------------
  $GUI{EditProfile}->{TabBar}->RaiseTab("connections") if ($profile ne "");
  $GUI{EditProfile}->{TabBar}->RaiseTab("start") if ($profile eq "");
}


sub jarlProfileIF_EditConnection {
  my ($connection) = @_;

  $connection = "" unless defined($connection);

  $GUI{EditProfile}->{Connections}->{Buttons}->{Next}->
    configure(-state=>"disabled");

  if ($connection ne "") {
    $GUI{EditProfile}->{vars}->{connection}->{name} = $connection;
    $GUI{EditProfile}->{vars}->{connection}->{oldName} = $connection;
    $GUI{EditProfile}->{vars}->{connection}->{type} = 
      $GUI{EditProfile}->{vars}->{connections}->{$connection}->{type};
    $GUI{EditProfile}->{vars}->{connection}->{port} = 
      $GUI{EditProfile}->{vars}->{connections}->{$connection}->{port};
  } else {
    $GUI{EditProfile}->{vars}->{connection}->{name} = "";
    $GUI{EditProfile}->{vars}->{connection}->{type} = "TCP/IP";
    $GUI{EditProfile}->{vars}->{connection}->{port} = "5222";
  }

  $GUI{EditProfile}->{Connections}->{Name}->{Entry}->
    configure(-state=>"normal",
	      -background=>$GUI{color}->{bg}->{light});
  $GUI{EditProfile}->{Connections}->{Type}->{Option}->
    configure(-state=>"normal");
  $GUI{EditProfile}->{Connections}->{Port}->{Entry}->
    configure(-state=>"normal",
	      -background=>$GUI{color}->{bg}->{light});
}


sub jarlProfileIF_SaveConnection {
  
  delete($GUI{EditProfile}->{vars}->{connections}->{$GUI{EditProfile}->{vars}->{connection}->{oldName}}) if (exists($GUI{EditProfile}->{vars}->{connection}->{oldName}) && ($GUI{EditProfile}->{vars}->{connection}->{name} ne $GUI{EditProfile}->{vars}->{connection}->{oldName}));
  
  $GUI{EditProfile}->{vars}->{connections}->{$GUI{EditProfile}->{vars}->{connection}->{name}}->{type} =
    $GUI{EditProfile}->{vars}->{connection}->{type};
  $GUI{EditProfile}->{vars}->{connections}->{$GUI{EditProfile}->{vars}->{connection}->{name}}->{port} =
    $GUI{EditProfile}->{vars}->{connection}->{port};
  
  $GUI{EditProfile}->{vars}->{connection}->{name} = "";
  $GUI{EditProfile}->{vars}->{connection}->{type} = "TCP/IP";
  $GUI{EditProfile}->{vars}->{connection}->{port} = 5222;

  $GUI{EditProfile}->{Connections}->{Name}->{Entry}->
    configure(-state=>"disabled",
	      -background=>$GUI{color}->{bg}->{normal});
  $GUI{EditProfile}->{Connections}->{Type}->{Option}->
    configure(-state=>"disabled");
  $GUI{EditProfile}->{Connections}->{Port}->{Entry}->
    configure(-state=>"disabled",
	      -background=>$GUI{color}->{bg}->{normal});

  &jarlProfileIF_DepopulateConnectionList();
  &jarlProfileIF_PopulateConnectionList();

  $GUI{EditProfile}->{Connections}->{Buttons}->{Next}->
    configure(-state=>"normal");
}



sub jarlProfileIF_PopulateConnectionList {
  foreach my $connection (sort {$a cmp $b} keys(%{$GUI{EditProfile}->{vars}->{connections}})) {
    $GUI{EditProfile}->{Connections}->{List}->{Listbox}->insert("end",$connection);
  }
  $GUI{EditProfile}->{Connections}->{Default}->{Option}->
    configure(-options=>[(sort {$a cmp $b} keys(%{$GUI{EditProfile}->{vars}->{connections}}))]);
}


sub jarlProfileIF_DepopulateConnectionList {
  $GUI{EditProfile}->{Connections}->{List}->{Listbox}->delete(0,"end");
}


###########################################################################
#
# jarlProfileIF_EditProfileCloseCB - close the EditProfile GUI.
#
###########################################################################
sub jarlProfileIF_EditProfileCloseCB {
  $GUI{EditProfile}->{window}->destroy;
  delete($GUI{EditProfile});
}





sub jarlProfileIF_SaveProfile {
  my ($profile) = @_;

  $profile = "" unless defined($profile);

  my $profileName = $GUI{EditProfile}->{vars}->{profile};

  if (!exists($profiles{$profileName})) {
    $profiles{$profileName} = new Jarl::Profile();
  }

  $profiles{$profileName}->Name($profileName);
  $profiles{$profileName}->Server($GUI{EditProfile}->{vars}->{server});
  $profiles{$profileName}->Username($GUI{EditProfile}->{vars}->{account}->{username});
  $profiles{$profileName}->Password($GUI{EditProfile}->{vars}->{account}->{password1});
  $profiles{$profileName}->Resource($GUI{EditProfile}->{vars}->{account}->{resource});

  delete($profiles{$profile}) if ($profile ne $profileName);

  $profiles{$profileName}->ConnectionObjClear();
  $profiles{$profileName}->ConnectionProfile($GUI{EditProfile}->{vars}->{connectionprofile});
  
  foreach my $connectionName (keys(%{$GUI{EditProfile}->{vars}->{connections}})) {
    my $connection = new Jarl::Profile::Connection();    
    $connection->Name($connectionName);
    $connection->Port($GUI{EditProfile}->{vars}->{connections}->{$connectionName}->{port});
    $connection->Type($GUI{EditProfile}->{vars}->{connections}->{$connectionName}->{type});
    $profiles{$profileName}->ConnectionObj($connectionName,$connection);
  }

  &jarlProfileIF_DepopulateProfileList();
  &jarlProfileIF_PopulateProfileList();

  $profiles{$profileName}->Save();
}


##############################################################################
#
# jarlProfileIF_EditorField - creates a field in the edit based on some 
#                           settings.
#
##############################################################################
sub jarlProfileIF_EditorField {
  my ($widget,$hash,$field,$fieldValue,$show) = @_;

  $GUI{EditProfile}->{vars}->{$hash}->{$field} = $fieldValue;

  $widget->{Fields}->{$field}->{top} =
    $widget->{top}->
      Frame(-background=>$GUI{color}->{window}->{bg}->{normal},
	    -foreground=>$GUI{color}->{window}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'both',
		   -expand=>1);
  $widget->{Fields}->{$field}->{Label} =
    $widget->{Fields}->{$field}->{top}->
      Label(-text=>ucfirst($field).":",
	    -width=>$GUI{width}->{jarl}->{profileeditor}->{label},
	    -background=>$GUI{color}->{bg}->{normal},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -anchor=>'e'
	   )->pack(-side=>'left',
		   -anchor=>'e');
  $widget->{Fields}->{$field}->{Entry} =
    $widget->{Fields}->{$field}->{top}->
      Entry(-textvariable=>\$GUI{EditProfile}->{vars}->{$hash}->{$field},
	    -width=>$GUI{width}->{jarl}->{profileeditor}->{entry},
	    -background=>$GUI{color}->{bg}->{light},
	    -foreground=>$GUI{color}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -state=>"normal"
	   )->pack(-side=>'left',
		   -anchor=>'w');
  $widget->{Fields}->{$field}->{Entry}->configure(-show=>"*") if ($show == 0);
}


1;
