##############################################################################
#
# Jarl - Roster Code
#
#   Perl code to handle some common roster tasks.
#
##############################################################################

##############################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#  Jabber
#  Copyright (C) 1998-1999 The Jabber Team http://jabber.org/
#
##############################################################################

##############################################################################
#
# jarlRoster_PresenceIcon - returns a string that defines the thing to show
#                           based on the presence argument.
#
##############################################################################
sub jarlRoster_PresenceIcon {
  my $roster = shift;
  my $presence = shift;

  my $type = "";
  my $show = "";
  my $subscription = "";
  my $iconString = "UnavailableNone";

  my $jid;

  if (ref($presence) eq "Net::Jabber::Presence") {
    my $fromJID = $presence->GetFrom("jid");
    $type = $presence->GetType();
    $show = $presence->GetShow();
    $subscription = $roster->GetValue($fromJID->GetJID(),"subscription");
    $jid = $fromJID->GetJID();
  } else {
    $jid = shift;
    $subscription = (
		     defined($jid) ? 
		     $roster->GetValue($jid,"subscription") :
		     "both"
		    );

    $type = "" if ($presence eq "available");
    $show = "away" if ($presence eq "away");
    $show = "chat" if ($presence eq "chat");
    $show = "dnd" if ($presence eq "dnd");
    $show = "xa" if ($presence eq "xa");
    $type = "unavailable" if ($presence eq "unavailable");
  }

  if (($type eq "") || ($type eq "available")) {
    if ($subscription eq "both") {
      $iconString = "Available";
      $iconString = "AvailableAway" if ($show eq "away");
      $iconString = "AvailableChat" if ($show eq "chat");
      $iconString = "AvailableDND" if ($show eq "dnd");
      $iconString = "AvailableXA" if ($show eq "xa");
      $iconString .= "Secure" if ((defined($roster->GetValue($jid,"gpgkeyid"))) || (!defined($jid) && ($config{gpg}->{active} == 1)));
    } else {
      if ($subscription eq "to") {
	$iconString = "AvailableTo";
	$iconString = "AvailableAwayTo" if ($show eq "away");
	$iconString = "AvailableChatTo" if ($show eq "chat");
	$iconString = "AvailableDNDTo" if ($show eq "dnd");
	$iconString = "AvailableXATo" if ($show eq "xa");
	$iconString .= "Secure" if (defined($roster->GetValue($jid,"gpgkeyid")));
      } else {
	if ($subscription eq "from") {
	  $iconString = "AvailableFrom";
	  $iconString = "AvailableAwayFrom" if ($show eq "away");
	  $iconString = "AvailableChatFrom" if ($show eq "chat");
	  $iconString = "AvailableDNDFrom" if ($show eq "dnd");
	  $iconString = "AvailableXAFrom" if ($show eq "xa");
	  $iconString .= "Secure" if (defined($roster->GetValue($jid,"gpgkeyid")));
	} else {
	  $iconString = "AvailableNone";
	}
      }
    }
  } else {
    $iconString = "UnavailableNone";
    $iconString = "Unavailable" if ($subscription eq "both");
    $iconString = "UnavailableFrom" if ($subscription eq "from");
    $iconString = "UnavailableTo" if ($subscription eq "to");
  }

  return $iconString;
}


##############################################################################
#
# jarlRoster_GetNick - quickly get teh best value for the jid, either the name
#                      if there was one, or the jid.
#
##############################################################################
sub jarlRoster_GetNick {
  my ($jid) = @_;

  if (ref($jid) eq "") {
    if ($Roster->GetValue($jid,"name") ne "") {
      return $Roster->GetValue($jid,"name");
    } else {
      my ($username,$server) = ($jid =~ /^([^\@]*)\@?([^\@\/]+)\/?/);
      my $testJID = $username."\@".$server;
      if ($Roster->GetValue($testJID,"name") ne "") {
	return $Roster->GetValue($testJID,"name");
      } else {
	if ($username eq "") {
	  return $server;
	} else {
	  return $jid;
	}
      }
    }
  }

  if (ref($jid) eq "Net::Jabber::JID") {
    if ($Roster->GetValue($jid->GetJID(),"name") ne "") {
      return $Roster->GetValue($jid->GetJID(),"name");
    } else {
      if ($Roster->GetValue($jid->GetJID("full"),"name") ne "") {
	return $Roster->GetValue($jid->GetJID("full"),"name");
      } else {
	if ($jid->GetUserID() eq "") {
	  return $jid->GetServer();
	} else {
	  return $jid->GetJID();
	}
      }	
    }
  }

  return "Unknown";
}


1;
