##############################################################################
#
# Jarl - Roster Command Line Interface Code
#
#   Perl code to handle showing the Jarl Roster GUI and interfacing with the
# roster items.
#
##############################################################################

##############################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#  Jabber
#  Copyright (C) 1998-1999 The Jabber Team http://jabber.org/
#
##############################################################################

##############################################################################
#
# jarlRosterIF_PresenceIcon - returns a string that represents the presence
#                             of the given JID.
#
##############################################################################
sub jarlRosterIF_PresenceIcon {
  my $string = &jarlRoster_PresenceIcon(@_);

  return "ON" if ($string eq "Available");
  return "AWY" if ($string eq "AvailableAway");
  return "CHT" if ($string eq "AvailableChat");
  return "DND" if ($string eq "AvailableDND");
  return "XA"  if ($string eq "AvailableXA");

  return "ON-t" if ($string eq "AvailableTo");
  return "AWY-t" if ($string eq "AvailableAwayTo");
  return "CHT-t" if ($string eq "AvailableChatTo");
  return "DND-t" if ($string eq "AvailableDNDTo");
  return "XA-t"  if ($string eq "AvailableXATo");

  return "ON-f" if ($string eq "AvailableFrom");
  return "AWY-f" if ($string eq "AvailableAwayFrom");
  return "CHT-f" if ($string eq "AvailableChatFrom");
  return "DND-f" if ($string eq "AvailableDNDFrom");
  return "XA-f" if ($string eq "AvailableXAFrom");

  return "ON-s" if ($string eq "AvailableSecure");
  return "AWY-s" if ($string eq "AvailableAwaySecure");
  return "CHT-s" if ($string eq "AvailableChatSecure");
  return "DND-s" if ($string eq "AvailableDNDSecure");
  return "XA-s" if ($string eq "AvailableXASecure");

  return "ON-ts" if ($string eq "AvailableToSecure");
  return "AWY-ts" if ($string eq "AvailableAwayToSecure");
  return "CHT-ts" if ($string eq "AvailableChatToSecure");
  return "DND-ts" if ($string eq "AvailableDNDToSecure");
  return "XA-ts" if ($string eq "AvailableXAToSecure");

  return "ON-fs" if ($string eq "AvailableFromSecure");
  return "AWY-fs" if ($string eq "AvailableAwayFromSecure");
  return "CHT-fs" if ($string eq "AvailableChatFromSecure");
  return "DND-fs" if ($string eq "AvailableDNDFromSecure");
  return "XA-fs" if ($string eq "AvailableXAFromSecure");

  return "OFF" if ($string eq "Unavailable");
  return "OFF-t" if ($string eq "UnavailableTo");
  return "OFF-f" if ($string eq "UnavailableFrom");
  return "???" if ($string eq "UnavailableNone");

  return "xxx";
}


1;
