##############################################################################
#
# Jarl - Settings Code
#   Perl code to read/write the profiles from disk and push the profile
# settings into the main %config variable.
#
##############################################################################

##############################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#  Jabber
#  Copyright (C) 1998-1999 The Jabber Team http://jabber.org/
#
##############################################################################

##############################################################################
#
# jarlSettings_Split - Takes the old config file format and splits it out
#                      into the new multi-file format.
#
##############################################################################
sub jarlSettings_Split {

  print "Converting from config format v0.1 to v0.2...\n";

  my $profile = new Jarl::Profile();

  my $parser = new XML::Stream::Parser();
  my @tree = $parser->parsefile("$ENV{HOME}/.jarlrc");

  my %config;

  #---------------------------------------------------------------------------
  # Grab the browser config.
  #---------------------------------------------------------------------------
  my @webBrowserTree = &XML::Stream::GetXMLData("tree",$tree[0],"webbrowser","","");
  $profile->WebBrowserCommand(&XML::Stream::GetXMLData("value",\@webBrowserTree,"command","",""));

  #---------------------------------------------------------------------------
  # Grab the font config.
  #---------------------------------------------------------------------------
  my @fontTree = &XML::Stream::GetXMLData("tree",$tree[0],"font","","");
  $profile->FontFamily(&XML::Stream::GetXMLData("value",\@fontTree,"family","",""));
  $profile->FontFamily("helvetica") if ($profile->FontFamily() eq "");
  $profile->FontSize(&XML::Stream::GetXMLData("value",\@fontTree,"size","",""));
  $profile->FontSize(14) if ($profile->FontSize() eq "");


  my $connection = new Jarl::Profile::Connection();
  $connection->Name("Normal");
  $connection->Type("TCP/IP");
  $connection->Port(5222);

  $profile->ConnectionObj($connection->Name(),$connection);
  $profile->ConnectionProfile("Normal");

  my @profilesTree = &XML::Stream::GetXMLData("tree",$tree[0],"profiles","","");
  my @profiles = &XML::Stream::GetXMLData("tree array",\@profilesTree,"profile","","");

  foreach my $profileTree (@profiles) {
    my $name =  &XML::Stream::GetXMLData("value",$profileTree,"","name","");

    $profile->Name($name);
    $profile->Server(&XML::Stream::GetXMLData("value",$profileTree,"server","",""));
    $profile->Username(&XML::Stream::GetXMLData("value",$profileTree,"username","",""));
    $profile->Password(&XML::Stream::GetXMLData("value",$profileTree,"password","",""));
    $profile->Resource(&XML::Stream::GetXMLData("value",$profileTree,"resource","",""));
    $profile->Save();
  }

  system("rm $ENV{HOME}/.jarlrc");
}


##############################################################################
#
# jarlSettings_ReadProfiles - reads in all of the profile files so that we
#                             can easily populate the lists of settings and
#                             edit them.
#
##############################################################################
sub jarlSettings_ReadProfiles {
  my ($file) = @_;

  system("mkdir $ENV{HOME}/.jarl") if !(-e "$ENV{HOME}/.jarl");

  &jarlSettings_Split() if (-e "$ENV{HOME}/.jarlrc");

  opendir(JARL,"$ENV{HOME}/.jarl");
  foreach my $profileFile(readdir(JARL)) {
    next if ($profileFile =~ /^\.\.?$/);
    my $profile = new Jarl::Profile($profileFile);
    next if ($profile->Name() eq "");
    next if ($profile->Filename() eq "\@\@");
    $profiles{$profile->Name()} = $profile;
    if ($profileFile ne $profile->Filename()) {
      unlink("$ENV{HOME}/.jarl/$profileFile");
      $profile->Save();
    }
  }
  closedir(JARL);
}


##############################################################################
#
# jarlSettings_Save - save the current profile to the disk
#
##############################################################################
sub jarlSettings_Save {
  &jarlSettings_SaveConfig();

  return if ($activeProfile eq "");
  return if ($activeProfile eq "Connect w/o Profile");
  return unless exists($profiles{$activeProfile});
  $profiles{$activeProfile}->Save();
}


##############################################################################
#
# jarlSettings_SetSonfig - take the profile settings and push them into the
#                          main %config hash and apply them all.
#
##############################################################################
sub jarlSettings_SetConfig {
  $config{font}->{family} = $profiles{$activeProfile}->FontFamily();
  $config{font}->{size} = $profiles{$activeProfile}->FontSize();
  $config{webbrowser}->{command} = $profiles{$activeProfile}->WebBrowserCommand();
  $config{onlineonly} = $profiles{$activeProfile}->OnlineOnly();
  $config{unifiedpresence} = $profiles{$activeProfile}->UnifiedPresence();
  $config{showdebug} = $profiles{$activeProfile}->ShowDebug();
  $config{gpg}->{active} = $profiles{$activeProfile}->GPGActive();
  $config{gpg}->{active} = 0 if ($options{gpg} == 0);
  $config{gpg}->{chat} = $profiles{$activeProfile}->GPGChat();
  $config{gpg}->{normal} = $profiles{$activeProfile}->GPGNormal();
  $config{gpg}->{autofetchtrust} = $profiles{$activeProfile}->GPGAutoFetchTrust();
  $config{gpg}->{trust} = $profiles{$activeProfile}->GPGTrust();
  $config{gpg}->{keyserver} = $profiles{$activeProfile}->GPGKeyServer();
  $config{rosterdoubleclick} = $profiles{$activeProfile}->RosterDoubleClick();
  $config{subscriptions} = $profiles{$activeProfile}->Subscriptions();
  $config{subscriptiondeny} = $profiles{$activeProfile}->SubscriptionDeny();
  $config{subscriptiondenymessage} = $profiles{$activeProfile}->SubscriptionDenyMessage();
  $config{subscribe} = $profiles{$activeProfile}->Subscribe();

  delete($config{favgroups});

  foreach my $group ($profiles{$activeProfile}->FavGroupObj()) {
    my $favgroup = $profiles{$activeProfile}->FavGroupObj($group);
    $config{favgroups}->{$group}->{channel} = $favgroup->Channel();
    $config{favgroups}->{$group}->{server} = $favgroup->Server();
    $config{favgroups}->{$group}->{nick1} = $favgroup->Nick1();
    $config{favgroups}->{$group}->{nick2} = $favgroup->Nick2();
  }

  &jarlMainIF_PopulateFavGroupsMenu();

  &jarlMainIF_InitFonts();
  &jarlMainIF_UpdateFontChange();
  &jarlMainIF_UpdateOnlineOnly();
  &jarlMainIF_UpdateShowDebug();
}


##############################################################################
#
# jarlSettings_SaveConfig - take all of the preferences that were set during
#                           during this session and save them in the profile.
#
##############################################################################
sub jarlSettings_SaveConfig {
  return unless defined($activeProfile);
  $profiles{$activeProfile}->FontFamily($config{font}->{family});
  $profiles{$activeProfile}->FontSize($config{font}->{size});
  $profiles{$activeProfile}->WebBrowserCommand($config{webbrowser}->{command});
  $profiles{$activeProfile}->OnlineOnly($config{onlineonly});
  $profiles{$activeProfile}->UnifiedPresence($config{unifiedpresence});
  $profiles{$activeProfile}->ShowDebug($config{showdebug});
  $profiles{$activeProfile}->GPGActive($config{gpg}->{active})
    unless (($config{gpg}->{active} == -1) || ($options{gpg} == 0));
  $profiles{$activeProfile}->GPGChat($config{gpg}->{chat});
  $profiles{$activeProfile}->GPGNormal($config{gpg}->{normal});
  $profiles{$activeProfile}->GPGAutoFetchTrust($config{gpg}->{autofetchtrust});
  $profiles{$activeProfile}->GPGTrust($config{gpg}->{trust});
  $profiles{$activeProfile}->GPGKeyServer($config{gpg}->{keyserver});
  $profiles{$activeProfile}->RosterDoubleClick($config{rosterdoubleclick});
  $profiles{$activeProfile}->Subscriptions($config{subscriptions});
  $profiles{$activeProfile}->SubscriptionDeny($config{subscriptiondeny});
  $profiles{$activeProfile}->SubscriptionDenyMessage($config{subscriptiondenymessage});
  $profiles{$activeProfile}->Subscribe($config{subscribe});
  $profiles{$activeProfile}->FavGroupObjClear();
  foreach my $group (keys(%{$config{favgroups}})) {
    my $favgroup = new Jarl::Profile::FavGroup;
    $favgroup->Name($group);
    $favgroup->Channel($config{favgroups}->{$group}->{channel});
    $favgroup->Server($config{favgroups}->{$group}->{server});
    $favgroup->Nick1($config{favgroups}->{$group}->{nick1});
    $favgroup->Nick2($config{favgroups}->{$group}->{nick2});

    $profiles{$activeProfile}->FavGroupObj($group,$favgroup);
  }
}


1;
