#ifndef lint
static char rcsid[] = "$Header: $";
#endif

/*
 * $Log:$
 */

/*
 *	batch.c
 *
 *	Batch adder for database.
 *
 *	 1 Aug 1990 Hardt
 *
 *	The following conventions are followed for return codes.
 *
 *			2?? informational
 *			3?? requested data
 *			4?? error
 *			5?? fatal error
 *
 *  A space immediately following the 3 digit number means program is
 *  ready to receive data or has finished.
 *  
 *	All coded output from batch is written to stdout.  If you change
 *  any of the error code numbers, or modify them, change the man page too.
 *
 */

#include <stdio.h>
#include <strings.h>
#include <sys/file.h>
#include <sys/errno.h>
#include <sys/wait.h>
#include "common.h"
#include "errors.h"
#include <sys/stat.h>
#include <sys/dir.h>
#if SYSLOG
#include <syslog.h>
#endif

/* order for input fields */
typedef struct order {
	int index;
	struct order *next;
} order_t;

int errs=0, lineno=0, ignorerealdate=0, lock=0;

Batch(argc, argv)
	int argc;
	char **argv;
{
	order_t *temporder,*curorder,*firstorder=NULL;
	int validated;
	int doingall;
	int errsthisline=0;
	extern int errno;
	int i,size,badinput;
	char *lp,*blp,*cp,*bcp;
	long tloc;
	char *keystr;
	int retval, flags=0, truncate=0, silent=0, len;
	char *user;

	/*
	 * if the -i flag is used then the date fields (createdate and moddate)
	 * are not changed.  this allows the reloading of the database without
	 * messing up the touch dates.
	 */
	for (i=1; i<argc; i++) {
		if (*argv[i] != '-')
			continue;
		if (*(argv[i]+2))
			break;
		switch (*(argv[i]+1)) {
			case 'i':
				if (!hasaccessall) {
					fprintf(stdout, "550-FATAL ERROR, \"-i\" flag used, but you don't have \"%s\" access\n", S_ALL);
					exit(1);
				}
				ignorerealdate = 1;
				flags++;
				break;
			case 'l':
				if (!hasaccessall) {
					fprintf(stdout, "550-FATAL ERROR, \"-l\" flag used, but you don't have \"%s\" access\n", S_ALL);
					exit(1);
				}
				lock = 1;
				flags++;
				break;
			case 's':
				if (!hasaccessall) {
					fprintf(stdout, "550-FATAL ERROR, \"-s\" flag used, but you don't have \"%s\" access\n", S_ALL);
					exit(1);
				}
				silent = 1;
				flags++;
				break;
			case 't':
				truncate = 1;
				flags++;
				break;
			default:
				usage();
				break;
		}
	}

	if (((ignorerealdate || truncate) && X_Doing == X_BRM) || flags != argc-1)
		usage();

	if (lock)
		LockOutAll(0);

	time(&tloc);
	fprintf(stdout, "230-%s %s ready at %s",ProgName,version,ctime(&tloc));

	if (X_Doing == X_BAD) {
		fputs("220 Ready for specification of field order.\n",stdout);
		fflush(stdout);

		if (!fgets(linein, LINEMAX, stdin)) {
			fprintf(stdout,"260-End of input.\n");
			quitprogram();
		}
		lineno++;

		lp = linein;
		doingall = 0;
		while (*lp != '\0') {
			if (firstorder == (order_t *)NULL)
				curorder = firstorder = (order_t *) malloc(sizeof(order_t));
			else {
				temporder = curorder;
				curorder = temporder->next = (order_t *) malloc(sizeof(order_t));
			}
			if (curorder == (order_t *)NULL) {
				fprintf(stdout,"550-FATAL ERROR, out of memory.\n");
				errs++;
				quitprogram();
			}
			curorder->next = (order_t *)NULL;
			while (*lp == '\t')
				lp++;
			blp = lp;
			while (*lp != '\t' && *lp != '\n' && *lp != '\0')
				lp++;
			if (*lp != '\0') {
				*lp = '\0';
				lp++;
			}
			if (STRCASEEQ(S_ALL, blp)) {
				if (*lp != '\0' || firstorder != curorder) {
					BDisplayErr(BE_FALONE,lineno,S_ALL,NULL,NULL);
					errs++;
					quitprogram();
				}
				for (i=0; i<nfields; i++) {
					if (fields[i]->props & R_PROP) {
						if (!hasaccessall) {
							BDisplayErr(BE_FPERM,lineno,fields[i]->str,NULL,NULL);
							errs++;
							quitprogram();
						}
					}
				}
				doingall = 1;
				break;
			}
			if ((curorder->index = GetFieldIndex(blp)) < 0) {
				if ((*blp == '\0') && (curorder == firstorder)) {
					curorder->index = pkeylen;
					fprintf(stdout,"240-Assuming only field to be \"%s\".\n",fields[i_pkey]->str);
				} else {
					BDisplayErr(BE_FUNKN,lineno,blp,NULL,NULL);
					errs++;
					quitprogram();
				}
			}
			if (fields[curorder->index]->props & R_PROP) {
				if (!hasaccessall) {
					BDisplayErr(BE_FPERM,lineno,fields[curorder->index]->str,NULL,NULL);
					errs++;
					quitprogram();
				}
			}
			if (curorder == firstorder && curorder->index != i_pkey) {
				curorder = firstorder->next = (order_t *) malloc(sizeof(order_t));
				if (curorder == (order_t *)NULL) {
					fprintf(stdout,"550-FATAL ERROR, out of memory.\n");
					errs++;
					quitprogram();
				}
				curorder->next = (order_t *)NULL;
				curorder->index = firstorder->index;
				firstorder->index = i_pkey;
				fprintf(stdout,"250-Assuming first field to be \"%s\".\n",fields[i_pkey]->str);
			}
			temporder = firstorder;
			while (temporder != curorder) {
				if (temporder->index == curorder->index) {
					BDisplayErr(BE_FDUP,lineno,blp,NULL,NULL);
					errs++;
					quitprogram();
				}
				temporder = temporder->next;
			}
		}
	}
	fputs("226 Ready for input.  End with ^D (End of File).\n",stdout);

	recflags = 0;
	if (lock) {
		DisableInterrupts();
		if (OpenData(1) < 0) {
			fprintf(stdout, "550-FATAL ERROR, %s.\n",errmsg);
			errs++;
			quitprogram();
		}
		EnableInterrupts();
	}

	if (X_Doing == X_BAD) {
		while (fgets(linein, LINEMAX, stdin)) {
			DisableInterrupts();
			bzero(data,recordlen);
			lineno++;
			blp = lp = linein;
			recflags = 0;
			curorder = firstorder;
			if (doingall)
				curorder->index = 0;
			while (*lp != '\n') {
				if (!curorder || (doingall && curorder->index == nfields)) {
					BDisplayErr(BE_FMANY,lineno,fields[i_pkey]->data,NULL,NULL);
					errs++;
					errsthisline++;
					break;
				}
				while (*lp == '\t')
					lp++;
				blp = lp;
				while ((*lp != '\n') && (*lp != '\0') && (*lp != '\t'))
					lp++;
				size = lp - blp;
				if (size > fields[curorder->index]->len) {
					if (truncate && fields[curorder->index]->keyindex < 0) {
						fprintf(stdout, "245-line %d, %s, field too long, truncated from %d to %d.\n",lineno,fields[curorder->index]->str,size,fields[curorder->index]->len);
						size = fields[curorder->index]->len;
					} else {
						if (curorder->index == i_pkey) {
							bcopy(blp,fields[i_pkey]->data,fields[i_pkey]->len);
							*(fields[i_pkey]->data+fields[i_pkey]->len) = '\0';
						}
						BDisplayErr(BE_FLONG,lineno,fields[i_pkey]->data,fields[curorder->index]->str,NULL);
						errs++;
						errsthisline++;
						break;
					}
				}
				bzero(fields[curorder->index]->data,fields[curorder->index]->len+1);
				if (!(*blp == '?' && size == 1)) {
					bcopy(blp,fields[curorder->index]->data,size);
					if (!StrEqExp(fields[curorder->index]->data,fields[curorder->index]->exp,1)) {
						BDisplayErr(BE_BAD,lineno,fields[i_pkey]->data,fields[curorder->index]->str,NULL);
						errs++;
						errsthisline++;
						break;
					}
					i = fields[curorder->index]->keyindex;
					if (i >= 0) {
						badinput = 0;
						i = keys[i]->len;
						bcp = fields[curorder->index]->data;
						for (cp=bcp; *cp; cp++) {
							if (*cp == ' ') {
	 							if (cp-bcp > i) {
									badinput = 1;
									break;
								} else
									bcp = cp+1;
							}
						}
						if (cp-bcp > i)
							badinput = 1;
						if (badinput) {
							BDisplayErr(BE_KLONG,lineno,fields[i_pkey]->data,fields[curorder->index]->str,NULL);
							errs++;
							errsthisline++;
							break;
						}
					}
				}
				if (curorder->index == i_pkey) {
					if ((retval=ReserveKeys(i_pkey,&keystr)) < 0) {
						fprintf(stdout, "550-FATAL ERROR, %s\n",errmsg);
						FreeKeys(fields[curorder->index]->keyindex,fields[curorder->index]->data,"");
						errs++;
						quitprogram();
					}
					validated = -1;
					if (retval > 0) {
						if (Validated(fields[i_access]->newdata))
							recflags |= REC_VALID;
						else {
							BDisplayErr(BE_RPERM,lineno,fields[i_pkey]->newdata,NULL,NULL);
							errsthisline++;
							errs++;
							break;
						}
						recordoffset = newrecordoffset;
						bcopy(newdata,data,recordlen);
						bcopy(data,origdata,recordlen);
						if (!(user=RecLock(i_pkey,fields[i_pkey]->data))) {
							fprintf(stdout,"550-FATAL ERROR: %s\n",errmsg);
							errs++;
							quitprogram();
						} else if (*user) {
							BDisplayErr(BE_RLOCK,lineno,fields[i_pkey]->data,NULL,NULL);
							errs++;
							errsthisline++;
							break;
						}
					} else {
						recflags |= REC_NEW;
						recordoffset = -1L;
						bzero(origdata,recordlen);
					}
					bcopy(data,prevdata,recordlen);
				} else if (curorder->index == i_access) {
					if (Validated(fields[i_access]->data))
						recflags |= REC_VALID;
					else {
						BDisplayErr(BE_RPERM,lineno,fields[i_pkey]->data,NULL,NULL);
						errsthisline++;
						errs++;
						break;
					}
				} else if (fields[curorder->index]->keyindex >= 0) {
					if ((retval=ReserveKeys(curorder->index,&keystr)) < 0) {
						fprintf(stdout, "550-FATAL ERROR, %s\n",errmsg);
						FreeKeys(fields[curorder->index]->keyindex,fields[curorder->index]->data,"");
						errs++;
						quitprogram();
					}
					if (retval > 0) {
						if (retval == 2)
							BDisplayErr(BE_KDUP,lineno,fields[i_pkey]->data,keystr,NULL);
						else
							BDisplayErr(BE_KUSED,lineno,fields[i_pkey]->data,keystr,fields[i_pkey]->newdata);
						errs++;
						errsthisline++;
						break;
					}
				}
				strncpy(fields[curorder->index]->prevdata,fields[curorder->index]->data,size);
				(fields[curorder->index]->prevdata)[size] = '\0';
				if (doingall)
					(curorder->index)++;
				else
					curorder = curorder->next;
			}
			if (errsthisline != 0) {
				errsthisline = 0;
			} else if (baddata()) {
				errs++;
			} else if ((doingall && curorder->index != nfields) || (!doingall && curorder)) {
				BDisplayErr(BE_FFEW,lineno,fields[i_pkey]->data,NULL,NULL);
				errs++;
			} else {
				if (!ignorerealdate) {
					if (recflags & REC_NEW)
						StampRec(i_createdate);
					else
						StampRec(i_moddate);
				}
				if (!lock && OpenData(1) < 0) {
					fprintf(stdout, "550-FATAL ERROR, %s.\n",errmsg);
					errs++;
					quitprogram();
				}
				if (WriteData(recordoffset)<0) {
					fprintf(stdout,"550-FATAL ERROR, %s.\n",errmsg);
					errs++;
					quitprogram();
				}
				if (!lock)
					CloseData();
				if (recflags & REC_NEW) {
					fprintf(stdout,
						"224 line %d, %s, successfully created.\n",
						lineno,fields[i_pkey]->data);
#if SYSLOG || LOGTOFILE
					if (!silent) {
						sprintf(msg,"addhoser %s created %s.\n",
							InvokerAcct, fields[i_pkey]->data);
#if SYSLOG
						syslog(LOG_INFO,msg);
#endif
#if LOGTOFILE
						LogToFile(msg);
#endif
					}
#endif
				} else {
					fprintf(stdout,
						"225 line %d, %s, successfully modified.\n",
						lineno,fields[i_pkey]->data);
#if SYSLOG || LOGTOFILE
					if (!silent) {
						sprintf(msg,"addhoser %s modified %s.\n",
							InvokerAcct, fields[i_pkey]->data);
#if SYSLOG
						syslog(LOG_INFO,msg);
#endif
#if LOGTOFILE
						LogToFile(msg);
#endif
					}
#endif
					RmRecLock(i_pkey,fields[i_pkey]->data);
				}
				EnableInterrupts();
				continue;
			}
			if (FreeAllKeys() < 0) {
				fprintf(stdout, "550-FATAL ERROR, %s\n",errmsg);
				errs++;
				quitprogram();
			}
			RmAllRecLocks();
			bzero(prevdata,recordlen);
			EnableInterrupts();
		}
	} else {
		while (fgets(linein, LINEMAX, stdin)) {
			DisableInterrupts();
			lineno++;
			len = strlen(linein);
			linein[len-1] = '\0'; /* nuke the newline */
			if (len > fields[i_pkey]->len) {
				linein[fields[i_pkey]->len] = '\0';
				BDisplayErr(BE_KLONG,lineno,linein,fields[i_pkey]->str,NULL);
				errs++;
				continue;
			}
			strcpy(fields[i_pkey]->data,linein);
			retval = ReadData(i_pkey);
			if (retval == 1) {
				BDisplayErr(BE_EXIST,lineno,linein,NULL,NULL);
				errs++;
				continue;
			}
			if (!Validated(fields[i_access]->newdata)) {
				BDisplayErr(BE_RPERM,lineno,linein,NULL,NULL);
				errs++;
				continue;
			}
			if (!(user=RecLock(i_pkey,fields[i_pkey]->data))) {
				fprintf(stdout,"550-FATAL ERROR: %s\n",errmsg);
				errs++;
				quitprogram();
			} else if (*user) {
				BDisplayErr(BE_RLOCK,lineno,linein,NULL,NULL);
				errs++;
				continue;
			}
			recordoffset = newrecordoffset;
			bcopy(newdata,data,recordlen);
			bcopy(newdata,prevdata,recordlen);
			strcpy(linein,fields[i_pkey]->data);
			if (RemoveData() < 0) {
				fprintf(stdout,"550-FATAL ERROR: %s\n",errmsg);
				errs++;
				quitprogram();
			}
			fprintf(stdout,
				"224 line %d, %s, successfully removed.\n",
				lineno, linein);
#if SYSLOG || LOGTOFILE
			if (!silent) {
				sprintf(msg,"addhoser %s removed %s.\n",
					InvokerAcct, linein);
#if SYSLOG
				syslog(LOG_INFO,msg);
#endif
#if LOGTOFILE
				LogToFile(msg);
#endif
			}
#endif
			bzero(prevdata,recordlen);
			EnableInterrupts();
		}
	}
	fprintf(stdout,"260-End of input.\n");
	quitprogram();
}

/*
 *  Check to see that we arent missing any important data.  This
 *  is done before we start talking with the server.  Also check
 *  to see if any characters are used that aren't allowed.  A
 *  return input of zero means all is well, otherwise 1 is returned.
 */
static baddata() {
	int i;
	scrfield_t *fptr;
	char *cp, *allow;

	fptr = firstscrfield;
	do {
		if ((fields[fptr->index]->props & M_PROP) && *fields[fptr->index]->data == '\0') {
			BDisplayErr(BE_FEMPTY,lineno,fields[i_pkey]->data,fields[fptr->index]->str,NULL);
			return(1);
		}
		allow = fields[fptr->index]->allow;
		for (cp=fields[fptr->index]->data; *cp; cp++)
			if (!allow[(int)*cp]) {
				BDisplayErr(BE_INVCHAR,lineno,fields[i_pkey]->data,fields[fptr->index]->str,unctrl(*cp));
				return(1);
			}
		fptr = fptr->next;
	} while (fptr != firstscrfield);

	return(0);
}

static usage() {
	int i;
	int len, col;

	if (X_Doing == X_BRM) {
		printf("200-usage: %s [-s] [-l]\n",ProgName);
		fputs("200-    -s suppress syslog output\n",stdout);
		fputs("200-    -l lock, speeds up program via exclusive database access\n",stdout);
		quitprogram();
	}
	printf("200-usage: %s [-s] [-l] [-i] [-t]\n",ProgName);
	fputs("200-    -s suppress syslog output\n",stdout);
	fputs("200-    -l lock, speeds up program via exclusive database access\n",stdout);
	fputs("200-    -i ignore the real date and username\n",stdout);
	fputs("200-    -t truncate non-key fields that are too long\n",stdout);
	fputs("200-On each line of input, tabs should separate the fields, this includes\n",stdout);
	fputs("200-the field specification line.  The field specification line is assumed\n",stdout);
	fputs("200-to be the first line.  The key field \"",stdout);
	fputs(fields[i_pkey]->str,stdout);
	fputs("\" is assumed to be\n",stdout);
	fputs("200-the first field if not there explicitly (it must be first).  If this\n",stdout);
	fputs("200-line begins with the word \"",stdout);
	fputs(S_ALL,stdout);
	fputs("\", then the following order of fields\n",stdout);
	fputs("200-is assumed:\n",stdout);
	fputs("200-",stdout);
	col = len = 0;
	for (i=0; i<nfields; i++) {
		len = strlen(fields[i]->str);
		if ((len+col > 74) && (col != 0)) {
			fputs("\n200-",stdout);
			col = len;
		} else
			col += len;
		fputs(fields[i]->str,stdout);
		if (i < nfields-1 && col < 80) {
			fputc(' ',stdout);
			col++;
		}
	}
	fputc('\n',stdout);
	fflush(stdout);
	quitprogram();
}

static quitprogram() {
	long    tloc;

	time(&tloc);
	fprintf(stdout, "270-lines in: %d, errors detected: %d.\n",lineno,errs);
	if (lockall == 1)
		UnLockOutAll();
	fprintf(stdout, "221 %s %s  done at %s",ProgName,version,ctime(&tloc));
	CleanUp();
	exit(errs);
}
