/*
 * $Header: $
 * $Log:	$
 * 
 */

#include <sys/types.h>
#include <sys/param.h>
#include <curses.h>
#include <utmp.h>
#include <time.h>
#include <errno.h>

/*
 * either SYSLOG or LOGTOFILE should be set to 1 if you want to log
 * database activity.  it's probably not safe to set up the syslog.conf
 * file to log to the same file as LOGTOFILE is set up to log to, but
 * there should be no problem if you want to use both options.
 */
#define SYSLOG		1
#define LOGTOFILE	0

#if SYSLOG
/* where to send syslog messages */
#define SYSLOGFAC	LOG_LOCAL7
#endif

#if LOGTOFILE
#define LOGFILEMODE	0640
#ifdef MAIN
char *LogFile = "/var/adm/testaddhostlog";
#else
extern char *LogFile;
#endif
#endif

/*****************************************************************************/
/* You probably don't need to change any of the rest of this file.           */
/*****************************************************************************/

#define UMASK		0027	/* umask for file creation */
#define DBMMODE		0640	/* mode used to create dbm files */
#define DBDIRMODE	0750	/* mode used to create NewDBDir */
#define	LINEMAX		1024	/* how big input lines can be */
#define DAEMONTIMEOUT	120	/* time (seconds) that daemon will wait for input */
#define DATALOCKTIME	5	/* time (seconds) before data lock is ignored */

/* different modes this program runs under */
#define X_ADD		1
#define X_RM		2
#define X_BAD		3
#define X_BRM		4
#define X_DAEMON	5

/* field properties */
#define R_PROP			1			/* reserved - only ACCESS=ALL can modify */
#define M_PROP			2			/* mandatory - field must have data */

#define S_ALL			"ALL"
#define S_KEY			"KEY"
#define S_ACCESS		"ACCESS"
#define S_CREATOR		"CREATOR"
#define S_MODIFIER		"MODIFIER"
#define S_CREATEDATE	"CREATEDATE"
#define S_MODDATE		"MODDATE"

#define L_CREATOR		sizeof(utmp.ut_name)
#define L_MODIFIER		sizeof(utmp.ut_name)
#define L_CREATEDATE	20
#define L_MODDATE		20

#define E_CREATOR		"*"
#define E_MODIFIER		"*"
#define E_CREATEDATE	"(0-2147483647)"
#define E_MODDATE		"(0-2147483647)"	/* the epression for MODDATE */

#define S_SCREEN	"SCREEN"
#define S_ADDCOMM	"ADDCOMM"
#define S_RMCOMM	"RMCOMM"
#define I_GENHELP		-1
#define I_CHOICEHELP	-2
#define I_EDITHELP		-3
#define	S_GENFIELD	"GENFIELD"		/* means it is not a key */
#define I_GENFIELD		-1
#define S_PRIMARY	"P"		/* means this is the primary key */

/* strings identifying help text in ScreenHelpFile */
#define S_GENHELP		"GENERAL"
#define S_CHOICEHELP	"CHOICE"
#define S_EDITHELP		"EDIT"

/* used to communicate with daemon */
#ifdef REMOTE
#define C_USER			"USER"
#define C_ACCESS		"ACCESS"
#define C_VALID			"VALID"
#define C_CAT			"CAT"
#endif
#define C_QUIT			"QUIT"
#define S_SCREENFILE	"SCR"
#define S_DBFIELDSFILE	"FLD"
#define S_DBKEYSFILE	"KEY"
#define S_FIELDSHF		"FLDHF"
#define S_SCREENHF		"SCRHF"
#define S_MOTDFILE		"MOTD"

/* whether to highlight or not */
#define NO_STAND	0
#define STANDOUT	1

#define ASCIICHARS	128

#ifdef REMOTE
/* list of valid remote users */
typedef struct rusers {
	char *username;
	struct rusers *next;
} rusers_t;
#endif

/* these are used in ChoiceList() */
typedef struct {
	int n;
	char **list;
	int longest;
	int *lens;
	char *chosen;
	int nchosen;
	int maxchosen;
} choice_t;

typedef struct field {
	char *str;
	char props;
	char *propstr;
	char *exp;
	int len;
	int keyindex;
	char *data;
	char *newdata;
	char *prevdata;
	char *origdata;
	choice_t *choice;
	char allow[ASCIICHARS];	/* characters allowed (boolean) */
	char *allowstr;			/* as read in from config file */
	struct field *next;
} field_t;

typedef struct mykey {
	char *str;
	int len;
	char *filename;
	struct mykey *next;
} mykey_t;

typedef struct FIELD {
	int x_label, y_label;	/* (x,y) coords for prompt */
	char *label;			/* prompt message */
	int x_input, y_input;	/* (x,y) coords for input & length */
	int x_error, y_error;	/* (x,y) coords for error message */
	int index;				/* index: i.e. I_YPTYPE */
	struct FIELD *next;
	struct FIELD *prev;
} scrfield_t;

typedef struct SPECIALFIELD {
	int x_label, y_label;
	char *label;
	int x_pos, y_pos;
	int index;
	struct SPECIALFIELD *next;
} specialscrfield_t;

/*
 *  The `allow' field of field_t is setup as the full range of ascii chars
 *  where each char maps directly to a boolean value.  True means the
 *  character is valid input, False means it is not.  Since every char
 *  is compared here, speed was more important than space.  NUL is not
 *  allowed anytime.
 */

typedef struct COMMENT {
	int type;
	char *text;
	int x_pos, y_pos;
	struct COMMENT *next;
} comment_t;

typedef struct SCREEN {
	WINDOW *win;
			/* these define what fields are on this screen */
	scrfield_t *begin;				/* ptr to first field on screen */
	scrfield_t *end;				/* ptr to last field on screen */
	int screennum;
	comment_t *comment;
	specialscrfield_t *specialscrfield;
	struct SCREEN *prev;
	struct SCREEN *next;
} screen_t;

#define	REC_NEW			0x01
#define REC_VALID		0x02
#define REC_MODIFIED	0x04
#define REC_EXISTS		0x08

#define IACCTLEN	sizeof(utmp.ut_name)
#define INAMELEN	40

/* size of syserr, errmsg, msg, and msg2 */
#define MSGSIZ	1024

#ifdef MAIN
char *version = "2.0";

struct utmp utmp;	/* just so the sizeof function works */

int pid, hasaccessall, naccess, nvalid, screenon=0;
char **accesschoices, **validchoices, X_Doing;
char HostName[MAXHOSTNAMELEN+1];		/* our hostname */
char PeerHostName[MAXHOSTNAMELEN+1];	/* hostname of remote host */
char InvokerAcct[IACCTLEN+1];			/* invoker's account name */
char LockAcct[IACCTLEN+1];				/* user who locked another record */
char InvokerName[INAMELEN+1];			/* invoker's full name */
uid_t InvokerUid;						/* invoker's user id */

char *LibDir			= LIB";			/* lib directory */
char *DBDir				= DBDIR";		/* all database files go here */
char *DataFile			= DBDIR/data";	/* data for records stored here */
char *NewDBDir			= DBDIR.new";
char *NewDataFile		= DBDIR.new/data";
char *DataLockFile		= DBDIR/lock";	/* prevent multiple writes to data */
char *RecLockDir		= RECLOCKDIR";	/* used to lock rec's by primary key */
char *DBLockDir			= DBLOCKDIR";	/* used to lock db */
char *LockAllFile		= DBLOCKDIR/lockall";   /* lock read/write access */
char *AccessUsersFile	= LIB/addhosers"; /* access file, which users are valid */
char *SConfFile			= LIB/screen.conf";
char *DotSConfFile		= LIB/.screen.conf";
char *DBFieldsFile		= LIB/db.fields";
char *DotDBFieldsFile	= LIB/.db.fields";
char *DBKeysFile		= LIB/db.keys";
char *DotDBKeysFile		= LIB/.db.keys";
char *LockMsgFile		= LIB/lockmsg";
char *MotdFile			= LIB/motd";
char *AccessHostsFile	= LIB/radhosts";
char *DaemonHelpFile	= LIB/daemon.hf";
char *FieldsHelpFile	= LIB/fields.hf";
char *ScreenHelpFile	= LIB/screen.hf";
char *HUPMesgFile		= LIB/mesg";

char *AddProg			= ADDPROG";
char *RmProg			= RMPROG";
char *BadProg			= BADPROG";
char *BrmProg			= BRMPROG";
char *DaemonProg		= DAEMONPROG";

screen_t *curscreen=NULL, *firstscreen;
scrfield_t *firstscrfield;			/* define the screen layout */
mykey_t *firstkey=0, *curkey, **keys;
field_t *firstfield=0, *curfield, **fields;
int nkeys, nfields;
char c_erase, c_kill, c_werase;		/* users' favorites... */
int LastLine, SecLastLine, LastCol;	/* last/second-last line; last col */
int recflags=REC_NEW, wasbeeperr=0, freepkeyfield=0, lockall=0, cleanall=0;
char *createdatestr, *moddatestr;
char unamewhitespace[sizeof(utmp.ut_name)+1];
char *tmpfieldspace, linein[LINEMAX];
char *ProgName;						/* name this program was started as */

int recordlen;				/* size of record in the database */
int pkeylen;				/* size of the primary key */
int maxkeylen;				/* size of the biggest key */
int maxfieldlen;			/* size of the biggest field */
long recordoffset = -1;		/* offset of last data record read in */
long newrecordoffset = -1;	/* offset of data record read into newdata */

/* indices into field array for reserved fields*/
int	i_pkey,					/* primary key for database */
	i_access,				/* controls access to groups of records */
	i_creator,				/* the creator of the record */
	i_modifier,				/* who last modified the record */
	i_createdate;			/* date the record was created */
	i_moddate;				/* date the record was last modified */

char *data=0;				/* current hosts data */
char *newdata=0;			/* newly read in data */
char *prevdata=0;			/* used to see if changes were made */
char *origdata=0;			/* used to cache what the data is like on disk */

/* message buffers so we have allocated space to use */
char syserr[MSGSIZ], errmsg[MSGSIZ], msg[MSGSIZ], msg2[MSGSIZ];

#ifdef REMOTE
rusers_t *firstruser=(rusers_t *)NULL, *curruser;
FILE *REMOTEIN=0, *REMOTEOUT=0;
#endif

#else

extern char *version;

extern struct utmp utmp;

extern int pid, hasaccessall, naccess, nvalid, screenon;
extern char **accesschoices, **validchoices, X_Doing,
	HostName[], PeerHostName[], InvokerAcct[], LockAcct[], InvokerName[];
extern uid_t InvokerUid;

extern char *LibDir, *DBDir, *DataFile, *DataLockFile, *RecLockDir,
	*DBLockDir, *LockAllFile, *AccessUsersFile, *SConfFile, *DotSConfFile,
	*DBFieldsFile, *DotDBFieldsFile, *DBKeysFile, *DotDBKeysFile,
	*LockMsgFile, *MotdFile, *AccessHostsFile, *DaemonHelpFile,
	*FieldsHelpFile, *ScreenHelpFile, *HUPMesgFile, *NewDataFile, *NewDBDir;
extern char *AddProg, *RmProg, *BatchProg, *DaemonProg;

extern screen_t *curscreen, *firstscreen;
extern scrfield_t *firstscrfield;
extern mykey_t *firstkey, *curkey, **keys;
extern field_t *firstfield, *curfield, **fields;
extern int nkeys, nfields;
extern char c_erase, c_kill, c_werase;
extern int LastLine, SecLastLine, LastCol;
extern int recflags, wasbeeperr, freepkeyfield, lockall, cleanall;
extern char *createdatestr, *moddatestr;
extern char unamewhitespace[];
extern char *tmpfieldspace, linein[];
extern char *ProgName;

extern int recordlen, pkeylen, maxkeylen, maxfieldlen, recordoffset,
	newrecordoffset, i_pkey, i_access, i_creator, i_modifier, i_createdate,
	i_moddate;

extern char *data, *newdata, *prevdata, *origdata;
extern char syserr[], errmsg[], msg[], msg2[];

#ifdef REMOTE
extern rusers_t *firstruser, *curruser;
extern FILE *REMOTEIN, *REMOTEOUT;
#endif

#endif

extern char *StrCaseStr(), *RecLock(), *ChoiceBox(), *NewStr();

/* so that we can get the system error messages */
extern int sys_nerr;
extern char *sys_errlist[];
extern int errno;

/*
 *	For speed...
 */
#define STREQ(s1,s2)		((*s1 == *s2) && strcmp(s1, s2) == 0)
#define STRCASEEQ(s1,s2)	((TOLOWER(*s1) == TOLOWER(*s2)) && \
								strcasecmp(s1, s2) == 0)
#define STRNEQ(s1,s2,n)		((*s1 == *s2) && strncmp(s1, s2, n) == 0)
#define STRNCASEEQ(s1,s2,n)	((TOLOWER(*s1) == TOLOWER(*s2)) && \
								strncasecmp(s1, s2, n) == 0)
#define TOLOWER(c)			((c >= 'A' && c <= 'Z') ? c + 32 : c)
#define MAKELO(s)			for (cp=s; *cp; cp++) *cp = TOLOWER(*cp);

