#ifndef lint
static char rcsid[] = "$Header: $";
#endif

/*
 * $Log:$
 */

/*
 *	daemon.c
 *
 *	Daemon server for host database.
 *
 *	28 Nov 1989 Hardt
 *
 *			2?? informational
 *			3?? requested data
 *			4?? error
 *			5?? fatal error
 *
 *  A space immediately following the 3 digit number means program is
 *  ready to receive data or has finished.
 *
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <sys/file.h>
#include <sys/param.h>

#include <ndbm.h>
#include <netdb.h>
#include <netinet/in.h>
#include <stdio.h>
#include <ctype.h>
#include <errno.h>
#include <string.h>
#include <strings.h>
#include <pwd.h>

#include "common.h"
#include "errors.h"
#if SYSLOG
#include <syslog.h>
#endif

#define SYNTAXERR return(DDisplayErr(DE_SYNTAX))

/* move pointer p to beginning of next word in line */
#define NEXTWORD(line,p) for(p=line; !isspace(*p) && (*p!='\0'); p++); \
 if (*p != '\0') p++; \
 if (*s == '\0') SYNTAXERR;

/* set last character in s to '\0' if it isspace */
char *c;
#define NULLEND(s) if (isspace(*(c=s+strlen(s)-1))) *c='\0'

typedef struct expi {
	char *exp;
	int i;
} expi_t;

typedef struct sort {
	int fi;		/* fields index */
	int si;		/* show index */
	int num;	/* numeric flag */
	char del;	/* delimiter */
} sort_t;

expi_t *sets;
expi_t *setkeys;
sort_t *sorts;
int setcount=0, setkeycount=0, sortcount=0;
int *shows, showcount=0, showkeyflag=0;
int sortkeyflag=0, sortkeynum=0, sortkeydel=0;
scrfield_t **sfp;

int humanflag=0, prettyflag=0;

int pid;
char ***sortlist;

/*
 * this is to speed up memory allocation when sorting.
 */
typedef struct blks {
	char *b;
	struct blks *next;
} blks_t;
blks_t *firstblk=0, *curblk;
char *freeptr, *endfree;
#define BLKSIZ 4096
char ***recs=0;
char **recarrays=0;
int nrecs,newnrecs,currec,recarraysize;

Daemon() {
	char line[1024], *getsret;
	long tloc;
	struct sockaddr_in sin;
	struct hostent *hp;
	int i;

	i = sizeof (sin);
	if (getpeername(0, (struct sockaddr *)&sin, &i) < 0)
		FatalError("getpeername failed");

	sin.sin_port = ntohs((u_short)sin.sin_port);
	if (sin.sin_family != AF_INET)
		FatalError("malformed from address");

	hp = gethostbyaddr((char *) &sin.sin_addr, sizeof(sin.sin_addr),
				sin.sin_family);
	(void) strncpy(PeerHostName, (hp == NULL) ? "UNKNOWN" : hp->h_name,
		MAXHOSTNAMELEN);
	PeerHostName[MAXHOSTNAMELEN] = '\0';

	if (sin.sin_port > IPPORT_RESERVED) {
		sprintf(errmsg,"connection from bad port attempted by %s.",PeerHostName);
		FatalError(errmsg);
	}

	if (ValidateHost(PeerHostName) < 0)
		FatalError(errmsg);

#if SYSLOG || LOGTOFILE
	sprintf(msg, "connection by %s\n", PeerHostName); 
#if SYSLOG
	syslog(LOG_INFO, msg); 
#endif
#if LOGTOFILE
	LogToFile(msg);
#endif
#endif

	CheckLockAll();
	DBLock();
	if (DBConfig(0) < 0)
		FatalError(errmsg);
	InitDB();

	if (ScreenConfig(0) < 0)
		FatalError(errmsg);

	sets = (expi_t *) malloc(sizeof(expi_t)*nfields);
	setkeys = (expi_t *) malloc(sizeof(expi_t)*nkeys);
	sorts = (sort_t *) malloc(sizeof(sort_t)*nfields);
	shows = (int *) malloc(sizeof(int)*nfields);
	sfp = (scrfield_t **) malloc(sizeof(scrfield_t *)*nfields);
	curblk = firstblk = (blks_t *) malloc(sizeof(blks_t));
	if (sets == (expi_t *)NULL || setkeys == (expi_t *)NULL ||
			sorts == (sort_t *)NULL || shows == (int *)NULL ||
			sfp == (scrfield_t **)NULL || firstblk == (blks_t *)NULL)
		FatalError("out of memory.");
	curblk->next = (blks_t *)NULL;
	curblk->b = (char *) malloc(BLKSIZ);
	if (curblk->b == (char *)NULL)
		FatalError("out of memory.");

	time(&tloc);
	printf("200 %s %s %s ready, %s",HostName,ProgName,version,ctime(&tloc));
	fflush(stdout);
	alarm(DAEMONTIMEOUT);
	getsret = gets(line);
	while(getsret != (char *)NULL &&
		  !STRNCASEEQ(line,C_QUIT,sizeof(C_QUIT)-1) &&
	      !STRNCASEEQ(line,"bye",3)) {
		if (STRNCASEEQ(line,"help",4))
			help(line);
		else if (STRNCASEEQ(line,"helo",4))
			helo(line);
		else if (STRNCASEEQ(line,"setkey",6))
			setkey(line);
		else if (STRNCASEEQ(line,"unsetkey",8))
			unsetkey(line);
		else if (STRNCASEEQ(line,"set",3))
			set(line);
		else if (STRNCASEEQ(line,"unset",5))
			unset(line);
		else if (STRNCASEEQ(line,"sortkey",7))
			sortkey(line);
		else if (STRNCASEEQ(line,"sort",4))
			sort(line);
		else if (STRNCASEEQ(line,"unsort",6))
			unsort(line);
		else if (STRNCASEEQ(line,"showkey",8))
			showkey();
		else if (STRNCASEEQ(line,"show",4))
			show(line);
		else if (STRNCASEEQ(line,"unshow",6))
			unshow(line);
		else if (STRNCASEEQ(line,"listkeys",8))
			listkeys();
		else if (STRNCASEEQ(line,"list",4))
			list();
		else if (STRNCASEEQ(line,"human",6))
			human();
		else if (STRNCASEEQ(line,"pretty",6))
			pretty();
		else if (STRNCASEEQ(line,"match",5))
			match();
#ifdef REMOTE
		else if (STRNCASEEQ(line,C_USER,sizeof(C_USER)-1))
			user(line);
		else if (STRNCASEEQ(line,C_ACCESS,sizeof(C_ACCESS)-1))
			access(line);
		else if (STRNCASEEQ(line,C_VALID,sizeof(C_VALID)-1))
			valid(line);
		else if (STRNCASEEQ(line,C_CAT,sizeof(C_CAT)-1))
			cat(line);
#endif REMOTE
		else
			DDisplayErr(DE_SYNTAX);
		fflush(stdout);
		alarm(DAEMONTIMEOUT);
		getsret = gets(line);
	}

	CleanUp();
	exit(0);
}

static help(line)
	char *line;
{
	FILE *fp;
	char *srchstr, *cp;
	int linecount;

	if ((fp = fopen(DaemonHelpFile, "r")) == NULL) {
		DDisplayErr(DE_HELPFILE);
		return;
	}

	if (strlen(line) <= 5 && (isspace(line[4]) || line[4] == '\0'))
		srchstr = "?";
	else
		srchstr = line+5;

	linecount = 0;
	while (fgets(linein, LINEMAX, fp) != NULL) {
		if (*linein == '\n' || *linein == '#')	/* ignore comment */
			continue;
		cp = linein;
		while ((*cp!=' ') && (*cp!='\t') && (*cp!='\0') && (*cp!='\n')) cp++;
		if (isspace(*cp)) *cp++ = '\0';
		if (STRCASEEQ(linein, srchstr)) {
			linecount++;
			printf("300-%s",cp);
		}
	}
	fclose(fp);

	if (linecount == 0)	/* unable to get any help info */
		DDisplayErr(DE_HELPTOPIC);
	else
		printf("220 End of HELP info\n");
}

static helo(line)
	char *line;
{
	char *s;

	if (strlen(line) < 6)
		printf("220 I'm %s - Pleased to have met you %s!\n",HostName,PeerHostName);
	else {
		NEXTWORD(line,s);
		NULLEND(s);
		printf("220 Hi %s! I'm %s.  Nice rappin' with you.\n", s, HostName);
	}
}

static setkey(line)
	char *line;
{
	char *s,*t;
	int i, j;
	
	if (strlen(line) < 8) {
		if (!setkeycount)
			DDisplayErr(DE_NOSET);
		else {
			for (i=0; i<setkeycount; i++)
				if (setkeys[i].exp)
					printf("300-%s\t%s\n",keys[setkeys[i].i]->str,setkeys[i].exp);
			printf("220 End of SETKEY values.\n");
		}
	} else {
		NEXTWORD(line,s);
		NEXTWORD(s,t);
		*(t-1) = '\0';
		NULLEND(t);
		if ((j=GetKeyIndex(s))<0)
			DDisplayErr(DE_INVKEY);
		else {
			for (i=0; i<setkeycount; i++)
				if (setkeys[i].i == j)
					break;
			if (setkeycount == i) {
				setkeys[i].i = j;
				setkeycount++;
			}
			if ((setkeys[i].exp = (char *)NewStr(t)) == (char *)NULL)
				FatalError("out of memory.");
			printf("220 SETKEY %s to '%s'.\n",keys[setkeys[i].i]->str,setkeys[i].exp);
		}
	}
}

static unsetkey(line)
	char *line;
{
	char *s;
	int i, j;

	if (strlen(line) < 10) {
		SYNTAXERR;
	} else {
		NEXTWORD(line,s);
		NULLEND(s);
		if (STRCASEEQ(s,S_ALL)) {
			if (!setkeycount)
				DDisplayErr(DE_NOSET);
			else {
				for (i=0; i<setkeycount; i++)
					if (setkeys[i].exp) {
						free(setkeys[i].exp);
						setkeys[i].exp = (char *)NULL;
					}
				setkeycount = 0;
				printf("220 All keys unset.\n");
			}
		} else if (!setkeycount)
			DDisplayErr(DE_NOSET);
		else if ((j=GetKeyIndex(s)) < 0)
			DDisplayErr(DE_INVKEY);
		else {
			for (i=0; i<setkeycount; i++)
				if (setkeys[i].i == j) {
					free(setkeys[i].exp);
					setkeys[i].exp = (char *)NULL;
					printf("220 %s no longer set.\n",keys[j]->str);
					setkeycount--;
					if (setkeycount-i > 0)
						bcopy(&setkeys[i+1],&setkeys[i],(setkeycount-i)*sizeof(expi_t));
					return;
				}
			DDisplayErr(DE_NOTSET);
		}
	}
}

static set(line)
	char *line;
{
	char *s,*t;
	int i,j;
	
	if (strlen(line) < 5) {
		if (!setcount)
			DDisplayErr(DE_NOSET);
		else {
			for (i=0; i<setcount; i++)
				if (sets[i].exp)
					printf("300-%s\t%s\n",fields[sets[i].i]->str,sets[i].exp);
			printf("220 End of SET values.\n");
		}
	} else {
		NEXTWORD(line,s);
		NEXTWORD(s,t);
		*(t-1) = '\0';
		NULLEND(t);
		if ((j=GetFieldIndex(s))<0)
			DDisplayErr(DE_INVFIELD);
		else {
			for (i=0; i<setcount; i++)
				if (sets[i].i == j)
					break;
			if (setcount == i) {
				sets[i].i = j;
				setcount++;
			}
			if ((sets[i].exp = (char *)NewStr(t)) == (char *)NULL)
				FatalError("out of memory.");
			printf("220 SET %s to '%s'.\n",fields[sets[i].i]->str,sets[i].exp);
		}
	}
}

static unset(line)
	char *line;
{
	char *s;
	int i, j;

	if (strlen(line) < 7)
		SYNTAXERR;
	else {
		NEXTWORD(line,s);
		NULLEND(s);
		if (STRCASEEQ(s,S_ALL)) {
			if (!setcount)
				DDisplayErr(DE_NOSET);
			else {
				for (i=0; i<setcount; i++)
					if (sets[i].exp) {
						free(sets[i].exp);
						sets[i].exp = (char *)NULL;
					}
				setcount = 0;
				printf("220 All fields unset.\n");
			}
		} else if (!setcount)
			DDisplayErr(DE_NOSET);
		else if ((j=GetFieldIndex(s)) < 0)
			DDisplayErr(DE_INVFIELD);
		else {
			for (i=0; i<setcount; i++)
				if (sets[i].i == j) {
					free(sets[i].exp);
					sets[i].exp = (char *)NULL;
					printf("220 %s no longer set.\n",fields[j]->str);
					setcount--;
					if (setcount-i > 0)
						bcopy(&sets[i+1],&sets[i],(setcount-i)*sizeof(expi_t));
					return;
				}
			DDisplayErr(DE_NOTSET);
		}
	}
}

static sortkey(line)
	char *line;
{
	char *s,*t,del;
	int i, j, num;
	
	if (strlen(line) < 9) {
		if (sortkeyflag) {
			sortkeyflag = 0;
			printf("220 SORTKEY off.\n");
		} else
			SYNTAXERR;
	} else {
		s = line;
		while (*s && !isspace(*s)) s++;
		while (isspace(*s)) s++;
		if (!*s) SYNTAXERR;
		if (TOLOWER(*s) == 'n')
			num = 1;
		else if (TOLOWER(*s) == 'a')
			num = 0;
		else
			SYNTAXERR;
		s++;
		while (isspace(*s)) s++;
		if (*s) {
			if (TOLOWER(*s) == 'd' && *(s+1) == '=') {
				s += 2;
				del = *s;
			} else
				SYNTAXERR;
		} else
			del = 0;
		showkeyflag = 0;
		sortkeyflag = 1;
		sortkeynum = num;
		sortkeydel = del;
		printf("220 SORTKEY on.\n");
	}
}

static sort(line)
	char *line;
{
	char *s,*t,del;
	int i, j, numeric;
	
	if (strlen(line) < 6) {
		if (!sortcount)
			DDisplayErr(DE_NOSET);
		else {
			for (i=0; i<sortcount; i++) {
				if (sorts[i].num) printf("300-numeric\t");
				else printf("300-ascii\t");
				if (sorts[i].del) printf("'%s'\t",unctrl(sorts[i].del));
				else printf("''\t");
				printf("%s\n",fields[sorts[i].fi]->str);
			}
			printf("220 End of SORT values.\n");
		}
	} else {
		s = line;
		while (*s && !isspace(*s)) s++;
		while (isspace(*s)) s++;
		if (!*s) SYNTAXERR;
		if (TOLOWER(*s) == 'n')
			numeric = 1;
		else if (TOLOWER(*s) == 'a')
			numeric = 0;
		else
			SYNTAXERR;
		s++;
		while (isspace(*s)) s++;
		if (!*s) SYNTAXERR;
		if (TOLOWER(*s) == 'd' && *(s+1) == '=') {
			s += 2;
			del = *s++;
			while (isspace(*s)) s++;
			if (!*s) SYNTAXERR;
		} else
			del = 0;
		t = s;
		while (*t && !isspace(*t)) t++;
		if (*t) *t++ = '\0';
		if (STRCASEEQ(s,S_ALL)) {
			sortcount = nfields;
			for (i=0; i<sortcount; i++) {
				sorts[i].fi = i;
				sorts[i].num = numeric;
				sorts[i].del = del;
			}
			printf("220 All fields will be sorted.\n");
		} else if((j=GetFieldIndex(s)) < 0)
			DDisplayErr(DE_INVFIELD);
		else {
			for (i=0; i<sortcount; i++)
				if (sorts[i].fi == j)
					break;
			sorts[i].num = numeric;
			sorts[i].del = del;
			if (i != sortcount)
				sorts[i].fi = j;
			else
				sorts[sortcount++].fi = j;
			printf("220 Field will be sorted.\n");
		}
	}
}

unsort(line)
	char *line;
{
	char *s;
	int i,j;

	if (strlen(line) < 8)
		SYNTAXERR;
	else {
		NEXTWORD(line,s);
		NULLEND(s);
		if (!sortcount)
			DDisplayErr(DE_NOSET);
		else if (STRCASEEQ(s,S_ALL)) {
			sortcount = 0;
			printf("220 No fields will be sorted.\n");
		} else if((j=GetFieldIndex(s)) < 0)
			DDisplayErr(DE_INVFIELD);
		else {
			for (i=0; i<sortcount; i++)
				if (sorts[i].fi == j) {
					sortcount--;
					printf("220 Field will not be sorted.\n");
					if (sortcount-i > 0)
						bcopy(&sorts[i+1],&sorts[i],(sortcount-i)*sizeof(sort_t));
					return;
				}
			DDisplayErr(DE_NOTSET);
		}
	}
}

static showkey() {
	if (showkeyflag) {
		showkeyflag=0;
		printf("220 SHOWKEY off.\n");
	} else {
		sortkeyflag=0;
		showkeyflag=1;
		printf("220 SHOWKEY on.\n");
	}
}

static show(line)
	char *line;
{
	char *s;
	int i,j;

	if (strlen(line) < 6) {
		if (!showcount)
			DDisplayErr(DE_NOSET);
		else {
			for (i=0; i<showcount; i++)
				printf("300-%s\n",fields[shows[i]]->str);
			printf("220 End of field name display list.\n");
		}
	} else {
		NEXTWORD(line,s);
		NULLEND(s);
		if (STRCASEEQ(s,S_ALL)) {
			showcount = nfields;
			for (i=0; i<showcount; i++)
				shows[i] = i;
			printf("220 All fields will be displayed.\n");
		} else if((j=GetFieldIndex(s)) < 0)
			DDisplayErr(DE_INVFIELD);
		else {
			for (i=0; i<showcount; i++)
				if (shows[i] == j)
					break;
			if (i != showcount)
				shows[i] = j;
			else
				shows[showcount++] = j;
			printf("220 Field will be displayed.\n");
		}
	}
}

static unshow(line)
	char *line;
{
	char *s;
	int i,j;

	if (strlen(line) < 8)
		SYNTAXERR;
	else {
		NEXTWORD(line,s);
		NULLEND(s);
		if (!showcount)
			DDisplayErr(DE_NOSET);
		else if (STRCASEEQ(s,S_ALL)) {
			showcount = 0;
			printf("220 No fields will be shown.\n");
		} else if((j=GetFieldIndex(s)) < 0)
			DDisplayErr(DE_INVFIELD);
		else {
			for (i=0; i<showcount; i++)
				if (shows[i] == j) {
					showcount--;
					printf("220 Field will not be shown.\n");
					if (showcount-i > 0)
						bcopy(&shows[i+1],&shows[i],(showcount-i)*sizeof(int));
					return;
				}
			DDisplayErr(DE_NOTSET);
		}
	}
}

static listkeys() {
	int i;

	for (i = 0; i<nkeys; i++)
		printf("300-%s\n", keys[i]->str);
	printf("220 End of keys list.\n"); 
}

static list() {
	int i;

	for (i = 0; i<nfields; i++)
		printf("300-%s\n", fields[i]->str);
	printf("220 End of fields list.\n"); 
}

static human() {
	if (humanflag) {
		humanflag=0;
		printf("220 Default format for output.\n");
	} else {
		humanflag=1;
		prettyflag=0;
		printf("220 Human readable format for output.\n");
	}
}

static pretty() {
	if (prettyflag) {
		prettyflag = 0;
		printf("220 Default format for output.\n");
	} else {
		prettyflag=1;
		humanflag=0;
		printf("220 Pretty format for output.\n");
	}
}

/*****************************************************************************/
/* match() routines and defines                                              */
/*****************************************************************************/
#define WILDCARDS(cp) \
	wildcards = 0; \
	while (*cp && !wildcards) { \
		switch (*cp) { \
			case '\\': \
				cp++; \
				break; \
			case ' ': case '*': case '[': \
			case '?': case '(':	case '{': /* } */ \
				wildcards = 1; \
				break; \
			default: \
				break; \
		} \
		if (*cp != '\0') cp++; \
	}

#define STORE(str) \
	bcp = cp = str; \
	while (*cp++); len = cp - bcp + 1; \
	if (freeptr + len >= endfree) { \
		if (curblk->next) \
			curblk = curblk->next; \
		else { \
			curblk->next = (blks_t *) malloc(sizeof(blks_t)); \
			if (curblk->next == (blks_t *)NULL) \
				FatalError("out of memory."); \
			curblk = curblk->next; \
			curblk->next = (blks_t *)NULL; \
			curblk->b = (char *) malloc(BLKSIZ); \
			if (curblk->b == (char *)NULL) \
				FatalError("out of memory."); \
		} \
		freeptr = curblk->b; \
		endfree = freeptr + BLKSIZ; \
	} \
	cp = *cpp++ = (char *) freeptr; \
	freeptr += len; \
	while (*bcp) *cp++ = *bcp++; *cp = '\0';

#define STOREREC() if (count < nrecs) \
	for (i=0; i<showcount; i++) { \
		STORE(fields[shows[i]]->newdata) \
	}

#define STOREKEY() \
	if (count < nrecs) { \
		STORE(keystr) \
	} else { \
		newnrecs = nrecs << 1; \
		recs = (char ***) realloc((char *)recs,sizeof(char **)*newnrecs); \
		if (recs == (char ***)NULL) \
			FatalError("out of memory."); \
		recarrays = (char **) realloc((char *)recarrays,recarraysize*newnrecs);\
		if (recarrays == (char **)NULL) \
			FatalError("out of memory."); \
		cpp = recarrays + nrecs; \
		cppp = recs + nrecs; \
		for (i=0; i<nrecs; i++) \
			*cppp++ = cpp++; \
		cpp = recarrays + nrecs; \
		nrecs = newnrecs; \
		STORE(keystr) \
	}

/*
 * used with qsort function to sort records.
 */
static compar(e1,e2)
	char ***e1, ***e2;
{
	static int i,k,len1,len2;
	static char *cp1,*cp2,*bcp1,*bcp2,del;

	for (i=0; i<sortcount; i++) {
		del = sorts[i].del;
		if (sorts[i].num) {
			cp1 = (*e1)[k=sorts[i].si];
			cp2 = (*e2)[k];
			do {
				if (del) {
					while (isspace(*cp1) || *cp1 == del) cp1++;
					while (isspace(*cp2) || *cp2 == del) cp2++;
				} else {
					while (isspace(*cp1)) cp1++;
					while (isspace(*cp2)) cp2++;
				}
				while (*cp1 == '0') cp1++; if (isspace(*cp1)) cp1--;
				while (*cp2 == '0') cp2++; if (isspace(*cp2)) cp2--;
				while (*cp1 == '.' && *cp2 == '.') {
					cp1++;
					cp2++;
				}
				bcp1 = cp1; bcp2 = cp2;
				while (*cp1 != del && *cp1 && !isspace(*cp1) && *cp1 != '.') cp1++;
				while (*cp2 != del && *cp2 && !isspace(*cp2) && *cp2 != '.') cp2++;
				len1 = cp1-bcp1; len2 = cp2-bcp2;
				if (len1 == len2) {
					while (TOLOWER(*bcp1) == TOLOWER(*bcp2) && bcp1 < cp1) {
						bcp1++;
						bcp2++;
					}
					if (bcp2 == cp2) {
						while (*cp1 == '.' && *cp2 == '.') {
							cp1++;
							cp2++;
						}
					} else
						return(TOLOWER(*bcp1)-TOLOWER(*bcp2));
				} else
					return(len1-len2);
			} while (*cp1 && *cp2);
			return(0);
		} else {
			cp1 = (*e1)[k=sorts[i].si];
			cp2 = (*e2)[k];
			while (*cp1 && *cp2 && TOLOWER(*cp1) == TOLOWER(*cp2)) {
				*cp1++;
				*cp2++;
			}
			if (*cp1 || *cp2) {
				if (*cp1 == del) {
					return(-1);
				} else if (*cp2 == del) {
					return(1);
				} else {
					return(TOLOWER(*cp1)-TOLOWER(*cp2));
				}
			}
		}
	}
	return(0);
}

/*
 * used with qsort function to sort keys.
 */
static keycompar(e1,e2)
	char ***e1, ***e2;
{
	static int len1,len2;
	static char *cp1,*cp2,*bcp1,*bcp2;

	if (sortkeynum) {
		cp1 = (*e1)[0];
		cp2 = (*e2)[0];
		do {
			if (sortkeydel) {
				while (isspace(*cp1) || *cp1 == sortkeydel) cp1++;
				while (isspace(*cp2) || *cp2 == sortkeydel) cp2++;
			} else {
				while (isspace(*cp1)) cp1++;
				while (isspace(*cp2)) cp2++;
			}
			while (*cp1 == '0') cp1++; if (isspace(*cp1)) cp1--;
			while (*cp2 == '0') cp2++; if (isspace(*cp2)) cp2--;
			while (*cp1 == '.' && *cp2 == '.') {
				cp1++;
				cp2++;
			}
			bcp1 = cp1; bcp2 = cp2;
			while (*cp1 != sortkeydel && *cp1 && !isspace(*cp1) && *cp1 != '.') cp1++;
			while (*cp2 != sortkeydel && *cp2 && !isspace(*cp2) && *cp2 != '.') cp2++;
			len1 = cp1-bcp1; len2 = cp2-bcp2;
			if (len1 == len2) {
				while (TOLOWER(*bcp1) == TOLOWER(*bcp2) && bcp1 < cp1) {
					bcp1++;
					bcp2++;
				}
				if (bcp2 == cp2) {
					while (*cp1 == '.' && *cp2 == '.') {
						cp1++;
						cp2++;
					}
				} else
					return(TOLOWER(*bcp1)-TOLOWER(*bcp2));
			} else
				return(len1-len2);
		} while (*cp1 && *cp2);
		return(0);
	} else {
		cp1 = (*e1)[0];
		cp2 = (*e2)[0];
		while (*cp1 && *cp2 && TOLOWER(*cp1) == TOLOWER(*cp2)) {
			*cp1++;
			*cp2++;
		}
		if (*cp1 || *cp2) {
			if (*cp1 == sortkeydel)
				return(-1);
			else if (*cp2 == sortkeydel)
				return(1);
			else
				return(TOLOWER(*cp1)-TOLOWER(*cp2));
		}
	}
	return(0);
}

static outputdata() {
	int i, count;
	scrfield_t *fptr;

	if (prettyflag) {
		/*
		 * get labels from screen config file.  if a field does not
		 * have a corresponding pointer for screen input, then the
		 * field will not be output (sfp[i] set to NULL).
		 */
		for (i=0; i<showcount; i++) {
			sfp[i] = (scrfield_t *)NULL;
			fptr = firstscrfield;
			do {
				if (fptr->index == shows[i])
					sfp[i] = fptr;
				fptr = fptr->next;
			} while (fptr != firstscrfield);
		}
		for (i=0; i<showcount; i++) {
			if (!(fptr=sfp[i]))
				continue;
			if (*fields[shows[i]]->newdata=='\0')
				printf("300-%-20s ?\n",fptr->label);
			else
				printf("300-%-20s %s\n",fptr->label,fields[shows[i]]->newdata);
		}
		return;
	}
	if (!humanflag) printf("300-");
	count = 0;
	for (i=0; i<showcount; i++) {
		if (humanflag) {
			if (!*fields[shows[i]]->newdata)
				printf("300-%-20s ?\n",fields[shows[i]]->str);
			else
				printf("300-%-20s %s\n",fields[shows[i]]->str,fields[shows[i]]->newdata);
		} else {
			if (count++)
				putchar('\t');
			if (!*fields[shows[i]]->newdata)
				putchar('?');
			else
				printf("%s",fields[shows[i]]->newdata);
		}
	}
	if (!humanflag) printf("\n");
}

static match() {
	datum key;
	int count = 0, fcount, i, j, ismatch, len;
	char *cp, *bcp, **cpp, ***cppp, *keystr;
	int wildcards;
	int retval, fieldstorecount;
	long offset;
	scrfield_t *fptr;

	alarm(0); /* in case search takes longer than timeout period */

	if (!setcount && !setkeycount) {
		DDisplayErr(DE_NOSET);
		return;
	}

	if (sortcount) {
		fieldstorecount = showcount;
		for (i=0; i<sortcount; i++) {
			sorts[i].si = -1;
			for (j=0; j<fieldstorecount; j++)
				if (shows[j] == sorts[i].fi) {
					sorts[i].si = j;
				}
			if (sorts[i].si == -1) {
				sorts[i].si = fieldstorecount;
				shows[fieldstorecount++] = sorts[i].fi;
			}
		}
	}
	if (sortcount || (sortkeyflag && setkeycount == 1)) {
		if (sortkeyflag && setkeycount == 1)
			fieldstorecount = 1;
		currec = 0;
		recarraysize = sizeof(char *) * fieldstorecount;
		curblk = firstblk;
		freeptr = curblk->b;
		endfree = freeptr + BLKSIZ;
		if (recs)
			free(recs);
		if ((nrecs=NumberOfRecs()) < 0)
			FatalError(errmsg);
		/*
		 * assume that there are more keys than records
		 * in an attempt to reduce number of realloc's
		 */
		if (sortkeyflag && setkeycount == 1)
			nrecs *= 4;
		recs = (char ***) malloc(sizeof(char **)*nrecs);
		if (recs == (char ***)NULL)
			FatalError("out of memory.");
		recs[0] = (char **)NULL;
		if (recarrays)
			free(recarrays);
		cpp = recarrays = (char **) malloc(recarraysize*nrecs);
		if (recarrays == (char **)NULL)
			FatalError("out of memory.");
		cppp = recs;
		for (i=0; i<nrecs; i++) {
			*cppp++ = cpp;
			cpp += fieldstorecount;
		}
		cpp = recarrays;
	}

	if (setcount == 1 && fields[sets[0].i]->keyindex >= 0) {
		cp = sets[0].exp;
		WILDCARDS(cp)
	}
	if (setkeycount == 1 && setcount == 0) {
		cp = setkeys[0].exp;
		WILDCARDS(cp)
		if (wildcards) {
			if ((offset=FirstKey(setkeys[0].i,&keystr)) == -1)
				FatalError(errmsg);
			else if (offset >= 0)
				while (1) {
					if (StrEqExp(keystr,setkeys[0].exp)) {
						if (sortkeyflag) {
							STOREKEY()
						} else if (showkeyflag)
							printf("300-%s\n",keystr);
						else {
							ReadDataByOffset(offset);
							if (showcount) {
								if (sortcount) {
									STOREREC()
								} else
									outputdata();
							}
						}
						count++;
					}
					if ((offset=NextKey(&keystr)) == -1)
						FatalError(errmsg);
					else if (offset == -2)
						break;
				}
		} else {
			if ((offset=FindKey(setkeys[0].i,setkeys[0].exp,&keystr)) == -1)
				FatalError(errmsg);
			if (offset >= 0) {
				count++;
				if (showkeyflag)
					printf("300-%s\n",keystr);
				else {
					ReadDataByOffset(offset);
					if (showcount) outputdata();
				}
			}
		}
	} else if (setcount == 1 && fields[sets[0].i]->keyindex >= 0 && !wildcards) {
		if ((offset=FindKey(fields[sets[0].i]->keyindex,sets[0].exp,&keystr)) == -1)
			FatalError(errmsg);
		if (offset >= 0) {
			ReadDataByOffset(offset);
			if (STRCASEEQ(fields[sets[0].i]->newdata,keystr)) {
				count++;
				if (showcount)
					outputdata();
			}
		}
	} else {
		if (OpenData(0) < 0)
			FatalError(errmsg);
		while (1) {
			if (ReadNextRec() < 0)
				FatalError(errmsg);
			if (!*fields[i_pkey]->newdata)
				break;
			ismatch=1;
			for (i=0; i<setcount; i++) {
				if (StrEqExp(fields[sets[i].i]->newdata,sets[i].exp,0))
					ismatch=1;
				else {
					ismatch=0;
					break;
				}
			}
			if (ismatch) for (i=0; i<setkeycount; i++) {
				ismatch=0;
				for (j=0; j<nfields; j++) {
					if (fields[j]->keyindex == setkeys[i].i) {
						strcpy(tmpfieldspace,fields[j]->newdata);
						cp = tmpfieldspace;
						while (*cp == ' ') cp++;
						while (*cp) {
							bcp = cp;
							while (*cp && *cp != ' ') cp++;
							if (*cp) *cp++ = '\0';
							if (StrEqExp(bcp,setkeys[i].exp,0)) {
								ismatch=1;
								break;
							}
							while (isspace(*cp)) cp++;
						}
						if (ismatch) break;
					}
				}
			}
			if (ismatch) {
				if (showcount) {
					if (sortcount) {
						STOREREC()
					} else
						outputdata();
				}
				count++;
			}
		}	
		CloseData();
	}

	if (sortkeyflag && setkeycount == 1 && count > 1) {
		if (count > nrecs)
			count = nrecs;
		qsort((char *)(&recs[0]),count,sizeof(char **),keycompar);
		for (i=0,cppp=recs; i<count; i++,cppp++)
			printf("300-%s\n",**cppp);
	} else if (showcount && sortcount) {
		if (count > nrecs)
			count = nrecs;
		qsort((char *)(&recs[0]),count,sizeof(char **),compar);
		if (prettyflag) {
			/*
			 * get labels from screen config file.  if a field does not
			 * have a corresponding pointer for screen input, then the
			 * field will not be output (sfp[i] set to NULL).
			 */
			for (i=0; i<showcount; i++) {
				sfp[i] = (scrfield_t *)NULL;
				fptr = firstscrfield;
				do {
					if (fptr->index == shows[i])
						sfp[i] = fptr;
					fptr = fptr->next;
				} while (fptr != firstscrfield);
			}
			for (i=0,cppp=recs; i<count; i++,cppp++) {
				for (j=0,cpp = *cppp; j<showcount; j++,cpp++) {
					cp = *cpp;
					if (!(fptr=sfp[j]))
						continue;
					if (cp && *cp)
						printf("300-%-20s %s\n",fptr->label,cp);
					else
						printf("300-%-20s ?\n",fptr->label);
				}
			}
		} else {
			for (i=0,cppp=recs; i<count; i++,cppp++) {
				fcount = 0;
				if (!humanflag) printf("300-");
				for (j=0,cpp = *cppp; j<showcount; j++,cpp++) {
					cp = *cpp;
					if (humanflag) {
						if (cp && *cp)
							printf("300-%-20s %s\n",fields[shows[j]]->str,cp);
						else
							printf("300-%-20s ?\n",fields[shows[j]]->str);
					} else {
						if (fcount++)
							putchar('\t');
						if (cp && *cp)
							printf("%s",cp);
						else
							putchar('?');
					}
				}
				if (!humanflag) printf("\n");
			}
		}
	}

	printf("220 End of MATCH. ");

	if (count==1)
		printf("1 match.");
	else
		printf("%d matches.", count);
	if (!showcount)
		printf(" use SHOW or SHOWKEY to output data.\n");
	else
		printf("\n");
	return;
}

/*****************************************************************************/
/* REMOTE routines                                                           */
/* these are routines for the partially-implemented remote interactive       */
/* interface.                                                                */
/*****************************************************************************/

#ifdef REMOTE
/*
 * user <USERNAME>
 */
static user(line)
	char *line;
{
	FILE *fp;
	char *cp;
	int linecount, i;

	cp = line+4;
	while (isspace(*cp)) cp++;

	if (strlen(line) < 5 || !*cp)
		SYNTAXERR;

	if (InvokerAcct[0])
		FatalError("username already set.");

	for (curruser=firstruser; curruser; curruser=curruser->next)
		if (STRCASEEQ(cp,curruser->username)) break;
	if (!curruser) {
		sprintf(errmsg,"(%s) username not valid for your host.",cp);
		FatalError(errmsg);
	}
	if (strlen(cp) > IACCTLEN)
		FatalError("username too long.");
	strcpy(InvokerAcct,cp);
	if (InitValidation() < 0)
		FatalError(errmsg);
	printf("220 hello %s.\n",InvokerAcct);
	return;
}

static access(line)
	char *line;
{
	FILE *fp;
	char *cp;
	int linecount, i;

	if (!InvokerAcct[0]) {
		DDisplayErr(DE_USERNAME);
		return;
	}

	for (i=0; i<naccess; i++)
		printf("300-%s\n",accesschoices[i]);
	printf("220 end of access choices.\n");
	return;
}

static valid(line)
	char *line;
{
	FILE *fp;
	char *cp;
	int linecount, i;

	if (!InvokerAcct[0]) {
		DDisplayErr(DE_USERNAME);
		return;
	}

	for (i=0; i<nvalid; i++)
		printf("300-%s\n",validchoices[i]);
	printf("220 end of valid choices.\n");
	return;
}

/*
 * cat S_SCREENFILE,S_DBFIELDSFILE,S_DBKEYSFILE,S_FIELDSHF,S_SCREENHF,S_MOTDFILE
 */
static cat(line)
	char *line;
{
	FILE *fp;
	char *cp, *filename;
	int linecount;

	cp = line+3;
	while (isspace(*cp)) cp++;

	if (strlen(line) < 5 || !*cp)
		SYNTAXERR;

	if (STREQ(cp,S_SCREENFILE))
		filename = DotSConfFile;
	else if (STREQ(cp,S_DBFIELDSFILE))
		filename = DotDBFieldsFile;
	else if (STREQ(cp,S_DBKEYSFILE))
		filename = DotDBKeysFile;
	else if (STREQ(cp,S_FIELDSHF))
		filename = FieldsHelpFile;
	else if (STREQ(cp,S_SCREENHF))
		filename = ScreenHelpFile;
	else if (STREQ(cp,S_MOTDFILE))
		filename = MotdFile;
	else {
		DDisplayErr(DE_INVFILE);
		return;
	}

	if ((fp = fopen(filename, "r")) == NULL) {
		DDisplayErr(DE_OPENFILE);
		return;
	}

	linecount = 0;
	while (fgets(linein, LINEMAX, fp) != NULL) {
		linecount++;
		printf("300-%s",linein); /* newline is already in there */
	}
	fclose(fp);
	
	printf("220 End of file.  %d lines.\n",linecount);
	return;
}
#endif
