#ifndef lint
static char rcsid[] = "$Header: $";
#endif

/*
 * $Log:$
 */

/*
 * dumphost - obtain information via splathostdb from host database
 *
 * Usage: dumphost [-v] [configfile [outputfile]]
 * Examples:
 *        dumphost -v configfile outputfile
 *        dumphost < configfile > outputfile
 *        dumphost configfile > outputfile
 *
 * exit status is 1 if an error occurred, 0 otherwise.
 *
 * If the person calls dumphost, and is typing directly at the addhostd
 * port, then isatty(0) returns true, and we print everything exactly
 * as addhostd outputs it.  If we're not dealing with a tty then we only
 * print data and error messages from addhostd (messages starting with
 * 3 and 5 respectively).
 *
 */

#define MAIN
#include "dumphost.h"
#include <sys/types.h>
#include <utmp.h>
#include <pwd.h>
#include <strings.h>

struct utmp utmp; /* just so the sizeof function works */
#define IACCTLEN    sizeof(utmp.ut_name)
#define INAMELEN    40

extern int errno;
char InvokerAcct[IACCTLEN+1];   /* invoker's account name */
char InvokerName[INAMELEN+1];   /* invoker's full name */
uid_t InvokerUid;
char *ProgName;

main(argc,argv)
	int argc;
	char **argv;
{
	char buf1[BUFSIZ];
	char buf2[BUFSIZ];
	FILE *inputfile, *outputfile;
	int verbose=0, saveisatty;
	int i,fatalerror=0;
	int pid;
	
	saveisatty = isatty(0);

	ProgName = (ProgName = rindex(argv[0],'/')) ? ++ProgName : *argv;

	if (setinvoker((uid_t) getuid()) < 0) {
		(void) fprintf(stderr, "%s: Your login does not exist.\n", ProgName);
		exit(1);
	}

	if (argc > 1) {
		if (strncmp(argv[1],"-h",2) == 0) {
			hostdbserver = argv[1]+2;
			/* remove -h from args */
			for (i=2; i<argc; i++)
				argv[i-1] = argv[i];
			argc--;
		}
	}

	if (argc > 1) {
		if (strncmp(argv[1],"-p",2) == 0) {
			port = argv[1]+2;
			/* remove -p from args */
			for (i=2; i<argc; i++)
				argv[i-1] = argv[i];
			argc--;
		}
	}

	if (argc > 1) {
		if (strcmp(argv[1],"-v") == 0) {
			verbose = 1;
			/* remove -v from args */
			for (i=2; i<argc; i++)
				argv[i-1] = argv[i];
			argc--;
		}
	}

	if ((argc < 1) || (argc > 3)) {
		fprintf(stderr,"Usage: %s [-hHOST] [-pPORT] [-v] [inputfile [outputfile]]\n", argv[0]);
		exit(1);
	}

	/* set inputfile to argv[1] or stdin */
	if ((argc==2) || (argc==3)) {
		if ((inputfile=fopen(argv[1],"r")) == NULL) {
			perror(*argv);
			exit(1);
		}
		saveisatty = 0;
	} else if (argc == 1) {
		if ((inputfile=fdopen(dup(0),"r")) == NULL) {
			perror(*argv);
			exit(1);
		}
	}

	/* set outputfile to argv[2] or stdout */
	if (argc==3) {
		if ((outputfile=fopen(argv[2],"w")) == NULL) {
			perror(*argv);
			exit(1);
		}
	} else if ((argc == 1) || (argc == 2)) {
		if ((outputfile=fdopen(dup(1),"w")) == NULL) {
			perror(*argv);
			exit(1);
		}
	}

	if (OpenSock(hostdbserver, port) < 0) 
		exit(1);	

	/* get initial greeting line or lines */
	while (1) {
		if ((fgets(buf2,sizeof(buf2),InSockP))==NULL) {
			perror(*argv);
			exit(1);
		}
		if (buf2[0] == '5')
			fatalerror = atoi(buf2+1);
		if (verbose || saveisatty || buf2[0] == '5') {
			fputs(buf2,outputfile);
			fflush(outputfile);
		}
		if (buf2[3] == ' ') break;
	}

	if (buf2[2] == '1')
		exit(fatalerror);
	else while ((fgets(buf1,sizeof(buf1),inputfile)) != NULL) {
		fputs(buf1,OutSockP);
		fflush(OutSockP);

		while ((fgets(buf2,sizeof(buf2),InSockP)) != NULL) {
			if (verbose || saveisatty) {
				fputs(buf2,outputfile);
				fflush(outputfile);
			} else {
				/* output pertinent data only */
				if (buf2[0]=='3') fputs(buf2+4,outputfile);
				if (buf2[0]=='4' || buf2[0] == '5') {
					fputs(buf2,outputfile);
					fflush(outputfile);
					i = atoi(buf2+1);
					if (i == 0)
						exit(1);
					else
						exit(i);
				}
			}
			if (buf2[3] == ' ') break;
		}
		if (buf2==NULL) {
			perror(*argv);
			exit(1);
		}
		if (buf2[2]=='1') break;
	}

	fflush(outputfile); /* need this if saveisatty is false */
	exit(0);
}

/*
 * given a `uid', get the password entry and fill in associated `Invoker*'
 * fields.  return value is 0 if all went well, -1 if getpwuid() failed.
 */
static int setinvoker(uid)
	uid_t uid;
{
	struct passwd *pp;
	register char *cp;
	register int i;

	InvokerUid = uid;

	if ((pp=getpwuid((int) InvokerUid)) == NULL) {
		return(-1);
	}

	(void) strncpy(InvokerAcct, pp->pw_name, IACCTLEN);	/* acct name */

	/*
	 *  Go thru first field in GECOS assigning it to InvokerName[].
	 *  This is complicated by the BSD `&' hack; an ampersand in the
	 *  name field is supposed to be expanded to the account name.
	 */
	for (i = 0, cp = pp->pw_gecos; i < INAMELEN && *cp != ',' && *cp; cp++) {
	if (*cp == '&') {	/* Argh! */
		(void) strncpy(&InvokerName[i], InvokerAcct, INAMELEN-i);
		if (islower(InvokerName[i]))
		InvokerName[i] = toupper(InvokerName[i]);
		i += strlen(InvokerAcct);		/* `i' may be > INAMELEN */
	} else
		InvokerName[i++] = *cp;
	}

	InvokerAcct[IACCTLEN] = 
	InvokerName[MIN(i,INAMELEN)] = '\0';

	return(0);
}
