#ifndef lint
static char rcsid[] = "$Header: $";
#endif

/*
 * $Log:$
 */

#include "dumphost.h"

/*
 * 
 * OpenSock(hostname,port) - open connection to TCP/IP stream socket
 *
 */
OpenSock(hostname,port)
	char *hostname, *port;
{
	register struct servent *sp;
	register struct hostent *hp;
	extern struct hostent *gethostbyaddr();
	extern struct servent *getservbyname();
	extern FILE *fdopen();
	int Timeout();

	if (connected) 
		return(0);
	
	alarm(SIGALRM,Timeout);	/* in case connect blocks */
	TimeoutPeriod = 10; 	/* seconds */

	alarm(TimeoutPeriod);
	if (setjmp(TimeoutBuf)) {
		fprintf(stderr,"Timeout during connect to daemon\n");
		return(-1);
	}

	/*
	 * if port is a name, look up port number, etc
	 * otherwise, use port number given..
	 */
	if (isalpha(*port))
		sp = getservbyname(port, "tcp");
	else 
	{
		int i;
		struct servent srvnt;
		sp = &srvnt;

		if (sscanf(port,"%d",&i) != 1)
			sp = 0;

		sp->s_name = "";
		sp->s_aliases = NULL;
		sp->s_proto = "tcp";
		sp->s_port = htons(i);

	}


	if (sp == 0) {
		perror("open(): bad port");
		return(-1);
	}

	hp = gethostbyname(hostname);
	if (hp == 0){
		perror("open(): gethostbyname():");
		return(-1);
	}

	Socket = socket(AF_INET, SOCK_STREAM, 0);
	if (Socket < 0) {
		perror("socket()");
		return(-1);
	}

	/* bind to reserved port on this side */	
	if (GetPort(Socket) < 0)
		exit(1);

	/* proceed with connection */
	bcopy(hp->h_addr, &inetaddr.sin_addr, hp->h_length);
	inetaddr.sin_family  = AF_INET;
	inetaddr.sin_port    = sp->s_port;
	
	if (connect(Socket, &inetaddr, sizeof(inetaddr)) < 0) {
		perror("connect()");
		return(-1);
	}
		
	/* associate FILE *'s with socket */
	connected = 1;
	InSockP   = fdopen(Socket,"r");
	OutSockP  = fdopen(dup(Socket),"w");

	alarm(0);

	return(0);
}

/*
 * break down connection.
 */
CloseSock() {
	fflush(OutSockP);
	fclose(InSockP);
	fclose(OutSockP);
	close(Socket);
	connected = 0;
	alarm(0);
	TimeoutPeriod = 10;
	return(0);
}

/*
 * control xfers to here when an alarm signal is received
 * as a result of a system call that never came back..
 */
Timeout() {
	longjmp(TimeoutBuf,1);
}

/*
 * GetPort - binds socket to unused ip port in non-reserved range
 */
GetPort(s)
	int  s;
{
	struct sockaddr_in sin;
	int myport;

	sin.sin_family          = AF_INET;
	sin.sin_addr.s_addr     = INADDR_ANY;

	myport = IPPORT_RESERVED;

	/*
	 * Go thru reserved ports (starting at IPPORT_USERRESERVED - 1)
	 * and find one we can bind to; stop when bind() succeeds, or
	 * we have run out of ports (IPPORT_USERRESERVED-1 is last one).
	 */
	while (1) {
		if (--myport == 0) {
		(void) close(s);
			s = -1;
			fprintf(stderr,"out of ports");
			return(-1);
		}

		sin.sin_port = htons(myport);

		if (bind(s, (struct sockaddr *)&sin, sizeof(sin)) >= 0)
			break;

		if (errno != EADDRINUSE) {
			(void) close(s);
			s = -1;
			perror("bind");
			return(-1);
		}
	}

	return(0);
}
