#ifndef lint
static char rcsid[] = "$Header: $";
#endif

/*
 * $Log:$
 */

#include "common.h"
#include "errors.h"
#if SYSLOG
#include <syslog.h>
#endif

static char locerrmsg[MSGSIZ];

/*
 * Check to see that we aren't missing any important data as defined by
 * the "props" var in the scrfield_t structure.  A return of 0 means all is
 * well, otherwise, the number of errors detected is returned.
 */
MissingData() {
	int i,errcnt=0;
	scrfield_t *fptr;

	fptr = firstscrfield;
	do {
		if ((fields[fptr->index]->props & M_PROP) &&
				*fields[fptr->index]->data == '\0') {
			sprintf(errmsg,"Wait! no %s.",fields[fptr->index]->str);
			DispMsg(fptr->y_error,
			        fptr->x_error, STANDOUT,
					errmsg);
			errcnt++;
		}
		fptr = fptr->next;
	} while (fptr != firstscrfield);

	return(errcnt);
}

/*
 * this routine is used by the interactive interface to output the error
 * contained in str, run CleanUp(), then exit.  this is different than
 * the routine in the daemon process.
 */
FatalError(str)
	char *str;
{
	WINDOW *pwin;			/* cache current screen */

	sprintf(locerrmsg,"FATAL ERROR: %s\n",str);
	if (X_Doing == X_DAEMON) {
#if SYSLOG
		syslog(LOG_ERR, locerrmsg);
#endif
#if LOGTOFILE
		LogToFile(locerrmsg);
#endif
		printf("550-%s",locerrmsg);
	} else if (X_Doing == X_BAD || X_Doing == X_BRM) {
		printf("550-%s",locerrmsg);
	} else if (screenon) {
		pwin = curscreen->win;
		(void) putc('\007', stdout);
		wstandout(pwin);
		locerrmsg[strlen(locerrmsg)-1] = '\0'; /* nuke newline */
		GetAnyKey(locerrmsg);
		wstandend(pwin);
		ResetScreen();
	} else {
		fprintf(stderr,"%s",locerrmsg);
		fflush(stderr);
	}

	CleanUp();
	exit(1);
}

/*
 * this displays the error (associated with errorno) to stderr, along with
 * the program name (in ProgName) and line number (given in lineno).
 */
DisplayErr(lineno,errorno)
	int lineno;
	int errorno;
{
	char *cp;

	if (X_Doing == X_DAEMON)
		return;
	(void) fprintf(stderr, "%s: error, line #%d [", ProgName, lineno);

	switch(errorno) {
		case PE_SUBFLD:
			(void) fprintf(stderr, "missing comma in sub-field");
			break;
		case PE_EOL:
			(void) fprintf(stderr, "premature end of line");
			break;
		case PE_DIGIT:
			(void) fprintf(stderr, "expected a digit");
			break;
		case PE_PAREN:
			(void) fprintf(stderr, "expected left paren");
			break;
		case PE_NOTYPE:
			(void) fprintf(stderr, "unknown type field");
			break;
		case PE_RESERV:
			(void) fprintf(stderr, "X co-ord out of range");
			break;
		case PE_EMPTY:
			(void) fprintf(stderr, "screen with no entry fields found");
			break;
		case PE_QUOTE:
			(void) fprintf(stderr, "expected quote");
			break;
		case PE_PROP:
			(void) fprintf(stderr, "unknown property found");
			break;
		case PE_DUP:
			(void) fprintf(stderr, "duplicate field name found");
			break;
		case PE_PKEYDUP:
			(void) fprintf(stderr, "duplicate primary key found");
			break;
		case PE_PRIMARY:
			(void) fprintf(stderr, "key field expected after \"%s=\"",S_PRIMARY);
			break;
		case PE_KEYDUP:
			(void) fprintf(stderr, "duplicate key name found");
			break;
		case PE_LONGEXP:
			(void) fprintf(stderr, "choice expression too long for field length");
			break;
		case PE_BADEXP:
			(void) fprintf(stderr, "invalid choice expression");
			break;
		case PE_BADKEY:
			(void) fprintf(stderr, "key not found in %s",DBKeysFile);
			break;
		default:
			(void) fprintf(stderr, "unknown error");
			break;
	}
	(void) fprintf(stderr, "]\n");
}

SetSysErr() {
	if (errno >= 0 && errno <= sys_nerr)
		sprintf(syserr,"%s",sys_errlist[errno]);
	else
		strcpy(syserr,"unknown error");
}

/*
 * this displays the error (associated with errorno) to stdout for the
 * daemon process.
 */
DDisplayErr(errorno)
	int errorno;
{
	char *str;

	switch(errorno) {
		case DE_SYNTAX:
			str = "405 syntax error";
			break;
		case DE_HELPFILE:
			str = "406 could not open help file";
			break;
		case DE_HELPTOPIC:
			str = "407 unknown help topic";
			break;
		case DE_INVKEY:
			str = "408 invalid key name";
			break;
		case DE_INVFIELD:
			str = "409 invalid field name";
			break;
		case DE_NOSET:
			str = "410 no values set";
			break;
		case DE_NOTSET:
			str = "411 that was not set";
			break;
#ifdef REMOTE
		case DE_USERNAME:
			str = "must set username first";
			break;
		case DE_INVFILE:
			str = "unknown file";
			break;
		case DE_OPENFILE:
			str = "could not open file";
			break;
#endif
		default:
			str = "440 unknown error";
			break;
	}
	(void) printf("%s\n",str);
}

/*
 * this displays the error (associated with errorno) to stdout for the
 * batch process.
 */
BDisplayErr(errorno,lineno,instr1,instr2,instr3)
	int errorno, lineno;
	char *instr1, *instr2, *instr3;
{
	char *str;

	switch(errorno) {
		case BE_RPERM:
			str = "405 line %d, %s, permission denied to modify this record";
			break;
		case BE_FPERM:
			str = "406 line %d, %s, permission denied to modify this field";
			break;
		case BE_RLOCK:
			str = "407 line %d, %s, record locked";
			break;
		case BE_FUNKN:
			str = "408 line %d, %s, unknown field";
			break;
		case BE_FALONE:
			str = "409 line %d, %s, can only be used alone";
			break;
		case BE_FDUP:
			str = "410 line %d, %s, duplicate field";
			break;
		case BE_FFEW:
			str = "411 line %d, %s, too few fields";
			break;
		case BE_FMANY:
			str = "412 line %d, %s, too many input fields";
			break;
		case BE_KLONG:
			str = "413 line %d, %s, field %s, key too long in field";
			break;
		case BE_FLONG:
			str = "414 line %d, %s, %s field too long";
			break;
		case BE_BAD:
			str = "415 line %d, %s, %s field has bad input";
			break;
		case BE_INVCHAR:
			str = "416 line %d, %s, %s, `%s' invalid character";
			break;
		case BE_FEMPTY:
			str = "417 line %d, %s, %s field must have data";
			break;
		case BE_KUSED:
			str = "418 line %d, %s, %s key already used (with %s)";
			break;
		case BE_KDUP:
			str = "419 line %d, %s, %s, key used multiple times in this record";
			break;
		case BE_EXIST:
			str = "420 line %d, %s, does not exist";
			break;
		default:
			str = "440 unknown error";
			break;
	}
	(void) printf(str,lineno,instr1,instr2,instr3);
	(void) printf("\n");
}
