#ifndef lint
static char rcsid[] = "$Header: $";
#endif

/*
 * $Log:$
 */

/*
 * StrEqExp() compares str with the regular expression contained in pattern.
 * the comparison is case insensitive. it returns non-zero if str matches
 * pattern, otherwise, it returns 0. StrEqExp() does not flatly check if the
 * string matches the regular expression if spaceflag is set.  spaces then
 * act as delimeters.  so if the 'pattern' is matched, and a space then
 * occurs in 'str', then the next thing in 'str' will be checked against
 * 'pattern' as well.  the return value is non-zero if str matches
 * pattern, so the number of matches found is in fact the number
 * returned.  if there is even one mismatch though, 0 is still returned.
 * example:
 * 	Let the expression for internet address be
 * 		"(0-255).(0-255).(0-255).(0-255)"
 * 	This allows 'str' to be things like
 * 		"128.138.240.1",
 *		"128.138.240.1 128.138.238.18" or
 *		"128.138.240.1 128.138.238.18 128.138.242.15" etc...
 *  the return value is 1, 2, and 3 respectively for the above three 'str'.
 *
 *	wild:
 *   *           match 0 or more occurances of anything
 *   [abc]       match anyof "abc" (ranges supported)
 *   {a,ab,abc}  match longest of "a", "ab", or "abc"
 *   ?           match any single character
 *   (0-9)       match number in numeric decimal range
 *   (x0-f)      match number in numeric hex range
 *   (o0-7)      match number in numeric octal range
 *
 */

#include "common.h"
#include <ctype.h>

/* This gives us case insensitivity */
#define CHAR_LESS(c1,c2)   ( TOLOWER(c1) < TOLOWER(c2) )
#define CHAR_GTR(c1,c2)    ( TOLOWER(c1) > TOLOWER(c2) )
#define CHAR_LESSEQ(c1,c2) ( TOLOWER(c1) <= TOLOWER(c2) )
#define CHAR_GTREQ(c1,c2)  ( TOLOWER(c1) >= TOLOWER(c2) )
#define CHAR_EQ(c1,c2)     ( TOLOWER(c1) ==	TOLOWER(c2) )
#define CHAR_NEQ(c1,c2)    ( TOLOWER(c1) != TOLOWER(c2) )

StrEqExp(str,pattern,spaceflag)
	char *str,*pattern;
	int spaceflag;
{
	char c,*cp,*strbegin,*patbegin,*patp,*tempstr;
	int	done=0,yetanother=1,ret_code,ok;
	int i1,i2,i3,count=0;

	strbegin = str;
	patbegin = pattern;
	do {
		while (*pattern && !done && ((!*str &&
			(*pattern == '{' || *pattern == '*')) ||		/*}*/
			*str)) {
			switch (*pattern) {
			case '\\':
				pattern++;
				if (*pattern && CHAR_EQ(*str,*pattern)) {
					pattern++;
					str++;
				} else
					done = 1;
				break;
			case '*':
				pattern++;
				ret_code=0;
				if (spaceflag)
					while (*str && *str != ' ' && !(ret_code=StrEqExp(str++,pattern,1)));
				else
					while (*str && !(ret_code=StrEqExp(str++,pattern,0)));
				if (ret_code) {
					while (*str) str++;
					while (*pattern) pattern++;
				}
				break;
			case '[':
				pattern++;
				repeat:
					if (!*pattern || *pattern == ']') {
						done=1;
						break;
					} 
					if (*pattern == '\\') {
						pattern++;
						if (*pattern == '\0') {
							done=1;
							break;
						}
					}
					if (*(pattern+1) == '-') {
						c = *pattern;
						pattern+=2;
						if (*pattern == ']') {
							done=1;
							break;
						}
						if (*pattern == '\\') {
							pattern++;
							if (!*pattern) {
								done=1;
								break;
							}
						}
						if (CHAR_LESS(*str,c) || CHAR_GTR(*str,*pattern)) {
							pattern++;
							goto repeat;
						} 
					} else if (CHAR_NEQ(*pattern,*str)) {
						pattern++;
						goto repeat;
					}
				pattern++;
				while (*pattern != ']' && *pattern) {
					if (*pattern == '\\' && *(pattern+1))
						pattern++;
						pattern++;
					}
				if (*pattern) {
					pattern++;
					str++;
				}
				break;
			case '?':
				pattern++;
				str++;
				break;
			case '{':	/*}*/
				pattern++;
				patp = pattern;
				/*
				 * tempstr is used to search through all of {..} to make
				 * sure that we find the longest match.  for example, if
				 * we have {a,ab,abc}, make sure that "abc" matches the
				 * the "abc" in the expression, and not just "a".
				 */
				tempstr = (char *)NULL;
/*{*/			while (*pattern != '}' && *pattern) {
					cp = str;
					ok = 1;
					while ((ok && *cp && *pattern) &&
/*{*/					   *pattern != ',' && *pattern != '}') {
						if (*pattern == '\\')
							pattern++;
						ok=(CHAR_EQ(*pattern,*cp));
						cp++;
						pattern++;
					}

/*{*/				if (!*cp && *pattern != '}' && *pattern != ',')
						ok=0;

					if (!*pattern) {
						ok=0;
						done=1;
						break;
					} else if (ok && tempstr < cp)
						tempstr=cp;
/*{*/				while (*pattern != '}' && *pattern != ',' && *pattern) {
						pattern++;
						if (*pattern == '\\') {
							pattern++;
							if (*pattern)
								pattern++;
						}
					}
					if (*pattern)
						pattern++;
/*{*/				if (*pattern == '}') {
						if (*(pattern-1)==',' || tempstr) pattern++;
						else pattern=patp;
						break;
					}
/*{*/				if (*(pattern-1) == '}') {
						if (!ok && !tempstr)
							pattern=patp;
						break;
					}
				}
				if (tempstr)
					str = tempstr;
				break;
			case '(':	/*)*/
				pattern++;
				if (CHAR_EQ('x',*pattern)) {
				/* hex numeric range */
					pattern++;
					i1=0;
					while (*pattern != '-') {
						if ((*pattern >= '0' && *pattern <= '9') || (CHAR_GTREQ(*pattern,'a') && CHAR_LESSEQ(*pattern,'f'))) {
							i1 <<= 4;
							i1 += (int) *(pattern++) - '0';
						} else {
							done = 1;
							break;
						}
					}
					if (*pattern != '-') {
						done = 1;
						break;
					} else {
						pattern++;
					}
					i2=0;
					while (*pattern != ')') {
						if ((*pattern >= '0' && *pattern <= '9') || (CHAR_GTREQ(*pattern,'a') && CHAR_LESSEQ(*pattern,'f'))) {
							i2 <<= 4;
							i2 += (int) *(pattern++) - '0';
						} else {
							done = 1;
							break;
						}
					}
					if (*pattern != ')') {
						done = 1;
						break;
					} else {
						pattern++;
					}
					i3 = 0;
					while ((*str >= '0' && *str <= '9') || (CHAR_GTREQ(*str,'a') && CHAR_LESSEQ(*str,'f'))) {
						i3 <<= 4;
						i3 += (int) *(str++) - '0';
					}
					if ((i3 < i1) || (i3 > i2)) {
						done=1;/* str doesn't match pattern so "str--" is */
						str--;	/* a cheap way to make str != pattern when */
					}			/* this goes through next while loop	   */
				} else if (CHAR_EQ('o',*pattern)) {
				/* octal numeric range */
					pattern++;
					i1=0;
					while (*pattern != '-') {
						if (*pattern >= '0' && *pattern <= '7') {
							i1 <<= 3;
							i1 += (int) *(pattern++) - '0';
						} else {
							done = 1;
							break;
						}
					}
					if (*pattern != '-') {
						done = 1;
						break;
					} else {
						pattern++;
					}
					i2=0;
					while (*pattern != ')') {
						if (*pattern >= '0' && *pattern <= '7') {
							i2 <<= 3;
							i2 += (int) *(pattern++) - '0';
						} else {
							done = 1;
							break;
						}
					}
					if (*pattern != ')') {
						done = 1;
						break;
					} else {
						pattern++;
					}
					i3 = 0;
					while (*str >= '0' && *str <= '7') {
						i3 <<= 3;
						i3 += (int) *(str++) - '0';
					}
					if (i3 < i1 || i3 > i2) {
						done=1;/* str doesn't match pattern so "str--" is */
						str--;	/* a cheap way to make str != pattern when */
					}			/* this goes through next while loop	   */
				} else {
				/* decimal numeric range */
					i1=0;
					while (*pattern != '-') {
						if (*pattern >= '0' && *pattern <= '9') {
							i1 *= 10;
							i1 += (int) *(pattern++) - '0';
						} else {
							done = 1;
							break;
						}
					}
					if (*pattern != '-') {
						done = 1;
						break;
					} else {
						pattern++;
					}
					i2=0;
					while (*pattern != ')') {
						if (*pattern >= '0' && *pattern <= '9') {
							i2 *= 10;
							i2 += (int) *(pattern++) - '0';
						} else {
							done = 1;
							break;
						}
					}
					if (*pattern != ')') {
						done = 1;
						break;
					} else {
						pattern++;
					}
					i3 = 0;
					while (*str >= '0' && *str <= '9') {
						i3 *= 10;
						i3 += (int) *(str++) - '0';
					}
					if (i3 < i1 || i3 > i2) {

						done = 1;/* str don't match pattern so "str--" is */
						str--;	/* a cheap way to make str != pattern when */
					}			/* this goes through next while loop	   */
				}
				break;
			default:
				if (CHAR_EQ(*str,*pattern)) {
					str++;
					pattern++;
				} else {
					done=1;
				}
			}
		}
		while (*pattern == '*') pattern++;
		if (!spaceflag)
			return(!*str && !*pattern);
		if (*pattern == '\0') count++;
		if ((*pattern == '\0') && (*str == ' ')) {
			pattern = patbegin;
			str++;
		} else
			yetanother = 0;
	} while (yetanother);
	if (!*str && !*pattern)
		return(count);
	else return(0);
}
