#ifndef lint
static char rcsid[] = "$Header: $";
#endif

/*
 * $Log:$
 */

#include "common.h"

#include <sys/stat.h>
#include <string.h>
#include <strings.h>
#include <ctype.h>
#if SYSLOG
#include <syslog.h>
#endif

#define DIRECT_NONE		0	/* not moving */
#define DIRECT_UP		1	/* moving upwards */
#define DIRECT_DOWN		2	/* moving downwards */
#define DIRECT_ESC		3	/* try to make user (escape) */
#define DIRECT_UNKNOWN	4	/* not a directional character */
#define DIRECT_FORWARD	5	/* moving forward a screen */
#define DIRECT_BACKWARD	6	/* moving backward a screen */
#define DIRECT_RET		7	/* carriage return */

/*
 *  GETDIRECT sets a directional variable to one of the above #define's.
 *  It is a macro because it is used twice, once, where we dont want to
 *  call a function (speed considerations).
 */
#define GETDIRECT(CHR,DIR)	/* set DIR according to CHR */		\
	switch (CHR) {												\
		case '\002':		/* ^B backward a screen */			\
			DIR = DIRECT_BACKWARD;								\
			break;												\
		case '\006':		/* ^F forward a screen */			\
			DIR = DIRECT_FORWARD;								\
			break;												\
		case '\013':		/* ^K up a field */					\
			DIR = DIRECT_UP;									\
			break;												\
		case '\012':		/* ^J down a field */				\
			DIR = DIRECT_DOWN;									\
			break;												\
		case '\033':		/* ESC -- try to save record */		\
			DIR = DIRECT_ESC;									\
			break;												\
		case '\r':			/* ^M downward direction */			\
			DIR = DIRECT_RET;									\
			break;												\
		default:			/* not a directional character */	\
			DIR = DIRECT_UNKNOWN;								\
	}

/*
 * returns value corresponding to whether the record is changed (key field
 * had all non-used keys in it), or not changed (key field resulted in
 * a new record getting pulled up)
 *    -1 on error
 *     0 record is newly retrieved
 *     1 if all keys in the field were successfully reserved
 */
static checkkeyfield(mindex,keystr)
	int mindex;
	char **keystr;
{
	int i, retval, newrecflags;
	char *cp;

	newrecflags = 0;

	DisableInterrupts();
	if ((retval=ReserveKeys(mindex,keystr)) < 0) {
		EnableInterrupts();
		DispMsg(SecLastLine, 0, NO_STAND, errmsg);
		GetAnyKey("Serious error, please contact system administrator");
		DispMsg(SecLastLine, 0, NO_STAND, "");
		return(-1);
	}

	if (retval > 0) {
		newrecflags |= REC_EXISTS;
		if (Validated(fields[i_access]->newdata))
			newrecflags |= REC_VALID;
	} else
		newrecflags |= REC_NEW;

	if (retval == 0) {
		if (X_Doing == X_RM) {
			FreeKeys(fields[i_pkey]->keyindex,fields[i_pkey]->data,"");
			EnableInterrupts();
			GetAnyKey("This record isn't in the database so you can't remove it");
			return(-1);
		}
		if (mindex == i_pkey && (recflags&REC_EXISTS)) {
			/* if they can change host, give them option to do so */
			if (recflags&REC_VALID) {
				if (STRCASEEQ(fields[i_pkey]->data,fields[i_pkey]->origdata)) {
					if (FreeKeys(fields[i_pkey]->keyindex,fields[i_pkey]->prevdata,fields[mindex]->data) < 0) {
						EnableInterrupts();
						return(-1);
					}
					RedrawStatus();
					EnableInterrupts();
					return(1);
				}
				/*
				 * we have a window of danger here, so we do this hack
				 * to assure that the key gets freed if an interrupt
				 * occurs.
				 */
				freepkeyfield = 1;
				EnableInterrupts();
				if (PromptMsg("Do you want to change the primary key for this record? ")) {
					RedrawStatus();
					return(1);
				}
				DisableInterrupts();
				freepkeyfield = 0;
			}
			/* fall through to making this a new record */
			FreeAllKeys();
			/* null key fields */
			for (i=0; i<nfields; i++) {
				if (fields[i]->keyindex < 0 || i == i_pkey) continue;
				*fields[i]->data = '\0';
			}
			/* null access field if necessary */
			if (recflags&REC_VALID)
				newrecflags |= REC_VALID;
			else
				*fields[i_access]->data = '\0';
			recordoffset = -1L;
			recflags = newrecflags;
			RmRecLock(i_pkey,fields[i_pkey]->origdata);
			bzero(origdata,recordlen);
			bcopy(data,prevdata,recordlen);
			ConvertDate(0);
			RedrawScreen();
			RedrawStatus();
			EnableInterrupts();
			return(1);
		}
		if (!(recflags&REC_VALID) && recflags&REC_EXISTS) {
			FreeKeys(fields[mindex]->keyindex,fields[mindex]->data,"");
			EnableInterrupts();
			sprintf(msg,"This record is view only and that key was not found");
			GetAnyKey(msg);
			return(-1);
		}
		if (FreeKeys(fields[mindex]->keyindex,fields[mindex]->prevdata,fields[mindex]->data) < 0) {
			EnableInterrupts();
			return(-1);
		}
		if (mindex == i_pkey)
			RedrawStatus();
		EnableInterrupts();
		return(1);
	} else if (retval == 1) {
		if (X_Doing == X_RM) {
			if (!(newrecflags&REC_VALID)) {
				EnableInterrupts();
				GetAnyKey("You do not have permission to remove this record.");
				return(-1);
			} else {
				if ((cp=RecLock(i_pkey,fields[i_pkey]->newdata)) == (char *)NULL) {
					EnableInterrupts();
					DispMsg(SecLastLine, 0, NO_STAND, errmsg);
					GetAnyKey("Serious error, please contact system administrator");
					DispMsg(SecLastLine, 0, NO_STAND, "");
					return(-1);
				} else if (*cp) {
					EnableInterrupts();
					sprintf(msg,"Sorry, this record is locked by %s right now",cp);
					GetAnyKey(msg);
					return(-1);
				}
				if (recflags&REC_VALID)
					RmRecLock(i_pkey,fields[i_pkey]->origdata);
				recordoffset = newrecordoffset;
				recflags = newrecflags;
				bcopy(newdata,data,recordlen);
				bcopy(newdata,prevdata,recordlen);
				bcopy(newdata,origdata,recordlen);
				ConvertDate(1);
			}
		} else {
			if (newrecordoffset < 0) {
				EnableInterrupts();
				sprintf(msg,"Sorry, \"%s\" is being used in a new record right now",*keystr);
				GetAnyKey(msg);
				return(-1);
			}

			if ((cp=RecLock(i_pkey,fields[i_pkey]->newdata)) == (char *)NULL) {
				EnableInterrupts();
				DispMsg(SecLastLine, 0, NO_STAND, errmsg);
				GetAnyKey("Serious error, please contact system administrator");
				DispMsg(SecLastLine, 0, NO_STAND, "");
				return(-1);
			}

			if (STRCASEEQ(*keystr,fields[i_pkey]->newdata))
				sprintf(msg,"\"%s\" is the primary key for another record.",*keystr);
			else
				sprintf(msg,"\"%s\" is used by %s.",*keystr,fields[i_pkey]->newdata);

			if (*cp) {
				EnableInterrupts();
				DispMsg(SecLastLine, 0, NO_STAND, msg);
				sprintf(msg,"Sorry, that record is locked by %s right now",cp);
				GetAnyKey(msg);
				DispMsg(SecLastLine, 0, NO_STAND, "");
				return(-1);
			}

			if ((recflags&REC_NEW && recflags&REC_MODIFIED) || (recflags&REC_VALID && recflags&REC_EXISTS)) {
				*msg2 = '\0';
				if (recflags&REC_MODIFIED)
					sprintf(msg2,"This record has been modified, do you want to bring the other record up? ",fields[i_pkey]->newdata);
				else
					sprintf(msg2,"Do you want to bring the other record up? ",fields[i_pkey]->newdata);
				if (*msg2) {
					DispMsg(SecLastLine, 0, NO_STAND, msg);
					EnableInterrupts();
					if (!PromptMsg(msg2)) {
						DisableInterrupts();
						FreeKeys(fields[mindex]->keyindex,fields[mindex]->data,fields[mindex]->prevdata);
						RmRecLock(i_pkey,fields[i_pkey]->newdata);
						EnableInterrupts();
						return(-1);
					}
					DisableInterrupts();
				}
			}

			FreeKeys(fields[mindex]->keyindex,fields[mindex]->data,fields[mindex]->prevdata);
			if (recflags&REC_VALID)
				RmRecLock(i_pkey,fields[i_pkey]->origdata);
			FreeAllKeys();
			/* if it's view-only, then don't lock the record */
			if (!(newrecflags&REC_VALID))
				RmRecLock(i_pkey,fields[i_pkey]->newdata);

			recordoffset = newrecordoffset;
			recflags = newrecflags;
			bcopy(newdata,data,recordlen);
			bcopy(newdata,prevdata,recordlen);
			bcopy(newdata,origdata,recordlen);
			ConvertDate(1);
			recflags &= ~REC_MODIFIED;
			RedrawStatus();
			SetUpChosen();
		}
		EnableInterrupts();
		return(0);
	} else if (retval == 2) {
		EnableInterrupts();
		/* this should only happen if we're doing X_ADD */
		sprintf(msg,"Sorry, but you're using \"%s\" in this record already",*keystr);
		GetAnyKey(msg);
		return(-1);
	}
}

/*
 * use the psuedo-vi mode edit on current field.
 */
static char editline(fptr)
	scrfield_t *fptr;
{
	int leftx, rightx, x, y, i, j;
	int len, maxlen, done, undox = -1;
	char ichar, leftch, rightch, *data, *udata, *cp, direction;
	char c1, c2, *cp1, *cp2, *allow;
	WINDOW *win;
	/* movemode = -1 means we are moving around, otherwise movemode
	 * contains x location of where insert or replace mode started.
     */
	int movemode = -1;
	/* replacemode=1 means we are in replace mode for one character,
	 * meaning 'r' was pressed.  replacemode>1 means we are in replace
	 * mode for more than one character, meaning 'R' was pressed.
	 * otherwise we are in insert mode.
	 */
	int replacemode;
	int lastreplacex; /* used to undo replace if we backed over some chars */

	data = fields[fptr->index]->data;
	allow = fields[fptr->index]->allow;
	/* use newdata to remember previous changes for undo command */
	udata = fields[fptr->index]->newdata;
	strcpy(udata,data);
	maxlen = fields[fptr->index]->len;
	len = strlen(data);
	win = curscreen->win;
	leftx = fptr->x_input;
	rightx = leftx + fields[fptr->index]->len - 1;
	y = fptr->y_input;
	x = leftx + len - 1;
	if (x < leftx) x = leftx;

	for (i=0; i<maxlen; i++)
		tmpfieldspace[i] = '_';
	tmpfieldspace[maxlen] = '\0';

	wstandout(win);
	if (leftx-1 >= 0) {
		leftch = mvwinch(win,y,leftx-1);
		waddch(win,'[');
	}
	if (rightx+1 <= LastCol) {
		rightch = mvwinch(win,y,rightx+1);
		waddch(win,']');
	}
	wstandend(win);
	wmove(win,y,x);
	wrefresh(win);
	done = 0;
	while (!done) {
		ichar = wgetch(win);		/* get next character */
		if (wasbeeperr) ClearBeepErr(1);
		switch (ichar) {
			case '?':
				(void) HelpThem(I_GENHELP,0);
				break;
			case '\011':
				(void) HelpThem(I_EDITHELP,0);
				break;
			case '\014':	/* ^L -- redraw the screen */
				(void) wrefresh(curscr);
				break;
			case '\002':	/* ^B backward a screen */
			case '\006':	/* ^F forward a screen */
			case '\013':	/* ^K up a field */
			case '\012':	/* ^J down a field */
			case '\r':		/* ^M quit edit mode */
			case '\026':	/* ^V quit edit mode */
				GETDIRECT(ichar, direction);
				done = 1;
				break;
			case '\033':	/* ESC -- go to movement mode */
				if (movemode < 0) {
					BeepErr("You are not in insert mode.",1);
					break;
				}
				movemode = -1;
				if (replacemode == 2 && lastreplacex >= x) {
					strcpy(data+(x-leftx),udata+(x-leftx));
					len = strlen(data);
					wmove(win,y,x);
					cp = data+(x-leftx);
					cp2 = cp+(lastreplacex-x);
					wmove(win,y,x);
					j = leftx+len-1;
					for (i=x; cp<=cp2; i++,cp++) {
						if (i > j)
							waddch(win,'_');
						else
							waddch(win,*cp);
					}
				}
				if (x != leftx && replacemode != 1)
					x--;
				wmove(win,y,x);
				wrefresh(win);
				break;
			default:
				if (movemode < 0) {
					switch (ichar) {
						case 'u':	/* undo changes just made */
						case 'U':
							if (undox < 0) {
								BeepErr("Nothing to undo.",1);
								break;
							}
							if (ichar == 'U') {
								strcpy(udata,data);
								strcpy(data,fields[fptr->index]->prevdata);
								undox = leftx;
							} else {
								/* swap chars between data and udata */
								c1 = c2 = 1;
								cp1=data;
								cp2=udata;
								do {
									if (c1) c1 = *cp1;
									if (c2) c2 = *cp2;
									*cp1++ = c2;
									*cp2++ = c1;
								} while (c1 || c2);
							}
							len = strlen(data);
							x = undox;
							if (x-leftx == len && x != leftx)
								x--;
							if (*data)
								mvwaddstr(win,y,leftx,data);
							else
								wmove(win,y,leftx);
							tmpfieldspace[maxlen-len] = '\0';
							if (tmpfieldspace[0])
								waddstr(win,tmpfieldspace);
							tmpfieldspace[maxlen-len] = '_';
							wmove(win,y,x);
							wrefresh(win);
							break;
						case '$':	/* go to end of line */
							x = leftx+len-1;
							wmove(win,y,x);
							wrefresh(win);
							break;
						case '^':	/* go to beginning of line */
						case '0':	/* go to beginning of line */
							x = leftx;
							wmove(win,y,x);
							wrefresh(win);
							break;
						case 'I':	/* insert at beginning of string */
							x = leftx;
							wmove(win,y,x);
							wrefresh(win);
						case 'i':	/* insert at current position */
							movemode = x;
							replacemode = 0;
							strcpy(udata,data);
							undox = x;
							break;
						case 'A':
							if (len < maxlen) {
								if (len != 0) {
									x = leftx + len;
									wmove(win,y,x);
									wrefresh(win);
								}
								movemode = x;
								replacemode = 0;
								strcpy(udata,data);
								undox = x;
							} else
								BeepErr("Can't append, field already full.",1);
							break;
						case 'a':
							if (x < rightx && len < maxlen) {
								if (len != 0) {
									x++;
									wmove(win,y,x);
									wrefresh(win);
								}
								movemode = x;
								replacemode = 0;
								strcpy(udata,data);
								undox = x;
							} else
								BeepErr("Can't append, field already full.",1);
							break;
						case 'r':
							if (*(data+x-leftx)) {
								movemode = x;
								replacemode = 1;
								strcpy(udata,data);
								undox = x;
							} else
								BeepErr("Nothing to replace.",1);
							break;
						case 'R':
							lastreplacex = movemode = x;
							replacemode = 2;
							strcpy(udata,data);
							undox = x;
							break;
						case 'h':	/* move to the left */
							if (x != leftx) {
								x--;
								wmove(win,y,x);
								wrefresh(win);
							} else
								BeepErr("You've gone too far.",1);
							break;
						case 'l':	/* move to the right */
						case ' ':	/* allow space to move us right too */
							if (x-leftx+1 < len) {
								x++;
								wmove(win,y,x);
								wrefresh(win);
							} else
								BeepErr("You've gone too far.",1);
							break;
						case 'x':	/* delete a char */
							cp = data+(x-leftx);
							if (*cp) {
								strcpy(udata,data);
								undox = x;
								bcopy(cp+1,cp,len-(x-leftx));
								len--;
								if (*cp)
									waddstr(win,cp);
								else
									x--;
								if (x < leftx) x = leftx;
								waddch(win,'_');
								wmove(win,y,x);
								wrefresh(win);
							} else
								BeepErr("Nothing to delete.",1);
							break;
						default:
							BeepErr("Not a valid character for this mode.",1);
							break;
					}
				} else {
					if (ichar == c_kill || ichar == c_werase) {	/* line erase */
						if (movemode == x)
							BeepErr("You've gone too far.",1);
						else if (movemode != x) {
							if (ichar == c_werase) {
								cp = data+(x-leftx);
								for (i=x; i>movemode && *(cp-1) == ' '; i--,cp--);
								for (; i>movemode && *(cp-1) != ' '; i--,cp--);
							} else {
								cp = data+(movemode-leftx);
								i = movemode;
							}
							if (replacemode == 2) {
								if (lastreplacex < x) lastreplacex = x;
								x = i;
								wmove(win,y,x);
								wrefresh(win);
							} else {
								bcopy(data+(x-leftx),cp,len-(x-leftx)+1);
								len = strlen(data);
								x = i;
								if (*cp)
									mvwaddstr(win,y,x,cp);
								else
									wmove(win,y,x);
								tmpfieldspace[maxlen-len] = '\0';
								if (tmpfieldspace[0])
									waddstr(win,tmpfieldspace);
								tmpfieldspace[maxlen-len] = '_';
								wmove(win,y,x);
								wrefresh(win);
							}
						}
					} else if (ichar == c_erase) {		/* character erase */
						if (movemode == x)
							BeepErr("You've gone too far.",1);
						else if (replacemode == 2) {
							if (lastreplacex < x) lastreplacex = x;
							x--;
							wmove(win,y,x);
							wrefresh(win);
						} else if (movemode != x) {
							cp = data+(x-leftx);
							bcopy(cp,cp-1,len-(x-leftx)+1);
							len--;
							x--;
							if (*cp)
								waddstr(win,cp);
							else
								wmove(win,y,x);
							waddch(win,'_');
							wmove(win,y,x);
							wrefresh(win);
						}
					} else if (replacemode == 0) {	/* field input */
						if (len >= maxlen)
							BeepErr("You've gone too far.",1);
						else if (!allow[ichar]) {
							sprintf(errmsg,"Character not allowed: `%s'.",unctrl(ichar));
							BeepErr(errmsg,1);
						} else {
							cp = data+(x-leftx);
							bcopy(cp,cp+1,len-(x-leftx)+1);
							*cp = ichar;
							len++;
							waddstr(win,cp);
							x++;
							wmove(win,y,x);
							wrefresh(win);
						}
					} else if (replacemode == 1) { /* 'r' command */
						if (allow[ichar]) {
							*(data+(x-leftx)) = ichar;
							waddch(win,ichar);
							wmove(win,y,x);
							wrefresh(win);
							movemode = -1;
						} else {
							sprintf(errmsg,"Character not allowed: `%s'.",unctrl(ichar));
							BeepErr(errmsg,1);
						}
					} else {	/* 'R' command */
						if (allow[ichar]) {
							cp = data+(x-leftx);
							if (x-leftx == len) {
								len++;
								*(cp+1) = '\0';
							}
							*cp = ichar;
							waddch(win,ichar);
							if (x < rightx)
								 x++;
							else
								wmove(win,y,x);
							wrefresh(win);
						} else {
							sprintf(errmsg,"Character not allowed: `%s'.",unctrl(ichar));
							BeepErr(errmsg,1);
						}
					}
				}
				break;
		}
	}
	if (leftx-1 >= 0)
		mvwaddch(win,y,leftx-1,leftch);
	if (rightx+1 <= LastCol)
		mvwaddch(win,y,rightx+1,rightch);
	return(direction);
}

/*
 * Read characters from stdin into fields[fptr->index]->data. incoming
 * `ichar' is guaranteed to have the first character for the line
 * (i.e. the * first character that should be processed as input for
 * this field).
 */
static char getline(ichar,changed,fptr)
	char ichar;	/* First character to be processed */
	int *changed;	/* set `1' if field has been changed */
	scrfield_t *fptr;	/* pointer to current field */
{
	register int abscol, relcol;	/* absolute & relative column */
	register char direction;
	register char *dptr;
	WINDOW *pwin;			/* cache current screen */
	int temp;
	char *cp, *allow;

	dptr = fields[fptr->index]->data;
	allow = fields[fptr->index]->allow;
	relcol = strlen(dptr);		/* relative current position */
	abscol = relcol + fptr->x_input;	/* absolute current position */
	direction = DIRECT_UNKNOWN;		/* set direction unknown */

	pwin = curscreen->win;
	while (1) {
		switch (ichar) {
			case '?':
				(void) HelpThem(I_GENHELP,0);
				break;
			case '\014':	/* ^L -- redraw the screen */
				(void) wrefresh(curscr);
				break;
			case '\011':	/* tab -- display per field help info */
				(void) HelpThem(fptr->index,fptr);
				break;
			case '\026':	/* ^V -- go into edit mode */
				if (!fields[fptr->index]->choice) {
					*(dptr+relcol) = '\0';	/* insert end of string char */
					direction = editline(fptr);
					relcol = strlen(dptr);
					abscol = relcol + fptr->x_input;
					break;
				}
			default:
				if (ichar == c_kill) {	/* line erase */
					if (relcol > 0) {
						wmove(pwin,fptr->y_input, fptr->x_input);
						temp = fields[fptr->index]->len;
						for (relcol=0; relcol<temp; relcol++)
							waddch(pwin,'_');
						relcol = 0;
						abscol = fptr->x_input;
					}
				} else if (fields[fptr->index]->choice) {
					if ((cp=ChoiceBox(fptr))) {
						strcpy(fields[fptr->index]->data,cp);
						RedrawField(fptr);
						if (STREQ(fields[fptr->index]->data,fields[fptr->index]->prevdata))
							*changed = 0;
						else
							*changed = 1;
						return(DIRECT_RET);
					} else
						return(DIRECT_NONE);
				} else if (ichar == c_werase) {	/* word erase */
					if (relcol > 0) {
						while (relcol && (*(dptr+relcol)==' ' ||
							  *(dptr+relcol)==',')) {
							mvwaddch(pwin,fptr->y_input, --abscol, '_');
							--relcol;
						}
						while (relcol && (*(dptr+relcol)!=' ' &&
							  *(dptr+relcol)!=',')) {
							mvwaddch(pwin,fptr->y_input, --abscol, '_');
							--relcol;
						}
					}
				} else if (ichar == c_erase) {		/* character erase */
					if (relcol > 0) {
						mvwaddch(pwin,fptr->y_input, --abscol,'_');
						relcol--;
					}
				} else {			/* field input */
					if (relcol < fields[fptr->index]->len) {	/* we have room */
						if (allow[ichar]) {		/* valid */
							mvwaddch(pwin,fptr->y_input, abscol++, ichar);
							*(dptr+relcol++) = ichar;
						} else {				/* not valid */
							sprintf(errmsg,"Character not allowed: `%s'.",unctrl(ichar));
							BeepErr(errmsg,0);
						}
					} else			/* past end of field */
						BeepErr("You've gone too far.",0);
				}
			break;
		}

		if (direction == DIRECT_UNKNOWN) {
			wmove(pwin,fptr->y_input, abscol);
			wrefresh(pwin);				/* and refresh the screen */

			ichar = wgetch(pwin);		/* get next character */

			GETDIRECT(ichar, direction);
		}

		if (direction != DIRECT_UNKNOWN) {	/* it's a directional */
			if (wasbeeperr) ClearBeepErr(0);
			*(dptr+relcol) = '\0';		/* insert end of string char */
			if (STREQ(fields[fptr->index]->data,fields[fptr->index]->prevdata))
				*changed = 0;
			else
				*changed = 1;
			if (*changed) {			/* clear to end of line */
				DispMsg(fptr->y_error, (fptr->y_error == fptr->y_input &&
					abscol > fptr->x_error)?
					abscol: fptr->x_error, NO_STAND, "");
			}
			return(direction);			/* return direction */
		}
	}
}

/*
 * ESC was pressed, so decide what needs to be done by asking the user.
 * ask if we save the record or not if X_Doing equals X_ADD, or ask if
 * we remove the record or not if X_Doing equals X_RM, or refuse to do
 * either if the user doesn't have the permission.
 */
static dealwithrec() {
	int temp;
	char *promptmsg, *cp;

	if (X_Doing == X_RM) {
		if (PromptMsg("Are you sure you want to remove this record?")) {
			DispMsg(LastLine, 0, NO_STAND,
				"Removing record, please wait...");
#if SYSLOG || LOGTOFILE
			sprintf(msg,"addhoser %s removed %s.\n", InvokerAcct, fields[i_pkey]->data);
#endif
			DisableInterrupts();
			if ((temp=RemoveData())<0)
				DispMsg(LastLine, 0, NO_STAND,
					"Host is not in database!");
			else {
#if SYSLOG
				syslog(LOG_INFO, msg);
#endif
#if LOGTOFILE
				LogToFile(msg);
#endif
				DispMsg(LastLine, 0, NO_STAND,
					"Success removing data!");
				RedrawScreen();
			}
			EnableInterrupts();
			return;
		}
	} else {
		if (recflags&REC_MODIFIED)
			promptmsg = "Are you sure you want to save this record?";
		else
			promptmsg = "This record hasn't been modified, are you sure you want to save it?";
		if (PromptMsg(promptmsg)) {
			DispMsg(LastLine, 0, NO_STAND,
				"Saving record, please wait...");
			if (recflags & REC_NEW)
				StampRec(i_createdate);
			else
				StampRec(i_moddate);
			DisableInterrupts();
			if (OpenData(1) < 0) {
				sprintf(errmsg,"%s: %s", DataFile, syserr);
				DispMsg(SecLastLine, 0, NO_STAND, errmsg);
				DispMsg(LastLine, 0, NO_STAND,
					"Error saving data!");
			} else {
				if (recflags & REC_NEW) {
					if ((cp=RecLock(i_pkey,fields[i_pkey]->data))==(char *)NULL) {
						CloseData();
						EnableInterrupts();
						DispMsg(SecLastLine, 0, NO_STAND, errmsg);
						GetAnyKey("Serious error, please contact system administrator");
						DispMsg(SecLastLine, 0, NO_STAND, "");
						return;
					} else if (*cp) {
						CloseData();
						EnableInterrupts();
						DispMsg(SecLastLine,0,NO_STAND,"record is already locked (this should not happen)");
						GetAnyKey("Serious error, please contact system administrator");
						DispMsg(SecLastLine, 0, NO_STAND, "");
						return;
					}
				}

				*tmpfieldspace = '\0';
				if ((recflags&REC_EXISTS) && !STRCASEEQ(fields[i_pkey]->origdata,fields[i_pkey]->data))
					strcpy(tmpfieldspace,fields[i_pkey]->origdata);
				if (*tmpfieldspace)
					RecLock(i_pkey,fields[i_pkey]->data);
				if (WriteData() < 0) {
					DispMsg(SecLastLine, 0, NO_STAND, errmsg);
					DispMsg(LastLine, 0, NO_STAND,
						"Error saving data!");
					CloseData();
				} else {
					if (recflags & REC_NEW) {
						recflags = REC_VALID|REC_EXISTS;
						RedrawStatus();
#if SYSLOG || LOGTOFILE
						sprintf(msg,"addhoser %s created %s.\n",
							InvokerAcct, fields[i_pkey]->data);
#if SYSLOG
						syslog(LOG_INFO, msg);
#endif
#if LOGTOFILE
						LogToFile(msg);
#endif
#endif
					} else if (*tmpfieldspace) {
						RedrawStatus();
#if SYSLOG || LOGTOFILE
						sprintf(msg, "addhoser %s changed %s to %s.\n",
						       InvokerAcct,tmpfieldspace,fields[i_pkey]->data);
#if SYSLOG
						syslog(LOG_INFO, msg);
#endif
#if LOGTOFILE
						LogToFile(msg);
#endif
#endif
					} else {
#if SYSLOG || LOGTOFILE
						sprintf(msg, "addhoser %s modified %s.\n",
						       InvokerAcct, fields[i_pkey]->data);
#if SYSLOG
						syslog(LOG_INFO, msg);
#endif
#if LOGTOFILE
						LogToFile(msg);
#endif
#endif
					}
					RedrawScreen();
					DispMsg(LastLine, 0, NO_STAND, "Success saving data!");
					recflags &= ~REC_MODIFIED;
					CloseData();
				}
				if (*tmpfieldspace)
					RmRecLock(i_pkey,tmpfieldspace);
			}
			EnableInterrupts();
		}
	}
	return;
}

/*
 *  GetScreen() gathers all the gnarly screen input from the user.  The
 *  routine can be exited with an ESC (i.e. save the record) or an
 *  interrupt (in which case, we'll either be back or the program will
 *  terminate).
 */
GetScreen() {
	scrfield_t *fptr;			/* current field pointer */
	WINDOW *pwin;				/* cache current screen */
	char direction;				/* get input for a particular field */
	int i, len;
	register int temp;			/* index */
	register char c;			/* character index, initial input/line */
	int changed;				/* boolean; 1 if getline() changed field */
	int badinput=0;
	char *keystr, *cp, *bcp;
	screen_t *savescreen;

	/*
	 *	Loop getting data for current field (fld,fldptr) until:
	 *	  1) an ESC is entered, in which case, we run dealwithrec().
	 *	  2) user hit's an interrupt.
	 */
	
	recflags = REC_NEW;
	RedrawStatus();
	fptr = firstscrfield;
	while (1) {
		pwin = curscreen->win;

		mvwaddstr(pwin,fptr->y_input, fptr->x_input, fields[fptr->index]->data);
		len = strlen(fields[fptr->index]->data);
		temp = fields[fptr->index]->len - len;
		while (temp-- > 0)
			waddch(pwin,'_');
		wmove(pwin,fptr->y_input,(len+fptr->x_input));
		wrefresh(pwin);

		changed = 0;	/* reinit changed to zero (nothing changed yet) */
		c = wgetch(pwin);	/* get first character from user */

		/* Is it a directional character, or field input? */
		GETDIRECT(c, direction);

		if (direction == DIRECT_UNKNOWN) { /* field input; get rest of line */
			if (!(recflags&REC_VALID) && fields[fptr->index]->keyindex < 0 && fptr->index != i_pkey && recflags&REC_EXISTS)
				BeepErr("This record is view only.");
			else if (fields[fptr->index]->props & R_PROP) {
				if (hasaccessall)
					direction = getline(c, &changed, fptr);
				else {
					(void) putc('\007', stdout);	
        			DispMsg(SecLastLine, 0, NO_STAND,
						"Sorry. You cannot modify this field.");
				}
			} else if (!recflags&REC_NEW && !recflags&REC_VALID) {
				(void) putc('\007', stdout);	
				DispMsg(SecLastLine, 0, NO_STAND,
					"Sorry.  You cannot modify the access field on this host.");
			} else
				direction = getline(c, &changed, fptr);
		}

		/* `direction' guaranteed to contain a valid "DIRECT_*" */

		/* deal with special processing here */
		if ((changed || badinput) && (*fields[fptr->index]->data == '\0')) {
			if (fptr->index == i_pkey && recflags&REC_VALID) {
				GetAnyKey("Sorry, but you can't leave this field blank");
				strcpy(fields[i_pkey]->data,fields[i_pkey]->prevdata);
				RedrawField(fptr);
				continue;
			}
			if (fields[fptr->index]->keyindex >= 0)
				FreeKeys(fields[fptr->index]->keyindex,fields[fptr->index]->prevdata,"");
			if (fptr->index == i_pkey) RedrawStatus();
		} else if (changed || badinput) {
			if (StrEqExp(fields[fptr->index]->data,fields[fptr->index]->exp,1)) {
				badinput = 0;
				i = fields[fptr->index]->keyindex;
				if (i >= 0) {
					i = keys[i]->len;
					bcp = fields[fptr->index]->data;
					for (cp=bcp; *cp; cp++) {
						if (*cp == ' ') {
 							if (cp-bcp > i) {
								badinput = 1;
								break;
							} else
								bcp = cp+1;
						}
					}
					if (cp-bcp > i)
						badinput = 1;
					if (badinput) {
						sprintf(errmsg,"Key too long (max %d chars).",i);
						BeepErr(errmsg);
						continue;
					}
				}
				if (fptr->index == i_access) {
					if (Validated(fields[i_access]->data)) {
						recflags |= REC_VALID;
					} else {
						sprintf(errmsg,
							"You don't have permission to use this %s",
							fields[i_access]->str);
						GetAnyKey(errmsg);
						/* put the access field back to previous value */
						strcpy(fields[i_access]->data,fields[i_access]->prevdata);
						RedrawField(fptr);
						continue;
					}
				} else if (fields[fptr->index]->keyindex >= 0) {
					keystr = (char *)NULL;
					if ((changed=checkkeyfield(fptr->index,&keystr)) < 0) {
						/* put the field back to previous value */
						strcpy(fields[fptr->index]->data,fields[fptr->index]->prevdata);
						RedrawField(fptr);
						continue;
					}
					if (changed == 0) {
						temp = fields[fptr->index]->keyindex;
						len = strlen(keystr);
						savescreen = curscreen;
						fptr = firstscreen->begin;
						curscreen = firstscreen;
						do {
							i = fptr->index;
							if (fields[i]->keyindex == temp) {
								if (cp=StrCaseStr(fields[i]->data,keystr)) {
									if ((cp == fields[i]->data || *(cp-1) == ' ') &&
						    			(*(cp+len) == '\0' || *(cp+len) == ' '))
										break;
								}
							}
							if (fptr == curscreen->end) {
								if (curscreen != curscreen->next) {
									curscreen = curscreen->next;
									fptr = curscreen->begin;
								} else
									fptr = curscreen->begin;
							} else
								fptr = fptr->next;
						} while (fptr != firstscreen->begin);
						if (savescreen != curscreen) wclear(curscr);
						RedrawScreen();
					}
					if (X_Doing != X_RM && changed == 0 && direction == DIRECT_RET) continue;
				}
			} else {
				badinput = 1;
				(void) putc('\007', stdout);
				DispMsg(fptr->y_error, fptr->x_error, STANDOUT,
					"Invalid input for this field.");
				continue;
			}
		}
		if (changed) {
			recflags |= REC_MODIFIED;
			strcpy(fields[fptr->index]->prevdata,fields[fptr->index]->data);
			freepkeyfield = 0;
		}

		/*
		 * the only thing you can do in X_RM is enter a primary key so
		 * if they try to move to another field, assume they are done
		 * and act as if escape was pressed (i.e. remove the host ).
		 */
		if (X_Doing == X_RM)
			direction = DIRECT_ESC;

		/*
		 *  Erase dashes.
		 */
		temp = strlen(fields[fptr->index]->data);
		wmove(pwin,fptr->y_input, fptr->x_input+temp);
		temp = fields[fptr->index]->len - temp;
		while (temp-- > 0)
			waddch(pwin,' ');

		switch (direction) {
			case DIRECT_BACKWARD:
				curscreen = curscreen->prev;
				fptr = curscreen->begin;
				wclear(curscr);
				wrefresh(curscreen->win);
				break;
			case DIRECT_FORWARD:
				curscreen = curscreen->next;
				fptr = curscreen->begin;
				wclear(curscr);
				wrefresh(curscreen->win);
				break;
			case DIRECT_DOWN:
				if (fptr == curscreen->end)
					fptr = curscreen->begin;
				else
					fptr = fptr->next;
				break;
			case DIRECT_UP:
				if (fptr == curscreen->begin)
					fptr = curscreen->end;
				else
					fptr = fptr->prev;
				break;
			case DIRECT_ESC:
				if (!MissingData()) {
					if (curscreen != firstscreen) {
						curscreen = firstscreen;
						fptr = firstscrfield;
						wclear(curscr);
						wrefresh(curscreen->win);
					} else
						fptr = firstscrfield;
					if (recflags&REC_VALID)
						dealwithrec();
					else
						GetAnyKey("Sorry, you do not have permission to save this record");
				}
				break;
			case DIRECT_RET:
				if (fptr == curscreen->end) {
					if (curscreen != curscreen->next) {
						curscreen = curscreen->next;
						fptr = curscreen->begin;
						wclear(curscr);
						wrefresh(curscreen->win);
					} else {
						fptr = curscreen->begin;
					}
				} else
					fptr = fptr->next;
				break;
			case DIRECT_NONE:
				break;
		}
	}
}
