#ifndef lint
static char rcsid[] = "$Header: $";
#endif

/*
 * $Log:$
 */

#include "common.h"

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <strings.h>

#ifdef REMOTE
typedef struct savestrs {
	char *str;
	struct savestrs *next;
} savestrs_t;

savestrs_t *firstline, *curline;
savestrs_t *firstscrhf=0, *curscrhf;
savestrs_t *firstfldhf=0, *curfldhf;
#endif

/*
 * if index is in the user-defined range (above 0), then output help for
 * the field that index refers to, getting the help text from the
 * FieldsHelpFile.  if the index matches one of the other help topics,
 * then we output the help from ScreenHelpFile instead.  the format of the
 * help files is such that each line of help begins with a string, a
 * single tab or space, then the help text until end of line.  the string
 * is the user-defined field name if we're giving help on a field, or
 * S_GENHELP (general help), S_CHOICEHELP (choice box help), or S_EDITHELP
 * (pseudo-vi mode help), for the other types of help.
 */
HelpThem(index,fptr)
	int index;
	scrfield_t *fptr;
{
	FILE *fp;
	char *srchstr;
	int i, row, col, authorized, openbrack;
	register char *cp, *bcp, *username;
	char *helpfile, *helpline;

	switch (index) {
		case I_GENHELP:
			srchstr = S_GENHELP;
			break;
		case I_CHOICEHELP:
			srchstr = S_CHOICEHELP;
			break;
		case I_EDITHELP:
			srchstr = S_EDITHELP;
			break;
		default:
			srchstr = fields[index]->str;	/* get field identifier */
			break;
	}
#ifdef REMOTE
	if (index==I_GENHELP || index==I_CHOICEHELP || index==I_EDITHELP)
		firstline = firstscrhf;
	else
		firstline = firstfldhf;
	if (!firstline) {
		if (index==I_GENHELP || index==I_CHOICEHELP || index==I_EDITHELP)
			fprintf(REMOTEIN,"%s %s\n",C_CAT,S_SCREENHF);
		else
			fprintf(REMOTEIN,"%s %s\n",C_CAT,S_FIELDSHF);
		fflush(REMOTEIN);
		while (fgets(linein, LINEMAX, REMOTEOUT) != NULL) {
			if (*linein == '\n' || *linein == '#')	/* ignore comment */
				continue;
			if (linein[3] != '-')
				break;
			linein[LastCol] = '\0';			/* truncate line */
			if (!firstline)
				firstline = curline = (savestrs_t *)malloc(sizeof(savestrs_t));
			else {
				curline->next = (savestrs_t *)malloc(sizeof(savestrs_t));
				curline = curline->next;
			}
			if (curline == (savestrs_t *)NULL ||
					(curline->line=(char *)NewStr(linein+4)) == (char *)NULL) {
				DispMsg(LastLine,0,STANDOUT,"out of memory.");
				return;
			}
			curline->next = (savestrs_t *)NULL;
		}
		if (index==I_GENHELP || index==I_CHOICEHELP || index==I_EDITHELP)
			firstscrhf = firstline;
		else
			firstfldhf = firstline;
	}
	curline = firstline;
#else
	switch (index) {
		case I_GENHELP:
			helpfile = ScreenHelpFile;
			break;
		case I_CHOICEHELP:
			helpfile = ScreenHelpFile;
			break;
		case I_EDITHELP:
			helpfile = ScreenHelpFile;
			break;
		default:
			helpfile = FieldsHelpFile;
			break;
	}
	if ((fp = fopen(helpfile, "r")) == NULL) {
		DispMsg(LastLine,0,STANDOUT,"Can't open help file (see admin)");
		return;
	}
#endif

	row = 0;			/* start at top of screen */

	(void) wclear(curscr);
	(void) wstandend(curscr);

	while (1) {
#ifdef REMOTE
		if (curline)
			cp = bcp = curline->line;
		else
			break;
		curline = curline->next;
#else
		if (fgets(linein, LINEMAX, fp))
			cp = bcp = linein;
		else
			break;
		linein[LastCol] = '\0';			/* truncate line */
#endif
		if (*cp == '\n' || *cp == '#')	/* ignore comment */
			continue;
		while (*cp && !isspace(*cp))
			cp++;
		if (STRNEQ(bcp, srchstr, cp-bcp)) {	/* we have a match */
			if (row == 0)
				(void) wstandout(curscr);
			mvwaddstr(curscr, row, 0, &bcp[cp-bcp]);
			if (row == 0)
				(void) wstandend(curscr);
			if (++row >= LastLine) {
				break;
			}
		}
	}

	if (row == 0) {		/* unable to get any help info */
		mvwaddstr(curscr, SecLastLine, 0,
				  "Sorry, no help is available for this field.");
	} 

	if ((index == i_access) && !(row >= LastLine)) {
		/* show the access choices from the validation file */
		col=1;	/* column to print next access string at */

		for (i=0; i<naccess && row<LastLine; i++) {
			if ((col+fields[i_access]->len) > LastCol) {
				col=1;
				row++;
			}
			if (Validated(accesschoices[i])) {
				(void) wstandout(curscr);
				mvwaddstr(curscr, row, col, accesschoices[i]);
				(void) wstandend(curscr);
			} else
				mvwaddstr(curscr, row, col, accesschoices[i]);
			col += fields[i_access]->len + 1;
		}

		row += 2;
	}

	/*
	 *  Display the regular expression used on this field.
	 */

	if (row < LastLine && index != I_GENHELP && index != I_CHOICEHELP && index != I_EDITHELP) {
		if (fields[index]->keyindex >= 0) {
			sprintf(msg,"This is a \"%s\" key field.",
				keys[fields[index]->keyindex]->str);
			mvwaddstr(curscr, row, 1, msg);
			if (index == i_pkey)
				waddstr(curscr,"  It is the primary key field.");
			i = (int)' ';
			if (fields[index]->allow[i]) {
				sprintf(msg,"Each space-separated key may be no more than %d characters long.",keys[fields[index]->keyindex]->len);
				mvwaddstr(curscr, ++row, 1, msg);
			}
			row += 2;
		}
		if (fields[index]->choice) {
			mvwaddstr(curscr, row, 1, "This is a choice box field");
			if (fields[index]->choice->maxchosen == 1)
				waddstr(curscr,", only 1 selection can be made.");
			else if (fields[index]->choice->maxchosen > 0) {
				sprintf(msg,", only %d selections can be made.");
				waddstr(curscr,msg);
			} else
				waddch(curscr,'.');
			row += 2;
		}
		mvwaddstr(curscr, row++, 1, "Allowed: ");
		openbrack = 0;
		for (cp=fields[index]->allowstr; *cp; cp++) {
			switch (*cp) {
				case 'A': case 'C': case 'D': case 'X':
				case 'O': case 'L': case 'U': case 'S': case '!':
					if (openbrack) {
						waddstr(curscr,"], ");
						openbrack = 0;
					} else if (cp != fields[index]->allowstr)
						waddstr(curscr,", ");
					if (*cp == '!') {
						if (*(cp+1) == '\0')
							break;
						waddstr(curscr,"no ");
						cp++;
					} else if (*cp != 'S')
						waddstr(curscr,"all ");
					break;
				default:
					break;
			}
			switch (*cp) {
				case 'A':
					waddstr(curscr,"printable chars");
					break;
				case 'C':
					waddstr(curscr,"letters");
					break;
				case 'D':
					waddstr(curscr,"decimal digits");
					break;
				case 'X':
					waddstr(curscr,"hex digits");
					break;
				case 'O':
					waddstr(curscr,"octal digits");
					break;
				case 'L':
					waddstr(curscr,"lowercase letters");
					break;
				case 'U':
					waddstr(curscr,"uppercase letters");
					break;
				case 'S':
					waddstr(curscr,"spaces");
					break;
				case '\\':
					if (*(cp+1) == '\0')
						break;
					cp++;
				default:
					if (!openbrack) {
						if (cp != fields[index]->allowstr)
							waddstr(curscr,", [");
						else
							waddch(curscr,'[');
						openbrack++;
					}
					if (isprint(*cp)) waddch(curscr,*cp);
			}
		}
		if (openbrack) waddch(curscr,']');
		if (index == i_pkey) {
			if (cp != fields[index]->allowstr)
				waddstr(curscr,", ");
			waddstr(curscr,"(and no spaces)");
		}
		mvwaddstr(curscr, row, 1, "Reg Exp: ");
		waddstr(curscr, fields[index]->exp);
	}

	HitAnyKey();
}
