#ifndef lint
static char rcsid[] = "$Header: $";
#endif

/*
 * $Log:$
 */

#define MAIN
#include "common.h"

#include <sys/ioctl.h>
#include <sys/wait.h>

#include <signal.h>
#include <netdb.h>
#include <ctype.h>
#include <pwd.h>
#include <strings.h>
#if SYSLOG
#include <syslog.h>
#endif
#include <stdlib.h>
#if LOGTOFILE
#include <fcntl.h>
#endif

char *remoteargv[3] = { DUMPPROG", "-v", 0 };
char *remoteenvp[1] = { 0 };

static int gotsignal=0;
void interrupt(), ignoreinterrupt();

main(argc,argv)
	int argc;
	char *argv[];
{
	FILE *fp;
	int retval, doingwhatflag;
#ifdef REMOTE
	pid_t childpid;
	int childstdin[2], childstdout[2];
#endif

#ifdef lint
	retval = gsize;
#endif

	umask(UMASK);
	ProgName = (ProgName = rindex(argv[0],'/')) ? ++ProgName : *argv;
	pid = getpid();
	(void) gethostname(HostName,MAXHOSTNAMELEN);

#if SYSLOG
	openlog(ProgName, LOG_PID, SYSLOGFAC);
#endif

	if (setinvoker((uid_t) getuid()) < 0) {
		(void) fprintf(stderr, "%s: Your login does not exist.\n", ProgName);
		exit(1);
	}

#ifndef REMOTE
	if (STREQ(ProgName,DaemonProg))
		X_Doing = X_DAEMON;
	else
#endif
	if (STREQ(ProgName,AddProg))
		X_Doing = X_ADD;
	else if (STREQ(ProgName,RmProg))
		X_Doing = X_RM;
	else if (STREQ(ProgName,BadProg))
		X_Doing = X_BAD;
	else if (STREQ(ProgName,BrmProg))
		X_Doing = X_BRM;
	else {	  /* the name this program is going under is unknown */
		do {
			(void) printf("Are you:\n\t%d) Adding/changing a record\n\t%d) Removing a record\n\t%d) Batch-adding record(s)\n\t%d) Batch-removing record(s)\n? ", X_ADD, X_RM, X_BAD, X_BRM);
			(void) fflush(stdout);
			if (fgets(msg, MSGSIZ, stdin) == NULL)
				exit(1);
			if (isdigit(*msg)) {
				X_Doing = atoi(msg);
				if (X_Doing == X_ADD || X_Doing == X_RM || X_Doing == X_BAD || X_Doing == X_BRM)
					break;
			}
			(void) putc('\007', stdout);
		} while (1);
	}

#ifdef REMOTE
	if (pipe(childstdin) < 0 || pipe(childstdout) < 0) {
		SetSysErr();
		sprintf(errmsg,"%s: pipe: %s",ProgName,syserr);
		return(-1);
	}

	fprintf(stderr,"connecting to remote daemon...");
	fflush(stderr);
	if ((childpid=fork()) < 0) {
		SetSysErr();
		sprintf(errmsg,"%s: fork: %s",ProgName,syserr);
		return(-1);
	} else if (childpid == 0) {
		/* close stdin fd, and make sure we get 0 back again */
		if (close(0) < 0 || dup(childstdin[0]) != 0)
			exit(1);
		/* close stdout fd, and make sure we get 1 back again */
		if (close(1) < 0 || dup(childstdout[1]) != 1)
			exit(1);
		if (execve(ETC/DUMPPROG",remoteargv,remoteenvp) < 0) {
			SetSysErr();
			fprintf(stderr,"%s: execve: %s",ProgName,syserr);
			exit(1);
		}
		/* if execve succeeds, then we don't get to this point */
	} else {
		if (!(REMOTEOUT=fdopen(childstdout[0],"r")) ||
		    !(REMOTEIN=fdopen(childstdin[1],"w"))) {
			SetSysErr();
			fprintf(stderr,"%s: fdopen: %s",ProgName,syserr);
			exit(1);
		}
		fgets(linein,LINEMAX,REMOTEOUT);
		fprintf(REMOTEIN,"%s %s\n",C_USER,InvokerAcct);
		fflush(REMOTEIN);
		if (!fgets(linein,LINEMAX,REMOTEOUT)) {
			fprintf(stderr,"read from remote failed.\n");
			exit(1);
		}
		if (linein[0] != '2') {
			fprintf(stderr,"%s",linein+4);
			exit(1);
		}
		fprintf(stderr,"done.\n");
		fflush(stderr);
	}
#else
	/* we exit within Daemon() */
	if (X_Doing == X_DAEMON) {
		EnableInterrupts();
		Daemon();
	}
#endif

	if (InitValidation() < 0) {
		fprintf(stderr,"%s\n",errmsg);
		exit(1);
	}

	if (X_Doing == X_ADD && argc >= 2) {
		if (!hasaccessall) {
			fprintf(stderr, "%s: Sorry, you must have \"%s\" access to use extended options.\n",ProgName,S_ALL);
			exit(1);
		}
		if (STRCASEEQ(argv[1],"-killall"))
			SendSignal(SIGTERM);
		else if (STRCASEEQ(argv[1],"-mesg"))
			SendSignal(SIGHUP);
		else if (STRCASEEQ(argv[1],"-init")) {
			getttyinfo();
			DisableInterrupts();
			if (DBConfig(1) < 0) {
				(void) fprintf(stderr,"%s\n",errmsg);
				exit(1);
			}
			if (ScreenConfig(1) < 0) {
				(void) fprintf(stderr,"%s\n",errmsg);
				exit(1);
			}
			exit(0);
		} else if (STRCASEEQ(argv[1],"-lock"))
			exit(LockOutAll(1));
		else if (STRCASEEQ(argv[1],"-unlock"))
			exit(UnLockOutAll());
		else if (STRCASEEQ(argv[1],"-list"))
			doingwhatflag = 0;
		else if (STRCASEEQ(argv[1],"-listall"))
			doingwhatflag = 1;
		else if (STRCASEEQ(argv[1],"-clean"))
			doingwhatflag = 2;
		else if (STRCASEEQ(argv[1],"-cleanall")) {
			cleanall = 1;
			LockOutAll(0);
			doingwhatflag = 3;
		} else
			usage();
		if (DBConfig(0) < 0) {
			fprintf(stderr,"%s\n",errmsg);
			exit(1);
		}
		EnableInterrupts();
		DBLock();
		InitDB();
		if (doingwhatflag != 3)
			CheckDB(doingwhatflag);
		else {
			CleanAll();
			UnLockOutAll();
		}
		CleanUp();
		exit(0);
	} else if (X_Doing != X_BAD && X_Doing != X_BRM && argc > 1) {
		(void) fprintf(stderr, "%s: too many arguments.\n",ProgName);
		exit(1);
	}

	EnableInterrupts();

	getttyinfo();

	CheckLockAll();
	if (DBConfig(0) < 0) {
		(void) fprintf(stderr,"%s\n",errmsg);
		exit(1);
	}
	InitDB();

	if (ScreenConfig(0) < 0) {
		(void) fprintf(stderr,"%s\n",errmsg);
		exit(1);
	}
	DBLock();

	if (X_Doing == X_BAD || X_Doing == X_BRM) {
		Batch(argc,argv);
		RmDBLock();
		exit(0);
	}

	if (initscr() == ERR) {		/* this shouldnt happen much, but... */
		(void) fprintf(stderr, "Insufficient memory, try later\n");
		exit(1);
	}

	nonl();					/* dont map \r to \n */
	noecho();				/* dont echo characters as entered */
	cbreak();				/* make chars avail when typed */
	clear();				/* clear the screen -- necessary? */

	screenon = 1;

	ShowMessage(MotdFile,0);

	RedrawScreen();		/* draw the screen */

	/* The only way out of GetScreen is an interrupt (usually ^C). */
	GetScreen();
}

/*
 *	Determine number of lines (LastLine) and columns (LastCol) on this
 *  terminal.  This must be done before configuring the screen so we
 *  can make sure the bottom 2 lines are unused.
 */
getttyinfo() {
	char *termtype;
#ifdef TIOCGWINSZ
	struct winsize win;
#endif TIOCGWINSZ

	if (X_Doing != X_BAD && X_Doing != X_BRM) {
#ifdef TIOCGWINSZ
		if (ioctl(1, TIOCGWINSZ, (char *) &win) != -1) {
			LastLine = win.ws_row;
			LastCol = win.ws_col;
		} else {
#endif TIOCGWINSZ
			if ((termtype=getenv("TERM")) == NULL) {
				(void) fprintf(stderr, "%s: Can't get terminal type.\n", ProgName);
				exit(1);
			}
			switch(tgetent(msg,termtype)) {
				case -1:
					fprintf(stderr, "%s: Can't read /etc/termcap\n", ProgName);
					exit(1);
					break;
				case 0:
					fprintf(stderr, "%s: No termcap for %s\n", ProgName, termtype);
					exit(1);
					break;
			}
			LastLine = tgetnum("li");
			LastCol = tgetnum("co");
#ifdef TIOCGWINSZ
		}
#endif TIOCGWINSZ

		if (LastLine <= 0) {	
			(void) printf("%s: Assuming 24 lines on this screen", ProgName);
			(void) fflush(stdout); sleep(1); (void) printf(".");
			(void) fflush(stdout); sleep(1); (void) printf(".");
			(void) fflush(stdout); sleep(1); (void) printf(".");
			(void) fflush(stdout); sleep(1); (void) printf("\n");
			LastLine = 24;
		}
		if (LastCol <= 0) {	
			(void) printf("%s: Assuming 80 columns on this screen", ProgName);
			(void) fflush(stdout); sleep(1); (void) printf(".");
			(void) fflush(stdout); sleep(1); (void) printf(".");
			(void) fflush(stdout); sleep(1); (void) printf(".");
			(void) fflush(stdout); sleep(1); (void) printf("\n");
			LastCol = 80;
		}
		LastLine -= 1;			/* line/column count starts at 0 */
		SecLastLine = LastLine - 1;
		LastCol -= 1;
	} else {
		/* actually, it doen't matter what LastLine is */
		LastLine = 0;
	}
}

/*
 * SIGHUP is used to send messages to interactive users.  SIGINT (^C) and
 * SIGQUIT are used to quit the program.  SIGTERM is used to immediately
 * and cleanly kill processes.  SIGALRM is used by daemon process to time
 * out if no activity is taking place for a specified period of time.
 */
EnableInterrupts() {
	(void) signal(SIGALRM, interrupt);
	(void) signal(SIGHUP, interrupt);
	(void) signal(SIGINT, interrupt);	/* trap user interrupts */
	(void) signal(SIGTERM, interrupt);
	(void) signal(SIGQUIT, interrupt);
	if (gotsignal)
		interrupt(gotsignal);
}

DisableInterrupts() {
	(void) signal(SIGHUP, ignoreinterrupt);
	(void) signal(SIGINT, ignoreinterrupt);	/* trap user interrupts */
	(void) signal(SIGTERM, ignoreinterrupt);
	(void) signal(SIGQUIT, ignoreinterrupt);
	(void) signal(SIGALRM, ignoreinterrupt);
}

/*
 * We got an interrupt.  If we have a screen and the signal is HUP, we
 * display what's in file HUPMesgFile, then the program continues normally
 * after user finishes reading message.  If we have a screen and the
 * signal is QUIT or INT, give option not to quit.  If we have a screen,
 * and the signal is TERM, then tell user we're quitting, then exit.
 * If we don't have a screen (running batch mode), then we quit
 * immediately after printing message to stderr.
 */
static void interrupt(sig)
	int sig;
{
	int x, y, i, PromptMsg();
	char *promptmsg;

	if ((X_Doing == X_DAEMON || X_Doing == X_BAD || X_Doing == X_BRM || cleanall) && sig == SIGHUP)
		return;
	(void) signal(SIGINT, ignoreinterrupt);
	if ((X_Doing == X_ADD || X_Doing == X_RM) && screenon && sig != SIGTERM && sig != SIGALRM) {
		if (sig == SIGHUP) {
			ShowMessage(HUPMesgFile,1);
		} else {
			promptmsg = "This record has been modified, do you really want to quit? ";
			if (recflags&REC_MODIFIED && !PromptMsg(promptmsg)) {
				(void) signal(SIGINT, interrupt);
				return;
			}
			CleanUp();
			ResetScreen();
			exit(0);
		}
		(void) signal(SIGINT, interrupt);
		return;
	} else {
		if (X_Doing == X_DAEMON) {
			if (sig == SIGALRM)
				sprintf(errmsg,"time out from no activity.");
			else
				sprintf(errmsg,"received signal %d.",sig);
			FatalError(errmsg);
		}
		if (sig == SIGALRM)
			sprintf(msg,"Quit because of ALRM signal.\n");
		else if (sig == SIGINT)
			sprintf(msg,"Quit because of interrupt (^C).\n");
		else if (sig == SIGTERM)
			sprintf(msg,"Quit because of TERM signal.\n");
		else
			sprintf(msg,"Quit because of signal #%d.\n",sig);
#if SYSLOG
		syslog(LOG_INFO,msg);
#endif
#if LOGTOFILE
		LogToFile(msg);
#endif
		CleanUp();
		if (X_Doing == X_ADD || X_Doing == X_RM)
			if (screenon) ResetScreen();
		else if (X_Doing == X_BAD || X_Doing == X_BRM) {
			printf("550 ");
			fprintf(stdout,"%s: %s",ProgName,msg);
			fflush(stdout);
		}
		exit(0);
	}
}

/* just remember that we received an interrupt */
static void ignoreinterrupt(sig)
	int sig;
{
	gotsignal = sig;
}

/*
 *  If we're exiting, then we don't want to leave any locks or reserved
 *  keys around.
 */
CleanUp() {
	DisableInterrupts();
#ifdef REMOTE
	if (REMOTEIN) {
		fprintf(REMOTEIN,"%s\n",C_QUIT);
		fflush(REMOTEIN);
		fclose(REMOTEIN);
	}
#endif
	if ((X_Doing == X_BAD || X_Doing == X_BRM || cleanall) && lockall == 1)
		UnLockOutAll();
	if (cleanall)
		rm(NewDBDir);
	if (X_Doing == X_DAEMON) {
		int i;
		long tloc;
		union wait status;

#if SYSLOG || LOGTOFILE
		sprintf(msg, "disconnect by %s\n",PeerHostName);
#if SYSLOG
		syslog(LOG_INFO,msg);
#endif
#if LOGTOFILE
		LogToFile(msg);
#endif
#endif
		time(&tloc);
		printf("221 %s %s %s closing connection, %s",HostName,ProgName,version,ctime(&tloc));
		fflush(stdout);
		RmDBLock();
	} else {
		CloseData();
		FreeAllKeys();
		RmAllRecLocks();
		if (freepkeyfield)
			FreeKeys(fields[i_pkey]->keyindex,fields[i_pkey]->data,"");
		RmDBLock();
	}
#if LOGTOFILE
	CloseLogFile();
#endif
}

static usage () {
	fprintf(stderr,"usage: %s [-<FLAG>]\n", ProgName);
	fprintf(stderr,"  -init     re-initialize database with config files\n");
	fprintf(stderr,"  -list     list all reserved keys and locks\n");
	fprintf(stderr,"  -listall  same as list, but include erroneous keys (takes longer)\n");
	fprintf(stderr,"  -lock     lock out any new accesses to database\n");
	fprintf(stderr,"  -unlock   remove lock created with -lock option\n");
	fprintf(stderr,"  -clean    remove all reserved keys and database locks\n");
	fprintf(stderr,"  -cleanall rewrite database files, removing empty records and bad keys\n");
	fprintf(stderr,"  -mesg     send message to interactive processes\n");
	fprintf(stderr,"  -killall  kill all processes currently running\n");
	exit(1);
}

/*
 * given a `uid', get the password entry and fill in associated `Invoker*'
 * fields.  return value is 0 if all went well, -1 if getpwuid() failed.
 */
static int setinvoker(uid)
	uid_t uid;
{
	struct passwd *pp;
	register char *cp;
	register int i;

	InvokerUid = uid;

	if ((pp=getpwuid((int) InvokerUid)) == NULL) {
		return(-1);
	}

	(void) strncpy(InvokerAcct, pp->pw_name, IACCTLEN);	/* acct name */

	/*
	 *  Go thru first field in GECOS assigning it to InvokerName[].
	 *  This is complicated by the BSD `&' hack; an ampersand in the
	 *  name field is supposed to be expanded to the account name.
	 */
	for (i = 0, cp = pp->pw_gecos; i < INAMELEN && *cp != ',' && *cp; cp++) {
	if (*cp == '&') {	/* Argh! */
		(void) strncpy(&InvokerName[i], InvokerAcct, INAMELEN-i);
		if (islower(InvokerName[i]))
		InvokerName[i] = toupper(InvokerName[i]);
		i += strlen(InvokerAcct);		/* `i' may be > INAMELEN */
	} else
		InvokerName[i++] = *cp;
	}

	InvokerAcct[IACCTLEN] = 
	InvokerName[MIN(i,INAMELEN)] = '\0';

	return(0);
}

/*
 * works like strdup().  some machines don't have this so might as well
 * just use this instead.
 */
char *NewStr(s)
	char *s;
{
	static char *news;

	news = (char *)malloc(strlen(s)+1);
	if (news != (char *)NULL)
		strcpy(news,s);
	return(news);
}

#if LOGTOFILE
static int logfileopen = 0, logfilefd;
static char logmsg[1024];

LogToFile(s)
	char *s;
{
	static int len;
	static long tloc;

	if (!logfileopen) {
		logfilefd = open(LogFile,O_WRONLY|O_APPEND|O_CREAT,LOGFILEMODE);
		if (logfilefd < 0)
			return;
		else
			logfileopen = 1;
	}
	time(&tloc);
	sprintf(logmsg,"%s%s[%d]: %s",ctime(&tloc),ProgName,pid,s);
	logmsg[24] = ' ';
	len = strlen(logmsg);
	if (*(logmsg+len-1) != '\n') {
		*(logmsg+len) = '\n';
		*(logmsg+len+1) = '\0';
		len++;
	}
	write(logfilefd,logmsg,len);
	if ((X_Doing == X_BAD || X_Doing == X_BRM || cleanall) && lockall)
		return; /* don't have to close it each time */
	close(logfilefd);
	logfileopen = 0;
}

CloseLogFile() {
	if (logfileopen)
		close(logfilefd);
	logfileopen = 0;
}
#endif
