#ifndef lint
static char rcsid[] = "$Header: /cujo/users/src/local/common/bin/addhost/admintools/mkhostsections/RCS/parsehosts.c,v 1.1 90/08/23 20:52:54 hardt Exp $";
#endif

/*
 * $Log:	parsehosts.c,v $
 * Revision 1.1  90/08/23  20:52:54  hardt
 * Initial revision
 * 
 */

/*
 * file: parsehosts.c
 *
 * This program is intended to parse data from stdin, assumed to be from
 * the addhost database.  It will then parse and reformat it to a form
 * suitable for the /etc/hosts file, outputting this to stdout.
 *
 * we assume input will be in the following order, on one line, with tabs
 * separating each field.  words in all caps refer to field names.
 *
 *    INETDOMAIN MODEL LOCATION INETADDR1 HOSTNAME
 *    INETADDR2 INETNAME2 INETADDR3 INETNAME3 INETALIASES COMMENT1
 *
 * output will be in the form of the following.  if the required fields
 * have info in them (non-empty), then from 1 to 3 lines may be produced
 * by a single host entry in addhost, one line for each internet address.
 *
 * if INETADDR1 and INETDOMAIN both have info in them then
 *    INETADDR1 HOSTNAME HOSTNAME.INETDOMAIN INETALIASES   # MODEL, LOCATION
 *
 * if INETADDR2 and INETNAME2 both have info in them then
 *    INETADDR2 INETNAME2 INETNAME2.INETDOMAIN             # MODEL, LOCATION
 *
 * if INETADDR3 and INETNAME3 both have info in them then
 *    INETADDR3 INETNAME3 INETNAME3.INETDOMAIN             # MODEL, LOCATION
 *
 * if the MODEL and LOCATION fields are both empty, then COMMENT1 is used
 * in place of "MODEL, LOCATION" as shown above.
 *
 * Output is truncated to 79 characters per line unless this would cut into
 * something important like the aliases.
 *
 * Warnings and error messages are part of the output and should be
 * removed, and dealt with if necessary.  They are printed with the
 * first character of the line being a '?' to allow easy separation
 * of messages and data.  These are on a per-host basis and are not
 * fatal.
 *
 * fatal error occurs if line encountered where too few fields were present.
 */
#include <stdio.h>

#define BUFLEN		1024					/* input buffer for one line */
#define NFIELDS		11						/* number of fields */
#define EMPTY(f) (strcmp(f,"?") == 0)		/* "?" means empty field */
#define NOTEMPTY(f) (strcmp(f,"?") != 0)	/* "?" means empty field */

main(argc, argv)
int argc;
char **argv;
{
	char inbuf[BUFLEN];
	char buf1[BUFLEN];
	char buf2[BUFLEN];
	char *field[NFIELDS];
	char *inetdomain, *model, *location, *inetaddr1, *hostname, *inetaddr2,
		 *inetname2, *inetaddr3, *inetname3, *inetaliases, *comment1;
	int i;
	char *cp, *bcp;
	char c;

	while (gets(inbuf,BUFLEN) != (char*)NULL) {
		cp = inbuf;
		for (i=0; i<NFIELDS; i++) {
			field[i] = cp;
			while ((*cp != '\0') && (*cp != '\t')) cp++;
			if (*cp == '\0')
				break;
			*cp = '\0';
			cp++;
		}
		if (i != NFIELDS-1) {
			printf("?error: %s: I scanned %d tab-separated inputs. Should have scanned %d.\n", argv[0], i+1, NFIELDS);
			exit(1);
		}

		/* for readability later */
		inetdomain	= field[0];	model		= field[1];	location	= field[2];
		inetaddr1	= field[3];	hostname	= field[4];	inetaddr2	= field[5];
		inetname2	= field[6];	inetaddr3	= field[7];	inetname3	= field[8];
		inetaliases	= field[9]; comment1	= field[10];

		if (NOTEMPTY(inetdomain)) {
			if (NOTEMPTY(inetaliases))
				sprintf(buf1,"%s %s.%s %s",hostname,hostname,inetdomain,inetaliases);
			else
				sprintf(buf1,"%s %s.%s",hostname,hostname,inetdomain);
		} else {
			if (NOTEMPTY(inetaliases))
				sprintf(buf1,"%s %s",hostname,inetaliases);
			else
				sprintf(buf1,"%s",hostname);
			printf("?warning: hostname=%s, inetdomain=%s\n",hostname,inetdomain);
		}

		if (NOTEMPTY(inetaddr1)) {
			if (EMPTY(model) && EMPTY(location)) {
				if (EMPTY(comment1))
					sprintf(buf2,"%-16s%-39s",inetaddr1,buf1);
				else
					sprintf(buf2,"%-16s%-39s # %s",inetaddr1,buf1,comment1);
			} else
				sprintf(buf2,"%-16s%-39s # %s, %s",inetaddr1,buf1,model,location);
		} else {
			printf("?warning: hostname=%s, inetaddr1=%s\n",hostname,inetaddr1);
			continue;
		}

		/*
		 * we need to make sure that the entirety of buf1
		 * shows up in the hosts file.
		 */
		if (strlen(buf1) + 16 > 79)
			printf("%s\n",buf2);
		else
			printf("%.79s\n",buf2);

		if (NOTEMPTY(inetname2)) {
			if (NOTEMPTY(inetaddr2)) {
				sprintf(buf1,"%s %s.%s",inetname2,inetname2,inetdomain);
				if (EMPTY(model) && EMPTY(location)) {
					if (EMPTY(comment1))
						sprintf(buf2,"%-16s%-39s",inetaddr2,buf1);
					else
						sprintf(buf2,"%-16s%-39s # %s",inetaddr2,buf1,comment1);
				} else
					sprintf(buf2,"%-16s%-39s # %s, %s",inetaddr2,buf1,model,location);
				/*
				 * we need to make sure that the entirety of buf1
				 * shows up in the hosts file.
				 */
				if (strlen(buf1) + 16 > 79)
					printf("%s\n",buf2);
				else
					printf("%.79s\n",buf2);
			} else {
				printf("?warning: hostname=%s, inetname2=%s, inetaddr2=%s\n",
						hostname,inetname2,inetaddr2);
			}
		} else if (NOTEMPTY(inetaddr2)) {
			printf("?warning: hostname=%s, inetname2=%s, inetaddr2=%s\n",
					hostname,inetname2,inetaddr2);
		}
			
		if (NOTEMPTY(inetname3)) {
			if (NOTEMPTY(inetaddr3)) {
				sprintf(buf1,"%s %s.%s",inetname3,inetname3,inetdomain);
				if (EMPTY(model) && EMPTY(location)) {
					if (EMPTY(comment1))
						sprintf(buf2,"%-16s%-39s",inetaddr3,buf1);
					else
						sprintf(buf2,"%-16s%-39s # %s",inetaddr3,buf1,comment1);
				} else
					sprintf(buf2,"%-16s%-39s # %s, %s",inetaddr3,buf1,model,location);
				/*
				 * we need to make sure that the entirety of buf1
				 * shows up in the hosts file.
				 */
				if (strlen(buf1) + 16 > 79)
					printf("%s\n",buf2);
				else
					printf("%.79s\n",buf2);
			} else {
				printf("?warning: hostname=%s, inetname3=%s, inetaddr3=%s\n",
						hostname,inetname3,inetaddr3);
			}
		} else if (NOTEMPTY(inetaddr3)) {
			printf("?warning: hostname=%s, inetname3=%s, inetaddr3=%s\n",
					hostname,inetname3,inetaddr3);
		}
	}
}
