#ifndef lint
static char rcsid[] = "$Header: $";
#endif

/*
 * $Log:$
 */

#include "common.h"

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <strings.h>

typedef struct savestrs {
	char *str;
	struct savestrs *next;
} savestrs_t;

int nstrs;
savestrs_t *firststr, *curstr;
savestrs_t *firstvalid=0, *curvalid;
savestrs_t *firstaccess=0, *curaccess;

/*
 * this is called when entering program to read validation file in,
 * and parse to see what the current user has access to modify or
 * create.
 */
int InitValidation() {
	register char *username, *cp, *access;
	FILE *fp;
	int n,i;

	hasaccessall = 0;

#ifdef REMOTE
	do {
		if (!firstaccess)
			fprintf(REMOTEIN,"%s\n",C_ACCESS);
		else
			fprintf(REMOTEIN,"%s\n",C_VALID);
		fflush(REMOTEIN);
		firststr = (savestrs_t *)NULL;
		nstrs = 0;
		while (fgets(linein,LINEMAX,REMOTEOUT)) {
			if (linein[3] != '-')
				break;
			if (!firststr)
				firststr=curstr=(savestrs_t *)malloc(sizeof(savestrs_t));
			else {
				curstr->next=(savestrs_t *)malloc(sizeof(savestrs_t));
				curstr=curstr->next;
			}
			if (linein[0])
				linein[strlen(linein)-1] = '\0'; /* get rid of newline */
			if (curstr == (savestrs_t *)NULL
					|| (curstr->str=(char *)NewStr(linein+4)) == (char *)NULL) {
				sprintf(errmsg,"out of memory.");
				return(-1);
			}
			curstr->next = (savestrs_t *)NULL;
			nstrs++;
		}
		if (!firstaccess) {
			firstaccess = firststr;
			naccess = nstrs;
		} else {
			firstvalid = firststr;
			nvalid = nstrs;
		}
	} while (firststr != firstvalid);
	if (nvalid == 0 || naccess == 0) {
		sprintf(errmsg,"%s: (%s) permission denied.",ProgName,InvokerAcct);
		return(-1);
	}
	accesschoices = (char **)malloc(sizeof(char *)*naccess);
	validchoices = (char **)malloc(sizeof(char *)*nvalid);
	if (accesschoices == (char **)NULL || validchoices == (char **)NULL) {
		sprintf(errmsg,"out of memory.");
		return(-1);
	}
	for (i=0,curstr=firstaccess; i<naccess; i++,curstr=curstr->next)
		accesschoices[i] = curstr->str;
	for (i=0,curstr=firstvalid; i<nvalid; i++,curstr=curstr->next) {
		validchoices[i] = curstr->str;
		if (STRCASEEQ(validchoices[i],S_ALL))
			hasaccessall = 1;
	}
	return(0);
#else

	if ((fp=fopen(AccessUsersFile,"r"))==(FILE *)NULL) {
		sprintf(errmsg,"%s: Can't open \"%s\".",ProgName,AccessUsersFile);
		return(-1);
	}

	naccess = 0;
	while (fgets(linein,LINEMAX,fp) != NULL) {
		if (*linein == '#' || *linein == '\n')  /* comment, ignore it */
			continue;
		naccess++;
	}
	accesschoices = (char **)malloc(sizeof(char *)*naccess);
	validchoices = (char **)malloc(sizeof(char *)*naccess);
	if (accesschoices == (char **)NULL || validchoices == (char **)NULL) {
		sprintf(errmsg,"out of memory.");
		return(-1);
	}
	fseek(fp,0,0); /* seek to beginning of file */

	n = nvalid = 0;
	while (fgets(linein,LINEMAX,fp) != (char *)NULL) {
		if (*linein == '#' || *linein == '\n')	/* ignore comment lines */
			continue;

		cp = linein;
		while (isspace(*cp)) cp++;
		if (!*cp) continue;
		access = cp;
		while (*cp && !isspace(*cp)) cp++; /* skip to first space or \n */
		if (!*cp) continue;
		*cp++ = '\0';				/* null term access */
		accesschoices[n] = (char *)NewStr(access);
		if (accesschoices[n] == (char *)NULL) {
			sprintf(errmsg,"out of memory.");
			return(-1);
		}

		while (*cp) {							/* move across input line */
			while (isspace(*cp)) cp++;			/* skip leading white space */
			username = cp;						/* found a username */
			while (*cp && !isspace(*cp)) cp++;	/* skip to end of name */
			if (*cp) *cp++ = '\0';				/* set `space' to NULL */
			if (STRCASEEQ(username,InvokerAcct)) {	/* compare usernames */
				validchoices[nvalid++] = accesschoices[n];
				break;
			}
		}
		if (nvalid > 0 && STRCASEEQ(validchoices[nvalid-1],S_ALL))
			hasaccessall = 1;
		if (!STRCASEEQ(accesschoices[n],S_ALL))
			n++;
	}

	if (nvalid == 0) {
		sprintf(errmsg,"%s: (%s) permission denied.",ProgName,InvokerAcct);
		return(-1);
	}

	naccess = n;

	(void) fclose(fp);
	return(0);
#endif
}

/*
 * returns 1 if user has access to modify a record with "access".
 * otherwise returns 0.
 */
int Validated(access)
	char *access;
{
	int i;

	if (hasaccessall) return(1);
	for (i=0; i<nvalid; i++)
		if (STRCASEEQ(access,validchoices[i]))
			return(1);
	return(0);
}

/*
 * if host is valid, returns 0.  if an error occurs (including host not
 * valid), sets errmsg and returns -1.
 */
ValidateHost(rhost)
	char *rhost;
{
	register char *cp, *bcp;
	FILE *fp;
	int foundmatch;

	if ((fp=fopen(AccessHostsFile,"r"))==(FILE *)NULL) {
		sprintf(errmsg,"%s: Can't open \"%s\".",ProgName,AccessHostsFile);
		return(-1);
	}

	foundmatch = 0;
	while (fgets(linein,LINEMAX,fp) != (char *)NULL) {
		if (*linein == '#' || *linein == '\n')	/* ignore comment lines */
			continue;

		cp = linein;
		while (isspace(*cp)) cp++;
		if (!*cp) continue;
		bcp = cp;
		while (*cp && !isspace(*cp)) cp++;
		if (*cp) *cp++ = '\0';
#ifndef REMOTE
		if (STRCASEEQ(bcp,rhost)) {
			foundmatch++;
			break;
		}
#else
		if (!STRCASEEQ(bcp,rhost)) continue;

		while (*cp) {							/* move across input line */
			while (isspace(*cp)) cp++;			/* skip leading white space */
			bcp = cp;							/* found a username */
			while (*cp && !isspace(*cp)) cp++;	/* skip to end of name */
			if (*cp) *cp++ = '\0';				/* set `space' to NULL */
			if (!firstruser)
				curruser = firstruser = (rusers_t *)malloc(sizeof(rusers_t));
			else {
				curruser->next = (rusers_t *)malloc(sizeof(rusers_t));
				curruser = curruser->next;
			}
			if (curruser == (rusers_t *)NULL) {
				sprintf(errmsg,"out of memory.");
				return(-1);
			}
			curruser->next = (rusers_t *)NULL;
			if ((curruser->username = (char *)NewStr(bcp)) == (char *)NULL) {
				sprintf(errmsg,"out of memory.");
				return(-1);
			}
		}
#endif
	}
	(void) fclose(fp);
#ifdef REMOTE
	if (!firstruser) { /*}*/
#else
	if (!foundmatch) {
#endif
		sprintf(errmsg,"unprivileged connection attempted by %s.",rhost);
		return(-1);
	}
	return(0);
}
