//==============================================================================
//
// Project  :  RCX2.0 - RIS2.0
// Unit     :  Global Module
// Name     :  RCX2Def
// Date     :  2000.01.12
// Ver.     :  1.00
//
//------------------------------------------------------------------------------
//
// $Copyright (C) 1999 - LEGO Company. All rights reserved.             $
//
// $Workfile:: RCX2Def.h                                                $
// 
// $Date:: 30-03-00 15:24                                               $
//                     
// $Revision:: 3                                                        $
//
// $Author:: Dkmicand                                                   $
//
//------------------------------------------------------------------------------
//
// Contains constant declarations for RCX2 related resources 
//
//==============================================================================

#ifndef RCX2DEF__H
#define RCX2DEF__H        1

//==============================================================================
// Program slot 1 to 5
// Command use: prgm
//==============================================================================

#define P1                0
#define P2                1
#define P3                2
#define P4                3
#define P5                4

//==============================================================================
// Task names 0-9
// Command use: start, stop, delt and SRC_TASKEVENT
//==============================================================================

#define TASK_MY_TASKNAME  0

//==============================================================================
// Subroutine names
// RAM subroutines: 0-7
// Command use: calls, dels
//==============================================================================

// Subroutines in RAM

#define SUB_MY_SUBNAME    0

//==============================================================================
// RCX2 system sounds
// Command use: plays
//==============================================================================

// System sounds

#define SND_CLICK         0
#define SND_BEEP          1
#define SND_SWEEP_DOWN    2
#define SND_SWEEP_UP      3
#define SND_ERROR         4
#define SND_SWEEP_FAST    5

//==============================================================================
// Source names
// Command use: Multiple
//==============================================================================
                
#define SRC_VAR           0 
#define SRC_TIMER         1
#define SRC_CON           2
#define SRC_MOTSTA        3
#define SRC_RAN           4 
#define SRC_PRGM          8 
#define SRC_SENVAL        9 
#define SRC_SENTYPE       10  
#define SRC_SENMODE       11  
#define SRC_SENRAW        12  
#define SRC_SENBOOL       13  
#define SRC_WATCH         14  
#define SRC_MESSAGE       15  
#define SRC_MOTSET        17  
#define SRC_COUNTER       21  
#define SRC_TASKEVENT     23  
#define SRC_EVENTSTATE    25
#define SRC_TIMER100      26  
#define SRC_CLKCNT        27  
#define SRC_UT            28  
#define SRC_LT            29  
#define SRC_HYST          30  
#define SRC_CLKDUR        31  
#define SRC_UARTSET       33  
#define SRC_BATT          34
#define SRC_FWVER         35
#define SRC_INDIRECT      36

//==============================================================================
// Variable names
// Global variables: 0-31
// Local variables : 32-47
// Command use: Together with SRC_VAR
//==============================================================================

// Global variables

#define GV_MY_VARIABLE    0

// Local variables

#define LV_MY_VARIABLE    32

//==============================================================================
// Timer names
// Command use: tmrs, tmrz
//              Together with SRC_TIMER
//==============================================================================

#define TIMER_1           0
#define TIMER_2           1
#define TIMER_3           2
#define TIMER_4           3

//==============================================================================
// Constant names
// Command use: Together with SRC_CON
//==============================================================================

#define K_MY_CONSTANT     0

//==============================================================================
// Output names
// Command use: Together with SRC_MOTSTA and SRC_MOTSET
//==============================================================================

#define OUTPUT_A          0
#define OUTPUT_B          1
#define OUTPUT_C          2

//==============================================================================
// Sensor names
// Command use: senz, sent, senm
//              Together with SRC_SENVAL, SRC_SENTYPE, SRC_SENMODE, SRC_SENRAW
//              and SRC_SENBOOL
//==============================================================================

#define SEN_1             0
#define SEN_2             1
#define SEN_3             2

//==============================================================================
// Virtual sensor names
// Command use: Together with SRC_UPPER, SRC_LOWER, SRC_HYST, SRC_DURATION
//==============================================================================

#define SEN_TIMER_1       3
#define SEN_TIMER_2       4
#define SEN_TIMER_3       5
#define SEN_TIMER_4       6
#define SEN_IR            7
#define SEN_COUNTER_1     8
#define SEN_COUNTER_2     9
#define SEN_COUNTER_3     10


//==============================================================================
// Event names
// Command use: sete (3. parameter)
//==============================================================================

#define ENAME_PRESSED     0
#define ENAME_RELEASED    1
#define ENAME_PERIOD      2
#define ENAME_TRANS       3

#define ENAME_CHANGE      7
#define ENAME_LOW         8
#define ENAME_NORMAL      9
#define ENAME_HIGH        10
#define ENAME_CLICK       11
#define ENAME_2CLICK      12
#define ENAME_CLICK_OL    13
#define ENAME_MESSAGE     14
#define ENAME_OVER_LIMIT  15

//==============================================================================
// Sensor types
// Command use: sent
//              Together with SRC_SENTYPE
//==============================================================================

#define STYPE_NONE        0
#define STYPE_SWITCH      1
#define STYPE_TEMP        2
#define STYPE_LIGHT       3
#define STYPE_ROT         4

//==============================================================================
// Sensor modes
// Command use: senm
//              Together with SRC_SENMODE
//==============================================================================

#define SMODE_RAW         0
#define SMODE_BOOL        1
#define SMODE_TRANS       2
#define SMODE_PERIOD      3
#define SMODE_PERCENT     4
#define SMODE_CELCIUS     5
#define SMODE_FAHRENHEIT  6
#define SMODE_ANGLE       7

//==============================================================================
// Event masks (added by JB)
// Command use: mone
//==============================================================================

#define EMASK_NONE        0x0000
#define EVENT_NONE        0x0000

#define EVENT_BIT_0       0x0001
#define EVENT_BIT_1       0x0002
#define EVENT_BIT_2       0x0004
#define EVENT_BIT_3       0x0008
#define EVENT_BIT_4       0x0010
#define EVENT_BIT_5       0x0020
#define EVENT_BIT_6       0x0040
#define EVENT_BIT_7       0x0080
#define EVENT_BIT_8       0x0100
#define EVENT_BIT_9       0x0200
#define EVENT_BIT_10      0x0400
#define EVENT_BIT_11      0x0800
#define EVENT_BIT_12      0x1000
#define EVENT_BIT_13      0x2000
#define EVENT_BIT_14      0x4000
#define EVENT_BIT_15      0x8000


//==============================================================================
// Touch sensor boolean states
// Setting of touch sensor value
//==============================================================================

#define TVAL_RELEASED     0
#define TVAL_PRESSED      1

//==============================================================================
// Touch sensor ID
// Setting of touch sensor type
//==============================================================================

#define TOUCH_ID_RED      5
#define TOUCH_ID_YELLOW   6
#define TOUCH_ID_WHITE    7

//==============================================================================
// Event states
//==============================================================================

#define ESTATE_LOW        0
#define ESTATE_NORMAL     1
#define ESTATE_HIGH       2

//==============================================================================
// Mailbox name
// Command use: Together with SRC_MESSAGE
//==============================================================================

#define MAILBOX_RCX2      0

//==============================================================================
// Counter names
// Command use: cntd, cnti, cnts, cntz
//              Together with SRC_COUNTER
//==============================================================================

#define COUNTER_1         0
#define COUNTER_2         1
#define COUNTER_3         2

//==============================================================================
// Output direction actions
// Command use: dir, gdir
//==============================================================================

#define DIR_BACKWARD      0
#define DIR_CHGDIR        1
#define DIR_FORWARD       2

//==============================================================================
// Shorthand versions for motor direction settings
//==============================================================================

#define rwd               dir     DIR_BACKWARD, 
#define fwd               dir     DIR_FORWARD, 
#define alt               dir     DIR_CHGDIR, 

#define grwd              gdir    DIR_BACKWARD, 
#define gfwd              gdir    DIR_FORWARD, 
#define galt              gdir    DIR_CHGDIR, 

//==============================================================================
// Output switch actions
// Command use: out, gout
//==============================================================================

#define OUT_FLOAT         0
#define OUT_OFF           1
#define OUT_ON            2

//==============================================================================
// Shorthand versions for motor control
//==============================================================================

#define   on              out     OUT_ON, 
#define   off             out     OUT_OFF,
#define   float           out     OUT_FLOAT, 

#define   gon             gout    OUT_ON,
#define   goff            gout    OUT_OFF,
#define   gfloat          gout    OUT_FLOAT, 

//==============================================================================
// Output lists
// Command use: dir, gdir, out, gout, pwr and gpwr 
//==============================================================================

#define OUTLIST_A         1
#define OUTLIST_B         2
#define OUTLIST_AB        3
#define OUTLIST_C         4
#define OUTLIST_AC        5
#define OUTLIST_BC        6
#define OUTLIST_ABC       7

//==============================================================================
// Resources
// Motor A: A
// Motor B: B
// Sound  : S
// Motor C: C
// Command use: monal
//==============================================================================

#define RES_A             1
#define RES_B             2
#define RES_AB            3
#define RES_S             4
#define RES_AS            5
#define RES_BS            6
#define RES_ABS           7
#define RES_C             8
#define RES_AC            9
#define RES_BC            10
#define RES_ABC           11
#define RES_SC            12
#define RES_ASC           13
#define RES_BSC           14
#define RES_ABSC          15

//==============================================================================
// Priority levels
// Command use: setp
//==============================================================================

#define PRT0              0
#define PRT1              1
#define PRT2              2
#define PRT3              3
#define PRT4              4
#define PRT5              5
#define PRT6              6
#define PRT7              7

//==============================================================================
// Fine resolution time constants
// Command use: wait, playt and playv
//==============================================================================

#define FR_MS_10          1
#define FR_MS_20          2
#define FR_MS_30          3
#define FR_MS_40          4
#define FR_MS_50          5
#define FR_MS_60          6
#define FR_MS_70          7
#define FR_MS_80          8
#define FR_MS_90          9
#define FR_MS_100         10
#define FR_MS_150         15
#define FR_MS_200         20
#define FR_MS_250         25
#define FR_MS_300         30
#define FR_MS_350         35
#define FR_MS_400         40
#define FR_MS_450         45
#define FR_MS_500         50
#define FR_MS_600         60
#define FR_MS_700         70
#define FR_MS_800         80
#define FR_MS_900         90
#define FR_SEC_1          100
#define FR_SEC_2          200       
#define FR_SEC_3          300
#define FR_SEC_4          400
#define FR_SEC_5          500
#define FR_SEC_6          600
#define FR_SEC_7          700
#define FR_SEC_8          800
#define FR_SEC_9          900
#define FR_SEC_10         1000
#define FR_SEC_15         1500
#define FR_SEC_20         2000
#define FR_SEC_30         3000
#define FR_MIN_1          6000

//==============================================================================
// Coarse resolution time constants
// Command use: Together with timers
//==============================================================================

#define CR_MS_100         1
#define CR_MS_200         2
#define CR_MS_300         3
#define CR_MS_400         4
#define CR_MS_500         5
#define CR_MS_600         6
#define CR_MS_700         7
#define CR_MS_800         8
#define CR_MS_900         9
#define CR_SEC_1          10
#define CR_SEC_2          20
#define CR_SEC_3          30
#define CR_SEC_4          40
#define CR_SEC_5          50
#define CR_SEC_6          60
#define CR_SEC_7          70
#define CR_SEC_8          80
#define CR_SEC_9          90
#define CR_SEC_10         100
#define CR_SEC_15         150
#define CR_SEC_20         200
#define CR_SEC_30         300
#define CR_MIN_1          600
#define CR_MIN_2          1200
#define CR_MIN_3          1800
#define CR_MIN_4          2400
#define CR_MIN_5          3000
#define CR_MIN_10         6000

//==============================================================================
// Tones
// Command use: playt
//==============================================================================

#define TONE_A4           220
#define TONE_AS4          233
#define TONE_B4           247
#define TONE_C4           262
#define TONE_CS4          277        
#define TONE_D4           294
#define TONE_DS4          311
#define TONE_E4           330
#define TONE_F4           349
#define TONE_FS4          370
#define TONE_G4           392
#define TONE_GS4          415

#define TONE_A5           440
#define TONE_AS5          466
#define TONE_B5           494
#define TONE_C5           523
#define TONE_CS5          554
#define TONE_D5           587
#define TONE_DS5          622
#define TONE_E5           659
#define TONE_F5           698
#define TONE_FS5          740
#define TONE_G5           784
#define TONE_GS5          831

#define TONE_A6           880
#define TONE_AS6          932
#define TONE_B6           988
#define TONE_C6           1047
#define TONE_CS6          1109
#define TONE_D6           1175
#define TONE_DS6          1245
#define TONE_E6           1319
#define TONE_F6           1397
#define TONE_FS6          1480
#define TONE_G6           1568
#define TONE_GS6          1661

#define TONE_A7           1760
#define TONE_AS7          1865
#define TONE_B7           1976
#define TONE_C7           2093
#define TONE_CS7          2217
#define TONE_D7           2349
#define TONE_DS7          2489
#define TONE_E7           2637
#define TONE_F7           2794
#define TONE_FS7          2960
#define TONE_G7           3136
#define TONE_GS7          3322

//==============================================================================
// IR range settings
// Command use: txs
//==============================================================================

#define IRRANGE_SHORT     0
#define IRRANGE_LONG      1

//==============================================================================
// Display precision selection (added by JB)
// Command use: disp
//==============================================================================

#define DISP_INTEGER      0
#define DISP_TENTHS       1
#define DISP_HUNDREDS     2
#define DISP_THOUSANDS    3

//==============================================================================
// String of prime numbers
// Command use: pollp, reset, boot
//==============================================================================

#define PRIME1            1
#define PRIME2            3
#define PRIME3            5
#define PRIME4            7
#define PRIME5            11

//==============================================================================
// boot magic numbers
// Command use: boot
//==============================================================================

#define BOOT_N1           (0x40 + 12) /* 'L' */
#define BOOT_N2           (0x40 + 5)  /* 'E' */
#define BOOT_N3           (0x40 + 7)  /* 'G' */
#define BOOT_N4           (0x40 + 15) /* 'O' */
#define BOOT_N5           174         /* '' */

//==============================================================================
// Boolean values
//==============================================================================

#define K_FALSE           0
#define K_TRUE            1

#define K_OFF             0
#define K_ON              1

//==============================================================================
// Logical comparison operators
// Command use: chk, chkl
//==============================================================================

#define GT                0 // Greater than
#define LT                1 // Less than
#define EQ                2 // Equal to
#define NE                3 // Not equal to

//==============================================================================
// Remote control bitmasks
// Command use: remote
//==============================================================================

#define REMOTE_RELEASE    0x0000  // 0000 0000 0000 0000

#define REMOTE_MES1       0x0100  // 0000 0001 0000 0000
#define REMOTE_MES2       0x0200  // 0000 0010 0000 0000
#define REMOTE_MES3       0x0400  // 0000 0100 0000 0000

#define REMOTE_A_FWD      0x0800  // 0000 1000 0000 0000
#define REMOTE_B_FWD      0x1000  // 0001 0000 0000 0000
#define REMOTE_C_FWD      0x2000  // 0010 0000 0000 0000
#define REMOTE_A_RWD      0x4000  // 0100 0000 0000 0000
#define REMOTE_B_RWD      0x8000  // 1000 0000 0000 0000
#define REMOTE_C_RWD      0x0001  // 0000 0000 0000 0001

#define REMOTE_P1         0x0002  // 0000 0000 0000 0010
#define REMOTE_P2         0x0004  // 0000 0000 0000 0100
#define REMOTE_P3         0x0008  // 0000 0000 0000 1000
#define REMOTE_P4         0x0010  // 0000 0000 0001 0000
#define REMOTE_P5         0x0020  // 0000 0000 0010 0000

#define REMOTE_STOP       0x0040  // 0000 0000 0100 0000

#define REMOTE_SOUND      0x0080  // 0000 0000 1000 0000

//==============================================================================
// Memory addresses can be found in header files: pollm.h, pollmx.h
//==============================================================================

//==============================================================================

#endif // RCX2DEF__H

//==============================================================================
