## libtool.m4 - Configure libtool for the target system. -*-Shell-script-*-
## Copyright (C) 1996-1999 Free Software Foundation, Inc.
## Originally by Gordon Matzigkeit <gord@gnu.ai.mit.edu>, 1996
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##
## As a special exception to the GNU General Public License, if you
## distribute this file as part of a program that contains a
## configuration script generated by Autoconf, you may include it under
## the same distribution terms that you use for the rest of that program.
##
##  $Id: aclocal.m4,v 1.8 2001/09/24 15:45:51 aland Exp $

# serial 40 AC_PROG_LIBTOOL
AC_DEFUN(AC_PROG_LIBTOOL,
[AC_REQUIRE([AC_LIBTOOL_SETUP])dnl

# Save cache, so that ltconfig can load it
AC_CACHE_SAVE

# Actually configure libtool.  ac_aux_dir is where install-sh is found.
CC="$CC" CFLAGS="$CFLAGS" CPPFLAGS="$CPPFLAGS" \
LD="$LD" LDFLAGS="$LDFLAGS" LIBS="$LIBS" \
LN_S="$LN_S" NM="$NM" RANLIB="$RANLIB" \
DLLTOOL="$DLLTOOL" AS="$AS" OBJDUMP="$OBJDUMP" \
${CONFIG_SHELL-/bin/sh} $ac_aux_dir/ltconfig --no-reexec \
$libtool_flags --no-verify $ac_aux_dir/ltmain.sh $lt_target \
|| AC_MSG_ERROR([libtool configure failed])

# Reload cache, that may have been modified by ltconfig
AC_CACHE_LOAD

# This can be used to rebuild libtool when needed
LIBTOOL_DEPS="$ac_aux_dir/ltconfig $ac_aux_dir/ltmain.sh"

# Always use our own libtool.
LIBTOOL='$(SHELL) $(top_builddir)/libtool'
AC_SUBST(LIBTOOL)dnl

# Redirect the config.log output again, so that the ltconfig log is not
# clobbered by the next message.
exec 5>>./config.log
])

AC_DEFUN(AC_LIBTOOL_SETUP,
[AC_PREREQ(2.13)dnl
AC_REQUIRE([AC_ENABLE_SHARED])dnl
AC_REQUIRE([AC_ENABLE_STATIC])dnl
AC_REQUIRE([AC_ENABLE_FAST_INSTALL])dnl
AC_REQUIRE([AC_CANONICAL_HOST])dnl
AC_REQUIRE([AC_CANONICAL_BUILD])dnl
AC_REQUIRE([AC_PROG_RANLIB])dnl
AC_REQUIRE([AC_PROG_CC])dnl
AC_REQUIRE([AC_PROG_LD])dnl
AC_REQUIRE([AC_PROG_NM])dnl
AC_REQUIRE([AC_PROG_LN_S])dnl
dnl

case "$target" in
NONE) lt_target="$host" ;;
*) lt_target="$target" ;;
esac

# Check for any special flags to pass to ltconfig.
libtool_flags="--cache-file=$cache_file"
test "$enable_shared" = no && libtool_flags="$libtool_flags --disable-shared"
test "$enable_static" = no && libtool_flags="$libtool_flags --disable-static"
test "$enable_fast_install" = no && libtool_flags="$libtool_flags --disable-fast-install"
test "$ac_cv_prog_gcc" = yes && libtool_flags="$libtool_flags --with-gcc"
test "$ac_cv_prog_gnu_ld" = yes && libtool_flags="$libtool_flags --with-gnu-ld"
ifdef([AC_PROVIDE_AC_LIBTOOL_DLOPEN],
[libtool_flags="$libtool_flags --enable-dlopen"])
ifdef([AC_PROVIDE_AC_LIBTOOL_WIN32_DLL],
[libtool_flags="$libtool_flags --enable-win32-dll"])
AC_ARG_ENABLE(libtool-lock,
  [  --disable-libtool-lock  avoid locking (might break parallel builds)])
test "x$enable_libtool_lock" = xno && libtool_flags="$libtool_flags --disable-lock"
test x"$silent" = xyes && libtool_flags="$libtool_flags --silent"

# Some flags need to be propagated to the compiler or linker for good
# libtool support.
case "$lt_target" in
*-*-irix6*)
  # Find out which ABI we are using.
  echo '[#]line __oline__ "configure"' > conftest.$ac_ext
  if AC_TRY_EVAL(ac_compile); then
    case "`/usr/bin/file conftest.o`" in
    *32-bit*)
      LD="${LD-ld} -32"
      ;;
    *N32*)
      LD="${LD-ld} -n32"
      ;;
    *64-bit*)
      LD="${LD-ld} -64"
      ;;
    esac
  fi
  rm -rf conftest*
  ;;

*-*-sco3.2v5*)
  # On SCO OpenServer 5, we need -belf to get full-featured binaries.
  SAVE_CFLAGS="$CFLAGS"
  CFLAGS="$CFLAGS -belf"
  AC_CACHE_CHECK([whether the C compiler needs -belf], lt_cv_cc_needs_belf,
    [AC_TRY_LINK([],[],[lt_cv_cc_needs_belf=yes],[lt_cv_cc_needs_belf=no])])
  if test x"$lt_cv_cc_needs_belf" != x"yes"; then
    # this is probably gcc 2.8.0, egcs 1.0 or newer; no need for -belf
    CFLAGS="$SAVE_CFLAGS"
  fi
  ;;

ifdef([AC_PROVIDE_AC_LIBTOOL_WIN32_DLL],
[*-*-cygwin* | *-*-mingw*)
  AC_CHECK_TOOL(DLLTOOL, dlltool, false)
  AC_CHECK_TOOL(AS, as, false)
  AC_CHECK_TOOL(OBJDUMP, objdump, false)
  ;;
])
esac
])

# AC_LIBTOOL_DLOPEN - enable checks for dlopen support
AC_DEFUN(AC_LIBTOOL_DLOPEN, [AC_BEFORE([$0],[AC_LIBTOOL_SETUP])])

# AC_LIBTOOL_WIN32_DLL - declare package support for building win32 dll's
AC_DEFUN(AC_LIBTOOL_WIN32_DLL, [AC_BEFORE([$0], [AC_LIBTOOL_SETUP])])

# AC_ENABLE_SHARED - implement the --enable-shared flag
# Usage: AC_ENABLE_SHARED[(DEFAULT)]
#   Where DEFAULT is either `yes' or `no'.  If omitted, it defaults to
#   `yes'.
AC_DEFUN(AC_ENABLE_SHARED, [dnl
define([AC_ENABLE_SHARED_DEFAULT], ifelse($1, no, no, yes))dnl
AC_ARG_ENABLE(shared,
changequote(<<, >>)dnl
<<  --enable-shared[=PKGS]  build shared libraries [default=>>AC_ENABLE_SHARED_DEFAULT],
changequote([, ])dnl
[p=${PACKAGE-default}
case "$enableval" in
yes) enable_shared=yes ;;
no) enable_shared=no ;;
*)
  enable_shared=no
  # Look at the argument we got.  We use all the common list separators.
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}:,"
  for pkg in $enableval; do
    if test "X$pkg" = "X$p"; then
      enable_shared=yes
    fi
  done
  IFS="$ac_save_ifs"
  ;;
esac],
enable_shared=AC_ENABLE_SHARED_DEFAULT)dnl
])

# AC_DISABLE_SHARED - set the default shared flag to --disable-shared
AC_DEFUN(AC_DISABLE_SHARED, [AC_BEFORE([$0],[AC_LIBTOOL_SETUP])dnl
AC_ENABLE_SHARED(no)])

# AC_ENABLE_STATIC - implement the --enable-static flag
# Usage: AC_ENABLE_STATIC[(DEFAULT)]
#   Where DEFAULT is either `yes' or `no'.  If omitted, it defaults to
#   `yes'.
AC_DEFUN(AC_ENABLE_STATIC, [dnl
define([AC_ENABLE_STATIC_DEFAULT], ifelse($1, no, no, yes))dnl
AC_ARG_ENABLE(static,
changequote(<<, >>)dnl
<<  --enable-static[=PKGS]  build static libraries [default=>>AC_ENABLE_STATIC_DEFAULT],
changequote([, ])dnl
[p=${PACKAGE-default}
case "$enableval" in
yes) enable_static=yes ;;
no) enable_static=no ;;
*)
  enable_static=no
  # Look at the argument we got.  We use all the common list separators.
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}:,"
  for pkg in $enableval; do
    if test "X$pkg" = "X$p"; then
      enable_static=yes
    fi
  done
  IFS="$ac_save_ifs"
  ;;
esac],
enable_static=AC_ENABLE_STATIC_DEFAULT)dnl
])

# AC_DISABLE_STATIC - set the default static flag to --disable-static
AC_DEFUN(AC_DISABLE_STATIC, [AC_BEFORE([$0],[AC_LIBTOOL_SETUP])dnl
AC_ENABLE_STATIC(no)])


# AC_ENABLE_FAST_INSTALL - implement the --enable-fast-install flag
# Usage: AC_ENABLE_FAST_INSTALL[(DEFAULT)]
#   Where DEFAULT is either `yes' or `no'.  If omitted, it defaults to
#   `yes'.
AC_DEFUN(AC_ENABLE_FAST_INSTALL, [dnl
define([AC_ENABLE_FAST_INSTALL_DEFAULT], ifelse($1, no, no, yes))dnl
AC_ARG_ENABLE(fast-install,
changequote(<<, >>)dnl
<<  --enable-fast-install[=PKGS]  optimize for fast installation [default=>>AC_ENABLE_FAST_INSTALL_DEFAULT],
changequote([, ])dnl
[p=${PACKAGE-default}
case "$enableval" in
yes) enable_fast_install=yes ;;
no) enable_fast_install=no ;;
*)
  enable_fast_install=no
  # Look at the argument we got.  We use all the common list separators.
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}:,"
  for pkg in $enableval; do
    if test "X$pkg" = "X$p"; then
      enable_fast_install=yes
    fi
  done
  IFS="$ac_save_ifs"
  ;;
esac],
enable_fast_install=AC_ENABLE_FAST_INSTALL_DEFAULT)dnl
])

# AC_ENABLE_FAST_INSTALL - set the default to --disable-fast-install
AC_DEFUN(AC_DISABLE_FAST_INSTALL, [AC_BEFORE([$0],[AC_LIBTOOL_SETUP])dnl
AC_ENABLE_FAST_INSTALL(no)])

# AC_PROG_LD - find the path to the GNU or non-GNU linker
AC_DEFUN(AC_PROG_LD,
[AC_ARG_WITH(gnu-ld,
[  --with-gnu-ld           assume the C compiler uses GNU ld [default=no]],
test "$withval" = no || with_gnu_ld=yes, with_gnu_ld=no)
AC_REQUIRE([AC_PROG_CC])dnl
AC_REQUIRE([AC_CANONICAL_HOST])dnl
AC_REQUIRE([AC_CANONICAL_BUILD])dnl
ac_prog=ld
if test "$ac_cv_prog_gcc" = yes; then
  # Check if gcc -print-prog-name=ld gives a path.
  AC_MSG_CHECKING([for ld used by GCC])
  ac_prog=`($CC -print-prog-name=ld) 2>&5`
  case "$ac_prog" in
    # Accept absolute paths.
changequote(,)dnl
    [\\/]* | [A-Za-z]:[\\/]*)
      re_direlt='/[^/][^/]*/\.\./'
changequote([,])dnl
      # Canonicalize the path of ld
      ac_prog=`echo $ac_prog| sed 's%\\\\%/%g'`
      while echo $ac_prog | grep "$re_direlt" > /dev/null 2>&1; do
	ac_prog=`echo $ac_prog| sed "s%$re_direlt%/%"`
      done
      test -z "$LD" && LD="$ac_prog"
      ;;
  "")
    # If it fails, then pretend we aren't using GCC.
    ac_prog=ld
    ;;
  *)
    # If it is relative, then search for the first ld in PATH.
    with_gnu_ld=unknown
    ;;
  esac
elif test "$with_gnu_ld" = yes; then
  AC_MSG_CHECKING([for GNU ld])
else
  AC_MSG_CHECKING([for non-GNU ld])
fi
AC_CACHE_VAL(ac_cv_path_LD,
[if test -z "$LD"; then
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}${PATH_SEPARATOR-:}"
  for ac_dir in $PATH; do
    test -z "$ac_dir" && ac_dir=.
    if test -f "$ac_dir/$ac_prog" || test -f "$ac_dir/$ac_prog$ac_exeext"; then
      ac_cv_path_LD="$ac_dir/$ac_prog"
      # Check to see if the program is GNU ld.  I'd rather use --version,
      # but apparently some GNU ld's only accept -v.
      # Break only if it was the GNU/non-GNU ld that we prefer.
      if "$ac_cv_path_LD" -v 2>&1 < /dev/null | egrep '(GNU|with BFD)' > /dev/null; then
	test "$with_gnu_ld" != no && break
      else
	test "$with_gnu_ld" != yes && break
      fi
    fi
  done
  IFS="$ac_save_ifs"
else
  ac_cv_path_LD="$LD" # Let the user override the test with a path.
fi])
LD="$ac_cv_path_LD"
if test -n "$LD"; then
  AC_MSG_RESULT($LD)
else
  AC_MSG_RESULT(no)
fi
test -z "$LD" && AC_MSG_ERROR([no acceptable ld found in \$PATH])
AC_PROG_LD_GNU
])

AC_DEFUN(AC_PROG_LD_GNU,
[AC_CACHE_CHECK([if the linker ($LD) is GNU ld], ac_cv_prog_gnu_ld,
[# I'd rather use --version here, but apparently some GNU ld's only accept -v.
if $LD -v 2>&1 </dev/null | egrep '(GNU|with BFD)' 1>&5; then
  ac_cv_prog_gnu_ld=yes
else
  ac_cv_prog_gnu_ld=no
fi])
])

# AC_PROG_NM - find the path to a BSD-compatible name lister
AC_DEFUN(AC_PROG_NM,
[AC_MSG_CHECKING([for BSD-compatible nm])
AC_CACHE_VAL(ac_cv_path_NM,
[if test -n "$NM"; then
  # Let the user override the test.
  ac_cv_path_NM="$NM"
else
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}${PATH_SEPARATOR-:}"
  for ac_dir in $PATH /usr/ccs/bin /usr/ucb /bin; do
    test -z "$ac_dir" && ac_dir=.
    if test -f $ac_dir/nm || test -f $ac_dir/nm$ac_exeext ; then
      # Check to see if the nm accepts a BSD-compat flag.
      # Adding the `sed 1q' prevents false positives on HP-UX, which says:
      #   nm: unknown option "B" ignored
      if ($ac_dir/nm -B /dev/null 2>&1 | sed '1q'; exit 0) | egrep /dev/null >/dev/null; then
	ac_cv_path_NM="$ac_dir/nm -B"
	break
      elif ($ac_dir/nm -p /dev/null 2>&1 | sed '1q'; exit 0) | egrep /dev/null >/dev/null; then
	ac_cv_path_NM="$ac_dir/nm -p"
	break
      else
	ac_cv_path_NM=${ac_cv_path_NM="$ac_dir/nm"} # keep the first match, but
	continue # so that we can try to find one that supports BSD flags
      fi
    fi
  done
  IFS="$ac_save_ifs"
  test -z "$ac_cv_path_NM" && ac_cv_path_NM=nm
fi])
NM="$ac_cv_path_NM"
AC_MSG_RESULT([$NM])
])

# AC_CHECK_LIBM - check for math library
AC_DEFUN(AC_CHECK_LIBM,
[AC_REQUIRE([AC_CANONICAL_HOST])dnl
LIBM=
case "$lt_target" in
*-*-beos* | *-*-cygwin*)
  # These system don't have libm
  ;;
*-ncr-sysv4.3*)
  AC_CHECK_LIB(mw, _mwvalidcheckl, LIBM="-lmw")
  AC_CHECK_LIB(m, main, LIBM="$LIBM -lm")
  ;;
*)
  AC_CHECK_LIB(m, main, LIBM="-lm")
  ;;
esac
])

# AC_LIBLTDL_CONVENIENCE[(dir)] - sets LIBLTDL to the link flags for
# the libltdl convenience library, adds --enable-ltdl-convenience to
# the configure arguments.  Note that LIBLTDL is not AC_SUBSTed, nor
# is AC_CONFIG_SUBDIRS called.  If DIR is not provided, it is assumed
# to be `${top_builddir}/libltdl'.  Make sure you start DIR with
# '${top_builddir}/' (note the single quotes!) if your package is not
# flat, and, if you're not using automake, define top_builddir as
# appropriate in the Makefiles.
AC_DEFUN(AC_LIBLTDL_CONVENIENCE, [AC_BEFORE([$0],[AC_LIBTOOL_SETUP])dnl
  case "$enable_ltdl_convenience" in
  no) AC_MSG_ERROR([this package needs a convenience libltdl]) ;;
  "") enable_ltdl_convenience=yes
      ac_configure_args="$ac_configure_args --enable-ltdl-convenience" ;;
  esac
  LIBLTDL=ifelse($#,1,$1,['${top_builddir}/libltdl'])/libltdlc.la
  INCLTDL=ifelse($#,1,-I$1,['-I${top_builddir}/libltdl'])
])

# AC_LIBLTDL_INSTALLABLE[(dir)] - sets LIBLTDL to the link flags for
# the libltdl installable library, and adds --enable-ltdl-install to
# the configure arguments.  Note that LIBLTDL is not AC_SUBSTed, nor
# is AC_CONFIG_SUBDIRS called.  If DIR is not provided, it is assumed
# to be `${top_builddir}/libltdl'.  Make sure you start DIR with
# '${top_builddir}/' (note the single quotes!) if your package is not
# flat, and, if you're not using automake, define top_builddir as
# appropriate in the Makefiles.
# In the future, this macro may have to be called after AC_PROG_LIBTOOL.
AC_DEFUN(AC_LIBLTDL_INSTALLABLE, [AC_BEFORE([$0],[AC_LIBTOOL_SETUP])dnl
  AC_CHECK_LIB(ltdl, main,
  [test x"$enable_ltdl_install" != xyes && enable_ltdl_install=no],
  [if test x"$enable_ltdl_install" = xno; then
     AC_MSG_WARN([libltdl not installed, but installation disabled])
   else
     enable_ltdl_install=yes
   fi
  ])
  if test x"$enable_ltdl_install" = x"yes"; then
    ac_configure_args="$ac_configure_args --enable-ltdl-install"
    LIBLTDL=ifelse($#,1,$1,['${top_builddir}/libltdl'])/libltdl.la
    INCLTDL=ifelse($#,1,-I$1,['-I${top_builddir}/libltdl'])
  else
    ac_configure_args="$ac_configure_args --enable-ltdl-install=no"
    LIBLTDL="-lltdl"
    INCLTDL=
  fi
])

dnl old names
AC_DEFUN(AM_PROG_LIBTOOL, [indir([AC_PROG_LIBTOOL])])dnl
AC_DEFUN(AM_ENABLE_SHARED, [indir([AC_ENABLE_SHARED], $@)])dnl
AC_DEFUN(AM_ENABLE_STATIC, [indir([AC_ENABLE_STATIC], $@)])dnl
AC_DEFUN(AM_DISABLE_SHARED, [indir([AC_DISABLE_SHARED], $@)])dnl
AC_DEFUN(AM_DISABLE_STATIC, [indir([AC_DISABLE_STATIC], $@)])dnl
AC_DEFUN(AM_PROG_LD, [indir([AC_PROG_LD])])dnl
AC_DEFUN(AM_PROG_NM, [indir([AC_PROG_NM])])dnl

dnl This is just to silence aclocal about the macro not being used
ifelse([AC_DISABLE_FAST_INSTALL])dnl

dnl See whether we need a declaration for a function.
dnl RADIUSD_NEED_DECLARATION(FUNCTION [, EXTRA-HEADER-FILES])
AC_DEFUN(RADIUSD_NEED_DECLARATION,
[AC_MSG_CHECKING([whether $1 must be declared])
AC_CACHE_VAL(radius_cv_decl_needed_$1,
[AC_TRY_COMPILE([
#include <stdio.h>
#include <string.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_CRYPT_H
#include <crypt.h>
#endif
#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif
#ifdef HAVE_RESOURCE_H
#include <resource.h>
#endif
#ifdef HAVE_GETOPT_H
#include <getopt.h>
#endif
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif
#ifdef HAVE_UTMP_H
#include <utmp.h>
#endif
#ifdef HAVE_UTMPX_H
#include <utmpx.h>
#endif
#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif
#ifdef HAVE_DLFCN_H
#include <dlfcn.h>
#endif
#ifdef HAVE_REGEX_H
#include <regex.h>
#endif
#ifdef HAVE_SYSLOG_H
#include <syslog.h>
#endif
#ifdef HAVE_INTTYPES_H
#include <inttypes.h>
#endif
#ifdef HAVE_STDINT_H
#include <stdint.h>
#endif
#ifdef HAVE_ARPA_INET_H
#include <arpa/inet.h>
#endif
$2],
[char *(*pfn) = (char *(*)) $1],
eval "radius_cv_decl_needed_$1=no", eval "radius_cv_decl_needed_$1=yes")])
if eval "test \"`echo '$radius_cv_decl_needed_'$1`\" = yes"; then
  AC_MSG_RESULT(yes)
  radius_tr_decl=NEED_DECLARATION_`echo $1 | tr 'abcdefghijklmnopqrstuvwxyz' 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'`
  AC_DEFINE_UNQUOTED($radius_tr_decl)
else
  AC_MSG_RESULT(no)
fi
])dnl

dnl Check multiple functions to see whether each needs a declaration.
dnl RADIUSD_NEED_DECLARATIONS(FUNCTION... [, EXTRA-HEADER-FILES])
AC_DEFUN(RADIUSD_NEED_DECLARATIONS,
[for ac_func in $1
do
RADIUSD_NEED_DECLARATION($ac_func, $2)
done
])

dnl AM_MISSING_PROG(NAME, PROGRAM, DIRECTORY)
dnl The program must properly implement --version.
AC_DEFUN(AM_MISSING_PROG,
[AC_MSG_CHECKING(for working $2)
# Run test in a subshell; some versions of sh will print an error if
# an executable is not found, even if stderr is redirected.
# Redirect stdin to placate older versions of autoconf.  Sigh.
if ($2 --version) < /dev/null > /dev/null 2>&1; then
   $1=$2
   AC_MSG_RESULT(found)
else
   $1="$3/missing $2"
   AC_MSG_RESULT(missing)
fi
AC_SUBST($1)])


dnl Checks to see if this is SUNPro we're building with
dnl Usage:
dnl AC_PROG_CC_SUNPRO
AC_DEFUN(AC_PROG_CC_SUNPRO,
[AC_CACHE_CHECK(whether we are using SUNPro C, ac_cv_prog_suncc,
[dnl The semicolon is to pacify NeXT's syntax-checking cpp.
cat > conftest.c <<EOF
#ifdef __SUNPRO_C
  yes;
#endif
EOF
if AC_TRY_COMMAND(${CC-cc} -E conftest.c) | egrep yes >/dev/null 2>&1; then
  ac_cv_prog_suncc=yes
else
  ac_cv_prog_suncc=no
fi])])

dnl #
dnl # AC_CHECK_TYPE_INCLUDE([#includes ...], type, default-C-types)
dnl #
dnl # This function is like AC_CHECK_TYPE, but you can give this one
dnl # a list of include files to check.
dnl #
AC_DEFUN(AC_CHECK_TYPE_INCLUDE,
[
  AC_CACHE_CHECK(for $2, ac_cv_type_$2,
    [ ac_cv_type_$2=no
      AC_TRY_COMPILE($1,
        [$2 foo],
        ac_cv_type_$2=yes,
      )
    ]
  )

  if test "$ac_cv_type_$2" != "yes"; then
         AC_DEFINE($2, $3)
  fi
])

dnl Check the PostgreSQL installation

AC_DEFUN(POSTGRESQL_CHECKS, [
	AC_SUBST(PGROOT)
	AC_SUBST(PQ_LIBS)
	AC_SUBST(PG_INCLUDE_DIR)

AC_CHECKING(for PostgreSQL includes)

dnl First Check for a local install
if test "x$PGROOT" != "x" ; then
	IS_LOCAL=1
else
	dnl Check common local install paths
	if test -d /usr/local/pgsql ; then 
		PGROOT="/usr/local/pgsql"
		ISLOCAL=1
	elif test -d /usr/local/postgresql ; then
		PGROOT="/usr/local/postgresql"
		ISLOCAL=1
	elif test -d /opt/pgsql ; then
		PGROOT="/opt/pgsql"
		ISLOCAL=1
	elif test -d /opt/postgresql ; then
		PGROOT="/opt/postgresql"
		ISLOCAL=1
	fi
fi
dnl If we have a local install path, check for some files
if test "x$PGROOT" != "x" && test "x$IS_LOCAL" != "x" ; then
	if test -e $PGROOT/lib/libpq${libltdl_cv_shlibext} ; then
		if test -e $PGROOT/lib/libpq.a ; then
			PQ_LIBS="-L$PGROOT/lib -lpq"
		fi
	fi
	AC_CHECK_HEADERS($PGROOT/include/libpq-fe.h $PGROOT/include/postgres.h,
		FOUND_PG_HEADERS=1)
	if test "x$FOUND_PG_HEADERS" != "x" ; then
		PG_INCLUDE_DIR="$PGROOT/include"
	fi
fi

dnl Now check for the two common distribution installation locations
if test "x$PGROOT" = "x" ; then
	AC_CHECK_LIB(pq,PQconnectdb,FOUND_PQLIB=1)
	if test "x$FOUND_PQLIB" != "x" ; then
		PQ_LIBS="-lpq"
	fi
	if test -d /usr/include/pgsql ; then
		PG_INCLUDE_DIR="/usr/include/pgsql"
		PG_INCLUDED_DIR="$PG_INCLUDE_DIR/"
	elif test -d /usr/include/postgresql ; then
		PG_INCLUDE_DIR="/usr/include/postgresql"
		PG_INCLUDED_DIR="$PG_INCLUDE_DIR/"
	fi
	AC_CHECK_HEADER("${PG_INCLUDED_DIR}libpq-fe.h",AC_DEFINE(HAVE_LIBPQ_FE_H))
	AC_CHECK_HEADER("${PG_INCLUDED_DIR}postgres.h",AC_DEFINE(HAVE_POSTGRES_H))
	if test "x$HAVE_HEADER-LIBPQ-FE.H" != "x" ; then
		PG_INCLUDE_DIR="$PG_INCLUDE_DIR"
	fi
	if test -d /usr/lib/pgsql ; then
		PGROOT="/usr/lib/pgsql"
	elif test -d /usr/lib/postgresql ; then
		PGROOT="/usr/lib/postgresql"
	fi
fi

if test "x$PGROOT" != "x" && test "x$PQ_LIBS" != "x" && test "x$PG_INCLUDE_DIR" != "x"; then
	echo Postgresql found in $PGROOT.
fi

])

dnl #######################################################################
dnl #
dnl #  Look for ODBC in a variety of places.
dnl #
AC_DEFUN(ODBC_CHECKS, [
	AC_SUBST(ODBC_LIBS)
	AC_SUBST(ODBC_INCLUDE)

AC_MSG_CHECKING([for isql.h])

dnl #
dnl #  First, see if we can build it WITHOUT using any special includes
dnl #
AC_TRY_COMPILE([#include <isql.h>],
               [ int a = 1;],
               ODBC_INCLUDE=" ",
               ODBC_INCLUDE=)

dnl #
dnl #  If not, look for it in a number of directories.
dnl #
if test "x$ODBC_INCLUDE" = "x"; then
  old_CFLAGS="$CFLAGS"

  AC_LOCATE_DIR(odbc_include_dir, isql.h)

  for try in /usr/include /usr/local/include/odbc /usr/local/odbc/include $odbc_include_dir; do
    CFLAGS="$old_CFLAGS -I$try"
    AC_TRY_COMPILE([#include <isql.h>],
                   [ int a = 1;],
                   ODBC_INCLUDE="-I$try",
                   ODBC_INCLUDE=)
    if test "x$ODBC_INCLUDE" != "x"; then
      break;
    fi
  done
  CFLAGS="$old_CFLAGS"
fi

if test "x$ODBC_INCLUDE" = "x"; then
  AC_MSG_RESULT(no)
else
  AC_MSG_RESULT(yes)
  
dnl #
dnl #  Now do the same thing, looking for the ODBC library directory
dnl #
  AC_MSG_CHECKING([for odbc_init in -lodbcclient])

dnl #
dnl #  Look for it in a number of directories.
dnl #
  old_LIBS="$LIBS"

  AC_LOCATE_DIR(odbc_lib_dir, [libodbcclient${libltdl_cv_shlibext}])
  AC_LOCATE_DIR(odbc_lib_dir, [libodbcclient.a])

  for try in /usr/lib /usr/lib/odbc /usr/local/lib/odbc /usr/local/odbc/lib $odbc_lib_dir; do
    LIBS="$old_LIBS -L$try -lodbcclient"
    AC_TRY_LINK([extern char odbc_init();],
                [ odbc_init()],
                ODBC_LIBS="-L$try -lodbcclient",
                ODBC_LIBS=)
    if test "x$ODBC_LIBS" != "x"; then
      break;
    fi
  done
  LIBS="$old_LIBS"

  dnl #
  dnl #  If one or the other isn't found, disable them both..
  dnl #  If both are found, enable them both.
  dnl #
  if test "x$ODBC_LIBS" = "x"; then
    AC_MSG_RESULT(no)
    ODBC_INCLUDE=
  else
    AC_MSG_RESULT(yes)
    AC_DEFINE(HAVE_ISQL_H)
  fi
fi
])

dnl #######################################################################
dnl #
dnl #  Look for SNMP in a variety of places.
dnl #
AC_DEFUN(SNMP_CHECKS, [
	AC_SUBST(SNMP_LIBS)
	AC_SUBST(SNMP_INCLUDE)

AC_MSG_CHECKING([for asn1.h])

dnl #
dnl #  First, see if we can build it WITHOUT using any special includes
dnl #
AC_TRY_COMPILE([
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_STDINT_H
#include <stdint.h>
#endif
#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif
#ifdef HAVE_NETDB_H
#include <netdb.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <asn1.h>],
               [ int a = 1;],
               SNMP_INCLUDE="",
               SNMP_INCLUDE=)

dnl #
dnl #  If not, look for it in a number of directories.
dnl #
if test "x$SNMP_INCLUDE" = "x"; then
  old_CFLAGS="$CFLAGS"
  for try in /usr/include/ucd-snmp /usr/local/include/ucd-snmp $snmp_include_dir; do
    CFLAGS="$old_CFLAGS -I$try"
    AC_TRY_COMPILE([
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_STDINT_H
#include <stdint.h>
#endif
#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif
#ifdef HAVE_NETDB_H
#include <netdb.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <asn1.h>],
                   [ int a = 1;],
                   SNMP_INCLUDE="-I$try",
                   SNMP_INCLUDE=)
    if test "x$SNMP_INCLUDE" != "x"; then
      break;
    fi
  done
  CFLAGS="$old_CFLAGS"
fi

if test "x$SNMP_INCLUDE" = "x"; then
  AC_MSG_RESULT(no)
else
  AC_MSG_RESULT(yes)
  AC_DEFINE(HAVE_ASN1_H)
  
dnl #
dnl #  Check for the rest of the SNMP headers.
dnl #
  old_CFLAGS="$CFLAGS"
  CFLAGS="$CFLAGS $SNMP_INCLUDE"

  AC_MSG_CHECKING(for snmp.h)
    AC_TRY_COMPILE([
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_STDINT_H
#include <stdint.h>
#endif
#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif
#ifdef HAVE_NETDB_H
#include <netdb.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_ASN1_H
#include <asn1.h>
#endif
#include <snmp.h>],
                   [ int a = 1;],
                   [AC_DEFINE(HAVE_SNMP_H) ac_cv_header_snmp_h=yes])
    if test "x$ac_cv_header_snmp_h" = "xyes"; then
      AC_MSG_RESULT(yes)
    else
      AC_MSG_RESULT(no)
    fi

    AC_MSG_CHECKING(for snmp_impl.h)
    AC_TRY_COMPILE([
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_STDINT_H
#include <stdint.h>
#endif
#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif
#ifdef HAVE_NETDB_H
#include <netdb.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_ASN1_H
#include <asn1.h>
#endif
#ifdef HAVE_SNMP_H
#include <snmp.h>
#endif
#include <snmp_impl.h>],
                   [ int a = 1;],
                   [AC_DEFINE(HAVE_SNMP_IMPL_H) ac_cv_header_snmp_impl_h=yes])
    if test "x$ac_cv_header_snmp_h" = "xyes"; then
      AC_MSG_RESULT(yes)
    else
      AC_MSG_RESULT(no)
    fi

dnl #
dnl #  Now do the same thing, looking for the SNMP library directory
dnl #
  AC_MSG_CHECKING([for snmp_build_var_op in -lsnmp])

dnl #
dnl #  First, see if we can build it WITHOUT using any special includes
dnl #
  old_LIBS="$LIBS"
  LIBS="$old_LIBS -lsnmp"
  AC_TRY_LINK([extern char snmp_build_var_op();],
              [ snmp_build_var_op()],
              SNMP_LIBS="-lsnmp",
              SNMP_LIBS=)

  if test "x$SNMP_LIBS" = "x"; then
    for try in /usr/lib /usr/local/lib /usr/local/snmp/lib $snmp_lib_dir; do
      LIBS="$old_LIBS -L$try -lsnmp"
      AC_TRY_LINK([extern char snmp_build_var_op();],
                  [ snmp_build_var_op()],
                  SNMP_LIBS="-L$try -lsnmp",
                  SNMP_LIBS=)
      if test "x$SNMP_LIBS" != "x"; then
        break;
      fi
dnl   #
dnl   #  That didn't work.  Try adding the '-lcrypto' line.
dnl   #  Some SNMP libraries are linked against SSL...
dnl   #
      LIBS="$old_LIBS -L$try -lsnmp -lcrypto"
      AC_TRY_LINK([extern char snmp_build_var_op();],
                  [ snmp_build_var_op()],
                  SNMP_LIBS="-L$try -lsnmp -lcrypto",
                  SNMP_LIBS=)
      if test "x$SNMP_LIBS" != "x"; then
        break;
      fi
    done
  fi
  LIBS="$old_LIBS"

  dnl #
  dnl #  If one or the other isn't found, disable them both..
  dnl #  If both are found, enable them both.
  dnl #
  CFLAGS="$old_CFLAGS"
  if test "x$SNMP_LIBS" = "x"; then
    AC_MSG_RESULT(no)
    SNMP_INCLUDE=
  else
    AC_MSG_RESULT(yes)
    AC_DEFINE(WITH_SNMP)
    AC_DEFINE(HAVE_LIBSNMP)
  fi
fi
])


dnl #
dnl #  Locate the directory in which a particular file is found.
dnl #
dnl #  Usage: AC_LOCATE_DIR(MYSQLLIB_DIR, libmysqlclient.a)
dnl #
dnl #    Defines the variable MYSQLLIB_DIR to be the directory(s) in
dnl #    which the file libmysqlclient.a is to be found.
dnl #
dnl #
AC_DEFUN(AC_LOCATE_DIR,
[
dnl # If we have the program 'locate', then the problem of finding a
dnl # particular file becomes MUCH easier.
dnl #

dnl #
dnl #  No 'locate' defined, do NOT do anything.
dnl #
if test "x$LOCATE" != "x"; then
  dnl #
  dnl #  Root through a series of directories, looking for the given file.
  dnl #
  DIRS=
  file=$2

  for x in `${LOCATE} $file 2>/dev/null`; do
    dnl #
    dnl #  When asked for 'foo', locate will also find 'foo_bar', which we
    dnl #  don't want.  We want that EXACT filename.
    dnl #
    dnl #  We ALSO want to be able to look for files like 'mysql/mysql.h',
    dnl #  and properly match them, too.  So we try to strip off the last
    dnl #  part of the filename, using the name of the file we're looking
    dnl #  for.  If we CANNOT strip it off, then the name will be unchanged.
    dnl #
    base=`echo $x | sed "s%/${file}%%"`
    if test "x$x" = "x$base"; then
      continue;
    fi

    dir=`${DIRNAME} $x 2>/dev/null`
    dnl #
    dnl #  Exclude a number of directories.
    dnl #
    exclude=`echo ${dir} | ${GREP} /home`
    if test "x$exclude" != "x"; then
      continue
    fi

    dnl #
    dnl #  OK, we have an exact match.  Let's be sure that we only find ONE
    dnl #  matching directory.
    dnl #
    already=`echo \$$1 ${DIRS} | ${GREP} ${dir}`
    if test "x$already" = "x"; then
      DIRS="$DIRS $dir"
    fi
  done
fi

dnl #
dnl #  And remember the directory in which we found the file.
dnl #
eval "$1=\"\$$1 $DIRS\""
])


dnl #######################################################################
dnl #
dnl #  Look for a library in a number of places.
dnl #
AC_DEFUN(AC_SMART_CHECK_LIB, [

AC_MSG_CHECKING([for $2 in -l$1])

smart_lib=
smart_lib_dir=

dnl #
dnl #  Try to link it first, using the default libs && library paths
dnl #
  old_LIBS="$LIBS"
  LIBS="$LIBS -l$1"
  AC_TRY_LINK([extern char $2();],
              [ $2()],
	      smart_lib="-l$1")

  if test "x$smart_lib" = "x"; then
    AC_LOCATE_DIR(smart_lib_dir,[lib$1${libltdl_cv_shlibext}])
    AC_LOCATE_DIR(smart_lib_dir,[lib$1.a])

    for try in $smart_try_dir $smart_lib_dir /usr/local/lib/ /opt/lib; do
      LIBS="$old_LIBS -L$try -l$1"

      AC_TRY_LINK([extern char $2();],
                  [ $2()],
  		  smart_lib="-L$try -l$1")
      if test "x$smart_lib" != "x"; then
        break;
      fi
    done
    LIBS="$old_LIBS"
  fi

  dnl #
  dnl #  Found it, set the appropriate variable.
  dnl #
  if test "x$smart_lib" != "x"; then
    AC_MSG_RESULT(yes)
    eval "ac_cv_lib_$1_$2=yes"
    LIBS="$old_LIBS $smart_lib"
    SMART_LIBS="$SMART_LIBS $smart_lib"
  else
    AC_MSG_RESULT(no) 
fi
])

dnl #######################################################################
dnl #
dnl #  Look for a header file in a number of places.
dnl #
AC_DEFUN(AC_SMART_CHECK_INCLUDE, [

ac_safe=`echo "$ac_hdr" | sed 'y%./+-%__p_%'`
AC_MSG_CHECKING([for $1])

smart_include=
smart_include_dir=

dnl #
dnl #  Try to link it first, using the default includes
dnl #
  old_CFLAGS="$CFLAGS"
  AC_TRY_COMPILE([#include <$1>],
                 [ int a = 1;],
                 smart_include=" ",
                 smart_include=)

  if test "x$smart_include" = "x"; then
    AC_LOCATE_DIR(smart_include_dir,$1)

    for try in $smart_try_dir $smart_include_dir /usr/local/include/ /opt/include; do
      CFLAGS="$old_CFLAGS -I$try"

      AC_TRY_COMPILE([#include <$1>],
                     [ int a = 1;],
                     smart_include="-I$try",
                     smart_include=)

      if test "x$smart_include" != "x"; then
        break;
      fi
    done
    CFLAGS="$old_CFLAGS"
  fi

  dnl #
  dnl #  Found it, set the appropriate variable.
  dnl #
  if test "x$smart_include" != "x"; then
    AC_MSG_RESULT(yes)
    eval "ac_cv_header_$ac_safe=yes"
    CFLAGS="$old_CFLAGS $smart_include"
    SMART_CFLAGS="$SMART_CFLAGS $smart_include"
  else
    AC_MSG_RESULT(no) 
fi
])

dnl #######################################################################
dnl #
dnl #  Look for a header file in a number of places.
dnl #
dnl #  Usage:  AC_CHECK_STRUCT_HAS_MEMBER([#include <foo.h>], [struct foo], member)
dnl #  If the member is defined, then the variable
dnl #     ac_cv_type_struct_foo_member is set to 'yes'
dnl #
AC_DEFUN(AC_CHECK_STRUCT_HAS_MEMBER, [
  AC_MSG_CHECKING([for $3 in $2])

dnl BASED on 'offsetof':
dnl #define offsetof(TYPE, MEMBER) ((size_t) &((TYPE *)0)->MEMBER)
dnl

  AC_TRY_COMPILE([
$1
#ifndef offsetof
#define offsetof(TYPE, MEMBER) ((int) &((TYPE *)0)->MEMBER)
#endif
],
                 [ int foo = offsetof($2, $3) ],
                 has_element=" ",
                 has_element=)

  ac_safe_type=`echo "$2" | sed 'y% %_%'`
  if test "x$has_element" != "x"; then
    AC_MSG_RESULT(yes)
    eval "ac_cv_type_${ac_safe_type}_has_$3=yes"
  else
    AC_MSG_RESULT(no) 
    eval "ac_cv_type_${ac_safe_type}_has_$3="
 fi
])
