/*
 *      Copyright (c) 1996 Ascend Communications, Inc.
 *      All rights reserved.
 *
 *      Permission to copy, display, distribute and make derivative works
 *      from this material in whole or in part for any purpose is granted
 *      provided that the above copyright notice and this paragraph are
 *      duplicated in all copies.  THIS SOFTWARE IS PROVIDED "AS IS" AND
 *      WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES INCLUDING, WITHOUT
 *      LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *      FOR A PARTICULAR PURPOSE.
 *
 */

/*
 * Copyright [C] The Regents of the University of Michigan and Merit Network,
 * Inc. 1992, 1993, 1994, 1995, 1996, 1997, 1998 All Rights Reserved
 *
 * Permission to use, copy, and modify this software and its documentation 
 * for any purpose and without fee is hereby granted, provided: 
 *
 * 1) that the above copyright notice and this permission notice appear in all
 *    copies of the software and derivative works or modified versions thereof, 
 *
 * 2) that both the copyright notice and this permission and disclaimer notice 
 *    appear in all supporting documentation, and 
 *
 * 3) that all derivative works made from this material are returned to the
 *    Regents of the University of Michigan and Merit Network, Inc. with
 *    permission to copy, to display, to distribute, and to make derivative
 *    works from the provided material in whole or in part for any purpose.
 *
 * Users of this code are requested to notify Merit Network, Inc. of such use
 * by sending email to aaa-admin@merit.edu
 *
 * Please also use aaa-admin@merit.edu to inform Merit Network, Inc of any
 * derivative works.
 *
 * Distribution of this software or derivative works or the associated
 * documentation is not allowed without an additional license.
 *
 * Licenses for other uses are available on an individually negotiated
 * basis.  Contact aaa-license@merit.edu for more information.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT NETWORK, INC. DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE.  The Regents of the
 * University of Michigan and Merit Network, Inc. shall not be liable for any
 * special, indirect, incidental or consequential damages with respect to any
 * claim by Licensee or any third party arising from use of the software.
 *
 * Merit AAA Server Support
 * Merit Network, Inc.
 * 4251 Plymouth Road, Suite C.
 * Ann Arbor, Michigan, USA 48105-2785
 *
 * attn:  John Vollbrecht
 * voice: 734-764-9430
 * fax:   734-647-3185
 * email: aaa-admin@merit.edu
 *
 */

/*
 *
 * Public entry points in this file:
 *
 */

static char     rcsid[] = "$Id: arades.c,v 1.2 1998/06/11 18:40:26 web Exp $";

#include	<sys/types.h>
#include	<sys/param.h>
#include	<sys/socket.h>
#include	<sys/time.h>
#include	<sys/file.h>
#include	<sys/wait.h>
#include	<net/if.h>
#include	<netinet/in.h>

#include	<stdio.h>
#include	<netdb.h>
#include	<errno.h>
#include	<signal.h>
#include	<memory.h>
#include	<syslog.h>

#include	"radius.h"

#ifndef ASCEND
AATVPTR         rad_arades_aatv = (AATVPTR) NULL;
#else	/* ASCEND */

extern int      debug_flag;

static int      arades_auth PROTO((AUTH_REQ *, int, char *));

static AATV     arades_aatv = DEF_AATV_DIRECT_TYPE("ARA-DES", AA_ARADES,
							arades_auth);

AATVPTR         rad_arades_aatv = &arades_aatv;

/*************************************************************************
 *
 *	Function: arades_auth
 *
 *	Purpose: Check the ARA DES scrambled string against the vector
 *		 encoded with the user's local password
 *
 *	Remark: Because the authentication process uses the User's clear text
 *		passord to encrypt the radius vector and compare that result
 *		with the PW_ASCEND_ARADES sent with the request, this will
 *		not work unless the NAS is talking directly to us.
 *
 *************************************************************************/

static int
arades_auth (authreq, value, af_param)

AUTH_REQ       *authreq;
int             value;
char           *af_param;

{
	int             i;
	int             pwdlen;
	UINT4           protocol;
	VALUE_PAIR     *vp;
	VALUE_PAIR     *auth_item;
	VALUE_PAIR     *protpair;
	VALUE_PAIR     *user_reply;
	char            name[AUTH_ID_LEN + 1];
	char            password[AUTH_PASS_LEN + 1];
	char            ara_vector[ARA_PASS_LEN + 1];
	char            ara_encrypted_string[ARA_PASS_LEN + 1];
	static char    *func = "arades_pass";

	dprintf(1, (LOG_AUTH, LOG_DEBUG, "entered %s", func));

	if ((vp = get_vp_vend (authreq->cur_request, PW_USER_ID, VC_MERIT))
								== NULL_VP)
	{
		logit (LOG_DAEMON, LOG_ALERT,
		       "%s: Improper userid specification", func);
		reply_message (authreq, EC_INTERNAL, func);
		return EV_NAK;
	}
	strcpy (name, vp->strvalue);

	dprintf(4, (LOG_AUTH, LOG_DEBUG, "%s: ID = '%s'", func, name));

	/* Need to retrieve user's password */
	/* Get framed protocol value */
	protpair = get_vp (authreq->cur_request, PW_FRAMED_PROTOCOL);
	protocol = (protpair == NULL_VP) ? 0 : protpair->lvalue;

	/* We must have a password available to continue */
	if (user_find ((char *) authreq->client->file_pfx, name, protocol,
			&authreq->user_check, &authreq->user_deny,
			&user_reply, 0) != 0)
	{
		dprintf(1, (LOG_AUTH, LOG_ERR,
			 "%s: user %s not found by user_find()", func, name));
		return EV_NAK;
	}

	if ((auth_item = get_vp_ci (authreq->user_check, CI_USER_PASSWORD, 0))
									== NULL)
	{
		dprintf(1, (LOG_AUTH, LOG_ERR,
			"%s: Missing password for %s", func, name));
		return EV_NAK;
	}
	memset (password, 0, ARA_PASS_LEN);
	pwdlen = strlen (auth_item->strvalue);

	/* ARA-DES uses only first eight bytes maximum. */
	if (pwdlen > ARA_PASS_LEN)
	{
		pwdlen = ARA_PASS_LEN;
	}

	for (i = 0; i < pwdlen; i++)
	{
		password[i] = (u_char) (auth_item->strvalue[i] << 1);
	}

	/*
	 *	Retrieve DES encoded string from the Access-Request.
	 */
	if ((vp = get_vp_vend (authreq->cur_request, PW_ASCEND_ARADES,
				VC_ASCEND)) == NULL_VP)
	{
		/* If this isn't in the auth request, we can't authenticate */
		dprintf(1, (LOG_DAEMON, LOG_ALERT,
			"%s: Auth request does not contain ARA DES string",
			func));
		return EV_NAK;
	}

	avpair_del (&authreq->cur_request, PW_ASCEND_ARADES, VC_ASCEND);

	/* Now use this as the key for the DES encryptor. */
	if (des_init ())
	{
		dprintf(1, (LOG_AUTH, LOG_ERR,
			"%s: cannot initialize DES function", func));
		return EV_NAK;
	}
	dessetkey ((char *) password);

	/*
	 *	Retrieve random vector from auth request - only lower
	 *	eight bytes are used.
	 */
	memcpy (ara_vector, authreq->repvec, ARA_PASS_LEN);
	endes (ara_vector);
	desdone ();

	memcpy (ara_encrypted_string, vp->strvalue, vp->lvalue);

	/* If it doesn't match what we got, the remote is invalid. */
	if (memcmp (ara_vector, ara_encrypted_string, ARA_PASS_LEN) != 0)
	{
		return EV_NAK;
	}

	return EV_ACK;
} /* end of arades_auth () */

#endif	/* ASCEND */
